/*
	Copyright (C) 2012 Steve Thomas <steve AT tobtu DOT com>

	This file is part of XSHA1 Reverser.

	XSHA1 Reverser is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	XSHA1 Reverser is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with XSHA1 Reverser.  If not, see <http://www.gnu.org/licenses/>.
*/

#define AVX_CODE
#define XOP_CODE

#include "xsha1.h"
#include "xsha1help.h"

// ***********************
// **** Compile flags ****
// ***********************
// Intel: icl /QxAVX
//        icc xAVX
// MSVS:  /arch:AVX
// GCC:   -mavx -mxop

#ifdef ARC_x86

uint32_t XSHA1_rev16::calcAVXXOP(const uint32_t *hash, uint32_t &invalidCount, bool onlyValid, bool onlyPrintable, bool noCollisions, FILE *fout)
{
	return xsha1Reverse_16_XOP(hash, invalidCount, onlyValid, onlyPrintable, noCollisions, fout);
}

uint32_t XSHA1_rev20::calcAVXXOP(const uint32_t *hash, uint32_t &invalidCount, bool onlyValid, bool onlyPrintable, bool noCollisions, FILE *fout)
{
	return xsha1Reverse_20_XOP(hash, invalidCount, onlyValid, onlyPrintable, noCollisions, fout);
}

#endif
