/*
	Copyright (C) 2012 Steve Thomas <steve AT tobtu DOT com>

	This file is part of XSHA1 Reverser.

	XSHA1 Reverser is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	XSHA1 Reverser is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with XSHA1 Reverser.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "xsha1help.h"

#ifdef ARC_x86

#define ROTS(n,s) ((n << (s)) | (n >> (32 - (s))))

uint32_t finishRev16(__m128i *t, __m128i *a, __m128i *b, __m128i *c, uint32_t *sx, uint32_t x0, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t &mask)
{
	uint32_t sa, sb, sc, i = 0;

	if ((mask & 0x000f) != 0)
	{
		mask &= 0xfff0;
	}
	else if ((mask & 0x00f0) != 0)
	{
		mask &= 0xff0f;
		i = 1;
	}
	else if ((mask & 0x0f00) != 0)
	{
		mask &= 0xf0ff;
		i = 2;
	}
	else //if ((mask & 0xf000) != 0)
	{
		mask = 0;
		i = 3;
	}

	sc = ((uint32_t*) c)[i];
	//sx[0] = ROTS(sc, 32 - 30) - (0xc3d2e1f0 + ((0xefcdab89 & 0x98badcfe) | ((~0xefcdab89) & 0x10325476)) + ROTS(0x67452301, 5) + 0x5a827999);
	sx[0] = ROTS(sc, 32 - 30) - 0x9fb498b3;
	if ((sx[0] & 31) == (x0 ^ x2))
	{
		sb = ROTS(((uint32_t*) b)[i], 32 - 30);
		//sx[1] = sb - (0x10325476 + ((0x67452301 & 0x7bf36ae2) | ((~0x67452301) & 0x98badcfe)) + ROTS(ROTS(sc, 32 - 30), 5) + 0x5a827999);
		sx[1] = sb - (ROTS(ROTS(sc, 32 - 30), 5) + 0x66b0cd0d);
		if ((sx[1] & 31) == (x1 ^ (x3 + i)))
		{
			sa = ((uint32_t*) a)[i];
			//sx[2] = sa - (0x98badcfe + ((ROTS(sc, 32 - 30) & 0x59d148c0) | ((~ROTS(sc, 32 - 30)) & 0x7bf36ae2)) + ROTS(sb, 5) + 0x5a827999);
			sx[2] = sa - (((ROTS(sc, 32 - 30) & 0x59d148c0) | ((~ROTS(sc, 32 - 30)) & 0x7bf36ae2)) + ROTS(sb, 5) + 0xf33d5697);
			if ((sx[2] & 31) == x2)
			{
				//st = ((uint32_t*) t)[i];
				//sx[3] = st - (0x7bf36ae2 + ((sb & sc) | ((~sb) & 0x59d148c0)) + ROTS(sa, 5) + 0x5a827999);
				sx[3] = ((uint32_t*) t)[i] - (((sb & sc) | ((~sb) & 0x59d148c0)) + ROTS(sa, 5) + 0xd675e47b);
				if ((sx[3] & 31) == x3 + i)
				{
					sx[4] = 0;
					return 1;
				}
			}
		}
	}
	return 0;
}

uint32_t finishRev20(__m128i *tmp, __m128i *t, __m128i *a, __m128i *b, __m128i *c, __m128i *d, uint32_t *sx, uint32_t x1, uint32_t x2, uint32_t x3, uint32_t x4, uint32_t &mask)
{
	uint32_t sa, sb, sc, sd, i = 0;

	if ((mask & 0x000f) != 0)
	{
		mask &= 0xfff0;
	}
	else if ((mask & 0x00f0) != 0)
	{
		mask &= 0xff0f;
		i = 1;
	}
	else if ((mask & 0x0f00) != 0)
	{
		mask &= 0xf0ff;
		i = 2;
	}
	else //if ((mask & 0xf000) != 0)
	{
		mask = 0;
		i = 3;
	}

	sc = ((uint32_t*) c)[i];
	sd = ((uint32_t*) d)[i];
	//sx[1] = ROTS(sc, 32 - 30) - (0x10325476 + ((0x67452301 & 0x7bf36ae2) | ((~0x67452301) & 0x98badcfe)) + ROTS(sd, 32 - 30 + 5) + 0x5a827999);
	sx[1] = ROTS(sc, 32 - 30) - (ROTS(sd, 32 - 30 + 5) + 0x66b0cd0d);
	if ((sx[1] & 31) == (x1 ^ x3))
	{
		sb = ROTS(((uint32_t*) b)[i], 32 - 30);
		//sx[2] = sb - (0x98badcfe + ((ROTS(sd, 32 - 30) & 0x59d148c0) | ((~ROTS(sd, 32 - 30)) & 0x7bf36ae2)) + ROTS(sc, 32 - 30 + 5) + 0x5a827999);
		sx[2] = sb - (((ROTS(sd, 32 - 30) & 0x59d148c0) | ((~ROTS(sd, 32 - 30)) & 0x7bf36ae2)) + ROTS(sc, 32 - 30 + 5) + 0xf33d5697);
		if ((sx[2] & 31) == x2)
		{
			sa = ((uint32_t*) a)[i];
			//sx[3] = sa - (0x7bf36ae2 + ((ROTS(sc, 32 - 30) & sd) | ((~ROTS(sc, 32 - 30)) & 0x59d148c0)) + ROTS(sb, 5) + 0x5a827999);
			sx[3] = sa - (((ROTS(sc, 32 - 30) & sd) | ((~ROTS(sc, 32 - 30)) & 0x59d148c0)) + ROTS(sb, 5) + 0xd675e47b);
			if ((sx[3] & 31) == x3)
			{
				//st = ((uint32_t*) t)[i];
				//sx[4] = st - (0x59d148c0 + ((sb & sc) | ((~sb) & sd)) + ROTS(sa, 5) + 0x5a827999);
				sx[4] = ((uint32_t*) t)[i] - (((sb & sc) | ((~sb) & sd)) + ROTS(sa, 5) + 0xb453c259);
				if ((sx[4] & 31) == x4 + i)
				{
					sx[0] = ((uint32_t*) tmp)[i];
					sx[5] = 0;
					return 1;
				}
			}
		}
	}
	return 0;
}

#endif
