/*
	Copyright (C) 2012 Steve Thomas <steve AT tobtu DOT com>

	This file is part of XSHA1 Reverser.

	XSHA1 Reverser is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	XSHA1 Reverser is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with XSHA1 Reverser.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef XSHA1_H
#define XSHA1_H

#include <stdio.h>
#include "common.h"

class XSHA1_rev16
{
public:
	static uint32_t run(const uint32_t *hash, uint32_t &invalidCount, bool onlyValid, bool onlyPrintable, bool noCollisions, FILE *fout);

private:
	XSHA1_rev16() {}
#ifdef ARC_x86
	static uint32_t calcAVXXOP(const uint32_t *hash, uint32_t &invalidCount, bool onlyValid, bool onlyPrintable, bool noCollisions, FILE *fout);
	static uint32_t calcAVX   (const uint32_t *hash, uint32_t &invalidCount, bool onlyValid, bool onlyPrintable, bool noCollisions, FILE *fout);
	static uint32_t calcSSE2  (const uint32_t *hash, uint32_t &invalidCount, bool onlyValid, bool onlyPrintable, bool noCollisions, FILE *fout);
#endif
	static uint32_t calcNorm  (const uint32_t *hash, uint32_t &invalidCount, bool onlyValid, bool onlyPrintable, bool noCollisions, FILE *fout);
};

class XSHA1_rev20
{
public:
	static uint32_t run(const uint32_t *hash, uint32_t &invalidCount, bool onlyValid, bool onlyPrintable, bool noCollisions, FILE *fout);

private:
	XSHA1_rev20() {}
#ifdef ARC_x86
	static uint32_t calcAVXXOP(const uint32_t *hash, uint32_t &invalidCount, bool onlyValid, bool onlyPrintable, bool noCollisions, FILE *fout);
	static uint32_t calcAVX   (const uint32_t *hash, uint32_t &invalidCount, bool onlyValid, bool onlyPrintable, bool noCollisions, FILE *fout);
	static uint32_t calcSSE2  (const uint32_t *hash, uint32_t &invalidCount, bool onlyValid, bool onlyPrintable, bool noCollisions, FILE *fout);
#endif
	static uint32_t calcNorm  (const uint32_t *hash, uint32_t &invalidCount, bool onlyValid, bool onlyPrintable, bool noCollisions, FILE *fout);
};

#endif
