/*
	Copyright (C) 2012 Steve Thomas <steve AT tobtu DOT com>

	This file is part of XSHA1 Reverser.

	XSHA1 Reverser is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	XSHA1 Reverser is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with XSHA1 Reverser.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef GETARGS_H
#define GETARGS_H

#include "common.h"
#include <vector>

using namespace std;

struct programArgs
{
	char *characters, *debug, *hashList, *outputFile, *status;
	int debugList, help, outputInvalid, onlyPrintable, outputNotFound, hasInvalid, noCollisions;
	uint32_t charactersInt, debugInt, statusInt;
	vector<char*> hash, xsha1;
};

int validateArs(int argc, char *argv[], programArgs &args);

#endif
