/*
	Copyright (C) 2012 Steve Thomas <steve AT tobtu DOT com>

	This file is part of XSHA1 Reverser.

	XSHA1 Reverser is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	XSHA1 Reverser is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with XSHA1 Reverser.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef COMMON_H
#define COMMON_H

#include "architecture.h"

//#define AVX_BROADCAST

// You can change this but it will probably go slower (only 1 or 2 are valid)
#ifdef ARC_x86_64
	#define __XSHA1_INTERLACED__ 1
#elif defined(ARC_x86_32)
	#define __XSHA1_INTERLACED__ 1
#endif

#ifdef _WIN32
	#pragma warning(disable:4996)
#endif

#if defined(_MSC_VER) || defined(__INTEL_COMPILER)
	#define __inline__  __forceinline
#elif defined(__GNUC__)
	#define __inline__  __inline __attribute__((__always_inline__))
#else
	#define __inline__  inline
#endif

#ifdef _WIN32
	#include "inttypes.h"
	#include <time.h>
	#define TIMER_TYPE               clock_t
	#define TIMER_FUNC(t)            t = clock()
	#define TIMER_DIFF(s,e)          ((e - s) / (double)CLOCKS_PER_SEC)
	#define DIRECTORY_SEPERATOR      '\\'
	#define DIRECTORY_SEPERATOR_STR  "\\"

	#define WIN_ALIGN_16 __declspec(align(16))
	#define ALIGN_16
#else
	#include <inttypes.h>
	#include <sys/time.h>
	#define TIMER_TYPE               timeval
	#define TIMER_FUNC(t)            gettimeofday(&t, NULL)
	#define TIMER_DIFF(s,e)          ((e.tv_sec - s.tv_sec) + (e.tv_usec - s.tv_usec) / (double)1000000.0)
	#define DIRECTORY_SEPERATOR      '/'
	#define DIRECTORY_SEPERATOR_STR  "/"

	#define WIN_ALIGN_16
	#define ALIGN_16 __attribute__((aligned(16)))
#endif

enum instructionSets
{
	IS_MMX    = 0x0001,
	IS_SSE    = 0x0002,
	IS_SSE2   = 0x0004,
	IS_SSE3   = 0x0008,
	IS_SSSE3  = 0x0010, // pshufb xmmd,xmms
	IS_SSE41  = 0x0020, // ptest xmm1,xmm2
	IS_SSE42  = 0x0040,
	IS_SSE4A  = 0x0080,
	IS_AVX    = 0x0100,
	IS_AVX2   = 0x0200, // I can't wait for AVX2 with XOP (vprotd and vpcmov weren't adding to AVX2 grrr)
	IS_OS_YMM = 0x0400,
	IS_XOP    = 0x0800, // vprotd xmmd,xmms,imm8; vpcmov xmmd,xmms1,xmms2,xmmc
	IS_POPCNT = 0x1000, // popcnt r,r/m16; popcnt r,r/m32; popcnt r,r/m64
	IS_ALL    = 0x1fff
};

uint32_t getInstructionSets(uint32_t debugSet = 0xffffffff);
uint32_t outputPassword(uint32_t *in, bool onlyValid, bool onlyPrintable, const uint32_t *hash, FILE *fout);

#endif
