#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "lockdown.h"

void hex_print(unsigned char str[], int length) 
{   
   int idx; 
   for (idx=0; idx < length; idx++) 
      printf("%02x",str[idx]); 
   printf("\n"); 
}  

int main(int argc, char **argv)
{
	
	char *screendata = "./lockdown/STAR.bin";
	char *file1 = "./lockdown/STAR/Starcraft.exe";
	char *file2 = "./lockdown/STAR/storm.dll";
	char *file3 = "./lockdown/STAR/battle.snp";
	char *lockdownfile = "./lockdown/lockdown-IX86-01.dll";
	
	char *value_string = "\x20\x6C\x2A\x48\xB4\xB6\x2E\xB5\x27\xCB\x2D\xAF\x36\xF5\x10\x63";

	int version, checksum;
	char digest[0x11];		
		
	char *expected_vs = "\x9D\xEF\x2C\xBE\xE0\xD4\x09\x45\x80\x07\xB0\x0D\xF3\xD9\xC9\x8E";
	
	if(CheckRevision(file1, file2, file3, value_string, &version, &checksum, digest, lockdownfile, screendata))
	{
		printf("Lockdown file: %s\n", lockdownfile);
	
		printf("Expected Checksum: %x\n", 0x69AA6320);
		printf("Checksum: %x\n", checksum);
		
		printf("Expected Version: %x\n", 0x010f0001);
		printf("Version: %x\n", version);
		
		printf("Expected Digest: "); hex_print(expected_vs, strlen(expected_vs));
		printf("Digest: "); hex_print(digest, strlen(digest));
		

	}else{
		printf("CheckRevision Failed...");
	}	
	

	#ifdef WIN32
		system("pause");
	#endif

	return 0;
}
