﻿
Public Class frmSettings
  Private Sub frmSettings_Load(sender As Object, e As System.EventArgs) Handles Me.Load
    cmbClientIP.Items.Clear()
    For Each addr In (From ip In Net.Dns.GetHostAddresses(Net.Dns.GetHostName) Where ip.AddressFamily = Net.Sockets.AddressFamily.InterNetwork)
      cmbClientIP.Items.Add(addr.ToString)
    Next
    cmbClientIP.SelectedIndex = cmbClientIP.FindStringExact(My.Settings.IP)
    If cmbClientIP.SelectedIndex = -1 Then cmbClientIP.SelectedIndex = 0
    txtKey.Text = My.Settings.CDKey
    cmbServer.Text = My.Settings.Server
    txtHome.Text = My.Settings.Home
    txtD1Hashes.Text = My.Settings.D1Hashes
    txtW2Hashes.Text = My.Settings.W2Hashes
    txtCRevs.Text = My.Settings.CRev
    If String.IsNullOrEmpty(txtD1Hashes.Text) Then txtD1Hashes.Text = Application.StartupPath & "\Hashes\DRTL"
    If String.IsNullOrEmpty(txtW2Hashes.Text) Then txtW2Hashes.Text = Application.StartupPath & "\Hashes\W2BN"
    If String.IsNullOrEmpty(txtCRevs.Text) Then txtCRevs.Text = Application.StartupPath & "\CheckRevision Libraries"
    Dim sGateways As New ArrayList
    sGateways.AddRange(My.Computer.Registry.CurrentUser.OpenSubKey("Software\Battle.net\Configuration").GetValue("Battle.net gateways"))
    chkServerReg.Checked = sGateways.Contains(GATEWAYNAME)
    chkAuto.Checked = My.Settings.Automatic
  End Sub

  Private Sub cmdOK_Click(sender As System.Object, e As System.EventArgs) Handles cmdOK.Click
    My.Settings.Automatic = chkAuto.Checked
    My.Settings.CDKey = txtKey.Text
    My.Settings.CRev = txtCRevs.Text
    My.Settings.D1Hashes = txtD1Hashes.Text
    My.Settings.W2Hashes = txtW2Hashes.Text
    My.Settings.Home = txtHome.Text
    My.Settings.IP = cmbClientIP.Text
    My.Settings.Server = cmbServer.Text
    My.Settings.Save()
    Dim sGateways As New ArrayList
    sGateways.AddRange(My.Computer.Registry.CurrentUser.OpenSubKey("Software\Battle.net\Configuration").GetValue("Battle.net gateways"))
    If chkServerReg.Checked Then
      If sGateways.Contains(GATEWAYNAME) Then
        If Not sGateways.Contains(My.Settings.IP) Then
          sGateways.RemoveRange(sGateways.IndexOf(GATEWAYNAME) - 2, 3)
          sGateways.InsertRange(2, {My.Settings.IP, "0", GATEWAYNAME})
        End If
      Else
        sGateways.InsertRange(2, {My.Settings.IP, "0", GATEWAYNAME})
      End If
    Else
      If sGateways.Contains(GATEWAYNAME) Then
        sGateways.RemoveRange(sGateways.IndexOf(GATEWAYNAME) - 2, 3)
      Else
        Exit Sub
      End If
    End If
    My.Computer.Registry.CurrentUser.OpenSubKey("Software\Battle.net\Configuration", True).SetValue("Battle.net gateways", sGateways.ToArray(GetType(String)), Microsoft.Win32.RegistryValueKind.MultiString)
    Me.DialogResult = Windows.Forms.DialogResult.OK
    Me.Close()
  End Sub

  Private Sub cmdCancel_Click(sender As System.Object, e As System.EventArgs) Handles cmdCancel.Click
    Me.DialogResult = Windows.Forms.DialogResult.Cancel
    Me.Close()
  End Sub

  Private Sub cmdD1HashBrowse_Click(sender As System.Object, e As System.EventArgs) Handles cmdD1HashBrowse.Click
    Dim cdlBrowse As New OpenFileDialog With {.Title = "Select DRTL Hash Folder", .InitialDirectory = txtD1Hashes.Text, .FileName = "DRTL", .CheckFileExists = False, .CheckPathExists = True}
    If cdlBrowse.ShowDialog(Me) = Windows.Forms.DialogResult.OK Then
      txtD1Hashes.Text = IO.Path.GetDirectoryName(cdlBrowse.FileName)
    End If
  End Sub

  Private Sub cmdW2HashBrowse_Click(sender As System.Object, e As System.EventArgs) Handles cmdW2HashBrowse.Click
    Dim cdlBrowse As New OpenFileDialog With {.Title = "Select W2BN Hash Folder", .InitialDirectory = txtW2Hashes.Text, .FileName = "W2BN", .CheckFileExists = False, .CheckPathExists = True}
    If cdlBrowse.ShowDialog(Me) = Windows.Forms.DialogResult.OK Then
      txtW2Hashes.Text = IO.Path.GetDirectoryName(cdlBrowse.FileName)
    End If
  End Sub

  Private Sub cmdCRevBrowse_Click(sender As System.Object, e As System.EventArgs) Handles cmdCRevBrowse.Click
    Dim cdlBrowse As New OpenFileDialog With {.Title = "Select CheckRevision Folder", .InitialDirectory = txtCRevs.Text, .FileName = "CRev", .CheckFileExists = False, .CheckPathExists = True}
    If cdlBrowse.ShowDialog(Me) = Windows.Forms.DialogResult.OK Then
      txtCRevs.Text = IO.Path.GetDirectoryName(cdlBrowse.FileName)
    End If
  End Sub
End Class

Public Module Globals
  Public Const GATEWAYNAME As String = "D1 to W2"
End Module