﻿Imports System.IO
Imports System.Security.Cryptography

Public Class XSHA
  Private Sub New()
  End Sub
  Private Shared Function ROL(val As UInteger, shift As Integer) As UInteger
    shift = shift And &H1F
    val = (val >> (&H20 - shift)) Or (val << shift)
    Return val
  End Function
  Private Shared Function BrokenHash(input As Byte()) As Byte()
    If input.Length > 1024 Then Throw New ArgumentOutOfRangeException("Input must be 1024 bytes or less!")
    Dim data As Byte() = New Byte(1023) {}
    Array.Copy(input, 0, data, 0, input.Length)
    Dim mdata As New MemoryStream(data, True)
    Dim br As New BinaryReader(mdata)
    Dim bw As New BinaryWriter(mdata)
    Dim a, b, c, d, e, g As UInteger
    For I As Integer = 0 To 63
      mdata.Seek((I * 4), SeekOrigin.Begin)
      Dim expr_ldata_i As UInteger = br.ReadUInt32()
      mdata.Seek(1 * 4, SeekOrigin.Current)
      Dim expr_ldata_i_2 As UInteger = br.ReadUInt32()
      mdata.Seek(5 * 4, SeekOrigin.Current)
      Dim expr_ldata_i_8 As UInteger = br.ReadUInt32()
      mdata.Seek(4 * 4, SeekOrigin.Current)
      Dim expr_ldata_i_13 As UInteger = br.ReadUInt32()
      Dim shiftVal As Integer = CInt((expr_ldata_i Xor expr_ldata_i_8 Xor expr_ldata_i_2 Xor expr_ldata_i_13) And &H1F)
      mdata.Seek(2 * 4, SeekOrigin.Current)
      bw.Write(ROL(1, shiftVal))
    Next
    a = &H67452301
    b = &HEFCDAB89UI
    c = &H98BADCFEUI
    d = &H10325476
    e = &HC3D2E1F0UI
    g = 0
    mdata.Seek(0, SeekOrigin.Begin)
    For I As Integer = 0 To 19
      g = br.ReadUInt32() + ROL(a, 5) + e + ((b And c) Or (Not b And d)) + &H5A827999
      e = d : d = c : c = ROL(b, 30) : b = a : a = g
    Next I
    For I As Integer = 0 To 19
      g = (d Xor c Xor b) + e + ROL(g, 5) + br.ReadUInt32() + &H6ED9EBA1
      e = d : d = c : c = ROL(b, 30) : b = a : a = g
    Next
    For I As Integer = 0 To 19
      g = br.ReadUInt32() + ROL(g, 5) + e + ((c And b) Or (d And c) Or (d And b)) - &H70E44324
      e = d : d = c : c = ROL(b, 30) : b = a : a = g
    Next I
    For I As Integer = 0 To 19
      g = (d Xor c Xor b) + e + ROL(g, 5) + br.ReadUInt32() - &H359D3E2A
      e = d : d = c : c = ROL(b, 30) : b = a : a = g
    Next
    br.Close()
    bw.Close()
    mdata.Close()
    Dim result As Byte() = New Byte(19) {}
    mdata = New MemoryStream(result, 0, 20, True, True)
    bw = New BinaryWriter(mdata)
    bw.Write(CUInt(&H67452301 + a))
    bw.Write(CUInt(&HEFCDAB89UI + b))
    bw.Write(CUInt(&H98BADCFEUI + c))
    bw.Write(CUInt(&H10325476 + d))
    bw.Write(CUInt(&HC3D2E1F0UI + e))
    mdata.Close()
    bw.Close()
    Return result
  End Function
  Public Shared Function CalculateHash(data() As Byte) As Byte()
    Return BrokenHash(data)
  End Function

  Public Shared Function HashPassword(sPassword As String) As Byte()
    Return BrokenHash(System.Text.Encoding.GetEncoding(28591).GetBytes(sPassword.ToLower))
  End Function

  Public Shared Function DoubleHashPassword(sPassword As String, ClientToken As UInt32, ServerToken As UInt32)
    Dim ms = New MemoryStream(28)
    Dim bw As New BinaryWriter(ms)
    Dim firstHash() As Byte = HashPassword(sPassword)
    bw.Write(ClientToken)
    bw.Write(ServerToken)
    bw.Write(firstHash)
    Dim toCalc() As Byte = ms.GetBuffer
    Return BrokenHash(toCalc)
  End Function

  Public Shared Function DoubleHashData(data() As Byte, ClientToken As UInt32, ServerToken As UInt32)
    Dim ms = New MemoryStream(28)
    Dim bw As New BinaryWriter(ms)
    Dim firstHash() As Byte = BrokenHash(data)
    bw.Write(ClientToken)
    bw.Write(ServerToken)
    bw.Write(firstHash)
    Dim toCalc() As Byte = ms.GetBuffer
    Return BrokenHash(toCalc)
  End Function

End Class

Public Class clsKey
  Private sKey As String
  Private uProd As UInt32
  Private uPub As UInt32
  Private uPriv As UInt32
  Private bPriv(9) As Byte
  Private bRet As Byte
  Public Sub New(CDKey As String)
    sKey = CDKey
    bRet = Decode(sKey)
  End Sub
  Public Property Key As String
    Get
      If sKey Is Nothing Then Return Nothing
      Select Case sKey.Length
        Case 13
          Return sKey.Substring(0, 4) & "-" & sKey.Substring(4, 5) & "-" & sKey.Substring(9, 4)
        Case 16
          Return sKey.Substring(0, 4) & "-" & sKey.Substring(4, 4) & "-" & sKey.Substring(8, 4) & "-" & sKey.Substring(12, 4)
        Case 26
          Return sKey.Substring(0, 6) & "-" & sKey.Substring(6, 4) & "-" & sKey.Substring(10, 6) & "-" & sKey.Substring(16, 4) & "-" & sKey.Substring(20, 6)
        Case Else
          Return sKey
      End Select
      Return sKey
    End Get
    Set(value As String)
      sKey = value
      bRet = Decode(sKey)
    End Set
  End Property
  Public Property Product As UInt32
    Get
      Return uProd
    End Get
    Set(value As UInt32)
      uProd = value
    End Set
  End Property
  Public Property PublicVal As UInt32
    Get
      Return uPub
    End Get
    Set(value As UInt32)
      uPub = value
      If uProd <> 0 And uPub <> 0 And uPriv <> 0 Then bRet = Encode(uProd, uPub, uPriv)
    End Set
  End Property
  Public Property PrivateVal As UInt32
    Get
      Return uPriv
    End Get
    Set(value As UInt32)
      uPriv = value
      Erase bPriv
      If uProd <> 0 And uPub <> 0 And uPriv <> 0 Then bRet = Encode(uProd, uPub, uPriv)
    End Set
  End Property
  Public ReadOnly Property IsValid As Boolean
    Get
      Return bRet = 0
    End Get
  End Property
  Public Function GetHash(ClientToken As UInt32, ServerToken As UInt32, Optional NullDWORD As Boolean = True) As Byte()
    Dim iVal As Integer
    If NullDWORD Then
      iVal = 26
    Else
      iVal = 20
    End If
    Dim ms = New System.IO.MemoryStream(iVal)
    Dim bw = New System.IO.BinaryWriter(ms)
    If bPriv Is Nothing Then
      bw.Write(CType(ClientToken, UInt32))
      bw.Write(CType(ServerToken, UInt32))
      bw.Write(CType(uProd, UInt32))
      bw.Write(CType(uPub, UInt32))
      If NullDWORD Then bw.Write(CType(0, UInt32))
      bw.Write(CType(uPriv, UInt32))
      Dim bTmp() As Byte = ms.GetBuffer
      ms.Close()
      Return XSHA.CalculateHash(bTmp)
    Else
      bw.Write(ClientToken)
      bw.Write(ServerToken)
      bw.Write(uProd)
      bw.Write(uPub)
      bw.Write(bPriv)
      Dim bTmp() As Byte = ms.GetBuffer
      Dim SHA As New SHA1Managed
      ms.Close()
      Return SHA.ComputeHash(bTmp)
    End If
  End Function
  Private Function Decode(CDKey As String) As Byte
    CDKey = CDKey.Replace("-", String.Empty).ToUpper
    If CDKey.Length = 16 Then
      Erase bPriv
      Decode16DigitKey(CDKey, uProd, uPub, uPriv)
      If uProd = 0 And uPub = 0 And uPriv = 0 Then Return 3
      If uProd = &H4 Or uProd = &H6 Or uProd = &HA Then Return 0
      Return 2
    Else
      Return 1
    End If
  End Function
  Public Function Encode(Product As UInt32, PublicVal As UInt32, PrivateVal As UInt32) As Byte
    If Product = &H4 Then
      sKey = Encode16DigitKey(Product, PublicVal, PrivateVal)
      If sKey IsNot Nothing Then Return 0
      Return 4
    End If
    Return 1
  End Function
End Class


Friend Module Key_16
  Friend Sub Decode16DigitKey(Key As String, ByRef Product As UInt32, ByRef PublicVal As UInt32, ByRef PrivateVal As UInt32)
    Dim salt As Int32 = &H13AC9741, aOrd() As Byte = {5, 6, 0, 1, 2, 3, 4, 9, 10, 11, 12, 13, 14, 15, 7, 8}
    Const CodeValues As String = "246789BCDEFGHJKMNPRTVWXZ"
    Dim cKey() As Char = Key.ToCharArray
    Dim N As Integer
    For I As Integer = 0 To 14 Step 2
      If Not CodeValues.Contains(cKey(I + 1)) OrElse Not CodeValues.Contains(cKey(I)) Then Exit Sub
      N = (CodeValues.IndexOf(cKey(I + 1))) + (CodeValues.IndexOf(cKey(I)) * 24) And &HFF
      cKey(I) = Chr(IIf(((N >> 4) And &HF) < 10, ((N >> 4) And &HF) + &H30, ((N >> 4) And &HF) + &H37))
      cKey(I + 1) = Chr(IIf((N And &HF) < 10, (N And &HF) + &H30, (N And &HF) + &H37))
    Next I
    Dim Decoded(15) As Char
    Dim C As Byte
    For I As Integer = 15 To 0 Step -1
      C = Asc(Char.ToUpper(cKey(aOrd(I))))
      If C <= 55 Then
        Decoded(I) = Chr(C Xor (salt And 7))
        salt >>= 3
      ElseIf C < 65 Then
        Decoded(I) = Chr(C Xor I And 1)
      Else
        Decoded(I) = Chr(C)
      End If
    Next
    Dim sDone As String = Decoded
    Product = UInt32.Parse(sDone.Substring(0, 2), Globalization.NumberStyles.AllowHexSpecifier)
    PublicVal = UInt32.Parse(sDone.Substring(2, 6), Globalization.NumberStyles.AllowHexSpecifier)
    PrivateVal = UInt32.Parse(sDone.Substring(8), Globalization.NumberStyles.AllowHexSpecifier)
  End Sub
  Friend Function Encode16DigitKey(Product As UInt32, PublicVal As UInt32, PrivateVal As UInt32) As String
    Dim salt As Int32 = &H13AC9741, aOrd() As Byte = {5, 6, 0, 1, 2, 3, 4, 9, 10, 11, 12, 13, 14, 15, 7, 8}, Encoded(15) As Char
    Const CodeValues As String = "246789BCDEFGHJKMNPRTVWXZ"
    Dim Key() As Char = (PadHex(Product, 2) & PadHex(PublicVal, 6) & PadHex(PrivateVal, 8)).ToCharArray
    For I As Int32 = 15 To 0 Step -1
      Dim C As Byte = Asc(Key(I))
      If C <= 55 Then
        Encoded(aOrd(I)) = Chr(C Xor (salt And 7))
        salt >>= 3
      ElseIf C < 65 Then
        Encoded(aOrd(I)) = Chr(C Xor I And 1)
      Else
        Encoded(aOrd(I)) = Chr(C)
      End If
    Next I
    Dim R As Int32 = 3
    For I As Int16 = 0 To 15 : R = R + ((IIf(IsNumeric(Encoded(I)), Asc(Encoded(I)) - &H30, Asc(Char.ToUpper(Encoded(I))) - &H37)) Xor (R * 2)) : Next I
    R = R And &HFF
    Dim tmpByte As Byte = &H80
    For I As Int16 = 14 To 0 Step -2
      Dim A As Int32 = IIf(IsNumeric(Encoded(I)), Asc(Encoded(I)) - &H30, Asc(Char.ToUpper(Encoded(I))) - &H37)
      Dim B As Int32 = (IIf(IsNumeric(Encoded(I + 1)), Asc(Encoded(I + 1)) - &H30, Asc(Char.ToUpper(Encoded(I + 1))) - &H37))
      A = UInt32.Parse(Hex(A) & Hex(B), Globalization.NumberStyles.AllowHexSpecifier)
      If R And tmpByte Then A = A + &H100
      B = 0
      While A >= &H18 : B = B + 1 : A = A - &H18 : End While
      Encoded(I) = Mid(CodeValues, B + 1, 1)
      Encoded(I + 1) = Mid(CodeValues, A + 1, 1)
      tmpByte = tmpByte / 2
    Next I
    Return Encoded
  End Function
  Friend Function PadHex(Value As UInt32, Length As UInt16) As String
    Dim sVal As String = Hex(Value)
    Do While sVal.Length < Length : sVal = "0" & sVal : Loop
    Return sVal
  End Function
End Module