﻿Imports System.Globalization
Imports System.Net

Public Class clsDRTLClient
  Implements IDisposable

  Private Structure BNetInfo
    Dim Username As String
    Dim UniqueName As String
    Dim Password As String
    Dim Statstring() As Byte
    Dim HashPath As String
    Dim ServerToken As UInt32
    Dim ClientToken As UInt32
    Dim UDPToken As UInt32
    Friend Structure CREV
      Dim Path As String
      Dim MPQName As String
      Dim ValueString() As Byte
    End Structure
    Dim CheckRevision As CREV
  End Structure

  Private bnInfo As BNetInfo
  Private sckDRTL As Sockets.TcpClient
  Private sckBuffer() As Byte
  Private Const BUFFER_SIZE As Integer = 102400


  Event SendToGame(data() As Byte)
  Event IsOnline()

  Private isReady As Boolean

  Public ReadOnly Property Online As Boolean
    Get
      If sckDRTL.Connected Then Return isReady
      Return False
    End Get
  End Property

  Public Sub New(Username As String, Password As String, Statstring() As Byte, Server As IPEndPoint, HashesDir As String, CRevDir As String)
    isReady = False
    bnInfo.Username = Username
    bnInfo.Password = Password
    bnInfo.Statstring = Statstring
    bnInfo.HashPath = HashesDir
    bnInfo.CheckRevision.Path = CRevDir
    bnInfo.ClientToken = Environment.TickCount
    sckDRTL = New Sockets.TcpClient
    sckDRTL.BeginConnect(Server.Address, Server.Port, AddressOf Connected, sckDRTL)
  End Sub

  Private Sub Connected(AR As IAsyncResult)
    If sckDRTL.Connected Then
      sckDRTL.Client.Send({&H1})
      BNCS_CLIENTID2_Send()
      BNCS_LOCALEINFO_Send()
      BNCS_STARTVERSIONING_Send()
      Listen()
    End If
  End Sub

  Private Sub Listen()
    Do Until sckBuffer Is Nothing
      Application.DoEvents()
    Loop
    ReDim sckBuffer(BUFFER_SIZE - 1)
    Try
      sckDRTL.Client.BeginReceive(sckBuffer, 0, BUFFER_SIZE, Net.Sockets.SocketFlags.None, New AsyncCallback(AddressOf Receive), sckDRTL)
    Catch ex As Exception
      Me.Dispose()
      Exit Sub
    End Try
  End Sub

  Private Sub Receive(AR As IAsyncResult)
    If sckDRTL Is Nothing Then Exit Sub
    Dim iLen As Integer
    Try
      iLen = sckDRTL.Client.EndReceive(ar)
    Catch ex As Exception
      Me.Dispose()
      Exit Sub
    End Try
    If iLen > 0 Then
      Dim bRet(iLen - 1) As Byte
      Array.Copy(sckBuffer, 0, bRet, 0, iLen)
      Erase sckBuffer
      Dim iStart As Integer = 0
      Do
        If bRet(iStart) = &HFF Then
          Dim bTmp(bRet.Length - iStart - 1) As Byte
          Array.Copy(bRet, iStart, bTmp, 0, bRet.Length - iStart)
          Dim pktTmp As New BNCSReader(bTmp)
          If pktTmp.Length = 0 Then Exit Do
          ReDim Preserve bTmp(pktTmp.Length - 1)
          HandlePacket(pktTmp)
          iStart += pktTmp.Length
        End If
      Loop While iStart < bRet.Length
    End If
    Listen()
  End Sub

  Private Sub HandlePacket(pIn As BNCSReader)
    Select Case pIn.PacketID
      Case &H5 : BNCS_CLIENTID_Recv(pIn)
      Case &H1D : BNCS_LOGONCHALLENGEEX_Recv(pIn)
      Case &H6 : BNCS_STARTVERSIONING_Recv(pIn)
      Case &H7 : BNCS_REPORTVERSION_Recv(pIn)
      Case &H29 : BNCS_LOGONRESPONSE_Recv(pIn)
      Case &HA : BNCS_ENTERCHAT_Recv(pIn)
      Case &H9 : BNCS_GETADVLISTEX_Recv(pIn)
      Case &H25 : BNCS_PING_Recv(pIn)
      Case &HB : BNCS_GETCHANNELLIST_Recv(pIn)
      Case &H1C : BNCS_STARTADVEX3_Recv(pIn)
      Case Else
        Debug.Print("Unknown packet " & Hex(pIn.PacketID))
        Debug.Print(FormatPacket(pIn.GetAllBytes))
    End Select
  End Sub

  Private Sub SendPacket(pOut As BNCSPacket)
    If sckDRTL.Connected Then
      sckDRTL.Client.Send(pOut.GetData)
    Else
      isReady = False
    End If
  End Sub

  Private Sub BNCS_CLIENTID2_Send()
    Using pSend As New BNCSPacket(&H1E)
      pSend.InsertUInt32(0)
      pSend.InsertUInt32(0)
      pSend.InsertUInt32(0)
      pSend.InsertUInt32(0)
      pSend.InsertUInt32(0)
      pSend.InsertCString(Environment.MachineName)
      pSend.InsertCString(Environment.UserName)
      SendPacket(pSend)
    End Using
  End Sub

  Private Sub BNCS_LOCALEINFO_Send()
    Using pSend As New BNCSPacket(&H12)
      Dim lTime As UInt64 = DateTime.Now.ToFileTime
      Dim lAdd As Int64 = ((DateTime.UtcNow - DateTime.Now).TotalMilliseconds * 10000)
      pSend.InsertUInt64(lTime)
      pSend.InsertUInt64(lTime - lAdd)
      pSend.InsertInt32((DateTime.UtcNow - DateTime.Now).TotalMinutes)
      pSend.InsertInt32(CultureInfo.InstalledUICulture.LCID)
      pSend.InsertInt32(CultureInfo.CurrentCulture.LCID)
      pSend.InsertInt32(CultureInfo.CurrentUICulture.LCID)
      pSend.InsertCString(CultureInfo.CurrentCulture.ThreeLetterWindowsLanguageName)
      pSend.InsertCString(RegionInfo.CurrentRegion.NativeName)
      pSend.InsertCString(RegionInfo.CurrentRegion.ThreeLetterWindowsRegionName)
      pSend.InsertCString(RegionInfo.CurrentRegion.EnglishName)
      SendPacket(pSend)
    End Using
  End Sub

  Private Sub BNCS_STARTVERSIONING_Send()
    Using pSend As New BNCSPacket(&H6)
      pSend.InsertDwordString("IX86")
      pSend.InsertDwordString("DRTL")
      pSend.InsertUInt32(&H2A)
      pSend.InsertUInt32(0)
      SendPacket(pSend)
    End Using
  End Sub

  Private Sub BNCS_CLIENTID_Recv(pRecv As BNCSReader)
    Dim RegVer As UInt32 = pRecv.ReadUInt32
    Dim RegAut As UInt32 = pRecv.ReadUInt32
    Dim RegAct As UInt32 = pRecv.ReadUInt32
    Dim RegTok As UInt32 = pRecv.ReadUInt32
  End Sub

  Private Sub BNCS_LOGONCHALLENGEEX_Recv(pRecv As BNCSReader)
    bnInfo.UDPToken = pRecv.ReadUInt32
    bnInfo.ServerToken = pRecv.ReadUInt32
  End Sub

  Private Sub BNCS_STARTVERSIONING_Recv(pRecv As BNCSReader)
    Dim fTime As UInt64 = pRecv.ReadUInt64
    bnInfo.CheckRevision.MPQName = pRecv.ReadCString
    bnInfo.CheckRevision.ValueString = pRecv.ReadNullTerminatedByteArray
    BNCS_REPORTVERSION_Send()
  End Sub

  Private Sub BNCS_REPORTVERSION_Send()
    Using pSend As New BNCSPacket(&H7)

      Dim HashFiles(2) As String
      Dim BINFile As String = Nothing
      Dim EXEVer As Int32
      Dim EXEHash As Int32
      Dim EXEInfo() As Byte
      GetHashFiles(HashFiles, BINFile)

      If bnInfo.CheckRevision.MPQName.ToLower.Contains("ix86") Then
        If bnInfo.CheckRevision.MPQName.Contains("ver") Then
          Dim sRequest = System.Text.Encoding.GetEncoding(28591).GetString(bnInfo.CheckRevision.ValueString)
          Dim EXEInfoS As String = String.Empty
          EXEVer = CheckRevision.GetExeInfo(HashFiles(0), EXEInfoS)
          EXEHash = CheckRevision.DoCheckRevision(sRequest, HashFiles, CheckRevision.ExtractMPQNumber(bnInfo.CheckRevision.MPQName))
          EXEInfo = System.Text.Encoding.GetEncoding(28591).GetBytes(EXEInfoS)
        ElseIf bnInfo.CheckRevision.MPQName.Contains("lockdown") Then
          Dim DLLPath As String = bnInfo.CheckRevision.Path & "\" & bnInfo.CheckRevision.MPQName.Substring(0, InStr(bnInfo.CheckRevision.MPQName, ".")) & "dll"
          If Not My.Computer.FileSystem.FileExists(DLLPath) Then
            frmStart.SetStatus(DLLPath & " not found!")
            frmStart.LogData("D1 Client " & DLLPath & " not found!")
            sckDRTL.Close()
            Exit Sub
          End If
          EXEInfo = Lockdown.CheckRevision(bnInfo.CheckRevision.ValueString, HashFiles, DLLPath, BINFile, EXEVer, EXEHash)
        Else
          frmStart.SetStatus(bnInfo.CheckRevision.MPQName & " not supported. Unrecognized library!")
          frmStart.LogData("D1 Client " & bnInfo.CheckRevision.MPQName & " not supported. Unrecognized library!")
          Exit Sub
        End If
      Else
        frmStart.SetStatus(bnInfo.CheckRevision.MPQName & " not supported. Not IX86!")
        frmStart.LogData("D1 Client " & bnInfo.CheckRevision.MPQName & " not supported. Not IX86!")
        Exit Sub
      End If
      pSend.InsertDwordString("IX86")
      pSend.InsertDwordString("DRTL")
      pSend.InsertUInt32(&H2A)
      pSend.InsertInt32(EXEVer)
      pSend.InsertInt32(EXEHash)
      pSend.InsertByteArray(EXEInfo)
      pSend.InsertByte(0)
      SendPacket(pSend)
    End Using
  End Sub

  Private Sub BNCS_REPORTVERSION_Recv(pRecv As BNCSReader)
    Dim Result As UInt32 = pRecv.ReadUInt32
    Select Case Result
      Case 0
        frmStart.SetStatus("Failed Version Check")
        frmStart.LogData("D1 Client Failed Version Check")
      Case 1
        frmStart.SetStatus("Old Game Version")
        frmStart.LogData("D1 Client Old Game Version")
      Case 2
        BNCS_LOGONRESPONSE_Send()
      Case 3
        frmStart.SetStatus("Reinstall Required")
        frmStart.LogData("D1 Client Reinstall Required")
      Case Else
        frmStart.SetStatus("Unknown Response: " & Result)
        frmStart.LogData("D1 Client Unknown Response: " & Result)
    End Select
  End Sub

  Private Sub BNCS_LOGONRESPONSE_Send()
    Using pSend As New BNCSPacket(&H29)
      pSend.InsertUInt32(bnInfo.ClientToken)
      pSend.InsertUInt32(bnInfo.ServerToken)
      pSend.InsertByteArray(XSHA.DoubleHashPassword(bnInfo.Password, bnInfo.ClientToken, bnInfo.ServerToken))
      pSend.InsertCString(bnInfo.Username)
      SendPacket(pSend)
    End Using
  End Sub

  Private Sub BNCS_LOGONRESPONSE_Recv(pRecv As BNCSReader)
    Dim Result As UInt32 = pRecv.ReadUInt32
    Select Case Result
      Case 0
        frmStart.SetStatus("Invalid Password")
        frmStart.LogData("D1 Client Invalid Password")
      Case 1
        BNCS_UDPPINGRESPONSE_Send()
        BNCS_ENTERCHAT_Send()
        BNCS_GETCHANNELLIST_Send()
        BNCS_JOINCHANNEL_Send("Diablo Warcraft")
    End Select
  End Sub

  Private Sub BNCS_UDPPINGRESPONSE_Send()
    Using pSend As New BNCSPacket(&H14)
      pSend.InsertUInt32(&H626E6574)
      SendPacket(pSend)
    End Using
  End Sub

  Private Sub BNCS_ENTERCHAT_Send()
    Using pSend As New BNCSPacket(&HA)
      pSend.InsertCString(bnInfo.Username)
      pSend.InsertByteArray(bnInfo.Statstring)
      pSend.InsertByte(0)
      SendPacket(pSend)
    End Using
  End Sub

  Private Sub BNCS_GETCHANNELLIST_Send()
    Using pSend As New BNCSPacket(&HB)
      pSend.InsertDwordString("DRTL")
      SendPacket(pSend)
    End Using
  End Sub

  Private Sub BNCS_JOINCHANNEL_Send(Channel As String)
    Using pSend As New BNCSPacket(&HC)
      pSend.InsertUInt32(&H2)
      pSend.InsertCString(Channel)
      SendPacket(pSend)
    End Using
  End Sub

  Private Sub BNCS_ENTERCHAT_Recv(pRecv As BNCSReader)
    bnInfo.UniqueName = pRecv.ReadCString
    bnInfo.Statstring = pRecv.ReadNullTerminatedByteArray
    bnInfo.Username = pRecv.ReadCString
    isReady = True
    RaiseEvent IsOnline()
  End Sub

  Private Sub BNCS_GETCHANNELLIST_Recv(pRecv As BNCSReader)
    'RaiseEvent SendToGame(pRecv.GetAllBytes)
  End Sub

  Public Sub BNCS_GETADVLISTEX_Send(GameType As UInt16, GameSubType As UInt16, Filter As UInt32, Reserved As UInt32, GameCount As UInt32, GameName As String, GamePass As String, GameStat As String)
    Using pSend As New BNCSPacket(&H9)
      pSend.InsertUInt16(GameType)
      pSend.InsertUInt16(GameSubType)
      pSend.InsertUInt32(0)
      pSend.InsertUInt32(Reserved)
      pSend.InsertUInt32(GameCount)
      pSend.InsertCString(GameName)
      pSend.InsertCString(GamePass)
      pSend.InsertCString(GameStat)
      SendPacket(pSend)
    End Using
  End Sub

  Private Sub BNCS_GETADVLISTEX_Recv(pRecv As BNCSReader)
    RaiseEvent SendToGame(pRecv.GetAllBytes)
  End Sub

  Public Sub BNCS_STARTADVEX3_Send(State As UInt32, UpTime As UInt32, GameType As UInt16, Teams As UInt16, Unknown As UInt32, Ladder As UInt32, GameName As String, GamePassword As String, GameStatString As String)
    Using pSend As New BNCSPacket(&H1C)
      pSend.InsertUInt32(State)
      pSend.InsertUInt32(UpTime)
      pSend.InsertUInt16(GameType)
      pSend.InsertUInt16(Teams)
      pSend.InsertUInt32(Unknown)
      pSend.InsertUInt32(Ladder)
      pSend.InsertCString(GameName)
      pSend.InsertCString(GamePassword)
      pSend.InsertCString(GameStatString)
      SendPacket(pSend)
    End Using
  End Sub

  Public Sub BNCS_STARTADVEX3_Recv(pRecv As BNCSReader)
    Dim Status As UInt32 = pRecv.ReadUInt32
    Select Case Status
      Case 0 'OK
      Case 1 : frmStart.LogData("D1 Client Failed to create game")
      Case Else : frmStart.LogData("D1 Client Unknown game creation result: " & Status)
    End Select
  End Sub

  Public Sub LeaveGame()
    BNCS_STOPADV_Send()
    BNCS_ENTERCHAT_Send()
    BNCS_GETCHANNELLIST_Send()
    BNCS_JOINCHANNEL_Send("Diablo Warcraft")
  End Sub

  Public Sub BNCS_STOPADV_Send()
    Using pSend As New BNCSPacket(&H2)
      SendPacket(pSend)
    End Using
  End Sub

  Public Sub BNCS_NOTIFYJOIN_Send(ProductID As UInt32, ProductVer As UInt32, GameName As String, GamePass As String)
    Using pSend As New BNCSPacket(&H22)
      pSend.InsertUInt32(ProductID)
      pSend.InsertUInt32(ProductVer)
      pSend.InsertCString(GameName)
      pSend.InsertCString(GamePass)
      SendPacket(pSend)
    End Using
  End Sub

  Private Sub BNCS_PING_Recv(pRecv As BNCSReader)
    Dim PingVal As UInt32 = pRecv.ReadUInt32
    BNCS_PING_Send(PingVal)
  End Sub

  Private Sub BNCS_PING_Send(PingVal As UInt32)
    Using pSend As New BNCSPacket(&H25)
      pSend.InsertUInt32(PingVal)
      SendPacket(pSend)
    End Using
  End Sub

  Public Sub BNCS_LEAVECHAT_Send()
    Using pSend As New BNCSPacket(&H10)
      SendPacket(pSend)
    End Using
  End Sub

  Private Sub GetHashFiles(ByRef HashFiles() As String, ByRef BINFile As String)
    HashFiles(0) = bnInfo.HashPath & "\Diablo.exe"
    HashFiles(1) = bnInfo.HashPath & "\Storm.dll"
    HashFiles(2) = bnInfo.HashPath & "\Battle.snp"
    BINFile = bnInfo.HashPath & "\DRTL.bin"
  End Sub

#Region "IDisposable Support"
  Private disposedValue As Boolean ' To detect redundant calls

  ' IDisposable
  Protected Overridable Sub Dispose(disposing As Boolean)
    If Not Me.disposedValue Then
      If disposing Then
        If sckDRTL IsNot Nothing Then
          sckDRTL.Close()
          sckDRTL = Nothing
        End If
        ' TODO: dispose managed state (managed objects).
      End If

      ' TODO: free unmanaged resources (unmanaged objects) and override Finalize() below.
      ' TODO: set large fields to null.
    End If
    Me.disposedValue = True
  End Sub

  ' TODO: override Finalize() only if Dispose(ByVal disposing As Boolean) above has code to free unmanaged resources.
  'Protected Overrides Sub Finalize()
  '    ' Do not change this code.  Put cleanup code in Dispose(ByVal disposing As Boolean) above.
  '    Dispose(False)
  '    MyBase.Finalize()
  'End Sub

  ' This code added by Visual Basic to correctly implement the disposable pattern.
  Public Sub Dispose() Implements IDisposable.Dispose
    ' Do not change this code.  Put cleanup code in Dispose(ByVal disposing As Boolean) above.
    Dispose(True)
    GC.SuppressFinalize(Me)
  End Sub
#End Region

End Class
