Attribute VB_Name = "modRBNLib"
'Ripple's Battle.Net Library
'Copyright 2007 - 2008 RealityRipple Software

'This code is free software; you can redistribute it and/or modify
'it under the terms of the GNU General Public License as published by
'the Free Software Foundation; either version 2 of the License, or
'(at your option) any later version.

'This code is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
'GNU General Public License for more details.

'You should have received a copy of the GNU General Public License
'along with this code; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

Option Explicit
Private Declare Function BrokenSHA Lib "RBNLib.dll" (sVal As String) As String
Private Declare Function StandardSHA Lib "RBNLib.dll" (sVal As String) As String
Private Declare Function LockdownSHA Lib "RBNLib.dll" (sVal As String) As String
Private Declare Function MD5 Lib "RBNLib.dll" (sVal As String) As String
Private Declare Function DoubleHashPassword Lib "SHA.dll" (Password As String, ClientToken As Long, ServerToken As Long) As String
Private Declare Function HashCDKey Lib "RBNLib.dll" (CDKey As String, Auth As Boolean, ClientToken As Long, ServerToken As Long, Product As Long, PublicVal As Long, KeyHash As String) As Byte
Private Declare Function HashCDKeyEx Lib "RBNLib.dll" (CDKey As String, Auth As Boolean, ClientToken As Long, ServerToken As Long, Product As Long, PublicVal As Long, PrivateVal As Long, KeyHash As String) As Byte
Private Declare Function CheckRevisionA Lib "RBNLib.dll" (Request As String, EXEPath As String, DLLPath As String, SNPPath As String, MPQName As String, EXEVer As Long, Checksum As Long, EXEInfo As String) As Byte

'HashPassword
' This function is used for Single Hashing passwords, which is used in
'  creating accounts and changing passwords with the Old Logon System
' In:
'  (String) Password   - Password to hash
' Out:
'  (String) Hash       - Hash of the password
Public Function HashPassword(ByVal Password As String) As String
  HashPassword = BrokenSHA(Password)
End Function

'HashPasswordTwice
' This function is used for Double Hashing passwords, which is used in
'  logging in with the Old Logon System
' In:
'  (String) Password   - Password to hash
'  (Long) Client Token - Connection Client Token
'  (Long) Server Token - Connection Server Token
' Out:
'  (String) Hash       - Hash of the password
Public Function HashPasswordTwice(ByVal Password As String, ByVal ClientToken As Long, ByVal ServerToken As Long) As String
  HashPasswordTwice = DoubleHashPassword(Password, ClientToken, ServerToken)
End Function

'HashKey
' This function is used for Hashing CD Keys. It can handle Starcraft,
'  Warcraft II, Diablo II, and Warcraft III CD Keys, in either OLS or NLS style.
' In:
'  (String) CD Key     - CD Key to hash, no extra characters, all capitals.
'  (Boolean) Auth      - NLS/OLS toggle. If using SID_CDKEY(2), set to False. If using SID_AUTH_*, set to True.
'  (Long) Client Token - Connection Client Token
'  (Long) Server Token - Connection Server Token
' Out:
'  (Long) Product      - CD Key's Product Value
'  (Long) Public Val   - CD Key's Public Value
'  (String) Key Hash   - Hash of the CD Key (Should be 20 characters long)
'  (Byte) Return       - Return Values as defined below
'   0                  - OK
'   1                  - Bad CD Key Length
'   2                  - Wrong Product
'   3                  - Check failed (STAR keys only for now)
Public Function HashKey(ByVal CDKey As String, ByVal UsingAuth As Boolean, ByVal ClientToken As Long, ByVal ServerToken As Long, ByRef Product As Long, ByRef PublicVal As Long, ByRef KeyHash As String) As Byte
  HashKey = HashCDKey(CDKey, UsingAuth, ClientToken, ServerToken, Product, PublicVal, KeyHash)
End Function

'HashKeyEx
' This function is used for Hashing CD Keys. It can handle Starcraft,
'  Warcraft II, Diablo II, and Warcraft III CD Keys, in either OLS or NLS style.
'  HashCDKeyEx returns PrivateVal, whereas HashCDKey doesn't.
' In:
'  (String) CD Key     - CD Key to hash, no extra characters, all capitals.
'  (Boolean) Auth      - NLS/OLS toggle. If using SID_CDKEY(2), set to False. If using SID_AUTH_*, set to True.
'  (Long) Client Token - Connection Client Token
'  (Long) Server Token - Connection Server Token
' Out:
'  (Long) Product      - CD Key's Product Value
'  (Long) Public Val   - CD Key's Public Value
'  (Long) Private Val  - CD Key's Private Value
'  (String) Key Hash   - Hash of the CD Key (Should be 20 characters long)
'  (Byte) Return       - Return Values as defined below
'   0                  - OK
'   1                  - Bad CD Key Length
'   2                  - Wrong Product
'   3                  - Check failed (STAR keys only for now)
Public Function HashKeyEx(ByVal CDKey As String, ByVal UsingAuth As Boolean, ByVal ClientToken As Long, ByVal ServerToken As Long, ByRef Product As Long, ByRef PublicVal As Long, ByRef PrivateVal As Long, ByRef KeyHash As String) As Byte
  HashKeyEx = HashCDKeyEx(CDKey, UsingAuth, ClientToken, ServerToken, Product, PublicVal, PrivateVal, KeyHash)
End Function

'CRevA
' This function is used for calculating CheckRevision Results for ver-PLAT-#.dll and PLATver#.dll.
'  Diablo II and Warcraft 3 CheckRevision
' In:
'  (String) Request    - Request string from Battle.net
'  (String) EXE Path   - Path to Executable file
'  (String) DLL Path   - Path to DLL file
'  (String) SNP Path   - Path to SNP file
'  (String) MPQ Name   - Name of the MPQ being used
' Out:
'  (Long) EXEVer       - Executable Version
'  (Long) Checksum     - Executable Checksum
'  (String) EXEInfo    - Executable Information
'  (Byte) Return       - Return values as defined below
'   0                  - OK
'   1                  - Bad Request
'   2                  - Bad MPQ
Public Function CRevA(Request As String, EXEPath As String, DLLPath As String, SNPPath As String, MPQName As String, EXEVer As Long, Checksum As Long, EXEInfo As String) As Byte
  CRevA = CheckRevisionA(Request, EXEPath, DLLPath, SNPPath, MPQName, EXEVer, Checksum, EXEInfo)
End Function
