/*
 * Decompiled with CFR 0.152.
 */
package sed.authemu;

import sed.authemu.HashSHA1FactoryAbstract;

public final class HashSHA1 {
    private byte[] pad = new byte[64];
    private long pad_index;
    private int[] context = new int[5];
    private static HashSHAFactoryImpl hash_sha_factory = new HashSHAFactoryImpl(null);

    public static HashSHA1FactoryAbstract getHashSHAObject() {
        return hash_sha_factory;
    }

    public HashSHA1() {
        this.initContext();
    }

    private HashSHA1(HashSHA1 other) {
        this.pad_index = other.pad_index;
        System.arraycopy(other.context, 0, this.context, 0, 5);
        System.arraycopy(other.pad, 0, this.pad, 0, (int)(this.pad_index & 0x3FL));
    }

    public final HashSHA1 getInstanceCopy() {
        return new HashSHA1(this);
    }

    public final int hashCode() {
        byte[] d = this.getDigest();
        return HashSHA1.bytesToDWord(d, 0) + HashSHA1.bytesToDWord(d, 1) + HashSHA1.bytesToDWord(d, 2) + HashSHA1.bytesToDWord(d, 3) + HashSHA1.bytesToDWord(d, 4);
    }

    public final int getBlockSize() {
        return 64;
    }

    public final void initContext() {
        this.pad_index = 0L;
        this.context[0] = 1732584193;
        this.context[1] = -271733879;
        this.context[2] = -1732584194;
        this.context[3] = 271733878;
        this.context[4] = -1009589776;
    }

    public final void updateEngine(byte[] input, int offset, int len) {
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("index is negative");
        }
        if (len < 0) {
            throw new NegativeArraySizeException("size is negative");
        }
        if (offset + len < offset || offset + len > input.length) {
            throw new ArrayIndexOutOfBoundsException("index and/or size are too large");
        }
        int i = 0;
        while (len > 0) {
            int j = (int)this.pad_index & 0x3F;
            int k = len <= 64 - j ? len : 64 - j;
            if (k == 64) {
                HashSHA1.hashBlock(input, offset + i, this.context);
            } else {
                System.arraycopy(input, offset + i, this.pad, j, k);
                if (j + k == 64) {
                    HashSHA1.hashBlock(this.pad, 0, this.context);
                }
            }
            this.pad_index += (long)k;
            i += k;
            len -= k;
        }
    }

    public final void updateEngine(byte[] input) {
        this.updateEngine(input, 0, input.length);
    }

    public final byte[] getDigest() {
        int j = (int)this.pad_index & 0x3F;
        this.pad[j] = -128;
        boolean flag = false;
        int k = 56 - (j + 1);
        if (k < 0) {
            k += 8;
            flag = true;
        }
        int i = 0;
        while (i < k) {
            this.pad[j + 1 + i] = 0;
            ++i;
        }
        int[] ai = new int[5];
        System.arraycopy(this.context, 0, ai, 0, 5);
        byte[] abyte0 = this.pad;
        if (flag) {
            HashSHA1.hashBlock(this.pad, 0, ai);
            abyte0 = new byte[64];
        }
        long l1 = this.pad_index * 8L;
        abyte0[56] = (byte)(l1 >>> 56);
        abyte0[57] = (byte)(l1 >>> 48);
        abyte0[58] = (byte)(l1 >>> 40);
        abyte0[59] = (byte)(l1 >>> 32);
        abyte0[60] = (byte)(l1 >>> 24);
        abyte0[61] = (byte)(l1 >>> 16);
        abyte0[62] = (byte)(l1 >>> 8);
        abyte0[63] = (byte)l1;
        HashSHA1.hashBlock(abyte0, 0, ai);
        byte[] digest = new byte[20];
        int j1 = 0;
        while (j1 < 20) {
            int k1 = ai[j1 / 4];
            digest[j1++] = (byte)(k1 >>> 24);
            digest[j1++] = (byte)(k1 >>> 16);
            digest[j1++] = (byte)(k1 >>> 8);
            digest[j1++] = (byte)k1;
        }
        return digest;
    }

    private static int rotDwordLeft(int shift, int x) {
        return (x << shift) + (x >>> 32 - shift);
    }

    private static int bytesToDWord(byte[] abyte0, int offset) {
        return ((abyte0[offset] & 0xFF) << 24) + ((abyte0[offset + 1] & 0xFF) << 16) + ((abyte0[offset + 2] & 0xFF) << 8) + (abyte0[offset + 3] & 0xFF);
    }

    private static void hashBlock(byte[] input, int offset, int[] context) {
        int[] ai1 = new int[80];
        int k = 0;
        while (k < 16) {
            ai1[k] = HashSHA1.bytesToDWord(input, offset + k * 4);
            ++k;
        }
        while (k < 80) {
            ai1[k] = HashSHA1.rotDwordLeft(1, ai1[k - 3] ^ ai1[k - 8] ^ ai1[k - 14] ^ ai1[k - 16]);
            ++k;
        }
        int i1 = context[0];
        int j1 = context[1];
        int k1 = context[2];
        int l1 = context[3];
        int i2 = context[4];
        k = 0;
        do {
            i2 += HashSHA1.rotDwordLeft(5, i1) + (j1 & k1 | ~j1 & l1) + ai1[k++] + 1518500249;
            j1 = HashSHA1.rotDwordLeft(30, j1);
            l1 += HashSHA1.rotDwordLeft(5, i2) + (i1 & j1 | ~i1 & k1) + ai1[k++] + 1518500249;
            i1 = HashSHA1.rotDwordLeft(30, i1);
            k1 += HashSHA1.rotDwordLeft(5, l1) + (i2 & i1 | ~i2 & j1) + ai1[k++] + 1518500249;
            i2 = HashSHA1.rotDwordLeft(30, i2);
            j1 += HashSHA1.rotDwordLeft(5, k1) + (l1 & i2 | ~l1 & i1) + ai1[k++] + 1518500249;
            l1 = HashSHA1.rotDwordLeft(30, l1);
            i1 += HashSHA1.rotDwordLeft(5, j1) + (k1 & l1 | ~k1 & i2) + ai1[k++] + 1518500249;
            k1 = HashSHA1.rotDwordLeft(30, k1);
        } while (k < 20);
        do {
            i2 += HashSHA1.rotDwordLeft(5, i1) + (j1 ^ k1 ^ l1) + ai1[k++] + 1859775393;
            j1 = HashSHA1.rotDwordLeft(30, j1);
            l1 += HashSHA1.rotDwordLeft(5, i2) + (i1 ^ j1 ^ k1) + ai1[k++] + 1859775393;
            i1 = HashSHA1.rotDwordLeft(30, i1);
            k1 += HashSHA1.rotDwordLeft(5, l1) + (i2 ^ i1 ^ j1) + ai1[k++] + 1859775393;
            i2 = HashSHA1.rotDwordLeft(30, i2);
            j1 += HashSHA1.rotDwordLeft(5, k1) + (l1 ^ i2 ^ i1) + ai1[k++] + 1859775393;
            l1 = HashSHA1.rotDwordLeft(30, l1);
            i1 += HashSHA1.rotDwordLeft(5, j1) + (k1 ^ l1 ^ i2) + ai1[k++] + 1859775393;
            k1 = HashSHA1.rotDwordLeft(30, k1);
        } while (k < 40);
        do {
            i2 += HashSHA1.rotDwordLeft(5, i1) + (j1 & k1 | j1 & l1 | k1 & l1) + ai1[k++] + -1894007588;
            j1 = HashSHA1.rotDwordLeft(30, j1);
            l1 += HashSHA1.rotDwordLeft(5, i2) + (i1 & j1 | i1 & k1 | j1 & k1) + ai1[k++] + -1894007588;
            i1 = HashSHA1.rotDwordLeft(30, i1);
            k1 += HashSHA1.rotDwordLeft(5, l1) + (i2 & i1 | i2 & j1 | i1 & j1) + ai1[k++] + -1894007588;
            i2 = HashSHA1.rotDwordLeft(30, i2);
            j1 += HashSHA1.rotDwordLeft(5, k1) + (l1 & i2 | l1 & i1 | i2 & i1) + ai1[k++] + -1894007588;
            l1 = HashSHA1.rotDwordLeft(30, l1);
            i1 += HashSHA1.rotDwordLeft(5, j1) + (k1 & l1 | k1 & i2 | l1 & i2) + ai1[k++] + -1894007588;
            k1 = HashSHA1.rotDwordLeft(30, k1);
        } while (k < 60);
        do {
            i2 += HashSHA1.rotDwordLeft(5, i1) + (j1 ^ k1 ^ l1) + ai1[k++] + -899497514;
            j1 = HashSHA1.rotDwordLeft(30, j1);
            l1 += HashSHA1.rotDwordLeft(5, i2) + (i1 ^ j1 ^ k1) + ai1[k++] + -899497514;
            i1 = HashSHA1.rotDwordLeft(30, i1);
            k1 += HashSHA1.rotDwordLeft(5, l1) + (i2 ^ i1 ^ j1) + ai1[k++] + -899497514;
            i2 = HashSHA1.rotDwordLeft(30, i2);
            j1 += HashSHA1.rotDwordLeft(5, k1) + (l1 ^ i2 ^ i1) + ai1[k++] + -899497514;
            l1 = HashSHA1.rotDwordLeft(30, l1);
            i1 += HashSHA1.rotDwordLeft(5, j1) + (k1 ^ l1 ^ i2) + ai1[k++] + -899497514;
            k1 = HashSHA1.rotDwordLeft(30, k1);
        } while (k < 80);
        context[0] = context[0] + i1;
        context[1] = context[1] + j1;
        context[2] = context[2] + k1;
        context[3] = context[3] + l1;
        context[4] = context[4] + i2;
    }

    private static class HashSHAFactoryImpl
    extends HashSHA1FactoryAbstract {
        @Override
        public final HashSHA1 getInstance() {
            return new HashSHA1();
        }

        private HashSHAFactoryImpl() {
        }

        HashSHAFactoryImpl(StubEmptySHA n1) {
            this();
        }
    }

    static class StubEmptySHA {
        StubEmptySHA() {
        }
    }
}

