/*
 * Decompiled with CFR 0.152.
 */
package sed.authemu;

import sed.authemu.HashSHA1;
import sed.authemu.HashSHA1FactoryAbstract;

public final class HMAC {
    protected final HashSHA1 hash1;
    protected final HashSHA1 hash2;

    public HMAC(HashSHA1FactoryAbstract h1) {
        this.hash1 = h1.getInstance();
        this.hash2 = h1.getInstance();
    }

    public final int hashCode() {
        return this.hash1.hashCode() + this.hash2.hashCode();
    }

    public final void mysteryUpdate(byte[] input) {
        this.mysteryUpdate(input, 0, input.length);
    }

    private void mysteryUpdate(byte[] input, int offset, int len) {
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("index is negative");
        }
        if (len < 0) {
            throw new NegativeArraySizeException("size is negative");
        }
        if (offset + len < offset || offset + len > input.length) {
            throw new ArrayIndexOutOfBoundsException("index and/or size are too large");
        }
        int k = this.hash1.getBlockSize();
        if (len > k) {
            this.hash1.initContext();
            this.hash1.updateEngine(input, offset, len);
            input = this.hash1.getDigest();
            len = input.length;
        }
        byte[] abyte0 = new byte[k];
        int i = 0;
        while (i < len) {
            abyte0[i] = (byte)(input[i] ^ 0x36);
            ++i;
        }
        while (i < k) {
            abyte0[i] = 54;
            ++i;
        }
        this.hash2.initContext();
        this.hash2.updateEngine(abyte0);
        i = 0;
        while (i < len) {
            abyte0[i] = (byte)(input[i] ^ 0x5C);
            ++i;
        }
        while (i < k) {
            abyte0[i] = 92;
            ++i;
        }
        this.hash1.initContext();
        this.hash1.updateEngine(abyte0);
    }

    public final void updateHash2(byte[] input) {
        this.hash2.updateEngine(input);
    }

    public final byte[] getDigest() {
        HashSHA1 result = this.hash1.getInstanceCopy();
        result.updateEngine(this.hash2.getDigest());
        return result.getDigest();
    }
}

