/*
 * Decompiled with CFR 0.152.
 */
package sed.authemu;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import sed.authemu.AuthKeyGen;
import sed.authemu.BlizzCrypt;

public class Authenticator {
    public static Map<String, Map<String, String>> str_consts;
    public long time_diff;
    public String str_serial;
    public String str_token;
    byte[] xor_key_random37;
    byte[] token;
    String last_key_string;
    long last_key_time;

    public Authenticator() {
        str_consts = new HashMap<String, Map<String, String>>();
        str_consts.put("US", new HashMap());
        str_consts.put("EU", new HashMap());
        str_consts.get("US").put("auth-url-enroll", "http://m.us.mobileservice.blizzard.com/enrollment/enroll.htm");
        str_consts.get("US").put("auth-url-time", "http://m.us.mobileservice.blizzard.com/enrollment/time.htm");
        str_consts.get("US").put("auth-url-setup", "http://www.battle.net/bma");
        str_consts.get("US").put("auth-url-acctmgmt", "http://www.battle.net/account/management");
        str_consts.get("US").put("auth-region", "US");
        str_consts.get("US").put("auth-phone-model", "Motorola RAZR v3");
        str_consts.get("EU").put("auth-url-enroll", "http://m.eu.mobileservice.blizzard.com/enrollment/enroll.htm");
        str_consts.get("EU").put("auth-url-time", "http://m.eu.mobileservice.blizzard.com/enrollment/time.htm");
        str_consts.get("EU").put("auth-url-setup", "http://eu.battle.net/bma");
        str_consts.get("EU").put("auth-url-acctmgmt", "http://eu.battle.net/account/management");
        str_consts.get("EU").put("auth-region", "EU");
        str_consts.get("EU").put("auth-phone-model", "Motorola RAZR v3");
        this.last_key_time = 0L;
        this.last_key_string = null;
    }

    String getRegion() {
        return this.str_serial == null ? "" : this.str_serial.substring(0, 2);
    }

    public long timeSinceLastKeyChange() {
        return (System.currentTimeMillis() + this.time_diff) % 30000L;
    }

    public String getAuthKey() {
        long time_last_div;
        long time_now = System.currentTimeMillis();
        long time_div = (time_now + this.time_diff) / 30000L;
        if (time_div != (time_last_div = (this.last_key_time + this.time_diff) / 30000L)) {
            this.last_key_time = time_now;
            return this.getAuthKeyString(time_div);
        }
        return this.last_key_string;
    }

    public void setSerial(String s_token, String s_serial, long t_diff) {
        this.time_diff = t_diff;
        this.checkAndStoreTokenSerial(s_token, s_serial);
        if (s_token == null || s_serial == null) {
            throw new RuntimeException("invalid token or serial number");
        }
        this.parseTokenString();
    }

    private String getAuthKeyString(long time_divided) {
        int i = AuthKeyGen.calcAuthKey(this.token, time_divided, 8);
        String authkey = "";
        int j = 0;
        while (j < 8) {
            authkey = String.valueOf(i % 10) + authkey;
            i /= 10;
            ++j;
        }
        return authkey;
    }

    private void checkAndStoreTokenSerial(String token, String serial) {
        char c;
        int i;
        boolean valid_token = false;
        boolean valid_serial = false;
        if (token.length() == 40) {
            valid_token = true;
            for (i = 0; i < 40 && (valid_token &= (c = token.charAt(i)) >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F'); ++i) {
            }
        }
        if (serial.length() == 17) {
            valid_serial = true;
            for (i = 0; i < 17; ++i) {
                c = serial.charAt(i);
                valid_serial = i < 2 ? (valid_serial &= c == 'E' || c == 'U' || c == 'S') : (valid_serial &= c >= '0' && c <= '9' || c == '-');
                if (!valid_serial) break;
            }
        }
        if (valid_token && valid_serial) {
            this.str_token = token;
            this.str_serial = serial;
            return;
        }
        this.str_token = null;
        this.str_serial = null;
    }

    private void parseTokenString() {
        if (this.str_serial != null && this.str_token != null) {
            byte[] btoken = new byte[20];
            int i = 0;
            while (i < this.str_token.length()) {
                byte b;
                btoken[i >> 1] = b = (byte)((Authenticator.hexcharToNibble(this.str_token.charAt(i)) << 4) + Authenticator.hexcharToNibble(this.str_token.charAt(i + 1)));
                i += 2;
            }
            this.token = btoken;
            return;
        }
    }

    byte[] generateEnrollmentMash(String region) {
        this.xor_key_random37 = BlizzCrypt.genRandomBytes(37);
        byte[] mash = new byte[55];
        System.arraycopy(this.xor_key_random37, 0, mash, 0, 37);
        byte[] tmp = region.getBytes();
        System.arraycopy(tmp, 0, mash, 37, Math.min(tmp.length, 2));
        tmp = str_consts.get(region).get("auth-phone-model").getBytes();
        System.arraycopy(tmp, 0, mash, 39, Math.min(tmp.length, 16));
        return mash;
    }

    static long bytesToLong(byte[] abyte, int offset) {
        long result = 0L;
        int k = offset;
        while (k < offset + 8) {
            result <<= 8;
            long l1 = abyte[k] & 0xFF;
            result += l1;
            ++k;
        }
        return result;
    }

    private static char nibbleToHexChar(int nibble) {
        if (nibble < 10) {
            return (char)(48 + nibble);
        }
        return (char)(97 + (nibble - 10));
    }

    private static int hexcharToNibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + (c - 65);
        }
        return 0;
    }

    public void net_enroll(String region) throws IOException {
        if (!region.equals("EU") && !region.equals("US")) {
            throw new RuntimeException("invalid region code");
        }
        URL url_enroll = new URL(str_consts.get(region).get("auth-url-enroll"));
        HttpURLConnection conn = (HttpURLConnection)url_enroll.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-type", "application/octet-stream");
        conn.setRequestProperty("Accept", "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2");
        conn.setReadTimeout(10000);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.connect();
        BlizzCrypt.prepareEnrollmentBytes(this.generateEnrollmentMash(region));
        while (BlizzCrypt.round() != 12) {
        }
        byte[] data_out = BlizzCrypt.getOTPBytes();
        OutputStream out_stream = conn.getOutputStream();
        out_stream.write(data_out);
        out_stream.close();
        byte[] b_servertime = new byte[8];
        byte[] b_token_and_serial = new byte[37];
        InputStream inp_stream = conn.getInputStream();
        inp_stream.read(b_servertime, 0, 8);
        inp_stream.read(b_token_and_serial, 0, 37);
        inp_stream.close();
        conn.disconnect();
        byte[] b_token = new byte[20];
        byte[] b_serial = new byte[17];
        this.time_diff = Authenticator.bytesToLong(b_servertime, 0) - System.currentTimeMillis();
        BlizzCrypt.xorEncryptArray(b_token_and_serial, this.xor_key_random37);
        System.arraycopy(b_token_and_serial, 0, b_token, 0, 20);
        System.arraycopy(b_token_and_serial, 20, b_serial, 0, 17);
        char[] c_token = new char[40];
        int i = 0;
        while (i < 20) {
            int nib_up = (b_token[i] & 0xF0) >> 4;
            int nib_lo = b_token[i] & 0xF;
            c_token[i * 2] = Authenticator.nibbleToHexChar(nib_up);
            c_token[i * 2 + 1] = Authenticator.nibbleToHexChar(nib_lo);
            ++i;
        }
        this.setSerial(new String(c_token), new String(b_serial, 0, 17), this.time_diff);
    }

    public void net_sync() throws IOException {
        URL url_sync = new URL(str_consts.get(this.getRegion()).get("auth-url-time"));
        HttpURLConnection conn = (HttpURLConnection)url_sync.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content-type", "application/octet-stream");
        conn.setRequestProperty("Accept", "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2");
        conn.setReadTimeout(10000);
        conn.setDoInput(true);
        conn.connect();
        byte[] b_servertime = new byte[8];
        InputStream inp_stream = conn.getInputStream();
        inp_stream.read(b_servertime, 0, 8);
        inp_stream.close();
        conn.disconnect();
        this.time_diff = Authenticator.bytesToLong(b_servertime, 0) - System.currentTimeMillis();
    }
}

