/*
 * Decompiled with CFR 0.152.
 */
package sed.authemu;

import sed.authemu.HMAC;
import sed.authemu.HashSHA1;

public final class AuthKeyGen {
    private static final int[] mysteryNumbers = new int[]{1000000, 10000000, 100000000};

    private static int tailbytesToInt(byte[] input) {
        int i = input[input.length - 1] & 0xF;
        return ((input[i] & 0x7F) << 24) + ((input[i + 1] & 0xFF) << 16) + ((input[i + 2] & 0xFF) << 8) + (input[i + 3] & 0xFF);
    }

    public static int calcAuthKey(byte[] token, long time_divided, int mysteryOffset) {
        HMAC hmac = new HMAC(HashSHA1.getHashSHAObject());
        hmac.mysteryUpdate(token);
        byte[] byArray = new byte[8];
        byte[] time_bytes = byArray;
        byArray[0] = (byte)(time_divided >>> 56);
        time_bytes[1] = (byte)(time_divided >>> 48);
        time_bytes[2] = (byte)(time_divided >>> 40);
        time_bytes[3] = (byte)(time_divided >>> 32);
        time_bytes[4] = (byte)(time_divided >>> 24);
        time_bytes[5] = (byte)(time_divided >>> 16);
        time_bytes[6] = (byte)(time_divided >>> 8);
        time_bytes[7] = (byte)time_divided;
        hmac.updateHash2(time_bytes);
        byte[] abyte2 = hmac.getDigest();
        return AuthKeyGen.tailbytesToInt(abyte2) % mysteryNumbers[mysteryOffset - 6];
    }
}

