/*
 * Decompiled with CFR 0.152.
 */
package sed.AuthEmuCLI;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import sed.authemu.Authenticator;

public class AuthEmuCLI {
    Authenticator auth = null;
    Preferences prefs = null;

    public static void main(String[] args) {
        AuthEmuCLI emu = new AuthEmuCLI();
        emu._main(args);
    }

    public void _main(String[] args) {
        String command;
        this.auth = new Authenticator();
        this.prefs = Preferences.userNodeForPackage(AuthEmuCLI.class);
        String[] _commands = new String[]{"create-eu", "create-us", "oneshot", "run", "sync"};
        List<String> commands = Arrays.asList(_commands);
        if (args.length != 1 || !commands.contains(args[0])) {
            System.out.println("Usage: AuthEmuCLI COMMAND");
            System.out.println("Commands:");
            System.out.println("  create-eu     create a new Blizzard Authenticator, region: EU");
            System.out.println("  create-us     create a new Blizzard Authenticator, region: US");
            System.out.println();
            System.out.println("  oneshot       print the current key");
            System.out.println("  run           print keys indefinitely");
            System.out.println("  sync          resynchronize time");
            System.exit(1);
        }
        if ((command = args[0].toUpperCase()).startsWith("CREATE")) {
            try {
                String region = command.substring(7, 9);
                System.out.printf("* Generating a new Authenticator for the region: %s\n", region);
                System.out.printf("* Requesting serial number...\n", new Object[0]);
                this.auth.net_enroll(region);
                this.prefs.put("token", this.auth.str_token);
                this.prefs.put("serial", this.auth.str_serial);
                this.prefs.putLong("time_diff", this.auth.time_diff);
                System.out.println();
                this.printSerial();
                System.out.println();
                System.out.printf("In order to use the Authenticator, you need to associate the serial number to your Battle.Net account.\n", new Object[0]);
                System.out.printf("Visit %s, enter the serial number, and click Attach.\n", Authenticator.str_consts.get(region).get("auth-url-setup"));
                System.exit(0);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.exit(0);
        }
        try {
            this.loadPreferences(this.prefs);
            System.out.printf("Using saved authenticator.\n\n", new Object[0]);
            this.printSerial();
            System.out.println();
        }
        catch (BackingStoreException e1) {
            e1.printStackTrace();
        }
        if (command.equals("ONESHOT")) {
            System.out.printf("Key: %s\n", this.auth.getAuthKey());
            System.exit(0);
        }
        if (command.equals("RUN")) {
            try {
                this.printKeysLoop();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (command.equals("SYNC")) {
            try {
                this.auth.net_sync();
                this.prefs.putLong("time_diff", this.auth.time_diff);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.printf("New time difference [ms]: %d\n", this.auth.time_diff);
        }
    }

    private void loadPreferences(Preferences p) throws BackingStoreException {
        String s_token = p.get("token", null);
        String s_serial = p.get("serial", null);
        long time_diff = p.getLong("time_diff", 0L);
        if (s_token == null || s_serial == null) {
            p.clear();
            System.err.println("No token generated yet.");
            System.exit(1);
        }
        this.auth.setSerial(s_token, s_serial, time_diff);
        if (this.auth.str_serial == null || this.auth.str_token == null) {
            System.err.println("Invalid token stored in preferences. generate a new one.");
            System.exit(1);
        }
    }

    private void printSerial() {
        System.out.printf("Serial: %s\n", this.auth.str_serial);
        System.out.printf("Token:  %s\n", this.auth.str_token);
        System.out.printf("Client/server time difference [ms]: %d\n", this.auth.time_diff);
    }

    public void printKeysLoop() throws InterruptedException {
        long t_elapsed_old = 0L;
        System.out.printf("Key: %s\n", this.auth.getAuthKey());
        while (true) {
            long t_elapsed;
            if ((t_elapsed = this.auth.timeSinceLastKeyChange() / 1000L) > t_elapsed_old) {
                int i = 0;
                while ((long)i < t_elapsed - t_elapsed_old) {
                    System.out.printf(".", new Object[0]);
                    ++i;
                }
                t_elapsed_old = t_elapsed;
            } else if (t_elapsed < t_elapsed_old) {
                System.out.printf("\nkey: %s\n", this.auth.getAuthKey());
                t_elapsed_old = t_elapsed;
            }
            Thread.sleep(500L);
        }
    }
}

