/*
 * Decompiled with CFR 0.152.
 */
package sed.foobma;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;
import sed.authemu.Authenticator;
import sed.foobma.AboutDialog;
import sed.foobma.AuthEditDialog;
import sed.foobma.FooBMA;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 7364192029784415173L;
    private JComboBox cbox_auth;
    private JButton btn_key_curr;
    private JButton btn_key_next;
    private JProgressBar pbar_time;
    private AbstractAction action_view;
    private AbstractAction action_delete;
    private AbstractAction action_sync;
    private AbstractAction action_export;
    private AboutDialog about_dialog;

    public static void setComponentFontSize(JComponent comp, float rel_size) {
        Font f = comp.getFont();
        Float s = Float.valueOf(f.getSize2D());
        s = Float.valueOf(s.floatValue() + rel_size);
        comp.setFont(f.deriveFont(s.floatValue()));
    }

    private void setGuiEnabledState(boolean s) {
        this.cbox_auth.setEnabled(s);
        this.btn_key_next.setEnabled(s);
        this.btn_key_curr.setEnabled(s);
        this.action_view.setEnabled(s);
        this.action_delete.setEnabled(s);
        this.action_sync.setEnabled(s);
        this.action_export.setEnabled(s);
        if (!s) {
            this.pbar_time.setValue(0);
            this.btn_key_curr.setText("00000000");
            this.btn_key_next.setText("00000000");
        }
    }

    private void addAuthenticator(Authenticator auth) {
        this.cbox_auth.addItem(auth);
        this.setGuiEnabledState(true);
    }

    private void loadAuthenticators() {
        Preferences prefs_app = Preferences.userNodeForPackage(FooBMA.class);
        Pattern re_child = Pattern.compile("^[eusEUS]{2}-\\d{4}-\\d{4}-\\d{4}$");
        try {
            String[] stringArray = prefs_app.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String childname = stringArray[n2];
                Preferences p = prefs_app.node(childname);
                if (re_child.matcher(childname).matches()) {
                    Authenticator a = new Authenticator();
                    String str_serial = p.get("serial", null);
                    String str_token = p.get("token", null);
                    long clockskew = p.getLong("clockskew", 0L);
                    if (str_serial != null && str_token != null) {
                        a.setSerial(str_token, str_serial, clockskew);
                        this.addAuthenticator(a);
                    }
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Could not load the settings...", "BackingStoreException", 0);
        }
    }

    private Preferences saveAuthenticators() {
        Preferences prefs_app = Preferences.userNodeForPackage(FooBMA.class);
        try {
            String[] stringArray = prefs_app.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                prefs_app.node(child).removeNode();
                ++n2;
            }
            int i = 0;
            while (i < this.cbox_auth.getItemCount()) {
                Authenticator a = (Authenticator)this.cbox_auth.getItemAt(i);
                String nodename = a.str_serial;
                Preferences prefs_auth = prefs_app.node(nodename);
                prefs_auth.clear();
                prefs_auth.put("serial", a.str_serial);
                prefs_auth.put("token", a.str_token);
                prefs_auth.putLong("clockskew", a.time_diff);
                prefs_auth.flush();
                ++i;
            }
            prefs_app.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Could not save the settings...", "BackingStoreException", 0);
        }
        return prefs_app;
    }

    MainFrame() {
        super("FooBMA");
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.about_dialog = new AboutDialog(this);
        ActionAuthNew action_new = new ActionAuthNew();
        ActionAuthImport action_import = new ActionAuthImport();
        this.action_view = new ActionAuthView();
        this.action_delete = new ActionAuthDelete();
        this.action_sync = new ActionAuthSync();
        this.action_export = new ActionAuthExport();
        JMenuBar menu_bar = new JMenuBar();
        JMenu menu = new JMenu("Authenticator");
        menu.setMnemonic(65);
        JMenuItem menu_item = new JMenuItem("Create new", 67);
        menu_item.setAction(action_new);
        menu.add(menu_item);
        menu_item = new JMenuItem("Import", 73);
        menu_item.setAction(action_import);
        menu.add(menu_item);
        menu.addSeparator();
        menu_item = new JMenuItem("View selected...", 86);
        menu_item.setAction(this.action_view);
        menu.add(menu_item);
        menu_item = new JMenuItem("Delete selected...", 68);
        menu_item.setAction(this.action_delete);
        menu.add(menu_item);
        menu.addSeparator();
        menu_item = new JMenuItem("Sync all...", 83);
        menu_item.setAction(this.action_sync);
        menu.add(menu_item);
        menu.addSeparator();
        menu_item = new JMenuItem("Export...", 69);
        menu_item.setAction(this.action_export);
        menu.add(menu_item);
        menu.addSeparator();
        menu_item = new JMenuItem("Exit", 88);
        menu_item.addActionListener(new ExitHandler());
        menu.add(menu_item);
        menu_bar.add(menu);
        menu = new JMenu("Help");
        menu.setMnemonic(72);
        menu_item = new JMenuItem("About", 65);
        menu_item.setAction(new ActionAbout());
        menu.add(menu_item);
        menu_bar.add(menu);
        this.setJMenuBar(menu_bar);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.cbox_auth = new JComboBox();
        this.cbox_auth.addItemListener(new OnAuthChanged());
        JPanel authsel_panel = new JPanel();
        authsel_panel.setLayout(new BoxLayout(authsel_panel, 1));
        authsel_panel.add(this.cbox_auth);
        pane.add((Component)authsel_panel, "North");
        JPanel code_panel = new JPanel();
        code_panel.setLayout(new GridLayout(3, 1));
        code_panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.btn_key_curr = new JButton("00000000");
        this.btn_key_curr.setToolTipText("Copy the current key to the clipboard");
        this.btn_key_curr.addActionListener(new OnKeyButtonClicked());
        MainFrame.setComponentFontSize(this.btn_key_curr, 6.0f);
        this.btn_key_next = new JButton("00000000");
        this.btn_key_next.setToolTipText("Copy the next key to the clipboard");
        this.btn_key_next.addActionListener(new OnKeyButtonClicked());
        this.pbar_time = new JProgressBar(0, 30000);
        code_panel.add(this.btn_key_curr);
        code_panel.add(this.pbar_time);
        code_panel.add(this.btn_key_next);
        pane.add((Component)code_panel, "Center");
        this.setGuiEnabledState(false);
        this.loadAuthenticators();
        this.setSize(300, 200);
        this.pack();
        this.setVisible(true);
        Timer t = new Timer(500, new OnTimer());
        t.start();
    }

    class ActionAbout
    extends AbstractAction {
        public ActionAbout() {
            super("About FooBMA...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.this.about_dialog.setVisible(true);
        }
    }

    class ActionAuthDelete
    extends AbstractAction {
        public ActionAuthDelete() {
            super("Delete selected...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JOptionPane.showConfirmDialog(MainFrame.this, "Do you really want to delete the selected Authenticator?", "Confirm deletion", 2) != 0) {
                return;
            }
            MainFrame.this.cbox_auth.removeItemAt(MainFrame.this.cbox_auth.getSelectedIndex());
            MainFrame.this.cbox_auth.validate();
            if (MainFrame.this.cbox_auth.getItemCount() == 0) {
                MainFrame.this.setGuiEnabledState(false);
            }
            MainFrame.this.saveAuthenticators();
        }
    }

    class ActionAuthExport
    extends AbstractAction {
        public ActionAuthExport() {
            super("Export authenticators as XML...");
        }

        private void showIOError(String msg) {
            JOptionPane.showMessageDialog(MainFrame.this, msg, "I/O Error", 0);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JFileChooser fc = new JFileChooser();
            fc.setFileFilter(new FileNameExtensionFilter("XML file", "xml"));
            if (fc.showSaveDialog(MainFrame.this) == 0) {
                int res;
                File f = fc.getSelectedFile();
                if (f.exists() && (res = JOptionPane.showConfirmDialog(MainFrame.this, String.format("Do you really want to overwrite the file '%s'?", f.toString()), "Confirm overwrite", 0)) != 0) {
                    return;
                }
                System.out.printf("Exporting authenticators to: %s\n", f);
                Preferences prefs_app = MainFrame.this.saveAuthenticators();
                try {
                    FileOutputStream os = new FileOutputStream(f);
                    prefs_app.exportSubtree(os);
                    os.close();
                }
                catch (FileNotFoundException e) {
                    this.showIOError("Could not open the specified file.");
                }
                catch (IOException e) {
                    this.showIOError("Write error.");
                }
                catch (BackingStoreException e) {
                    this.showIOError("Failed to access the preferences.");
                }
            }
        }
    }

    class ActionAuthImport
    extends AbstractAction {
        public ActionAuthImport() {
            super("Import existing...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final AuthEditDialog authedit = new AuthEditDialog(MainFrame.this, AuthEditDialog.EditDialogMode.MODE_IMPORT, null);
            authedit.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    Authenticator auth = authedit.auth;
                    if (auth != null) {
                        MainFrame.this.addAuthenticator(auth);
                        MainFrame.this.saveAuthenticators();
                        authedit.dispose();
                    }
                }
            });
            authedit.setTitle("FooBMA - Import");
            authedit.setVisible(true);
        }
    }

    class ActionAuthNew
    extends AbstractAction {
        public ActionAuthNew() {
            super("Create new...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final AuthEditDialog authedit = new AuthEditDialog(MainFrame.this, AuthEditDialog.EditDialogMode.MODE_NEW, null);
            authedit.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    Authenticator auth = authedit.auth;
                    if (auth != null) {
                        MainFrame.this.addAuthenticator(auth);
                        MainFrame.this.saveAuthenticators();
                        authedit.dispose();
                    }
                }
            });
            authedit.setTitle("FooBMA - New");
            authedit.setVisible(true);
        }
    }

    class ActionAuthSync
    extends AbstractAction {
        public ActionAuthSync() {
            super("Synchronize clocks");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            HashMap<String, Long> r_clock = new HashMap<String, Long>();
            int i = 0;
            while (i < MainFrame.this.cbox_auth.getItemCount()) {
                Authenticator a = (Authenticator)MainFrame.this.cbox_auth.getItemAt(i);
                String region = a.str_serial.substring(0, 2);
                if (r_clock.containsKey(region)) {
                    a.time_diff = (Long)r_clock.get(region);
                } else {
                    try {
                        a.net_sync();
                        r_clock.put(region, a.time_diff);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(MainFrame.this, ex.getMessage(), "IOException", 0);
                        return;
                    }
                }
                ++i;
            }
            String msg = "Clock skew:";
            for (String key : r_clock.keySet()) {
                msg = String.valueOf(msg) + String.format("\n%s: %d ms", key, r_clock.get(key));
            }
            JOptionPane.showMessageDialog(MainFrame.this, msg, "Synchronization completed", 1);
        }
    }

    class ActionAuthView
    extends AbstractAction {
        public ActionAuthView() {
            super("View selected...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final AuthEditDialog authedit = new AuthEditDialog(MainFrame.this, AuthEditDialog.EditDialogMode.MODE_VIEW, (Authenticator)MainFrame.this.cbox_auth.getSelectedItem());
            authedit.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    authedit.dispose();
                }
            });
            authedit.setTitle("FooBMA - View details");
            authedit.setVisible(true);
        }
    }

    class ExitHandler
    implements ActionListener {
        ExitHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    class OnAuthChanged
    implements ItemListener {
        OnAuthChanged() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                new OnTimer().updateDisplay();
            }
        }
    }

    class OnKeyButtonClicked
    implements ActionListener {
        private Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();

        @Override
        public void actionPerformed(ActionEvent evt) {
            JButton btn_src = (JButton)evt.getSource();
            StringSelection ssel = new StringSelection(btn_src.getText());
            this.clipboard.setContents(ssel, null);
        }
    }

    class OnTimer
    implements ActionListener {
        OnTimer() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.updateDisplay();
        }

        public void updateDisplay() {
            if (MainFrame.this.cbox_auth.getItemCount() == 0) {
                return;
            }
            Authenticator auth = (Authenticator)MainFrame.this.cbox_auth.getSelectedItem();
            MainFrame.this.btn_key_curr.setText(auth.getAuthKey());
            MainFrame.this.btn_key_next.setText(auth.getAuthKeyFuture());
            MainFrame.this.pbar_time.setValue((int)auth.timeSinceLastKeyChange());
        }
    }
}

