/*
 * Decompiled with CFR 0.152.
 */
package sed.foobma;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.MaskFormatter;
import javax.swing.text.NumberFormatter;
import sed.authemu.Authenticator;

public class AuthEditDialog
extends JDialog {
    private static final long serialVersionUID = -4830652629058530992L;
    EditDialogMode mode;
    JFormattedTextField tf_serial;
    JFormattedTextField tf_clockskew;
    JTextField tf_token;
    JButton btn_create_eu;
    JButton btn_create_us;
    JButton btn_ok;
    JButton btn_cancel;
    public Authenticator auth;

    public AuthEditDialog(JFrame parent, EditDialogMode mode, Authenticator a) {
        super((Window)parent, Dialog.ModalityType.TOOLKIT_MODAL);
        this.mode = mode;
        this.auth = a;
        JPanel root_panel = new JPanel();
        root_panel.setLayout(new BoxLayout(root_panel, 1));
        JPanel ok_panel = new JPanel();
        ok_panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        ok_panel.setLayout(new BoxLayout(ok_panel, 0));
        ok_panel.setAlignmentX(0.0f);
        this.btn_ok = new JButton("OK");
        this.btn_ok.setMnemonic(79);
        this.btn_ok.addActionListener(new OnOK());
        ok_panel.add(this.btn_ok);
        this.btn_cancel = new JButton("Cancel");
        this.btn_cancel.setMnemonic(67);
        this.btn_cancel.addActionListener(new OnCancel());
        ok_panel.add(this.btn_cancel);
        try {
            this.tf_serial = new JFormattedTextField(new MaskFormatter("UU-####-####-####"));
            this.tf_serial.setColumns(17);
            this.tf_token = new JTextField();
            this.tf_token.setColumns(40);
            this.tf_clockskew = new JFormattedTextField(new NumberFormatter());
            this.tf_clockskew.setColumns(6);
        }
        catch (ParseException e1) {
            e1.printStackTrace();
            System.exit(1);
        }
        JPanel info_panel = new JPanel();
        info_panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Authenticator details"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        info_panel.setAlignmentX(0.0f);
        info_panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 21;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridy = 0;
        gbc.gridx = 0;
        info_panel.add((Component)new JLabel("Serial Nr.:"), gbc);
        gbc.gridy = 0;
        gbc.gridx = 1;
        info_panel.add((Component)this.tf_serial, gbc);
        gbc.gridy = 1;
        gbc.gridx = 0;
        info_panel.add((Component)new JLabel("Token:"), gbc);
        gbc.gridy = 1;
        gbc.gridx = 1;
        info_panel.add((Component)this.tf_token, gbc);
        gbc.gridy = 2;
        gbc.gridx = 0;
        info_panel.add((Component)new JLabel("Clock skew [ms]:"), gbc);
        gbc.gridy = 2;
        gbc.gridx = 1;
        info_panel.add((Component)this.tf_clockskew, gbc);
        JPanel top_panel = new JPanel();
        top_panel.setLayout(new BoxLayout(top_panel, 0));
        top_panel.setAlignmentX(0.0f);
        if (mode == EditDialogMode.MODE_NEW) {
            JPanel region_panel = new JPanel();
            region_panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Region"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            region_panel.setLayout(new BoxLayout(region_panel, 0));
            region_panel.setAlignmentY(0.0f);
            this.btn_create_eu = new JButton("EU");
            this.btn_create_us = new JButton("US");
            this.btn_create_eu.setMnemonic(69);
            this.btn_create_eu.addActionListener(new OnCreateAuthenticator("EU"));
            this.btn_create_us.setMnemonic(85);
            this.btn_create_us.addActionListener(new OnCreateAuthenticator("US"));
            region_panel.add(this.btn_create_eu);
            region_panel.add(this.btn_create_us);
            top_panel.add(region_panel);
        }
        boolean e = mode == EditDialogMode.MODE_IMPORT;
        this.tf_serial.setEditable(e);
        this.tf_token.setEditable(e);
        this.tf_clockskew.setEditable(e);
        if (mode == EditDialogMode.MODE_NEW) {
            this.btn_ok.setEnabled(false);
        }
        if (mode == EditDialogMode.MODE_VIEW) {
            this.tf_serial.setText(this.auth.str_serial);
            this.tf_token.setText(this.auth.str_token);
            this.tf_clockskew.setText(new Long(this.auth.time_diff).toString());
        }
        root_panel.add(top_panel);
        root_panel.add(info_panel);
        root_panel.add(ok_panel);
        this.add(root_panel);
        this.pack();
        this.setResizable(false);
    }

    public static enum EditDialogMode {
        MODE_NEW,
        MODE_IMPORT,
        MODE_VIEW;

    }

    class OnCancel
    implements ActionListener {
        OnCancel() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AuthEditDialog.this.auth = null;
            AuthEditDialog.this.setVisible(false);
        }
    }

    class OnCreateAuthenticator
    implements ActionListener {
        private String region;

        public OnCreateAuthenticator(String region) {
            this.region = region;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                AuthEditDialog.this.auth = new Authenticator();
                AuthEditDialog.this.btn_create_eu.setEnabled(false);
                AuthEditDialog.this.btn_create_us.setEnabled(false);
                AuthEditDialog.this.auth.net_enroll(this.region);
                AuthEditDialog.this.tf_serial.setText(AuthEditDialog.this.auth.str_serial);
                AuthEditDialog.this.tf_token.setText(AuthEditDialog.this.auth.str_token);
                AuthEditDialog.this.tf_clockskew.setText(new Long(AuthEditDialog.this.auth.time_diff).toString());
                AuthEditDialog.this.btn_ok.setEnabled(true);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(AuthEditDialog.this, ex.getMessage(), "IOException", 0);
                AuthEditDialog.this.auth = null;
            }
        }
    }

    class OnOK
    implements ActionListener {
        OnOK() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AuthEditDialog.this.mode == EditDialogMode.MODE_IMPORT) {
                AuthEditDialog.this.auth = new Authenticator();
                try {
                    AuthEditDialog.this.auth.setSerial(AuthEditDialog.this.tf_token.getText().trim(), AuthEditDialog.this.tf_serial.getText(), new Long(AuthEditDialog.this.tf_clockskew.getText()));
                    AuthEditDialog.this.setVisible(false);
                }
                catch (RuntimeException ex) {
                    AuthEditDialog.this.auth = null;
                    JOptionPane.showMessageDialog(AuthEditDialog.this, "Invalid authenticator data.", "Error", 0);
                }
            } else {
                AuthEditDialog.this.setVisible(false);
            }
        }
    }
}

