#include "main.h"
#include "hashing.h"
#include "packetbuffer.h"
#include "fxns.h"
#include <zlib.h>
#include "warden.h"
		
#pragma comment(lib, "zdll.lib")

#define SWAP(a,b) ((a == b) ? (a=a) : (a ^= b ^= a ^= b))

char *wextracterrstrs[] = {
	"Module MD5 hash mismatch",
	"Module misdecryption, SIGN doesn't match",
	"zlib!uncompress() failed",
	"kernel32!CreateFile() failed",
	"kernel32!WriteFile() failed"
};

SNPFNTABLE snpFnTable = {
	WdnCbkSendPacket,
	WdnCbkCheckModule,
	WdnCbkLoadModule,
	WdnCbkMemAlloc,
	WdnCbkMemFree,
	WdnCbkSetRC4,
	WdnCbkGetRC4
};

void *lpWdnModClass;
LPWARDENFNTABLE lpwdnFnTable;

void *snpTable = &snpFnTable;

char modhash[16];
char modname[64];
char moddecryptkey[16];
int modsize;
char *rawmodule;
int moddlprog;
void *currentmodule;
unsigned long startedtick;
unsigned long wdnkeyseed;

char *newrc4;
char *pendingwpacket;
int pendingwpacketlen;

void Parse0x5E(char *data, int index) {
	unsigned int len = *(short *)(data + 2) - 4;
	data += 4;
	RC4Crypt(bot[index].wardenkey_in, (unsigned char *)data, len);
	switch (data[0]) {
		case 0:	  
			WardenParseCommand0(data, len, index);
			break;
		case 1:
			WardenParseCommand1(data, len, index);
			break;
		case 2:
			WardenParseCommand2(data, len, index);
			break;				
		case 5:
			WardenParseCommand5(data, len, index);
			break;
		default:
			AddChatEx(vbRed, "Unhandled warden command 0x%02x!", (unsigned char)*data);
	}
}

///////////////////////////////////////////[Command Handlers]//////////////////////////////////////////

void WardenParseCommand0(char *data, int len, int index) {
	unsigned char outbuf;
	*(__int32 *)(modname) = 'udom';	
	*(__int32 *)(modname + 4) = '\\sel';
	for (int i = 0; i != 16; i++)
		sprintf(modname + 8 + (i << 1), "%02x", (unsigned char)data[i + 1]);
	modname[40] = '.';
	*(int *)(modname + 41) = 'dom';
	AddChatEx(vbYellow, "Warden module %s requested.", modname + 8);
	if (currentmodule) {
		if (cmphash(modhash, data + 1)) {
			AddChat(vbGreen, "Module already loaded, using that.");
			goto send1;
		} else {
			WardenUnloadModule();
			AddChat(vbYellow, "New warden module requested, loading that.");
			goto contwprocessing;
		}
	} else {
contwprocessing:
		__asm {
			cld
			mov esi, data
			inc esi
			lea edi, [modhash]
			movsd
			movsd
			movsd
			movsd
			lea edi, [moddecryptkey]
			movsd
			movsd
			movsd
			movsd
			lea edi, [modsize]
			movsd
		}  
		if (GetFileAttributes(modname) == INVALID_FILE_ATTRIBUTES) {
			AddChatEx(vbYellow, "Module not found, downloading...");
			rawmodule = (char *)malloc(modsize);
			moddlprog = 0;
			outbuf = 0;
			startedtick = GetTickCount();
		} else {
			WardenPrepareModule(modname);
			WardenModuleInitalize((LPWMODHEADER)currentmodule);
send1:
			outbuf = 1;
		}
	}
	RC4Crypt(bot[index].wardenkey_out, &outbuf, 1);
	InsertByte(outbuf);
	SendPacket(0x5E, index);
}

void WardenParseCommand1(char *data, int len, int index) {
	//AddChat(vbGreen, "0x01!");
	char buf[128];
	if (rawmodule) {
		memcpy(rawmodule + moddlprog, data + 3, *(__int16 *)(data + 1));
		moddlprog += *(__int16 *)(data + 1);
		//sprintf(buf, "%d/%d bytes (%d%%)", moddlprog, modsize, int((float)moddlprog / (float)modsize * 100.f));
		//AddChat(vbGreen, buf, bot[index]->hWnd_rtfChat);
	}		
	if (moddlprog == modsize) {
		AddChatEx(vbGreen, "Module downloaded, dl @ %d kB/s", (int)((float)(modsize * 1000) / (float)(GetTickCount() - startedtick)));
		int fail = WardenDecryptInflateModule(modname, rawmodule, modsize, moddecryptkey, index);
		if (fail) {
			AddChatEx(vbRed, "Warden module decryption/inflation failure %d (%s).", fail, wextracterrstrs[fail - 1]);
		} else {
			WardenPrepareModule(modname);
			WardenModuleInitalize((LPWMODHEADER)currentmodule);
			*buf = 1;
			RC4Crypt(bot[index].wardenkey_out, (unsigned char *)buf, 1);
			InsertByte(*buf);
			SendPacket(0x5E, index);
		}
	}
}

int wdnexceptfilter(LPEXCEPTION_POINTERS lpei) {
	char asdf[256];
	sprintf(asdf, "Exception 0x%08x at 0x%08x (WardenParseCommand2(data = 0x%08x, len = %d, index = %d))!!!", 
		lpei->ExceptionRecord->ExceptionCode,
		lpei->ExceptionRecord->ExceptionAddress,
		*(char **)(lpei->ContextRecord->Ebp + 8),
		*(int *)(lpei->ContextRecord->Ebp + 12),
		*(int *)(lpei->ContextRecord->Ebp + 16));
	AddChat(vbRed, asdf);
	return EXCEPTION_CONTINUE_EXECUTION;
		//EXECUTE_HANDLER;
}

					
void WardenParseCommand2(char *data, int len, int index) {
	__try {	///////////////////////////////

	char buf[256];
	char *tosend = buf + 7;
	ZeroMemory(buf, sizeof(buf));
	int i = 2;
	if (!lpSCImage)
		return;			  
	while (i != len - 1) {
		if (i >= 256) /////////////////////////////
			break;
		//data[i] ^= data[len - 1];
		if (!data[i + 1] && !data[i + 5]) {
			void *address = *(__int32 *)(data + i + 2) - 0x400000 + lpSCImage;
			int lentoread = data[i + 6];
			*tosend++ = 0;
			memcpy(tosend, address, lentoread);
			tosend += lentoread;
			i += 7;
		} else {
			*tosend = 0;
			tosend++;
			i += 30;
		}
	}
	int length = tosend - buf;
	*buf = 2;
	*(__int16 *)(buf + 1) = length - 7;
	*(__int32 *)(buf + 3) = WardenGenerateChecksum(buf + 7, length - 7);
	//StrToHexOut(buf, length, bot[index]->hWnd_rtfChat);
	RC4Crypt(bot[index].wardenkey_out, (unsigned char *)buf, length);
	InsertVoid(buf, length);
	SendPacket(0x5E, index);

	} __except (wdnexceptfilter(GetExceptionInformation())) {	////////////////////////////
	
	} /////////////////////////////////////
}

void WardenParseCommand5(char *data, int len, int index) {
	__int32 buf32;
	unsigned char tmpkey[0x102];
	newrc4 = NULL;
	__asm {
		push 4
		push offset wdnkeyseed
		mov ecx, lpWdnModClass 
		mov eax, lpwdnFnTable
		call dword ptr [eax] //wdnGenKeys
	}
	if (!newrc4) {
		AddChat(vbRed, "wdnGenKeys() failed!");
		return;
	}
	char *tmpdata = (char *)malloc(len);
	memcpy(tmpdata, data, len);
	memcpy(tmpkey, newrc4 + 0x102, sizeof(tmpkey));
	RC4Crypt(tmpkey, (unsigned char *)tmpdata, len);
	memcpy(tmpkey, newrc4, sizeof(tmpkey));
	if (pendingwpacket)	{
		free(pendingwpacket);
		pendingwpacket = NULL;
	}
	__asm {
		lea eax, [buf32]
		push eax
		push len
		push tmpdata
		mov ecx, lpWdnModClass
		mov eax, lpwdnFnTable
		call dword ptr [eax + 8] //wdnHandlePacket
	}
	if (!pendingwpacket)
		AddChat(vbRed, "wdnSendPacket() failed!");
	RC4Crypt(tmpkey, (unsigned char *)pendingwpacket, pendingwpacketlen);
	RC4Crypt((unsigned char *)bot[index].wardenkey_out, (unsigned char *)pendingwpacket, pendingwpacketlen);
	memcpy(bot[index].wardenkey_out, newrc4, 0x102);
	memcpy(bot[index].wardenkey_in, (char *)newrc4 + 0x102, 0x102);
	InsertVoid(pendingwpacket, pendingwpacketlen);
	SendPacket(0x5E, index);
}

/////////////////////////////////[Warden Module Preparation]///////////////////////////////////////////

int WardenDecryptInflateModule(char *modulename, char *module, int modulelen, char *keyseed, int index) {
	unsigned long byts;
	unsigned char cryptkey[0x102];

	MD5((char *)module, modulelen, (char *)cryptkey);
	if (memcmp(modhash, cryptkey, 16))
		return 1;

	WardenKeyGenerate(cryptkey, (unsigned char *)keyseed, 0x10);
	RC4Crypt(cryptkey, (unsigned char *)module, modulelen);
	if (*(int *)(module + modulelen - 0x104) != 'SIGN')
		return 2;

	unsigned long extlen = *(int *)module;
	char *extmodule = (char *)malloc(extlen);
	if (uncompress((unsigned char *)extmodule, &extlen, (unsigned char *)module + 4, modulelen - 4)) {
		free(extmodule);
		return 3;
	}

	HANDLE hFile = CreateFile(modulename, GENERIC_WRITE, 0, NULL, CREATE_NEW,
		FILE_ATTRIBUTE_NORMAL, NULL);
	if (hFile == INVALID_HANDLE_VALUE) {
		free(extmodule);
		return 4;
	}

	if (!WriteFile(hFile, extmodule, extlen, &byts, NULL)) {
		free(extmodule);
		CloseHandle(hFile);
		return 5;
	}

	free(extmodule);
	CloseHandle(hFile);
	return 0;
}

bool WardenPrepareModule(char *filename) {
	unsigned long read;
	HANDLE hFile = CreateFile(filename, GENERIC_READ, 0, NULL, OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL, NULL);
	if (!hFile)
		return false;
	int filelen = GetFileSize(hFile, NULL);
	char *tmpmod = (char *)malloc(filelen);
	ReadFile(hFile, tmpmod, filelen, &read, NULL);
	CloseHandle(hFile);
	LPWMODHEADER lpwmodh = (LPWMODHEADER)tmpmod;
	char *lmodule = (char *)VirtualAlloc(0, lpwmodh->cbModSize, MEM_COMMIT, PAGE_READWRITE); 
	memcpy(lmodule, tmpmod, 40);
	unsigned long srcloc  = lpwmodh->sectioncount * 12 + 0x28;
	unsigned long destloc = lpwmodh->sectionlen;
	int sections = 0;
	while (destloc < lpwmodh->cbModSize) {
		int sectionsize = *(unsigned __int16 *)(tmpmod + srcloc);
		srcloc += 2;
		sections++;
		if (sections & 1) {
			memcpy(lmodule + destloc, tmpmod + srcloc, sectionsize);
			srcloc += sectionsize;
		}
		
		destloc += sectionsize;
	}
	srcloc = lpwmodh->rvaFxnTableReloc;
	destloc = 0;
	for (int i = 0; i != lpwmodh->reloccount; i++) {
		if (lmodule[srcloc] < 0) {
			destloc = ((lmodule[srcloc + 0] & 0x07F) << 24) |
					  ((lmodule[srcloc + 1] & 0x0FF) << 16) |
					  ((lmodule[srcloc + 2] & 0x0FF) << 8)  |
					  ((lmodule[srcloc + 3] & 0x0FF));
			srcloc += 4;
			MessageBox(0, "absolute address, hax", 0, 0);
		} else {				   
			destloc += (lmodule[srcloc + 1] & 0x0FF) + (lmodule[srcloc] << 8);
			srcloc += 2;
		}
		*(__int32 *)(lmodule + destloc) += (__int32)lmodule;
	}
	for (i = 0; i != lpwmodh->dllcount; i++) {
		__int32 tmp;
		unsigned long procstart  = lpwmodh->rvaImports + i * 8;
		unsigned long procoffset = *(__int32 *)(lmodule + procstart + 4);
		char *libtoload = lmodule + *(__int32 *)(lmodule + procstart);
		HMODULE hLib = LoadLibrary(libtoload);
		int fnnameoffset = *(__int32 *)(lmodule + procoffset);
		while (fnnameoffset) {
			fnnameoffset = *(__int32 *)(lmodule + procoffset);
			if (fnnameoffset > 0) {
				char *fnstr = lmodule + fnnameoffset;
				if (!strcmp(fnstr, "GetProcAddress"))
					tmp = (__int32)MyGetProcAddress;
				else 
					tmp = (__int32)GetProcAddress(hLib, fnstr);
			} else {
				tmp &= ~0x80000000;
			}			 
			*(__int32 *)(lmodule + procoffset) = tmp;
			procoffset += 4;
		}
	}  

	for (i = 0; i != lpwmodh->sectioncount; i++) {
		unsigned long oldprotect;
		LPWMODPROTECT lpwmodp = (LPWMODPROTECT)(lmodule + lpwmodh->sectioncount * 12 + 0x28);
		lpwmodp->base = lmodule + (int)lpwmodp->base;
		VirtualProtect(lpwmodp->base, lpwmodp->len, lpwmodp->protectdword, &oldprotect);
		if (oldprotect & 0xF0)
			FlushInstructionCache(GetCurrentProcess(), lpwmodp->base, lpwmodp->len);
	}
	if (lpwmodh->cbModSize < lpwmodh->rvaFxnTableReloc)
		return false;
	VirtualFree(lmodule + lpwmodh->rvaFxnTableReloc,
		lpwmodh->cbModSize - lpwmodh->rvaFxnTableReloc, MEM_RELEASE);
	currentmodule = (void *)lmodule;
	return true;
}

void WardenModuleInitalize(LPWMODHEADER lpwmodh) {
	int tmp = 1 - lpwmodh->unk2;
	if (tmp > (int)lpwmodh->unk1)
		return;
	__int32 lpfnInit = (int)lpwmodh + *(__int32 *)((int)lpwmodh + (int)lpwmodh->lpfnInit + (tmp << 2));
	__asm {
		mov ecx, offset snpTable
		call lpfnInit
		mov lpWdnModClass, eax
		mov eax, dword ptr [eax]
		mov lpwdnFnTable, eax
	}
}	

void WardenUnloadModule() {
	__asm {
		mov ecx, lpWdnModClass
		mov eax, lpwdnFnTable
		call dword ptr [eax + 4]
	}
	VirtualFree(currentmodule, 0, MEM_RELEASE);
	currentmodule = NULL;
}

void __stdcall nullsub(int p1, int p2) {
}

void __stdcall nullsub2(int p1) {
}

FARPROC WINAPI MyGetProcAddress(HMODULE hModule, LPCSTR lpProcName) {
	//AddChatEx(vbYellow, "Module getting address to 0x%08x!%s() ...", hModule, lpProcName);
	if (!strcmp(lpProcName, "AddVectoredExceptionHandler")) {
		return (FARPROC)nullsub;
	} else if (!strcmp(lpProcName, "RemoveVectoredExceptionHandler")) {
		return (FARPROC)nullsub2;
	}
	return GetProcAddress(hModule, lpProcName);
}

/////////////////////////////////////[Warden Callbacks]////////////////////////////////////////////////

void __stdcall WdnCbkSendPacket(char *data, int len) {
	pendingwpacket = (char *)malloc(len);
	memcpy(pendingwpacket, data, len);
	pendingwpacketlen = len;
	AddChatEx(vbGreen, "Warden module wants to send packet, len %d!", len);
}

bool __stdcall WdnCbkCheckModule(char *modname, unsigned long _2) {
	AddChatEx(vbGreen, "Warden module wants to check %s. _2: 0x%08x!", modname, _2);
	return true;
}

unsigned long __stdcall WdnCbkLoadModule(char *decryptkey, char *module, int modlen) {
	AddChatEx(vbYellow, "Warden module wants to load a new module, len %d.", modlen);
	return NULL;
}

void *__stdcall WdnCbkMemAlloc(unsigned long len) {
	AddChatEx(vbYellow, "Module allocated %d bytes.", len);
	return malloc(len);
}

void __stdcall WdnCbkMemFree(void *mem) {
	AddChatEx(vbYellow, "Module freed 0x%08x.", mem);
	free(mem);
}

void __stdcall WdnCbkSetRC4(void *keys, unsigned long len) {
	AddChatEx(vbYellow, "Module set RC4 keys");
}

char *__stdcall WdnCbkGetRC4(char *buffer, unsigned long *len) {
	AddChatEx(vbYellow, "Module got RC4 keys, len = %d", *len);
	char *oldrc4 = newrc4;
	newrc4 = buffer;
	return oldrc4;
}

///////////////////////////////////////[Warden Crypto]/////////////////////////////////////////////////

void RC4Crypt(unsigned char *key, unsigned char *data, int length) {
	for (int i = 0; i < length; i++) {
		key[0x100]++;
		key[0x101] += key[key[0x100]];
		SWAP(key[key[0x101]], key[key[0x100]]);
		data[i] = data[i] ^ key[(key[key[0x101]] + key[key[0x100]]) & 0xFF];
	}
}	

void WardenKeyInit(char *KeyHash, int index) {
	char temp[0x10];
	wdnkeyseed = (unsigned long)KeyHash;
	WardenKeyDataInit(&bot[index].warden_data, KeyHash, 4);
	WardenKeyDataGetBytes(&bot[index].warden_data, temp, 16);
	WardenKeyGenerate((unsigned char *)bot[index].wardenkey_out, (unsigned char *)temp, 16);
	WardenKeyDataGetBytes(&bot[index].warden_data, temp, 16);	
	WardenKeyGenerate((unsigned char *)bot[index].wardenkey_in, (unsigned char *)temp, 16);
}

void WardenKeyDataInit(t_random_data *source, char *seed, int length) {
	int length1 = length >> 1;
	int length2 = length - length1;
	char *seed1 = seed;
	char *seed2 = seed + length1;
	memset(source, 0, sizeof(t_random_data));
	SHA1(seed1, length1, source->random_source_1);
	SHA1(seed2, length2, source->random_source_2);
	WardenKeyDataUpdate(source);
	source->current_position = 0;
}

void WardenKeyGenerate(unsigned char *key_buffer, unsigned char *base, unsigned int baselen) {
	unsigned char val = 0;
	unsigned int pos = 0;
	for (unsigned int i = 0; i < 0x100; i++)
		key_buffer[i] = i;
	key_buffer[0x100] = 0;
	key_buffer[0x101] = 0;
	for (i = 1; i <= 0x40; i++) {
		int tmp = i << 2;
		val += key_buffer[tmp - 4] + base[pos++ % baselen];
		SWAP(key_buffer[tmp - 4], key_buffer[val & 0xFF]);
		val += key_buffer[tmp - 3] + base[pos++ % baselen];
		SWAP(key_buffer[tmp - 3], key_buffer[val & 0xFF]);
		val += key_buffer[tmp - 2] + base[pos++ % baselen];
		SWAP(key_buffer[tmp - 2], key_buffer[val & 0xFF]);
		val += key_buffer[tmp - 1] + base[pos++ % baselen];
		SWAP(key_buffer[tmp - 1], key_buffer[val & 0xFF]);
	}
}

void WardenKeyDataUpdate(t_random_data *source) {
	char data[60];
	memcpy(data, source->random_source_1, 20);
	memcpy(data + 20, source->random_data, 20);
	memcpy(data + 40, source->random_source_2, 20);
	SHA1(data, 60, source->random_data);
}

void WardenKeyDataGetBytes(t_random_data *source, char *buffer, int bytes) {
	for (int i = 0; i < bytes; i++)
		buffer[i] = WardenKeyDataGetByte(source);
}

char WardenKeyDataGetByte(t_random_data *source) {
	int i = source->current_position;
	char value = source->random_data[i];
	i++;
	if (i >= 20) {
		i = 0;
		WardenKeyDataUpdate(source);
	}
	source->current_position = i;
	return value;
}

unsigned long WardenGenerateChecksum(char *data, int len) {
	unsigned long result[5];
	SHA1(data, len, (char *)result);
	return result[0] ^ result[1] ^ result[2] ^ result[3] ^ result[4];
}	