#include "main.h"
#include "fxns.h"
#include "warden.h"
#include "cdkey.h"
#include "hashing.h"
#include "checkrevision.h"
#include "packetbuffer.h"
#include "packets.h"

const char *keyresstr[] = {
	"invalid",
	"in use",
	"banned",
	"wrong product"
};

const char *verresstr[] = {
	"Old product version.",
	"Invalid product version.",
	"Version must be downgraded."
};

void ParsePacket(unsigned char packetid, char *data, int index) {
	if (!bot[index].connected)
		AddChatEx(vbGreen, "[%d] Received 0x%02x!", index, (unsigned char)packetid);
	switch (packetid) {
		case 0x0A:
			Parse0x0A(data, index);
			break;
		case 0x0B:
			break;
		case 0x0F:
			//Parse0x0F(data, index);
			break;
		case 0x1C:
			Parse0x1C(data, index);
			break;
		case 0x25:
			send(bot[index].sck, data, 8, 0);
			break;
		case 0x3A:
			Parse0x3A(data, index);
			break;
		case 0x3D:
			//Parse0x3D(data, index);
			break;
		case 0x50:
			Parse0x50(data, index);
			break;
		case 0x51:
			Parse0x51(data, index);
			break;
		case 0x5E:
			Parse0x5E(data, index);
			break;
		default:
			AddChatEx(vbYellow, "[%d] Unhandled packet 0x%02x received!", index, (unsigned char)packetid);
	}
}

void Send0x50(int index) {
	InsertDWORD(0);
	InsertDWORD('IX86');
	InsertDWORD(client);
	InsertDWORD(verbyte);
	InsertDWORD('enUS');
	InsertDWORD(0);
	InsertDWORD(0);
	InsertDWORD(0);
	InsertDWORD(0);	
	InsertNTString("USA");
	InsertNTString("United States");
	SendPacket(0x50, index);
}

void Parse0x50(char *data, int index) {
	char crdlldir[MAX_PATH], KeyHash[20], exeInfo[128] = {0};
	char *mpqName = data + 24;
	char *ChecksumFormula = data + 25 + strlen(mpqName);
	unsigned long Checksum, exeVersion;

	bot[index].ClientToken = GetTickCount();	
	bot[index].ServerToken = *(unsigned long *)(data + 8);

	HashCDKey(KeyHash, bot[index].ClientToken, bot[index].ServerToken,
		bot[index].cdkey.productval, bot[index].cdkey.publicval, bot[index].cdkey.privateval);

	*(__int32 *)(mpqName + strlen(mpqName) - 4) = 'lld.';
	strcpy(crdlldir, hashes[4]);
	*(__int16 *)(crdlldir + strlen(crdlldir)) = '\\';
	strcat(crdlldir, mpqName);

	int result = CheckRevisionLD(hashes[0], hashes[1], hashes[2], ChecksumFormula, exeVersion, Checksum, exeInfo, crdlldir, hashes[3]);
	if (result) {
		AddChatEx(vbRed, "[%d] Failed CheckRevisionLD, error %d!", index, result);
		return;
	}

	WardenKeyInit(KeyHash, index);
	Send0x51(KeyHash, exeVersion, Checksum, exeInfo, index);
}	

void Send0x51(char *KeyHash, unsigned long exeVersion, unsigned long Checksum, char *exeInfo, int index) {
	InsertDWORD(bot[index].ClientToken);
	InsertDWORD(exeVersion);
	InsertDWORD(Checksum);
	InsertDWORD(1);
	InsertDWORD(0);
	InsertDWORD(13);
	InsertDWORD(bot[index].cdkey.productval);
	InsertDWORD(bot[index].cdkey.publicval);
	InsertDWORD(0);
	InsertVoid(KeyHash, 20);
	InsertNTString(exeInfo);
	InsertNTString("Epic Winrar");
	SendPacket(0x51, index);
}

void Parse0x51(char *data, int index) {
	char strerr[64], *exterr;
	int result = *(int *)(data + 4);
	if (!result) {
		Send0x3A(index);
	} else {
		strcpy(strerr, "[BNET] ");
		if (result & 0x0200) {
			if (result & 0x10)
				strcat(strerr, "Expansion ");
			strcat(strerr, "CDKey ");
			strcat(strerr, keyresstr[result & 0x03]);
			*(short *)(strerr + strlen(strerr)) = '.';
		} else if (result & 0x0100) {
			strcat(strerr, verresstr[result & 0x03]);
		}
		AddChat(vbRed, strerr);
		exterr = data + 8;
		if (*exterr) 
			AddChat(vbRed, exterr);
		//DisconnectProfile(index, false);
	}	
}

void Send0x3A(int index) {
	char outbuf[20];
	DoubleHashPass(bot[index].password, bot[index].ClientToken, bot[index].ServerToken, outbuf);
	InsertDWORD(bot[index].ClientToken);
	InsertDWORD(bot[index].ServerToken);
	InsertVoid(outbuf, 20);
	InsertNTString(bot[index].username);
	SendPacket(0x3A, index);
}

void Parse0x3A(char *data, int index) {
	char errstr[64];
	strcpy(errstr, "[BNET] ");
	switch (*(unsigned long *)(data + 4)) {
		case 0:
			Send0x0A(index);
			return;
		case 1:
			AddChat(vbYellow, "[BNET] Account doesn't exist, creating.");
			//Send0x3D(index);
			return;
		case 2:
			AddChat(vbRed, "[BNET] Logon failed.");
			break;
		default:
			AddChat(vbRed, data + 8);
	}
	//DisconnectProfile(index, false);
}

void Send0x0A(int index) {
	InsertNTString(bot[index].username);
	InsertByte(0x00);
	SendPacket(0x0A, index);
	InsertDWORD(0x02);
	InsertNTString(home);
	SendPacket(0x0C, index);
}

void Parse0x0A(char *data, int index) {
	char *tmp;
	bot[index].connected = true;
	AddChatEx(vbGreen, "Logged in as %s.", data + 4);
	CheckMenuItem(GetSubMenu(hMenu, 0), index, MF_BYPOSITION | MF_CHECKED);
	if (bot[0].connected + bot[1].connected == 2) {
		tmp = "Ready!";
		gstate |= GS_READY;
		EnableMenuItem(hMenu, 1, MF_BYPOSITION | MF_ENABLED);
	} else {
		tmp = "1 of 2 bots...";
	}
	SendMessage(hWnd_Statusbar, SB_SETTEXT, 0, (LPARAM)tmp);
}

void Send0x1C(int index, bool startgame) {
	//static tick = 0;
	char blah[128];
	sprintf(blah, ",44,12,6,5,a,,1,e2431c54,3,,%s\r%s\r", bot[index].username, mapname);
	InsertDWORD(startgame ? 0x0C : 0x00);
	InsertDWORD(startgame ? 8 : 0); //tick ? (GetTickCount() - tick) / 1000 : 0);
	InsertWORD(0x02);
	InsertWORD(0x01);
	InsertDWORD(0x1F);
	InsertDWORD(0);
	InsertNTString(gamename);
	InsertNTString("");
	InsertNTString(blah);
	SendPacket(0x1C, index);
	//if (!tick)
	//	tick = GetTickCount();
}

void Parse0x1C(char *data, int index) {
	if (*(int *)(data + 4)) {
		AddChat(vbRed, "Failed to create game!");
		return;
	}
	Send0x22(index);
	//AddChat(vbGreen, "Joined game~");
}

void Send0x22(int index) {
	InsertDWORD(client);
	InsertDWORD(verbyte);
	InsertNTString(gamename);
	InsertNTString("");
	SendPacket(0x22, index);
}

void Send0x2C(int index) {
	SCORE score;
	char buf[512];
	char tmpmapname[64];
	sprintf(tmpmapname, "<map>%s</map>\n", mapname);
	char *gameresult = "<leagueid>0</leagueid>\n<gameid>0xe2431c54</gameid>\n<race>Terran</race>\n<time>%d</time>\n\n  <score overall=\"%d\" units=\"%d\" structures=\"%d\" resources=\"%d\"/>\n\n  <units score=\"%d\" produced=\"%d\" killed=\"%d\" lost=\"%d\"/>\n\n  <structures score=\"%d\" constructed=\"%d\" razed=\"%d\" lost=\"%d\"/>\n\n  <resources score=\"%d\" gas=\"%d\" minerals=\"%d\" spent=\"%d\"/>\n";
	score.resources.minerals = 4500;
	score.resources.gas = 2500;		
	score.resources.spent = 2000;
	if (!index) {
		score.units.made = 100;
		score.units.killed = 30;
		score.units.lost = 20;
		score.structures.made = 20;
		score.structures.killed = 10;
		score.structures.lost = 2;
	} else {
		score.units.made = 70;
		score.units.killed = 20;
		score.units.lost = 30;
		score.structures.made = 10;
		score.structures.lost = 10;
		score.structures.killed = 2;
	}	
	int totalunits = score.units.made + score.units.killed - score.units.lost; 
	int totalstructures = score.structures.made + score.structures.killed - score.structures.lost;
	int totalresources = score.resources.gas + score.resources.minerals - score.resources.spent;
	sprintf(buf, gameresult, 125,
		totalunits + totalstructures + totalresources, totalunits, totalstructures, totalresources,		
		totalunits, score.units.made, score.units.killed, score.units.lost,
		totalstructures, score.structures.made, score.structures.killed, score.structures.lost,
		totalresources, score.resources.gas, score.resources.minerals, score.resources.spent);
	InsertDWORD(0);
	InsertDWORD(8);
	InsertDWORD(bot[0].gameresult);
	InsertDWORD(bot[1].gameresult);
	InsertDWORD(0);
	InsertDWORD(0);
	InsertDWORD(0);
	InsertDWORD(0);
	InsertDWORD(0);
	InsertDWORD(0);
	InsertNTString(bot[0].username);
	InsertNTString(bot[1].username);
	InsertNTString("");
	InsertNTString("");
	InsertNTString("");
	InsertNTString("");
	InsertNTString("");
	InsertNTString("");
	InsertNTString(tmpmapname);
	InsertNTString(gameresult);
	SendPacket(0x2C, index);
	//AddChat(vbGreen, "Sending game result");
	SendPacket(0x02, index);
}
