#include "main.h"
#include "fxns.h"
#include "packetbuffer.h"

char sendbuffer[2048];
unsigned int pbufferlen = 4;

void __fastcall InsertByte(unsigned char data) {
	*(sendbuffer + pbufferlen) = data;
	pbufferlen++;
}
 
void __fastcall InsertWORD(unsigned short data) {
	*(unsigned short *)(sendbuffer + pbufferlen) = data;
	pbufferlen += 2;
}
 
void __fastcall InsertDWORD(unsigned long data) {
	*(unsigned long *)(sendbuffer + pbufferlen) = data;
	pbufferlen += 4;
}
 
void __fastcall InsertNTString(char *data) {
	int datalen = strlen(data);
	strcpy(sendbuffer + pbufferlen, data);
	pbufferlen += datalen;
	sendbuffer[pbufferlen] = 0;
	pbufferlen++;
}
 
void __fastcall InsertNonNTString(char *data) {
	strcpy(sendbuffer + pbufferlen, data);
	pbufferlen += strlen(data);
}
 
void __fastcall InsertVoid(void *data, unsigned int len) {
	memcpy(sendbuffer + pbufferlen, data, (size_t)len);
	pbufferlen += len;
}
 
void __fastcall SendPacket(unsigned char PacketID, int index) {
	sendbuffer[0] = (unsigned char)0xFF;
	sendbuffer[1] = PacketID;
	*(unsigned short *)(sendbuffer + 2) = pbufferlen;
	send(bot[index].sck, sendbuffer, pbufferlen, 0);
	if (!bot[index].connected)
		AddChatEx(vbYellow, "[%d] Sending 0x%02x...", index, (unsigned char)PacketID);
	pbufferlen = 4; 
}