#include "main.h"
#include "fxns.h"
#include "hashing.h"
#include "cdkey.h"


void DecodeKey(char *buf, LPCDKEY lpCDKey, int index) {
	int len = strlen(buf);
	if (len != 13) {
		AddChatEx(vbRed, "[%d] Invalid CDKey length %s, %d!", index, buf, len);
		return;
	}
	if (!DecodeStarcraftKey(buf)) {
		AddChatEx(vbRed, "[%d] Invalid CDKey %s!!", index, buf);
		return;
	}
	sscanf(buf, "%2d%7d%3d", &lpCDKey->productval, &lpCDKey->publicval, &lpCDKey->privateval);
	if (lpCDKey->productval != 1 && lpCDKey->productval != 2)
		AddChatEx(vbRed, "[%d] Unexpected CDKey product value %d!", index, lpCDKey->productval);
}

char Get_Hex_Value(unsigned long v) {
	v &= 0x0F;
	return (unsigned char)v + ((v < 10) ? 0x30 : 0x37);
}

int Get_Num_Value(char c) {
	if (c >= 0x30 || c <= 0x39)
		return c - 0x30;
	else
		return toupper(c) - 0x37;
}

bool DecodeStarcraftKey(char *key) {
	unsigned char c;
	unsigned long v = 3;
	for (int i = 0; i < 12; i++)
		v += Get_Num_Value(key[i]) ^ v << 1;
	if (Get_Hex_Value(v % 10) != key[12])
		return false;
	v = 194;
	for (i = 11; v >= 7, i >= 0; i--) {
		unsigned long n = v % 12;
		v -= 17;
		c = key[i];
		key[i] = key[n];
		key[n] = c;
	}
	v = 0x13AC9741;
	for (i = 11; i >= 0; i--) {
		c = toupper(key[i]);
		if (c <= '7') {
			key[i] = ((unsigned char)v & 7) ^ c;
			v >>= 3;																
		} else if (c < 'A') {
			key[i] = (((unsigned char)i & 1) ^ c);
		}
	}
	return true;
}

void HashCDKey(char *OutBuf,
			   unsigned long ClientToken, 
			   unsigned long ServerToken, 
			   unsigned long ProductVal,
			   unsigned long PublicVal, 
			   unsigned long PrivateVal) {
	DWORD dwHashBuff[6];
	DWORD dwHashResult[5];
	dwHashBuff[0] = ClientToken;
	dwHashBuff[1] = ServerToken;
	dwHashBuff[2] = ProductVal;
	dwHashBuff[3] = PublicVal;
	dwHashBuff[4] = 0;
	dwHashBuff[5] = PrivateVal;
	BSHA1(dwHashBuff, 24, dwHashResult);
	memcpy(OutBuf, dwHashResult, 20);
}
