""" vbs.py

	Loads VBScript files that can be referenced by the bot in Python.
	Requires win32com installed.
	"""

import platform
if platform.system() == "Windows":
	print " Loading COM interface... "
	try:
		import win32com.client
	except:
		print " * Could not load COM interface: interface not installed"
else:
	print " * Could not load COM interface: system is not windows [%s]" % platform.system()
	
class pluginList():
	def __init__(self):
		self.list = []
		
	def all(self):
		return self.list
		
	def find(self, entry):
		for p in self.list:
			if p.info["name"].lower() == entry.lower():
				return p
		return None
		
	def add(self, entry):
		self.list.append( entry )
	
class plugin():
	def __init__(self, source):
		''' Ideally, all VBScript extensions should have at least:
			* prefix_cevent(ID, Username, Flags, Ping, Message)
			  * prefix being the name of the file [prefix.py]
			* prefix_author()
			
		'''
		if not platform.system() == "Windows":
			return None
		
		self.filepath = source
		self.name = self.filepath[:len(self.filepath)-4].replace("\\", "/")
		if (self.name.find("/") != -1):
			self.name.split
			
		
		self.code = open(self.filepath, "r").read()
		try:
			self.COM = win32com.client.Dispatch("ScriptControl")
			self.COM.language = "vbscript"
			self.COM.addcode(self.code + "\n")
			print "Loaded %s by %s." % (self.name, self.execFocal("author"))
		except:
			print "Warning: error in file [%s]:" % self.filepath
			
	def execUnique(self, statement):
		return self.COM.eval( statement )
	
	def execFocal(self, statement):
		return self.COM.eval( "Function " + self.name + "_" + statement )	
		