""" ui.py

	Advanced plugin to manage the bot's user interface
		
"""
#Project imports
import support, threading, sys, os, support
from statstring import statstring

#Python library imports
import datetime
from time import localtime, strftime

#"Constants"
UI_TITLE = support.getbotversion()
UI_LOCKCHAT = 401
UI_JOINLEAVE = 402


#Try to load wx
try:
	import wx
	wxen = True
except:
	support.doprint( " * It appears as though you do not have wxPython installed." )
	support.doprint( " * It is required for a bot interface. You can disable it in the config." )
	support.doprint( " * Literal: " + str(sys.exc_info()[1]) )
	wxen = False

#UI-specific imports
if wxen:
        from bni import bni
        from books import *
        from config import *
        from format import *
	
class MailTaskBarIcon(wx.TaskBarIcon):  
	def __init__(self, parent, shown=''):  
		wx.TaskBarIcon.__init__(self)
		self.callback = shown
		
		self.parentApp = parent  
		self.icon = wx.Icon("img\\python_red_16.png", wx.BITMAP_TYPE_PNG)   
		self.CreateMenu()  
		self.SetIconImage()
		self.ordered = []

	def CreateMenu(self):  
		self.Bind(wx.EVT_TASKBAR_RIGHT_UP, self.ShowMenu)  
		self.menu=wx.Menu()
		self.menu.Append(wx.ID_ABOUT, "Toggle Visibility")
		self.menu.AppendSeparator()  
		self.menu.Append(wx.ID_EXIT, "Close")

	def ShowMenu(self, event):  
		self.PopupMenu(self.menu)  
		
	def ShowUI(self, event):
		self.callback()

	def SetIconImage(self):
		try:
			self.parentApp.SetIcon(self.icon)
		except:
			support.doprint( "Failed to set window icon." )
			print sys.exc_info()
		self.SetIcon(self.icon, "PyBot") #TODO: display username, status	
class MailFrame(wx.Frame):
	def __init__(self, parent, id, title, tree, size=(100,100)):  
		wx.Frame.__init__(self, parent, -1, title, size = size) 
			#style=wx.NO_FULL_REPAINT_ON_RESIZE)  
	
		self.tree = tree
		self.tbicon = MailTaskBarIcon(self)  
		self.tbicon.Bind(wx.EVT_MENU, self.__fail__, id=wx.ID_EXIT)
		self.tbicon.Bind(wx.EVT_MENU, self.__tv__, id=wx.ID_ABOUT)		
		self.Show(True)
		self.shown = True

	def __fail__(self, event): 
		try:
			self.tbicon.RemoveIcon()
			self.tbicon.Destroy()
		except:
			pass
		sys.exit()
		
	def __tv__(self, event):  
		if self.shown == True:
			self.shown = False
			self.Show(False)
		else:
			self.shown = True
			self.Show(True)


	
class exposed(threading.Thread):
	def __init__(self, parent):
		if (not wxen): return None  
                self.upd_count = -1
		self.ordered = []
		self.status_bin = {}
		self.p = parent
		self.config = support.config(self.p.cfgfile)
		self.config.set("ui", "hidestatusbar", "no", False)
		self.udb = support.userlist()
		
		self.masterSize = wx.Size(800, 500)

		self.nb_right = {}
		
		threading.Thread.__init__(self)
		self.setDaemon(True)
		self.start()
	def reset_upd(self, evt):
                if type(evt) == wx.ActivateEvent and not evt.GetActive():
                    self.upd_count = 0
                    return
                self.upd_count = -1
                self.frame.SetTitle(UI_TITLE)
		wx.CallAfter(self.send.SetFocus) #It's what you want.
        def do_upd(self):
                if self.upd_count < 0:
                        return
                self.upd_count += 1
                self.frame.SetTitle('[%d] %s' % (self.upd_count, UI_TITLE))

        def open_config(self, *rest):
                p = self.nb_main.page_current()[3] #idx, name, kind, owner
                config(p)
                
	def run(self):
		self.app = wx.App(False)
		self.frame = MailFrame(None, -1, UI_TITLE, self, size=self.masterSize)
		
		if (self.config.get("ui", "hidestatusbar", "no") == "no"):
			self.ibar = self.frame.CreateStatusBar()
			self.ibar.SetStatusText("Welcome to PyBot")
		
                #Icon stuff
                self.bni = bni()
                self.icons, self.il, self.count = self.load_icons()

                self.draw = []

		#MENU BAR
		self.mnu_bot = wx.Menu()
		self.mnu_bot.Append(200, "Connect\tCtrl+B", "Connect to Battle.net")
                self.mnu_bot.Append(201, "Disconnect\tCtrl+D", "Disconnect from Battle.net")
                self.mnu_bot.AppendSeparator()
		self.mnu_bot.Append(wx.ID_ABOUT, "&Hide\tCtrl+H", "Puts the window in the taskbar so you can't see it")
		self.mnu_bot.Append(wx.ID_EXIT, "E&xit\tAlt+F4", "Exit PyBot")

		wx.EVT_MENU(self.frame, wx.ID_ABOUT, self.frame.__tv__)
		wx.EVT_MENU(self.frame, wx.ID_EXIT,  self.frame.__fail__)
		wx.EVT_MENU(self.frame, 200, self.mnuf_connect)
		wx.EVT_MENU(self.frame, 201, self.mnuf_disc)

		self.mnu_settings = wx.Menu()
		self.mnu_settings.Append(300, "Bot Settings\tCtrl+P", "Configure the bot")

		wx.EVT_MENU(self.frame, 300, self.open_config)

		self.mnu_window = wx.Menu()
		self.mnu_window.Append(400, "Clear chat window\tCtrl+S", "Empty the main window of any contents.")
		self.mnu_window.AppendSeparator()
		self.mnu_window.AppendCheckItem(UI_LOCKCHAT, "Lock chat window\tCtrl+L", "Stop the bot from adding new messages to the main window.")
		self.mnu_window.AppendCheckItem(UI_JOINLEAVE, "Disable join/leave messages\tAlt+V", "Stop the bot from adding messages to the main window about join/leave activity.")

                self.mnu_window.Check(UI_LOCKCHAT, self.config.get('ui', 'lockchat', "False") == "True")
                self.mnu_window.Check(UI_JOINLEAVE, self.config.get('ui', 'joinleave', "True") != "True")

		wx.EVT_MENU(self.frame, 400, self.mnuf_clear)
		wx.EVT_MENU(self.frame, UI_LOCKCHAT, self.mnuf_lock)
		wx.EVT_MENU(self.frame, UI_JOINLEAVE, self.mnuf_joinleave)

		self.menu = wx.MenuBar()
		self.menu.Append(self.mnu_bot, "&Bot")
		self.menu.Append(self.mnu_settings, "&Settings")
		self.menu.Append(self.mnu_window, "&Window")
		
		self.frame.SetMenuBar(self.menu)
		
		#Layout
		self.frame.half =  wx.BoxSizer(wx.HORIZONTAL)
		self.frame.leftsizer = wx.BoxSizer(wx.VERTICAL)
		self.frame.half.Add(self.frame.leftsizer, 500, wx.EXPAND)

		
		#MAIN NOTEBOOK
		self.nb_main = Book('main', self.p, self.frame, wx.aui.AUI_NB_WINDOWLIST_BUTTON |\
                            wx.aui.AUI_NB_CLOSE_BUTTON |\
                            wx.aui.AUI_NB_CLOSE_ON_ALL_TABS |\
                            wx.aui.AUI_NB_SCROLL_BUTTONS, self.tab_change)
		self.nb_main.page_add('disp', 'Main', 'Main')

		self.frame.leftsizer.Add(self.nb_main.book, 1, wx.EXPAND)

		#SEND BOX
		self.send = wx.ComboBox(self.frame, style=wx.TE_PROCESS_ENTER | wx.CB_DROPDOWN)
		self.send.SetBackgroundColour("black")
		self.send.SetForegroundColour("white")
		
		self.frame.Bind(wx.EVT_TEXT_ENTER, self.send_text, self.send)
		self.frame.Bind(wx.EVT_TEXT_PASTE, self.text_pasted, self.send)
		self.frame.Bind(wx.EVT_ACTIVATE, self.reset_upd)
                
		self.frame.leftsizer.Add(self.send, 0, wx.EXPAND)

                #CHANNEL LIST
		nb_right = self.get_book_right()
		nb_right.page_add('list', 'channel', 'Channel List', self)
		
		self.frame.half.Add(nb_right.book, 300, wx.EXPAND)
		self.nb_right.update({id(self.p): nb_right})
		
		
		#Final display
		self.frame.SetSizer(self.frame.half)
		self.frame.Layout()

		self.frame.Bind(wx.EVT_WINDOW_DESTROY, self.frame.__fail__, self.frame)
		
		self.frame.Show() 
		self.app.MainLoop()
	def get_book_right(self):
                return Book('right', self.p, self.frame, wx.aui.AUI_NB_WINDOWLIST_BUTTON |\
                                     wx.aui.AUI_NB_BOTTOM |\
                                     wx.aui.AUI_NB_SCROLL_BUTTONS, self.right_tab_change)

	def right_tab_change(self):
                pass
        
	def tab_change(self):
                wx.CallAfter(self.do_tab_change1)
        def do_tab_change1(self):
                co = self.frame.half.GetItem(1).GetWindow()
                co.Disable()
                co.Hide()
                c = self.nb_main.page_current() #idx, name, kind, owner
                
                key = id(c[3])
                if key in self.nb_right:
                        c = self.nb_right[key]
                else:
                        c = self.nb_right[id(self.p)]

                if co != c.book:
                        self.frame.half.Detach(1)                        
                        self.frame.half.Add(c.book, 300, wx.EXPAND)
                
                c.book.Enable()
                c.book.Show(True)
                self.frame.half.Layout()
                self.frame.Refresh()
		
                self.send.SetFocus()
                
        def addchat(self, *args, **kwargs):
                wx.CallAfter(self.do_addchat, *args, **kwargs)
        def do_addchat(self, *args, **kwargs):
                if self.mnu_window.IsChecked(UI_LOCKCHAT) and not ('override' in kwargs):
                        return
                if ('which' in kwargs):
                        which = kwargs['which']
                else:
                        which = 'Main'
                if ('caption' in kwargs):
                        caption = kwargs['caption']
                        capt_set = True
                else:
                        caption = which
                        capt_set = False
                new = False
                if (which in self.nb_main.tab) == False:
                        new = True
                        self.nb_main.page_add('disp', which, caption)
                if capt_set:
                        self.nb_main.tab[which].caption = caption
                        self.nb_main.tab[which].set_caption()
                if ('owner' in kwargs):
                        self.nb_main.tab[which].owner = kwargs['owner']
                        key = id(kwargs['owner'])
                        if (key in self.nb_right) == False:
                                self.nb_right[key] = self.get_book_right()
                                self.nb_right[key].page_add('list', 'channel', 'Channel List', self)

                wx.CallAfter(self.nb_main.tab[which].do_addchat, *args, **kwargs)

        def mnuf_disc(self, *rest):
                p = self.nb_main.page_current()[3] #idx, name, kind, owner
                self.nb_right[id(p)].tab['channel'].clear()
                
                p.disconnect()
                p.saydisc = False
                p.addchat("red", "All connections closed.")

        def mnuf_connect(self, *rest):
                p = self.nb_main.page_current()[3] #idx, name, kind, owner
                p.connect()

        def mnuf_lock(self, *rest):
                self.addchat('yellow', 'Chat window' + (self.mnu_window.IsChecked(UI_LOCKCHAT) and ' ' or ' un') + 'locked.', override=True)
                self.config.set('ui', 'lockchat', self.mnu_window.IsChecked(UI_LOCKCHAT), True)

        def mnuf_joinleave(self, *rest):
                self.addchat('yellow', 'Join/leave messages ' + (self.mnu_window.IsChecked(UI_JOINLEAVE) and 'dis' or 'en') + 'abled.')
                self.config.set('ui', 'joinleave', not self.mnu_window.IsChecked(UI_JOINLEAVE), True)

        def mnuf_clear(self, *rest):
                c = self.nb_main.page_current() #idx, name, kind, owner
                if c[2] == 'disp':
                       self.nb_main.tab[c[1]].panel.Clear() 
        def upd_header(self, *rest):
                wx.CallAfter(self.do_upd_header, *rest)
        def do_upd_header(self, p, c):
                c.header.SetLabel('%s (%d)' % (p.plugins.find('bncs').mychannel, c.lview.GetItemCount()))

        def load_icons(self, x=28, y=14, **kwargs):
                if kwargs == {}:
                        il = self.bni.il
                        icons = None
                        count = self.bni.count
                    
                else:        
                        il = wx.ImageList(x, y)
                        icons = {}
                        count = 0
                        for k, v in kwargs.iteritems():
                                icons[k] = il.Add(wx.Bitmap(v))
                        count += 1
                        
                return icons, il, count

        def set_status(self, text, **kwargs):
                self.status_bin.update(kwargs)
                if not hasattr(self, 'ibar'):
                       return 
                self.ibar.SetStatusText(text % self.status_bin)
        def text_pasted(self, event):
                if wx.TheClipboard.Open():
                        if wx.TheClipboard.IsSupported(wx.DataFormat(wx.DF_TEXT)):
                                data = wx.TextDataObject()
                                wx.TheClipboard.GetData(data)
                                msg = str(data.GetText())
                                if msg.find('\n') == -1:
                                        event.Skip(True)
                                else:
                                        p = self.nb_main.page_current()[3]
                                        for line in msg.split('\n'):
                                                if line != '':
                                                        p.pluginConsoleText(str(line))
                                                        if self.send.GetCount() >= 20:
                                                                self.send.Delete(19)
                                                        self.send.Insert(line, 0)

                        wx.TheClipboard.Close()
	def send_text(self, event):
                p = self.nb_main.page_current()[3] #owner of focused tab
		text = self.send.GetValue().strip('\n\r').split('\n')
		for msg in text:
                        if msg != '':
                                p.pluginConsoleText(str(msg))
                        if self.send.GetCount() >= 20:
                                self.send.Delete(19)
                        self.send.Insert(msg, 0)
		self.send.SetValue('')
		
	def __attr__(self):
		return {
			'name' : 'ui',
			'author' : "vi[r]us",
			'version' : (1, 0),
			'description' : 'Provides a simple interface for the bot.',
			'notes' : '',
			'help' : '',
			'chatexplicit' : False,
			'flags' : "s"
			}
		
	def __invoke__(self, ID, Length, Data, p):
		if (ID == 0x0A):
			#self.frame.tbicon.icon = wx.Icon("img\\pybot16_cssc.png", wx.BITMAP_TYPE_PNG)
			#self.frame.tbicon.SetIconImage()
			pass
        def new_bot(self, p):
                wx.CallAfter(self.do_new_bot, p)
        def do_new_bot(self, p):
		key = id(p)
		if (key in self.nb_right) == False:
                        self.nb_right[key] = self.get_book_right()
                        self.nb_right[key].page_add('list', 'channel', 'Channel List', self)

	def __cevent__(self, ID, Data, p):
                channel = p.plugins.find("channel")
                wx.CallAfter(self.do_cevent, ID, Data, p, channel, channel.evt_idx, channel.evt_start_idx, channel.evt_user)
                
        def do_cevent(self, ID, Data, p, chan, uid, init_uid, cuser):
		if (not wxen): return None

		key = id(p)
                cview = self.nb_right[key].tab['channel']
                bncs = p.plugins.find('bncs')
		self.do_upd()
		
		if (ID == 0x00): #CE_UNKNOWN
			p.addchat("red", "Unknown chat event.")
		elif (ID == 0x01): #CE_USERINCHANNEL
                        Data.update(statstring(Data['text']))
                        if init_uid == -1:
                                cview.do_add_entry(Data, Data['username'], (Data['ping'], Data['flags']), Data['clan'], idx=uid)
			
			if cuser.name.lower() == bncs.unique.lower():
				self.do_upd_header(p, cview)
		elif (ID == 0x02): #CE_USERJOIN
                        Data.update(statstring(Data['text']))
                        if init_uid == -1:
                                cview.do_add_entry(Data, Data['username'], (Data['ping'], Data['flags']), Data['clan'], idx=uid)
			
                        if not self.mnu_window.IsChecked(UI_JOINLEAVE):
                                p.addchat(
                                        "green", "-- ",
                                        "yellow", cuser.name + " [" + str(cuser.ping) + "]", 
                                        "green", " has joined the channel. " + cuser.infostring,
                                        )

                        self.do_upd_header(p, cview)
		elif (ID == 0x03): #CE_USERLEAVES
                        cview.do_remove_entry(init_uid)
                        if not self.mnu_window.IsChecked(UI_JOINLEAVE):
                                ''' CE_USERLEAVES '''
                                p.addchat(
                                        "green", "-- ",
                                        "yellow", Data['username'], 
                                        "green", " has left the channel.",
                                        )
                                
                        self.do_upd_header(p, cview)
		elif (ID == 0x04): #CE_WHISPERFROM
			p.addchat(
				"green", "<From ",
				"yellow", Data['username'], 
				"green", "> ", 
				"gray", Data['text'],
				no_upd=True)
		elif (ID == 0x05): #CE_USERTALK
			if (Data['text'][0] == "/"):
				return None
				
			ucolor = 'yellow'
			if (bncs.unique.lower() == cuser.name.lower()):
				ucolor = 'red'
			if ( (Data['flags'] & 0x02) == 0x02):
				ucolor = 'gold'
			if ( "h" in self.udb.getFlags(cuser.name) ):
				n = self.udb.getInfo(cuser.name)
				if ("color|" in n):
					ucolor = n[6:]
				else:
					ucolor = 'pink'
				
			p.addchat(
				"#0099CC", "<",
				ucolor, Data['username'], 
				"#0099CC", "> ", 
				"white", Data['text'],
                                )
		elif (ID == 0x07):#CE_CHANNELJOIN
                        cview.do_clear()
			p.addchat("green", "-- Joined: ", "yellow", Data['text'])
		elif (ID == 0x06): #CE_BROADCAST
			p.addchat(
				"#0099CC", "<Battle.net> ", 
				"white", Data['text'],
                                )
		elif (ID == 0x09): #CE_USERUPDATE / CE_FLAGSUPDATE
                        print cuser.clan
                        if init_uid != -1:
                                Data.update(statstring(Data['text']))
                                if init_uid != uid:
                                        cview.do_upd_entry(init_uid, Data, Data['username'], (Data['ping'], Data['flags']), cuser.clan, newidx=uid)

                                        p.addchat(
                                                "green", "-- ",
                                                "yellow", Data['username'], 
                                                "green", " has gained operator status.",
                                                )
                                else:
                                        cview.do_upd_entry(uid, 0, Data, 2, (Data['ping'], Data['flags']), 3, cuser.clan)
		elif (ID == 0x0A): #CE_WHISPERTO
			p.addchat(
				"green", "<To ",
				"yellow", Data['username'], 
				"green", "> ", 
				"gray", Data['text'],
				no_upd=True)
			p.addchat(
				"green", "<",
				"yellow", bncs.unique, 
				"green", "> ", 
				"gray", Data['text'],
				which='Whisper: ' + Data['username'])
		elif (ID == 0x0D or ID == 0x0F or ID == 0x0E or ID == 0x13): #CE_ERROR
			p.addchat("red", Data['text'])
		elif (ID == 0x12): #CE_INFO
			p.addchat("#0099CC", Data['text'])
		elif (ID == 0x17): #CE_USEREMOTE
			p.addchat(
				"yellow", "<" + Data['username'] + " " + Data['text'] + ">",
                                )
		elif (ID == 0x100): #CUSTOM_RAISEADDCHATEVENT
			p.addchat(*Data)
