import wx
exposed = None
import support

config_info = (('Username', 'username'),
               ('Password', 'password', {'style': wx.TE_PASSWORD}),
               ('CD Key', 'cdkey'),
               ('Server', 'bncs'),
               ('BNLS Server', 'bnls'),
               ('Home Channel', 'home')
               )

class config():
        def __init__(self, parent):
                self.p = parent
                self.config = support.config(self.p.cfgfile)
                self.frame = wx.Frame(None, -1, 'Settings', size=(400, 400))
                self.sizer = wx.GridSizer(len(config_info)+1, 2)

                self.textctrls = []

                for setting in config_info:
                        self.sizer.Add(wx.StaticText(self.frame, label=setting[0]+':', style=wx.ALIGN_RIGHT), flag=wx.ALIGN_RIGHT | wx.ALIGN_CENTER_VERTICAL)
                        if len(setting) < 3:
                                kwargs = {}
                        else:
                                kwargs = setting[2]
                        self.textctrls.append(wx.TextCtrl(self.frame, value=self.config.get('main', setting[1]), **kwargs))
                        self.sizer.Add(self.textctrls[-1], flag=wx.EXPAND)

                self.cancel = wx.Button(self.frame, label="Cancel")
                self.sizer.Add(self.cancel, flag=wx.EXPAND)
                self.apply = wx.Button(self.frame, label="Apply and Close")
                self.sizer.Add(self.apply, flag=wx.EXPAND)

                self.frame.Bind(wx.EVT_BUTTON, self.fcancel, self.cancel)
                self.frame.Bind(wx.EVT_BUTTON, self.fapply, self.apply)

                self.frame.SetSizerAndFit(self.sizer)
                self.frame.Show()
        def fcancel(self, *rest):
                self.frame.Destroy()

        def fapply(self, *rest):
                for setting in zip(config_info, self.textctrls):
                        self.config.set('main', setting[0][1], setting[1].GetValue(), True)
                self.frame.Destroy()
