from time import localtime, strftime
exposed = None
from format import safe_unicode
import webbrowser

import wx
import wx.aui 

class Book():
    def __init__(self, name, bot, parent, styles, change_evt):
        self.name = name
        self.bot = bot
        self.parent = parent
        self.panel = parent
        self.styles = styles
        self.change_evt = change_evt

        self.tab = {}
        self.order = []

        self.book = wx.aui.AuiNotebook(parent, style=styles)
        self.book.Bind(wx.aui.EVT_AUINOTEBOOK_PAGE_CHANGED,
                       self.page_selected,
                       self.book)

        self.book.Bind(wx.aui.EVT_AUINOTEBOOK_PAGE_CLOSED,
                       self.page_closed,
                       self.book)

    def page_current(self):
        idx = self.book.GetSelection()
        if self.order == [] or idx == -1:
                return None
        
        try:
                name = self.order[idx]
                kind = self.tab[name].kind
                owner = self.tab[name].owner
        except:
                print idx
                print self.order

        return idx, name, kind, owner

    def page_add(self, kind, name, caption, *args, **kwargs):
        self.tab[name] = types[kind](self.bot, self.parent, self, name,
                                     caption)
        
        wx.CallAfter(self.do_page_add, kind, name, caption, *args, **kwargs)
    def do_page_add(self, kind, name, caption, *args, **kwargs):
        if 'select' in kwargs:
            select = kwargs['select']
            del kwargs['select']
        else:
            select = False
        self.tab[name].ui_start(*args, **kwargs)
        
        if 'ui_order' in kwargs:
            self.order.insert(kwargs['ui_order'], name)
            self.book.InsertPage(kwargs['ui_order'], self.tab[name].panel,
                                 caption, select=select)

            del kwargs['ui_order']
        else:
            self.order.append(name)
            self.book.AddPage(self.tab[name].panel, caption, select=select)

    def page_remove(self, name):
        try:
            idx = self.order.index(name)
        except:
            return

        try:
            func = self.tab[name].__del__
        except:
            pass
        else:
            func()

        try:
            self.book.DeletePage(idx)
        except:
            pass

        del self.order[idx]
        try:
            del self.tab[name]
        except KeyError:
            pass

    def page_selected(self, *evt):
        try:
            page_name = self.order[self.book.GetSelection()]
            self.tab[page_name].selected()
            self.change_evt()
        except:
            return

        #self.bot.events.call('ui', self.name, page_name, 'selected')

    def page_closed(self, evt):
        idx = evt.selection
        name = self.order[idx]
        
        try:
            func = self.tab[name].__del__
        except:
            pass
        else:
            func()
            
        del self.order[idx]
        del self.tab[name]

        #self.bot.events.call('ui', self.name, 'closed', name, [name])

class Disp():
    kind = 'disp'
    def __init__(self, bot, parent, nb, name, caption):
        self.bot = bot
        self.parent = parent
        self.nb = nb

        self.name = name
        self.caption = caption
        self.unread = 0
        self.owner = bot

    def ui_start(self):
        self.text = wx.TextCtrl(self.nb.book, style=wx.TE_MULTILINE |\
                           wx.TE_READONLY | wx.TE_RICH2 | wx.TE_NOHIDESEL |\
                           wx.TE_AUTO_URL)
        self.text.SetBackgroundColour('#000000')
        self.text.SetForegroundColour('#FFFFFF')
        self.parent.Bind(wx.EVT_TEXT_URL, self.txt_url, self.text)
        self.panel = self.text
    def set_caption(self, *args):
        wx.CallAfter(self.do_set_caption, *args)

    def do_set_caption(self, *args):
        try:
                if self.unread == 0:
                        self.nb.book.SetPageText(self.nb.book.GetPageIndex(self.panel),
                                                 '%s' % (self.caption))
                else:
                        self.nb.book.SetPageText(self.nb.book.GetPageIndex(self.panel),
                                                 '[%d] %s' % (self.unread, self.caption))
        except:
                print 'caption set failed'
    def selected(self):
        self.unread = 0
        self.set_caption(self.caption)

    def txt_url (self, tue):
        if tue.GetMouseEvent().LeftDown():
            webbrowser.open(tue.EventObject.GetRange(tue.GetURLStart(),
                                                     tue.GetURLEnd()))

    def clear(self):
        self.text.Clear()

    def append (self, *args):
        wx.CallAfter(self.do_addchat, *args)
        
    def do_addchat(self, *args, **kwargs):
        if self.nb.page_current()[1] != self.name and ('no_upd' in kwargs) == False:
            self.unread += 1
            self.set_caption()
        if self.text.GetNumberOfLines() >= 250:
            length = self.text.GetLineLength(0) + 1
            self.text.Remove(0, length)

        self._indivchat('white', strftime(' [%I:%M:%S %p] ', localtime()))
                    
        if len(args) > 1:
            for x in range(0, len(args), 2):
                self._indivchat(args[x], args[x+1])
        else:
            self._indivchat('yellow', args[0])

        self.text.AppendText('\n')

    def _indivchat(self, style, text):  
        style = wx.TextAttr(style)
        self.text.SetDefaultStyle(style)
        try:
            self.text.AppendText(text)
        except TypeError:
            self.text.SetDefaultStyle(wx.TextAttr('red'))
            self.text.AppendText(u'<Invalid formatting>')
            print text
        except UnicodeDecodeError:
            self.text.SetDefaultStyle(wx.TextAttr('red'))
            self.text.AppendText(u'<Unicode decode error>')
            print text

class List():
    kind = 'list'
    def __init__(self, bot, parent, nb, name, caption):
        self.bot = bot
        self.parent = parent
        self.nb = nb

        self.name = name
        self.caption = caption
        self.unread = 0
        self.owner = bot

    def ui_start(self, ui):
        self.ui = ui
        self.draw = []
        self.type = [0x02, 0x00, 0x02, 0x00]
        self.panel = wx.Panel(self.nb.book)
        
        self.header = wx.StaticText(self.panel, label="Channel List", style=wx.ALIGN_CENTRE | wx.ST_NO_AUTORESIZE)
	self.header.SetBackgroundColour('black')
	self.header.SetForegroundColour('white')
        
	self.lview = wx.ListCtrl(self.panel, style= wx.LC_REPORT |\
                                 wx.LC_ALIGN_LEFT | wx.LC_ALIGN_TOP)
	self.lview.SetBackgroundColour("black")
	self.lview.SetForegroundColour("white")
	self.lview.InsertColumn(0, "Icon", width=34)
	self.lview.InsertColumn(1, "Username", width=140)
	self.lview.InsertColumn(2, "Lag", width=30)
	self.lview.InsertColumn(3, "Clan", width=40)
	self.lview.SetImageList(self.ui.il, wx.IMAGE_LIST_SMALL)

	self.lview.Bind(wx.EVT_LIST_ITEM_ACTIVATED, self.insert_user)

        self.gbs = wx.GridBagSizer(0, 0)
        self.gbs.Add(self.header, wx.GBPosition(0, 0), flag=wx.EXPAND)
        self.gbs.Add(self.lview, wx.GBPosition(1, 0), flag=wx.EXPAND)
        self.gbs.AddGrowableRow(1, 1)
        self.gbs.AddGrowableCol(0, 1)
        self.gbs.SetFlexibleDirection(wx.BOTH)
        #self.gbs.SetMinSize((270, 1))
        
        self.panel.SetBackgroundColour('#000000')
        self.panel.SetSizerAndFit(self.gbs, True)

    def insert_user(self, evt_list):
        #Prepare yourself.
        list_col = self.type.index(0x00)
        list_item = self.lview.GetItem(evt_list.GetIndex(), list_col)
        list_text = list_item.GetText()
        self.ui.send.SetValue(self.ui.send.GetValue() +\
                           list_text)

        evt_list.Skip(True)
        
    def get_lag_idx(self, arg):
        ping, flags = arg
        if (flags & 0x10) == 0x10:
            return self.ui.bni.legacy[49]['idx']
        elif ping <= 0:
            return self.ui.bni.legacy[42]['idx']
        elif ping < 200:
            return self.ui.bni.legacy[43]['idx']
        elif ping > 700:
            return self.ui.bni.legacy[48]['idx']
        else:
            return self.ui.bni.legacy[ping / 100 + 42]['idx']

    def get_bni_idx(self, user, draw):
        il = self.ui.bni.il
        try:
            icon = user['icon'][-4:] or user['product'][-4:]
        except KeyError:
            icon = user['product'][-4:]
        flags = user['flags']

        idx = -1
        for x in self.ui.bni.flag:
            if (flags & x['flags']) == x['flags']:
                idx = x['idx']
                return idx

        if (icon in ['STAR', 'SEXP', 'SSHR', 'JSTR']):
            try:
                if user['ladder_rank'] != 0:
                    if user['ladder_rank'] == 1:
                        idx = self.ui.bni.legacy[13]['idx']
                    else:
                        idx = self.ui.bni.legacy[12]['idx']
                elif user['ladder_rating'] != 0:
                    idx = self.ui.bni.legacy[11]['idx']
                elif user['wins'] > 0:
                    idx = ((user['wins'] > 10) and 10) or\
                            user['wins']
                    idx = self.ui.bni.legacy[idx]['idx']
                    return idx
            except KeyError:
                pass

        elif icon == 'W2BN':
            try:
                if user['ladder_rank'] != 0:
                    if user['ladder_rank'] == 1:
                        idx = self.ui.bni.legacy[28]['idx']
                    else:
                        idx = self.ui.bni.legacy[26]['idx']
                elif user['ladder_rating'] != 0:
                    idx = self.ui.bni.legacy[25]['idx']
                elif user['wins'] > 0:
                    idx = (((user['wins'] > 10) and 10) or\
                            user['wins']) + 14
                    return idx
            except KeyError:
                pass
                
        elif icon in ['DRTL', 'DSHR']:
            try:
                if user['class_num'] != -1:
                    idx = 30 + user['class_num'] + 3 * user['dots']
            except KeyError:
                pass
        elif user['product'] in ['WAR3', 'W3XP']:
            try:
                if user['level'] == 0:
                        icon = user['product'] #Override to more specific icon
            except KeyError:
                icon = user['product']
        if idx == -1:
            try:
                idx = self.ui.bni.prod[icon]['idx']
            except KeyError:
                return -1

        if 'level' in user:
            if user['level'] == 0:
                return idx
            bitm = il.GetBitmap(idx)
            mdc = wx.MemoryDC(bitm)
            mdc.SetTextForeground('#3399FF')
            font = wx.Font(6, wx.FONTFAMILY_ROMAN,
                           wx.FONTSTYLE_NORMAL,
                           wx.FONTWEIGHT_NORMAL)
            mdc.SetFont(font)
            if user['product'] in ['WAR3', 'W3XP']:
                mdc.DrawText(str(user['level']), 22, 3)
            elif user['product'] in ['DRTL', 'DSHR']:
                mdc.DrawText(str(user['level']), 16, 3)
            elif user['product'] in ['D2DV', 'D2XP']:
                mdc.DrawText(str(user['level']), 16, 3)

            mdc.SelectObjectAsSource(wx.NullBitmap)
            idx = self.ui.bni.add(bitm)
            draw.append(idx)
            return idx

        if 'ladder_rating' in user:
            if user['ladder_rating'] == 0:
                return idx

            bitm = il.GetBitmap(idx)
            mdc = wx.MemoryDC(bitm)
            font = wx.Font(6, wx.FONTFAMILY_ROMAN,
                               wx.FONTSTYLE_NORMAL,
                               wx.FONTWEIGHT_NORMAL)
            mdc.SetFont(font)
            mdc.SetTextForeground('#FFFFFF')
            mdc.DrawText(str(user['ladder_rating']), 5, 3)
            #if user['ladder_rank'] != 0:
            #    mdc.SetTextForeground('#3399FF')
            #    mdc.DrawText(str(user['ladder_rank']), 26, 10)
            #Not enough space anymore
            mdc.SelectObjectAsSource(wx.NullBitmap)
                
            idx = self.ui.bni.add(bitm)
            draw.append(idx)
            return idx

        return idx
    def get_icon_idx(self, icon):
        fgsfds = type(icon)
        if fgsfds == tuple:
            return self.get_lag_idx(icon)
        elif fgsfds == dict:
            return self.get_bni_idx(icon, self.draw)
        else:
            return self.ui.icons[icon]
    def add_entry(self, *args, **kwargs):
        wx.CallAfter(self.do_add_entry, *args, **kwargs)
    def do_add_entry(self, *args, **kwargs):
        if ('idx' in kwargs) == False:
            kwargs['idx'] = self.lview.GetItemCount()

        idx = self.lview.InsertImageStringItem(kwargs['idx'],
                                '',
                                -1)
        if 'bold' in kwargs:
            if kwargs['bold']:
                font = wx.Font(10, wx.FONTFAMILY_DEFAULT,
                           wx.FONTSTYLE_NORMAL,
                           wx.FONTWEIGHT_BOLD)
                self.lview.SetItemFont(idx, font)
        if 'color' in kwargs:
            self.lview.SetItemTextColour(idx, kwargs['color'])
        if 'bgcolor' in kwargs:
            self.lview.SetItemBackGroundColour(idx, kwargs['bgcolor'])

        x = 0
        for arg in args:
            if self.type[x] == 0x02:
                img_idx = self.get_icon_idx(arg)
                self.lview.SetItemColumnImage(idx, x, img_idx)
            else:
                self.lview.SetStringItem(idx, x, safe_unicode(arg))
            x += 1

    def upd_entry(self, *args, **kwargs):
        wx.CallAfter(self.do_upd_entry, *args, **kwargs)
    def do_upd_entry(self, idx, *args, **kwargs):
        if 'newidx' in kwargs:
            self.do_remove_entry(idx)
            kwargs['idx'] = kwargs['newidx']
            self.do_add_entry(*args, **kwargs)
        else:
            if 'color' in kwargs:
                self.lview.SetItemTextColour(idx, kwargs['color'])
            if 'bgcolor' in kwargs:
                self.lview.SetItemBackgroundColour(idx, kwargs['bgcolor'])
            for x in range(0, len(args), 2):
                if self.type[args[x]] == 0x02:
                    icon = self.get_icon_idx(args[x+1])
                    self.lview.SetItemColumnImage(idx, args[x], icon)
                else:
                    self.lview.SetStringItem(idx, args[x], safe_unicode(args[x+1]))
    def find_idx(self, text, column):
        #I wish this were more efficient, but wxListCtrl.FindItem = lolwut
        self.lview.Update()
        text = text.lower()
        for x in range(self.lview.GetItemCount()):
            list_item = self.lview.GetItem(x, column)
            #print '%s == %s' % (str(list_item.GetText()).lower(), text)
            if str(list_item.GetText()).lower() == text:
                return x
        return -1
    def remove_entry(self, idx):
        wx.CallAfter(self.do_remove_entry, idx)
    def do_remove_entry(self, idx):
        col = 0
        for kind in self.type:
            if kind == 0x02:
                list_item = self.lview.GetItem(idx, col)
                img_idx = list_item.GetImage()

                if img_idx in self.draw:
                    self.ui.bni.remove(img_idx)
                    self.draw.remove(img_idx)
            col += 1

        self.lview.DeleteItem(idx)

    def clear(self):
        wx.CallAfter(self.do_clear)
    def do_clear(self):
        self.ordered = []
        for x in self.draw:
            self.ui.bni.remove(x)
        self.draw = []
        self.lview.DeleteAllItems()
        self.header.SetLabel(self.caption)
    def upd_header(self, *rest):
        wx.CallAfter(self.do_upd_header, *rest)
    def do_upd_header(self, text):
        self.header.SetLabel('%s (%d)' % (text, self.lview.GetItemCount()))

types = {'disp': Disp,
         'list': List} 
