""" support.py

	Contains classes useful to the bot such as config or userlists. """

import ConfigParser, os, sys, datetime, time, re, random, threading, urllib2, default
import statstring, urllib, subprocess

## GLOBALS

config_actions = {}

## STATIC FUNCTIONS
	
def timestamp():
	return time.strftime("%H:%M:%S")
	
def doprint(text):
	try:
		print str(text)
		d = open("logs\\" + str(datetime.date.today()) + ".txt", "a")
		d.write("[" + str(datetime.datetime.now().hour) + ":" + str(datetime.datetime.now().minute) + ":" + str(datetime.datetime.now().second) + "] " + str(text) + "\r\n")
		d.close()
	except IOError:
		pass
		'''
		Paradoxal situation where we can't print or output anything because the output broke. Usually
		a program would explode in a fiery death of blue screens and white text, however this is python
		and we have a special error called exceptions.IOError that lets us solve the paradox by preventing
		it in the first place. In the end, this is what you want for all languages: easy to use try...except
		statements that do everything for you. If you're reading this i'm sorry, its just an IOError.
		'''
	
class inet_mask(urllib.URLopener):
	version = "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.0.5) Gecko/2008120122 Firefox/3.0.5"
	
def now():
	return datetime.datetime.now()
	
def getlastconfigact(name):
	global config_actions
	if (name.lower() in config_actions):
		return config_actions[name.lower()]
	else:
		return ''
		
def setlastconfigact(name, value):
	global config_actions
	config_actions[name.lower()] = value
	
def execafter(delay, func):
	t = threading.Timer(delay, func)
	t.start()
	del t
	
def listand(olist):
	c = 0
	if len(olist) == 0:
		return ''
	elif len(olist) == 1:
		return olist[0]
	else:
		r = ''
		for item in olist:
			c += 1
			if (c == len(olist)):
				r = r.rstrip(", ") + " and " + item
			else:
				r += item + ", "
		return r
	
def combinedict(a, b):
	## adds b to a if elements in b don't exist in a
	r = a
	for item in b:
		if not r.has_key(item):
			r[item] = b[item]
	return r
	
def familiar(name):
	n = name
	if name.find("@") != -1:
		n = name.split("@")[0]
	return n
	
def isyesno(value):
	v = value.lower()
	if (not v in ["yes", "no"]):
		return False
	else:
		return True
	
def orientyesno(value):
	v = value.lower()
	if (v == "no"):
		return False
	else:
		return True
	
def orient(value):
	game = value
	if not game in statstring.long_name:
		game = flipntrim(game)
		if not game in statstring.long_name:
			return False
	return game
	
def orientgame(value):
	return orient(value)
	
def unlame_message():
	d = ["no u", "ORLY", "lolhai", "sup", "deploy lolcats~!", "IMA FIRIN MA LAZOR", "oops", "misclick",
		"lolbai", "peace", "Fwd: The Void", "try again later", "denial", "^^", "noob", "so?", "i no rite",
		"http://www.youtube.com/watch?v=oHg5SJYRHA0", "step back", "not so fast", "gotcha"]
	return d[random.randint(0, len(d)-1)]
	
def trimopbrackets(name):
	if (name[0] == "[" and name[len(name)-1] == "]"):
		return name[1:len(name)-1]
	else:
		return name
		
def pd2(game):
	g = orientgame(game)
	if (g == "D2DV") or (g == "D2XP"):
		return "*"
	else:
		return ""
		
class timer(threading.Thread):
	def __init__(self, command, delay=1):
		threading.Thread.__init__(self)
		self.cmd = command
		self.execute = True
		self.delay = delay
		self.start()
		
	def run(self):
		while self.execute:
			self.cmd()
			time.sleep(self.delay)
		del self
	
def swfTime(seconds):
	''' Stopwatch format '''
	s, m, h, d = (seconds,0,0,0)
	while s > 60:
		s -= 60
		m += 1
		if m == 60:
			h += 1
			m = 0
		if h == 24:
			d += 1
			h = 0
	if d > 0:
		return str(d) + ":" + str(h).zfill(2) + ":" + str(m).zfill(2) + ":" + str(s).zfill(2)
	if h > 0:
		return str(h) + ":" + str(m).zfill(2) + ":" + str(s).zfill(2)
	else:
		return str(m) + ":" + str(s).zfill(2)
	
def hutime(seconds, fmt=(" seconds", " minutes", " hours", " days")):
	if seconds == 0:
		return "unknown"
	ss, mm, hh, dd = fmt
	s, m, h, d = (seconds,0,0,0)
	while s > 60:
		s -= 60
		m += 1
		if m == 60:
			h += 1
			m = 0
		if h == 24:
			d += 1
			h = 0
	r = str(d) + dd + ", " +\
		str(h) + hh + ", " +\
		str(m) + mm + ", " +\
		str(s) + ss
	return r.lstrip("0 days, ").lstrip("0 hours, ").lstrip("0 minutes, ")
	
def getsysuptime():
	if sys.platform.startswith('win'):
		''' Courtesy google.com '''
		try:
			pf = os.stat('C:/pagefile.sys').st_mtime
			td = datetime.datetime.now() - datetime.datetime.fromtimestamp(pf)
			return td.seconds + (td.days * 24 * 60 * 60)
		except:
			return 0
	else:
		return 0

	
class news():
	def retr(self):
		try:
			data = urllib2.urlopen("http://python.bot.nu/pybot/news.txt").read()
			return data
		except:
			return "Error occured getting the news: http://python.bot.nu/pybot/news.txt"
	
def match(text, pattern, mod=re.IGNORECASE, user=True):
		''' Instances a lit class so you do not have to constantly declare it. '''
		o = lit()
		return o.match(text, pattern, mod, user)

def groupen(groupname):
	if groupname.find("|") != -1:
		p = groupname.split("|")
		return "%s (%s)" % (p[1], p[0])
	else:
		return groupname
		
def servers(text, e, type="all"):
	''' Returns the internal list of bncs servers as lists within a dictionary. '''
	file = open("bncs_servers.txt", "r").read().replace("\r", "").split("\n")
	gateway = "useast.battle.net"
	ip3 = "0.0.0"
	servers = {}
	for line in file:
		if "|" in line:
			gateway, ip3 = line.split("|")
			servers[gateway] = []
		else:
			servers[gateway].append( ip3 + line )

			
			
## CLASSES AND SHIT


			
class lit():
	''' Textual help '''
	def __init__(self):
		pass
		
	def regex(self, text, e, mod=re.IGNORECASE):
		if len(e) == 0: return text
		if len(text) == 0: return ''
		if e[0] == "*":
			expression = "." + e
		else:
			expression = e
			
		try:
			exp = re.compile(expression, mod)
		except:
			exp = re.compile(expression)
		try:
			return str(exp.match(text).group())
		except:
			return ''

	def soundex(self, v, len=4):
		digits = '01230120022455012623010202'
		sndx = ''
		fc = ''

		for c in v.upper():
			if c.isalpha():
				if not fc: fc = c
				d = digits[ord(c)-ord('A')]
				if not sndx or (d != sndx[-1]):
					sndx += d

		sndx = fc + sndx[1:]
		sndx = sndx.replace('0','')
		return (sndx + (len * '0'))[:len]

	def match(self, text, p, mod=re.IGNORECASE, user=True):
		''' By default it is a non-case-sensative, absolutely no matches comparison '''
		try:
			pattern = p
			if pattern.find(".") != -1:
				self.doprint( "Note: " + t + " compared to " + pattern + " contains a period." )
			if (user): pattern.replace(".", "\.")
			if self.regex(text, pattern, mod) == '':
				return False
			else:
				return True
		except:
			return False
	
class config():
	''' Reads a configuration file. '''
	def __init__(self, source):
		self.config = None
		self.path = source
		setlastconfigact(self.path, 'read')
		self.reload()
		
	def set(self, target, key, value, overwrite=True):
		self.reload()
		if not self.config.has_section(target):
			self.config.add_section(target)
		if self.config.has_option(target, key):
			if overwrite == True:
				self.config.set(target, key, str(value))
		else:
			self.config.set(target, key, value)
		self.config.write(open(self.path, "w"))
		setlastconfigact(self.path, 'write')
			
	def reload(self):
		self.config = None
		self.config = ConfigParser.ConfigParser()
		if not os.path.exists(self.path):
			pre = open(self.path, "w")
			pre.write("")
			pre.close()
			doprint( "Created file %s." % self.path )
		self.config.read(self.path)
			
	def get(self, target, key, default=''):
		self.reload()
		setlastconfigact(self.path, 'read')
		try:
			return self.config.get(target, key)
		except:
			return default
		
			
	def gettype(self, target, key, type='int'):
		self.reload()
		try:
			value = self.config.get(target, key)
			if (type == 'int'):
				return int(value)
			elif (type == 'bool'):
				return bool(value)
			elif (type == 'str'):
				return str(value)
			elif (type == 'list'):
				return list(value)
			else:
				return value
		except:
			return 0

class flags():
	''' Lists of possible flag types. '''
	def __init__(self):
		pass
		
	def clanRankIS(self):
		''' ID -> STRING '''
		return {
				0x00: "Peon (probation)",
				0x01: "Peon",
				0x02: "Grunt",
				0x03: "Shaman",
				0x04: "Chieftain"
				}
				
def flipntrim(string): return ''.join(reversed(string)).strip(' \r\n\0')
			
class channelObject():
	''' Handles a user in the channel. '''
	def __init__(self, name, flags, ping, statstring):
		self.name = name
		self.unique = name
		self.number = 0
		
		self.flags = flags
		self.statstring = statstring
		self.ping = ping
		self.generated = now()
		self.game = 'CHAT'
		
		''' Only available after a string is parsed. '''
		self.ogame = 'CHAT' #cuz some stuff is too cumbersome to change the default game attr to oriented
		self.level = 0
		
		''' Warcraft III and Warcraft III Frozen Throne Explicit '''
		self.w3icon = ''
		self.w3icon_name = ''
		self.w3teir = ''
		self.clan = ''
		
		''' Diablo II and Lord of Destruction Explicit '''
		self.d2character = ''
		self.d2realm = ''
		self.d2characternt = []
		
		''' Starcraft and Legacy Explicit '''
		self.data = []
		
		''' ... '''
		self.infostring = self.__parse__() + ")"
		
	def hasFlag(self, flag):
		if (self.flags & int(flag)) == int(flag):
			return True
		else:
			return False
		
	def IsOperator(self):
		if self.hasFlag(0x02):
			return True
		else:
			return False
			
	def IsSquelched(self):
		if self.hasFlag(0x20):
			return True
		else:
			return False
			
	def IsIgnored(self):
		return self.IsSquelched()
		
	def HasUDPPlug(self):
		if self.hasFlag(0x16):
			return True
		else:
			return False
			
	def IsBlue(self):
		if self.hasFlag(0x01):
			return True
		else:
			return False
		
	def __parse__(self):
		if (self.statstring == ''):
			return "("
		else:
			## Figure out non-unique names
			if (self.name.find("#") != -1):
				name = ''
				if (self.name.find("@") != -1):
					p = self.name.split("@")
					name = p[0]
					serv = "@" + p[1]
				else:
					name = self.name
					serv = ''
				p2 = name.split("#")
				self.unique = p2[0] + serv
				self.number = int(p2[1])
			
			## ...
			s = self.statstring.split(" ")
			self.game = flipntrim(self.statstring[0:4])
			self.ogame = orient(self.game)
			try:
				i = statstring.long_name[self.game] + " ("
			except KeyError:
				return self.statstring + " ("
			
			if len(self.statstring) == 4:
				return self.game + " ("
			
			try:
				if (self.game == "WAR3" or self.game == "W3XP"):
					self.w3icon = s[1]
					try:
						self.w3icon_name = statstring.iconset(self.w3icon, self.game)[self.w3icon]
					except KeyError:
						doprint( ">> I do not know %s's icon code:  %s" % (self.name, self.w3icon))
					self.w3teir = self.w3icon[1]
					self.level = int(s[2])
					i += "level %s with a %s icon" % ( str(self.level), self.w3icon_name )
					try:
						self.clan = flipntrim(s[3])
						i += ", in Clan " + self.clan
					except:
						pass
				elif (self.game == "STAR" or self.game == "SEXP"):
					i += "Starcraft"
				elif (self.game == "D2XP" or self.game == "D2DV"):
					if len(s) == 1:
						self.d2character = "Open Character"
						i += "No character"
					else:
						self.d2character = s[2]
						self.d2realm = s[1]
						self.d2characternt = s[3:]
						i += self.d2character + " on " + self.d2realm
				elif (self.game == "W2BN"):
					i += "Warcraft II: BNE"
				else:
					doprint( "Code unknown ? " + self.game )
					self.game = "UNKN"
			except:
				doprint( ">> Could not parse %s's statstring:  %s" % (self.name, self.statstring))
				doprint(sys.exc_info())
				pass
				
			return i
			
class userlist():
	''' Handles a list of users with flags and access. '''
	def __init__(self):
		self.db = config("users.ini")
		self.db.set("access", "group|none", "0", False)
		self.db.set("flags", "group|none", "", False)
		self.db.set("info", "group|none", "", False)
		self.db.set("groups", "group|none", "", False)
		
	def proper(self, username):
		if username == None: return ""
		
		if type(username) == type(''):
			name = username.lower()
		else:
			name = username.name
		n = name
		if name.find("#") != -1:
			n = name.split("#")[0]
			if name.find("@") != -1:
				n += "@" + name.split("@")[1]
		return n
		
	def getAccess(self, username):
		if (username == None): return 0
		if type(username) == type(''):
			return int(self.db.get("access", self.proper(username), 0))
		else:
			returns = 0
			if "i" in self.getFlags(username): return -1
			access = self.db.config.items("access")
			for key, value in access:
				if self.accessWildcard(username, key):
					if int(value) > returns:
						returns = int(value)
			return returns
			
	def getInfo(self, username):
		if (username == None): return ""
		if type(username) == type(''):
			return self.db.get("info", self.proper(username), "")
		else:
			returns = ''
			info = self.db.config.items("info")
			u = username
			for key, value in info:
				if len(value) > 0:
					if self.accessWildcard(u, key):
						returns += "[%s] %s; " % (key, value)
			return returns.rstrip("; ")
			
	def getGroups(self, username, fmt=False):
		if (username == None): username = ""
		
		if type(username) == type(''):
			if fmt:
				return ""
			else:
				return "No groups."
		else:
			returns = ""
			info = self.db.config.items("access")
			u = username
			for key, value in info:
				if (not key == "group|none"):
					if (self.getAccess(key) > 0):
						if self.accessWildcard(u, key):
							if self.proper(username).lower() == key.lower():
								returns += "self; "
							else:
								returns += groupen(key) + "; "
			return returns.rstrip("; ")
			
	def getGroupMasks(self, username):
		if (username == None): username = ""
		u = username
		if type(username) == type(''):
			u = username
		else:
			u = username.name
		return self.db.get("groups", self.proper(username), chr(0))
		
	def getFlags(self, username):
		if (username == None): return ""
		
		if type(username) == type(''):
			fset = self.db.get("flags", self.proper(username), "")
		else:
			returns = ""
			access = self.db.config.items("flags")
			u = username
			for key, value in access:
				if self.accessWildcard(u, key):
					for flag in value:
						if not flag in returns:
							returns += flag
			fset = returns
		if ("i" in fset) and (not "a" in fset):
			return "i"
		else:
			return fset
		
	def accessWildcard(self, u, e):
		if u == None: return False
		r = self._accessWildcard(u, e)
		#print "COMPARE",e,"TO",self.proper(u),"YIELD",r
		return r
		
	def _accessWildcard(self, u, e):
		try:
			if u.name.lower() == e.lower():
				return True
		except: pass
		
		try:
			if u.lower() == e.lower():
				return True
		except: pass
		
		user = u
		username = self.proper(u).lower()
		expression = e.lower()
		
		# in this group?
		if ("group|" in expression):
			if (self.getGroupMasks(username).lower() == expression[6:].lower()):
				return True
			return False
		
		try:
			if match(username, expression):
				return True
			if username == expression:
				return True

			# all
			elif (expression == "all"):
				return True
				
			# lag
			elif ("lag|" in expression):
				## Ping
				if (user.ping >= int(expression[4:])):
					return True
			elif ("ping|" in expression):
				## Ping
				if (user.ping >= int(expression[5:])):
					return True
					
			# games
			elif ("game|" in expression):
				games = expression[5:].split(",")
				for game in games:
					if (orient(user.game).lower() == orient(game).lower()):
						return True
			elif ("peon" in expression):
				## Warcraft peons
				if (user.icon == "1R3W"): return True
			elif ("icon|" in expression):
				## Any icon ID
				if (user.icon == expression[5:]): return True
			elif ("level|" in expression):
				## Diablo or warcraft level
				pass
			elif ("wins|" in expression):
				## Starcraft victories
				pass
			elif (expression == "noch"):
				## Open diablo character boolean
				pass
			# clan
			elif ("clan|" in expression):
				if (user.clan.lower() == expression[5:].lower()): return True
			elif ("rank|" in expression):
				pass
			return False
		except AttributeError:
			if type(user) == type(''):
				if username == expression or match(username, expression):
					return True
				return False
		except:
			if match(user, expression):
				return True
			else:
				return False
		return False
		
	def setAccess(self, username, access, overwrite=True):
		self.db.set("access", username, str(access), overwrite)
		
	def setFlags(self, username, flags, overwrite=True):
		nf = flags
		f = self.getFlags(username)
		if (flags[:1] in ["+", "-"]):
			nf = flags[1:]
			if flags[:1] == "+":
				for flag in nf:
					if (not flag in f):
						f += flag
				self.db.set("flags", username, f.lower(), overwrite)
				return
			elif flags[:1] == "-":
				newflags = ''
				for flag in f:
					if not (flag in nf):
						newflags += flag
				self.db.set("flags", username, newflags.lower(), overwrite)
				return
		self.db.set("flags", username, flags.lower(), overwrite)
		
	def setInfo(self, username, text, overwrite=True):
		self.db.set("info", username, text, overwrite)
		
	def setGroupMask(self, username, text, overwrite=True):
		self.db.set("groups", username, text, overwrite)
		
	def find(self, username='', flag=''):
		access = self.db.config.items("flags")
		list = []
		for key, value in access:
			if ((flag in value) or (flag == '')) and ((username.lower() in key.lower()) or (username == '')):
				list.append(groupen(key))
		return list
	
	def safelisted(self, username):
		## If a user is safelisted they should not be banned by the bot
		## unless explicitly told to do so
		f = self.getFlags(username)
		if (not "a" in f) and (not "s" in f) and (not self.getAccess(username) > 80):
			return False
		else:
			return True
			
	def shitlisted(self, username):
		## If a user is shitlisted they should be banned by the bot
		## unless explicitly told to remove their b flag.
		f = self.getFlags(username)
		if ("b" in f) and (not "a" in f):
			return True
		else:
			return False
		
def getbotversion():
	v = version()
	return v.versionhistory()
		
class version():
	def __init__(self):
		self.major = 1
		self.minor = 2
		self.revision = 269 #Only really applies to source
		self.beta = 0
		self.hotfix = 0
		self.edition = "Developer's Edition"
		
	def versionhistory(self):
		base = "PyBot %i.%i" % (self.major, self.minor)
		
		## Beta release
		if self.beta > 0:
			base = " Beta %i" % self.beta
		## Revised
		if self.revision > 0:
			base += " Revision %i" % self.revision
		## Hotfix
		if self.hotfix > 0:
			base += " Hotfix #%i" % self.hotfix
		## Editions
		if not self.edition == "":
			base += " " + self.edition
			
		return base
		
	def versiondesc(self):
		return "by The PyBot Dev Team (http://python.bot.nu/)"
		
	def history(self):
		return ".: %s :: %s :." % (self.versionhistory(), self.versiondesc())
		
class command():
	def __init__(self, cfg="pybot.ini"):
		self.config = config(cfg)
		self.udb = userlist()
		
	def trigger(self):
		return self.config.get("main", "trigger", ".")
		
	def iscommand(self, cmdstring, parent, flag=0x00, flist=[]):
		''' Returns False if the string is not in command format, returns the parsed string if it is. 
			If there are multiple commands in this string, it returns a list. '''
		# Literal
		string = cmdstring
		cmd = string.split(" ")
		# For comparison
		cmdfc = string.lower().split(" ")
		
		target = ''
		mask = ''
		for m in range(0,3):
			if len(cmd) > 1:
				if (cmd[-2] == ">"):
					target = cmd[-1]
					cmd = cmd[:len(cmd)-2]
					cmdfc = cmdfc[:len(cmdfc)-2]
					string = " ".join(cmd)
				elif (cmd[-1] == "#"):
					target = "#"
					cmd = cmd[:len(cmd)-1]
					cmdfc = cmdfc[:len(cmdfc)-1]
					string = " ".join(cmd)
				elif (cmd[-2] == "|"):
					mask = cmd[-1]
					cmd = cmd[:len(cmd)-2]
					cmdfc = cmdfc[:len(cmdfc)-2]
					string = " ".join(cmd)
		
		if (parent.plugins.find("bncs").online):
			name = parent.plugins.find("bncs").unique.lower()
		else:
			name = "PyBot"
		triggers = \
			[
			(self.trigger(), -1),
			(self.trigger() * 2, 3),
			(self.trigger() * 3, 2),
			("all, ", -1),
			("bots, ", -1),
			("pybots, ", -1),
			("%s, " % name, -1),
			("all: ", -1),
			("bots: ", -1),
			("pybots: ", -1),
			("%s: " % name, -1)
			]
		if (flag & 0x02) == 0x02:
			triggers.append( ("ops, ", -1) )
			triggers.append( ("ops: ", -1) )
			
		if len(flist) > 0:
			for item in flist:
				if not type(item) == type(()):
					triggers.append( (item, -1) )
				else:
					triggers.append(item)

		for trigger, returnmode in triggers:
			if (string[:len(trigger)] == trigger.lower()) or (string[:8] == "?trigger"):
				s = string[len(trigger):]
				if (string[:8] == "?trigger"):
					s = string[1:]
				if s.find("; ") != -1:
					cmds = []
					for command in s.split("; "):
						cmdp = command.split(" ")
						if (len(cmdp) == 1):
							cmds.append(commandObject(cmdp[0], target=target, mask=mask, trigger=trigger, r=returnmode))
						else:
							cmds.append(commandObject(cmdp[0], cmdp[1:], target=target, mask=mask, trigger=trigger, r=returnmode))
				else:
					s = s.split(" ")
					if (len(s) == 1):
						cmds = [commandObject(s[0], target=target, mask=mask, trigger=trigger, r=returnmode)]
					else:
						cmds = [commandObject(s[0], s[1:], target=target, mask=mask, trigger=trigger, r=returnmode)]
				return cmds
		return False
			
class commandObject():
	def __init__(self, name, parameters='', target='', mask='', trigger=None, r=-1):
		self.name = name
		self.parameters = parameters
		self.target = target
		self.mask = mask
		self.trigger = trigger
		self.returnmode = r
		
		c = config("access.ini")
		if (c.get("access", self.name, "NONE") != "NONE"):
			self.hackedaccess = c.gettype("access", self.name, 'int')
		else:
			self.hackedaccess = -1
		
def commandProcess(Data, p, processor):
	id = Data[3]
	command = Data[2]
	s = processor(command.name, command, source=Data[0], origin=id)
	if not s == '' and not s == None:
		tpre = ""
		if (command.target != ""):
			if (command.target == "#"): command.target = Data[0]
			if (Data[0] == "~console"):
				tpre = "/w %s " % command.target
			else:
				tpre = "/w %s [%s] " % (command.target, Data[0])

		if command.returnmode != -1:
			id = command.returnmode
			print "Force return mode:",id
				
		if (id == 1):
			p.queue.addq( tpre + s )
		if (id == 2):
			p.queue.addq( "/me %s" % s )
		if (id == 3):
			if command.target != '':
				p.queue.addq( tpre + s )
			else:
				p.queue.addq( "/w %s %s" % (Data[0], s) )
		if (id == 4):
			p.addchat( "#C4BA8D", s)
		if (id == 5):
			p.queue.addq( "%s(%s) %s" % (tpre, command.name, s) )
		return True
	return False
	
def commandValidate(COMMAND, object, source, IChannel, database):
	CMD = COMMAND
	if (not COMMAND.lower() in default.commands()):
		''' has Alias? '''
		if (COMMAND.lower() in default.aliases()):
			CMD = default.aliases()[COMMAND.lower()]
		else:
			''' Nope. '''

	par = object.parameters

	user = source
	for u in IChannel:
		if u.name.lower() == source.lower():
			user = u
	
	access = database.getAccess(user)
	flags = database.getFlags(user)
	space = ""
	if access < 80: space = ' '
	
	if ("a" in flags): access = 200
	if (source == "~console"): access=201
	
	if (not CMD.lower() in default.commands()):
		return (user, access, flags, space, False)
	if (not access >= default.commands()[CMD.lower()]):
		return (user, access, flags, space, False)
	
	
	return (user, access, flags, space, CMD)
		
class clan():
	def __init__(self):
		self.members = [] ## All of them
		self.chieftain = ""
		
	def chieftain(self):
		return self.chieftain
		
	def shamans(self):
		shamans = []
		for member in self.members:
			if member.rank == 3:
				shamans.append(member)
		return shamans
		
	def members(self, full=False):
		## full = True if you do not want iniates
		members = []
		for member in self.members:
			if member.rank < 3:
				if full:
					if member.rank > 0: members.append(member)
				else:
					members.append(member)
		return members
		
	def remove(self, name):
		for member in self.members:
			if member.name.lower() == name.lower():
				self.members.remove(member)
				return True
		return False
		
	def find(self, name):
		for member in self.members:
			if member.name.lower() == name.lower():
				return member
		return None
		
	def modify(self, name, new):
		for member in self.members:
			if member.name.lower() == name.lower():
				member = new
				return True
		return False
	
class clanObject():
	def __init__(self, name, rank, online=False, location=''):
		self.name = name
		self.rank = rank
		self.online = online
		self.location = location
		
	def status(self):
		if self.online:
			s = "online"
		else:
			s = "offline"
		return s
		
class slashCommand():
	def __init__(self, text):
		r = self.parse(text)
		if r == False:
			self.valid = False
		else:
			self.valid = True
			self.name, self.parameters = r
		
	def parse(self, text):
		if text[:1] == "/":
			t = text[1:].split(" ")
			return (t[0].lower(), t[1:])
		else:
			return False
		
class ssparser():
	''' Parses user statstrings and converts flags into human-readable strings. '''
	def __init__(self):
		pass