
""" clan.py

	Internal clan list.
		
	"""
	
import buffer, language, support
	
class invitation():
	def __init__(self, cookie, tag, name, inviter):
		self.cookie = cookie
		self.rawtag = tag
		self.tag = support.flipntrim(tag)
		self.name = name
		self.inviter = inviter
		
		## Instance of a buffer to build replies
		self.out = buffer.pout()
		
	def reply(self, response):
		self.out.insertDWord(self.cookie)
		self.out.insertRawData(self.rawtag)
		self.out.insertString(self.inviter)
		self.out.insertByte(response)
		return self.out.build(0x79)
		
	def accept(self):
		print "ACCEPT INVITATION"
		return self.reply(0x06)
	
	def decline(self):
		print "DECLINE INVITATION"
		return self.reply(0x04)
	
class exposed():
	def __init__(self, parent):
		self.parent = parent
		self.f = support.flags()
		self.myClan = ""
		self.myClanRank = 0x00
		self.myClanList = support.clan()
		self.motd = "Clan MOTD was never sent."
		
		self.config = support.config(parent.cfgfile)
		self.config.set("main", "clannotify", "yes", False)
		
		## Invites
		self.i_pending = []
		
	def __attr__(self):
		return {
			'name' : 'clan',
			'author' : "vi[r]us",
			'version' : (1, 0),
			'description' : 'Handles your internal clan list.',
			'notes' : 'This class should generally not be edited.',
			'help' : '',
			'chatexplicit' : False,
			'flags' : "s"
			}
			
	def setMOTD(self, motd):
		if self.myClanRank >= 0x03:
			self.out.insertDWord(0)
			self.out.insertString(motd)
			self.parent.send(self.out.build(0x7B))
			return "Updated message of the day."
		else:
			IDs = self.f.clanRankIS()
			return IDs[self.myClanRank] + "s can not set the clan message of the day."
			
	def getClanList(self):
		if self.myClan != "":
			self.out.insertDWord(0)
			self.parent.send(self.out.build(0x7D))
			print "GET clan list"
		else:
			print "NOT a member of any clan"
			
	def __invoke__(self, ID, Length, Data, p):
		tr = language.english()
		b = buffer.pin()
		b.unbuild(Data)
		self.out = buffer.pout()
		
		IDs = self.f.clanRankIS()
		if (ID == 0x75):
			''' SID_CLANINFO '''
			b.getByte()
			self.myClan = support.flipntrim(b.getRawData(4))
			self.myClanRank = b.getByte()
			p.plugins.find("ui").addchat("green", "[CLAN] You are a ", "yellow", IDs[self.myClanRank], "green", " in Clan " + self.myClan + ".")
			support.doprint( "[CLAN] You are a %s in Clan %s." % ( IDs[self.myClanRank], self.myClan ) )
		if (ID == 0x79):
			''' SID_CLANINVITATIONRESPONSE '''
			## Being invited
			invite = invitation(b.getDWord(), b.getRawData(4), b.getString(), b.getString())
			self.i_pending.append(invite)
			print invite.inviter + " has invited you to join Clan " + invite.tag + " (" + invite.name + ")."
			p.plugins.find("ui").addchat("green", "[CLAN] You have been invited to join ", "yellow", "Clan " + invite.tag, "green", " [" + invite.name + "] by ", "yellow", invite.inviter, "green", ".") ## (\"/accept " + invite.tag + "\" or \"/decline " + invite.tag + "\")")
		if (ID == 0x7C):
			''' SID_CLANMOTD '''
			cookie = b.getDWord()
			b.getDWord()
			self.motd = b.getString()
		if (ID == 0x7D):
			''' SID_CLANMEMBERLIST '''
			cookie = b.getDWord()
			members = b.getByte()
			for n in range(0, members):
				m = support.clanObject(b.getString(), b.getByte(), b.getByte(), b.getString())
				if m.rank == 5: self.myClanList.chieftain = m.name
				self.myClanList.members.append(m)
		if (ID == 0x7E):
			''' SID_CLANMEMBEREMOVED '''
			name = b.getString()
			self.myClanList.remove(name)
			p.plugins.find("ui").addchat("yellow", "[CLAN] " + name + " has left the clan.")
		if (ID == 0x7F):
			''' SID_CLANMEMBERSTATUSCHANGE '''
			m = support.clanObject(b.getString(), b.getByte(), b.getByte(), b.getString())
			self.myClanList.modify(m.name, m)
			if self.config.get("main", "clannotify", "yes") == "yes":
				p.plugins.find("ui").addchat("green", "[CLAN] Update: ", "yellow", m.name, "green", " is now a " + IDs[m.rank] + " and is " + m.status() + ".")
		if (ID == 0x81):
			''' SID_CLANMEMBERRANKCHANGE '''
			old = b.getByte()
			new = b.getByte()
			user = b.getString()
			if new > old:
				action = "promoted"
			else:
				action = "demoted"
			p.plugins.find("ui").addchat("green", "[CLAN] ", "yellow", user, "green", " has " + action + " you to a " + IDs[new] + ".")
		
	def __cevent__(self, ID, Data, p):
		pass
