
""" channel.py

	Battle.net channel(s).
		
	"""
	
import buffer, language, support
	
class exposed():
	def __init__(self, parent):
		''' Contains the default channels after 0x0B is recieved. '''
		self.GChannels = [] # Internal list of channels.
		self.p = parent
		
		''' Internal '''
		self.IChannel = [] # Internal channel list.
		self.IPopulation = (0, 0) # This seems useless, but may be very helpful for PvPGN bots.
		
                self.evt_idx = -1 #Index of user in IChannel at end of chat event parsing
                self.evt_start_idx = -1 #Index of user in IChannel at start of chat event parsing
                self.evt_user = None #Pointer to user instance relevant to latest chat event

	def __attr__(self):
		return {
			'name' : 'channel',
			'author' : "vi[r]us",
			'version' : (1, 0),
			'description' : 'Handles Battle.net channels.',
			'notes' : 'This class should generally not be edited.',
			'help' : '',
			'chatexplicit' : False,
			'flags' : "s"
			}
			
	def __invoke__(self, ID, Length, Data, p):
		tr = language.english()
		b = buffer.pin()
		b.unbuild(Data)
		
		if (ID == 0x0B):
			''' SID_CHANNELLIST '''
			support.doprint( "Recieving list..." )
			self.GChannels = []
			last = " "
			while (len(last) > 0):
				last = b.getString()
				if not last == "": self.GChannels.append( last )
		
	def countops(self):
		c = 1
		for user in self.IChannel:
			if user.hasFlag(0x02):
				c += 1
		return c
		
	def mypos(self):
		i = 0
		for user in self.IChannel:
			i += 1
			if user.name == self.p.plugins.find("bncs").unique:
				return i
		return 0
		
	def find(self, expression, fail=False):
		assume = None
		s = 100
		for u in self.IChannel:
			print u.name.lower(), expression.lower()
			if u.name.lower() == expression.lower():
				return u
			elif (u.name.lower().find(expression.lower()) != -1):
				if (len(u.name) < s):
					assume = u
					s = len(u.name)
		if (not fail):
			return assume
		else:
			return expression

	def update_user(self, flags, statstring):
                self.evt_user.prevflags = self.evt_user.flags
                self.evt_user.flags = flags
                self.evt_user.statstring = statstring
                self.evt_user.__parse__()

                if (self.evt_user.prevflags & 0x02) == 0x00 and (flags & 0x02) == 0x02:
                        #User has gained operator status.
                        del self.IChannel[self.evt_idx]
                        self.IChannel.insert(0, self.evt_user)
                        self.evt_idx = 0
                        
		
	def __cevent__(self, ID, Data, p):
                self.evt_idx = -1 #Index of user in IChannel at end of this method
                self.evt_start_idx = -1 #Index of user in IChannel at start of this  method
                self.evt_user = None #Pointer to user instance
                
                if ID in (0x01, 0x02, 0x03, 0x05, 0x09):
                        f_realm = Data['username'].find('*')
                        if f_realm != -1:
                                Data['username'] = Data['username'][f_realm+1:]
                        for idx in range(len(self.IChannel)): #Try to find user in channel list
                                if self.IChannel[idx].name == Data['username']:
                                        self.evt_idx = idx
                                        self.evt_start_idx = idx
                                        self.evt_user = self.IChannel[idx]
                                        break
                                
                        if (ID == 0x01) or (ID == 0x02): #CE_USERINCHANNEL or CE_USERJOINS
                                if self.evt_user != None: #Basically a statstring/flags update
                                        self.update_user(Data['flags'], Data['text'])
                                        return None

                                self.evt_user = support.channelObject(Data['username'], Data['flags'], Data['ping'], Data['text']) #Create new user instance
                                if (Data['flags'] & 0x02) == 0x00: #Normal user, append to end of channel list
                                        self.evt_idx = len(self.IChannel)
                                        self.IChannel.append(self.evt_user)
                                else: #User has ops, insert at top of list
                                        self.evt_idx = 0
                                        self.IChannel.insert(0, self.evt_user)
                                        
                        elif self.evt_user == None: #Can't find user, nothing else we can do
                                return None
                        elif (ID == 0x03): #CE_USERLEAVES
                                del self.IChannel[self.evt_idx]
                                self.evt_idx = -1
                        elif (ID == 0x09): #CE_USERUPDATE / CE_FLAGSUPDATE
                                self.update_user(Data['flags'], Data['text'])
			
		elif (ID == 0x12):
			if self.IPopulation == ():
				''' Server populus '''
				if support.match(Data['text'], "There are currently*users playing*"):
					part = Data['text'].split(", and ")[1].split(" games on Battle.net")[0].split(" ")
					self.IPopulation = (int(part[0]), int(part[3]))
		elif (ID == 0x07):
			''' CE_CHANNELJOIN '''
			self.IChannel = []
