import threading, time, random, support, sys
 
class queue(threading.Thread):
	def __init__(self, BNCS, type="normal"):
		threading.Thread.__init__(self)
		self.queue = []
		self.banqueue = []
		self.parent = BNCS
		self.lastaddq = ''
 
 		self.config = support.config(BNCS.cfgfile)
		self.config.set("queue", "doublebandodge", "yes", False)
 
		if self.config.get("queue", "doublebandodge") == "yes":
			self.db = True
		else: self.db = False
		
		self.bytes = 0.0
		self.byteloss = 0.8
		self.speed = 0.025
		self.type = type
		self.stackinggrace = 0.05
		self.lastdepth = 0
		
		self.burst = True
 
		self.setDaemon(True)
		self.start()
 
	def bandelay(self, style="stealthbot"):
		ops = self.parent.plugins.find("channel").countops()
		mypos = self.parent.plugins.find("channel").mypos()
		delay = 0.5
		if style == "stealthbot":
			# The numbers used are adapted from StealthBot to make them sync better
			delay = (((random.random() + ops) * (1 + random.random() * 200)) + 100) / 1000
			if delay > 1.25:
				delay -= (random.random() / 2.5)
		else:
			# my take on a ban delay
			if ops == 0: ops = 2
			delay = (ops * 0.05) + (mypos * 0.08)
		return delay
 
	def priorityban(self, username):
		for item in self.queue:
			if (len(item) > 1):
				if (item[0] == "/"):
					data = item.split(" ")
					if data[0] in ["kick", "ban", "squelch"]:
						item2 = item
						self.queue.remove(item)
						self.queue.append(item2)
						print "*   Moved",item2,"to back of queue."
 
	def depth(self):
		return self.bytes / self.dps()
		
	def dps(self):
		return (1 / self.speed) * self.byteloss
 
	def allslash(self):
		allslash = True
		for item in self.queue:
			if (len(item) > 1):
				if (not item[0] == "/"):
					allslash = False
		return allslash
 
	def run(self):
			d = 0
			while True:
				try:
					if self.type == "normal":
						if self.qsize() > 0:
							## Double Bans
							try:
								if (self.queue[0][:1] == "/") and self.db and (self.bytes < 125): time.sleep( self.bandelay() )
							except IndexError: pass
							## Process queue item
							''' This will actually process the messages '''
							text = self.queue.pop(0)
							if (text is None): text = ''
							if len(text) > 0:
								if text != '':
									# Notes about the numbers:
									#  the divisor (self.bytes/x) will create higher delays faster the lower it is
									#   bench: 800/150 = 4; 800/180 = 5
									#  the bytes (self.bytes) should be generated in an amount respective to removal
									#   bench:  depth of field + compensation + standard > bytes added
									self.parent.em_SendText(text)
									bstart = self.bytes
									self.bytes += (len(text) * 2) + 40
									
									# first eval
									if len(text) <= 15:
										self.bytes += (len(text) * 2) + 15
									## 180 = old
									wait = (self.bytes/165) + 0.05
									
									# eval additional because of no medium
									if len(text) > 150:
										wait += 0.25
										self.bytes += 50
										
									# determine an unreasonable length
									if wait < 0.5:
										wait = 0.1 + (random.random() / 2)
										self.bytes += 25
									else:
										if wait > 5:
											s = self.qsize()
											self.bytes -= (400 + random.randint(0, 200))
											
											if s > 5: self.bytes -= (25 + random.randint(25, 75))
										print self.bytes
									support.doprint("# Queue bytes: " + str(self.bytes - bstart) + " | " + str(self.bytes))
									# limit
									if self.bytes > 1500: self.bytes = 1500

									if (wait > 0):
										support.doprint("# Queue: " + str(wait))
										time.sleep( wait )
							## ...
						self.bytes -= self.byteloss
						if self.bytes < 0: self.bytes = 0
						time.sleep(self.speed)
					elif self.type == "burn":
						if self.qsize() > 0:
							count = 0
							while count < 5 and self.qsize() > 0:
								try:
									text = self.queue.pop(0)
									self.parent.em_SendText(text)
									count += 1
								except:
									pass
								time.sleep(self.speed)
							time.sleep( (count * 4) )
						else:
							time.sleep(0.25)
					else: #queue disabled
						time.sleep(self.speed)
				except IOError:
					time.sleep(0.04)
				except:
					support.doprint( "==> Queue error:" )
					for e in sys.exc_info():
						support.doprint( "   * " + str(e) )
					time.sleep(1)

 
	def tryremban(self, text):
		t = text.lower()
		try:
			if t.find(" was banned by ") != -1:
				u = support.familiar(t.split(" ")[0]).lower()
				for m in self.queue:
					if support.familiar(m[:5+len(u)].lower()) == ("/ban " + str(u)).lower():
						self.queue.remove(m)
			if t.find(" was kicked out of the channel ") != -1:
				u = support.familiar(t.split(" ")[0])
				for m in self.queue:
					if support.familiar(m[:6+len(u)].lower()) == ("/kick " + str(u)).lower():
						self.queue.remove(m)
			if t.find(" was unbanned by ") != -1:
				u = support.familiar(t.split(" ")[0])
				for m in self.queue:
					if support.familiar(m[:7+len(u)].lower()) == ("/unban " + str(u)).lower():
						self.queue.remove(m)
		except: # Queue empty ;/
			pass
 
	def instant(self, text):
		self.addq(text)
 
	def addq(self, text, priority=-1, stop=False):
		if text is None: return False
		if len(text) == 0: return False
		#if text == self.lastaddq: return False
		self.lastaddq = text
		
		# split messages up that are pasted
		splitters = ["\r", "\n"]
		for s in splitters:
			if (text.find(s) != -1):
				items = text.split(s)
				for item in items:
					i = item
					for ss in splitters: i = i.replace(ss, "")
					if not ss == "":
						self.addq(i, priority, True)
				print "Multiple messages."
				return False
		
		# check to see if a ban or kick is in the queue already
		cmd = support.slashCommand(text)
		if cmd.valid:
			print cmd.name,cmd.parameters
			if cmd.name in ["ban", "kick"]:
				for item in self.queue:
					icmd = support.slashCommand(item)
					if icmd.valid:
						if icmd.name == cmd.name:
							if icmd.parameters[0] == cmd.parameters[0]:
								print "Already in queue..."
								return False
		
		# get the dsp id
		if support.match(text, "/(me|emote) *"):
			dspID = "/me "
		elif support.match(text, "/(w|whisper) ..* *", user=False):
			dspID = "/w " + text.split(" ")[1] + " "
		elif support.match(text, "/(f|friends) (m|message|msg) *"):
			dspID = "/f m "
		else:
			dspID = ""
		letters_allowed = (223 - len(dspID))
		
		# make sure we habz ops kk
		for item in ["ban", "kick", "unban", "designate"]:
			if (text[:1+len(item)] == ("/" + item)):
				if not (self.parent.plugins.find("bncs").me.flags & 0x02) == 0x02:
					support.doprint("Can't execute %s command, the bot is not an operator." % item)
					return False


				
		# split messages up that are too big
		if len(text) > letters_allowed:
			palabras = text.split(" ")
			part = ''
			for palabra in palabras:
				if (len(palabra) > letters_allowed):
					if (len(part) > 0):
						self.ins(part, priority)
						part = dspID
						print "Prepare to send large block: " + part

					p = palabra
					while len(p) > letters_allowed:
						a = p[:letters_allowed]
						p = p[letters_allowed:]
						self.ins(a, priority)
						print "Send block part: " + a
					self.ins(p, priority)
					print "Send rest: " + p
				else:
					if (not len(part + palabra + " ") > letters_allowed):
						part += palabra + " "
					else:
						self.ins(part.rstrip(), priority)
						print "Send part of AddQ: " + part.rstrip()
						part = dspID
			if (part != ''):
				self.ins(dspID + part.rstrip(), priority)
				print "Send leftover: " + part.rstrip()
			return
		
		'''try:
			if (not stop):
				if self.parent.family.oldest(self.parent):
					if self.parent.family.brothers() > 0:
						isban = False
						if (text[:4] == "/ban"): isban = True
						# ...
						bro = self.parent.family.brother(self.parent, isban)
						time.sleep(0.05)
						if bro.cfgfile == self.parent.cfgfile:
							print "Queue item came back to us."
							self.ins(text, priority)
							return True
						else:
							print "Forwarded queue item to %s:" % bro.cfgfile
							bro.queue.ins(text, priority)
							return True
		except: pass'''
		
		self.ins(text, priority)
		return True
		
	def ins(self, text, p=-1):
		if text == "": return None
		if p == -1:
			self.queue.append(text)
		else:
			self.queue.insert(p, text)
 
	def padq(self, amount=1):
		self.bytes += 124
		for number in range(amount):
			self.queue.insert(0, '')
		
 
	def qsize(self):
		return len(self.queue)