import struct
import socket

class Socks5Proxy(socket.socket):
	''' Mimic a normal socket '''
	def __init__(self, host, port):
		self.host = host
		self.port = port
		socket.socket.__init__( self, socket.AF_INET, socket.SOCK_STREAM )
		self.settimeout(5.0)
		
	def proxy_connect(self, tserver, userName = None, password = None):
		thost, tport = tserver
		print "Connecting to proxy %s:%s" % (self.host, self.port)
		self.connect( (self.host, self.port) )
		print "Connected!"
		self.settimeout(1000.0)
		buf = chr(0x05)
		if userName is not None:
			buf += chr(0x02) + chr(0x00) + chr(0x02)
		else:
			buf += chr(0x01) + chr(0x00)

		self.sendall(buf)

		buf = self.recv(2)
		if ord(buf[0]) != 0x05 or ord(buf[1]) == 0xff:
			return "SOCKS5 Error: Proxy gave a bad response to connection information"

		if userName is not None:
			buf = '\x01' + struct.pack('!B', len(userName)) + userName
			buf += struct.pack('!B', len(password)) + password

			self.sendall(buf)

			buf = self.recv(2)
			if len(buf) != 2 or ord(buf[0]) != 0x01 or ord(buf[1]) != 0x00:
				return "SOCKS5 Error: Proxy gave a bad answer to username"

		buf = '\x05\x01\x00\x03'
		buf += struct.pack('!B', len(thost)) + thost
		buf += struct.pack('!H', tport)
		self.send(buf)

		buf = self.recv(100)
		if ord(buf[0]) != 0x05 or ord(buf[1]) != 0x00: return "SOCKS5 Error: Proxy gave a bad response to host information"
		print "Proxy setup successfully."
		return True
