
""" userlist.py

	General userlist functions and commands.
		
	"""
	
import support, default, sys
	
class exposed():
	def __init__(self, parent):
		self.p = parent
		self.udb = support.userlist()
		self.cfg = support.config("pybot.ini")
		
	def __attr__(self):
		return {
			'name' : 'ulst',
			'author' : "vi[r]us",
			'version' : (1, 1),
			'description' : 'Processes userlist commands.',
			'notes' : '',
			'help' : '',
			'chatexplicit' : True,
			'flags' : "sc"
			}
		
	def __command__(self, COMMAND, o, source='~local', origin=4):
		p = self.p
		user, access, flags, space, CMD = support.commandValidate(COMMAND, o, source, p.plugins.find("channel").IChannel, self.udb)
		par = o.parameters
		
		p.veto = True
		if (CMD == "whois"):
			try:
				user = p.plugins.find("channel").find(par[0])
				if user == None:
					name = par[0]
					user = par[0]
				else:
					name = user.name
					
				a = self.udb.getAccess(user)
				f = self.udb.getFlags(user)
				i = self.udb.getInfo(user)
				g = self.udb.getGroups(user, True)
				if g != "": g = " [" + g + "]"
				if a == -1:
					return name + " has an ignored entry (flags \"i\"), and cannot have an access level."
				if "f" in f:
					return name + " has fixed access (flags \"f\"), and it can only be modified by a user with flags \"a\"."
				if a > 0 or f != "":
					s = name + g + " has access " + str(a) + " and flags \"" + str(f) + "\"."
					if len(i) > 0:
						s += " (" + i + ".)"
					return s
				else:
					return "Your query returned no results."
			except IndexError:
				return "You must supply a username as the first parameter."
		elif (CMD == "whoami"):
			f = flags
			i = self.udb.getInfo(user)
			g = self.udb.getGroups(user)
			if access >= 202:
				return "Error: You have more than 200 access"
			elif source == "~console":
				return "You are the console. You have unlimited access to everything."
			elif access > 0:
				s = "You, %s [%s], have access %i and flags \"%s\"." % (source, g, access, f)
				if len(i) > 0:
					s += " Notes: " + i
				return s
			elif (access == -1) or ("i" in f):
				return "Your user entry is nulled by flags \"i\"."
			else:
				return "You have no access or flags, or we did a bad job maintaining the channel list."
		elif (CMD == "set"):
			newacc = 0
			newgrp = "!"
			newfla = "!"
			flag_read_pos = 2
			tname = ''
			
			try:
				tname = par[0]
				newacc = int(par[1])
			except IndexError:
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 2)
			except ValueError:
				newacc = self.udb.getAccess(par[0])
				if (newacc < 0):
					newacc = 0
				flag_read_pos = 1
			finally:
				tacc = self.udb.getAccess(par[0])
				tfla = self.udb.getFlags(par[0])
				
			if (par[0].lower() == "group|none"):
				return "You cannot modify the 'none' group."
				
			try:
				newfla = par[flag_read_pos]
				if len(newfla) > 1:
					if newfla[:1] == "#":
						newgrp = newfla[1:]
						newfla = "!"
					else:
						newgrp = "!"
			except IndexError:
				newfla = "!"
				
			try:
				newgrp = par[flag_read_pos+1]
				if len(newgrp) > 1:
					if newgrp[:1] == "#":
						newgrp = newgrp[1:]
					else:
						newgrp = "!"
			except IndexError:
				pass
				
			if (newacc >= access) or (tacc >= access) or (newacc > 200) or (newacc < 0):
				return "You cannot assign that level of numeric access."

			if (not source == "~console"):
				if ("f" in tfla) and (not "a" in flags):
					return "This user's access is locked, you must be an admin (flags \"a\") to change it."
				if ("a" in newfla):
					return "You cannot assign flags \"a\". Do that from the console."
				if ("a" in self.udb.getFlags("group|" + newgrp)):
					return "You cannot assign that group because it contains flags \"a\"."
				if (self.udb.getAccess("group|" + newgrp) >= access):
					return "You cannot assign that group because it has a higher access level than you."
				
			msg = "Set %s to access %i" % (par[0], newacc)
			self.udb.setAccess(par[0], newacc)
				
			if (newfla != "!"):
				self.udb.setFlags(par[0], newfla.lower())
				msg += " and flags \"%s\"" % self.udb.getFlags(par[0])
			if (newgrp != "!"):
				self.udb.setGroupMask(par[0], newgrp)
				msg += ", gave user mask 'group|%s'" % newgrp
			return msg + "."
		elif (CMD == "note"):
			try:
				target = par[0]
				if (par[0].lower() == "group|none"):
					return "You cannot modify the 'none' group."
			except IndexError:
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 1)
			if len(par) > 0:
				newnote = ' '.join(par[1:])
			else:
				newnote = ""
				
			user = None
			for u in p.plugins.find("channel").IChannel:
				if u.name.lower() == par[0].lower():
					user = u
			if user == None: user = par[0]
			a = self.udb.getAccess(user)
			i = self.udb.getInfo(user)
			g = self.udb.getGroups(user)
			if (newnote != ""):
				if (access <= a):
					return "You cannot change that user's information, they have more access."
				else:
					self.udb.setInfo(target, newnote)
					return "Set %s's notes to: %s" % (target, newnote)
			else:
				return "Notes for %s [%s]: %s" % (target, g, i)
		elif (CMD == "rem"):
			try:
				tacc = self.udb.getAccess(par[0])
				tfla = self.udb.getFlags(par[0])
				if (par[0].lower() == "group|none"):
					return "You cannot delete the 'none' group."
			except IndexError:
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 1)
			if (tacc >= access):
				return "You do not have enough access to do that."
			else:
				if ("f" in tfla) and (not "a" in flags):
					return "This user's access is locked, you must be an admin (flags \"a\") to remove them."
				self.udb.setAccess(par[0], 0)
				self.udb.setFlags(par[0], '')
				self.udb.setGroupMask(par[0], "none")
				self.udb.setInfo(par[0], '')
				return "Removed " + par[0] + " from the local database. This user will still get access from clan and friend masks."
		else:
			p.veto = False
			return ''
		p.veto = True
		return ''

	def __cevent__(self, ID, Data, p):
		if (ID == 0x101): support.commandProcess(Data, p, self.__command__)
