""" pynet.py
	
"""

import support, buffer, random, time, threading, socket, hashlib, sys

def realmnamefromid(id):
	if not id in range(0,6): return "Unknown"
	realms = {
			0 : "Offline",
			1 : "USEast",
			2 : "USWest",
			3 : "Europe",
			4 : "Asia",
			5 : "Other",
			}
	return realms[id]

class pn_user():
	def __init__(self, username, flags, string):
		self.ss = string
		self.username = username
		self.flags = flags
		self.parse()
		
	def parse(self):
		try:
			blocks = self.ss.split(chr(2))
			self.name = blocks[0]
			self.channel = blocks[1]
			self.realmid = int(blocks[2])
			self.realm = blocks[3]
			self.bnflags = int(blocks[4])
			self.game = blocks[5]
			self.admin = bool(blocks[6])
			self.ping = int(blocks[7])
		except:
			print "Could not parse: " + self.ss
			
	def info(self):
		build = self.username
		if self.realmid > 0:
			build += "@" + realmnamefromid(self.realmid) + " in channel %s (%s)." % (self.channel, self.bnflags)
		else:
			build += " (Offline)"
		return build

class exposed(threading.Thread):
	def __init__(self, parent):
		self.p = parent
		#if not self.p.family.oldest(self.p):
		#	return None
			
		self.colors = {
			"statstrings" : "gray",
			"usernames" : "white",
			"message" : "green",
			"info" : "#0099CC",
			"note" : "yellow",
			"error" : "red"
			}
			
		self.buffer = buffer.pout(0xDD)
		self.socket = socket.socket ( socket.AF_INET, socket.SOCK_STREAM )
		self.data = ''
		self.info = self.buildinfo()
		
		self.p.config.set("pynet", "enabled", "yes", False)
		if self.p.config.get("pynet", "enabled", "yes") == "no":
			print "PyNet disabled."
			return None
		self.p.config.set("pynet", "server", "pynet.no-ip.org", False)
		self.p.config.set("pynet", "username", self.p.config.get("main", "username"), False)
		self.p.config.set("pynet", "password", random.randint(10000, 100000), False)
		
		self.username = self.p.config.get("pynet", "username")
		self.tabname = "PyNet: %s" % self.username
		
		# ...
		
		self.channel_name = 'lobby'
		self.channel = []
		
		# ...
		
		self.execute = True
		self.connected = False
		self.thread = False
		
		threading.Thread.__init__(self)
		self.setDaemon(True)
		self.keepalive = support.timer(self.keepalive, delay=180)
		self.autoupdate = support.timer(self.update, delay=2.5)
		
      
   	# sorry
		self.passfail = False
      
		self.addchat("#0099CC", "This tab is for PyNet activity. PyNet is a server designed to keep bots working together.")
		self.addchat("#0099CC", "If you wish to disable it, you can set the config key to 'no'.")
		self.addchat("#0099CC", "Check out http://pynet.no-ip.org/ for more information.")
		self.connect()
      
	def addchat(self, *args): 
		self.p.addchat(*args, which=self.tabname)
		
	def pyop(self, type, param):
		if (type in ["kick", "ban"]):
			if self.connected:
				print type,param
				self.sendevent(0x06, "/%s %s" % (type, param))
				return ""
		return "/%s %s" % (type, param)
		
	def send(self, data):
		try:
			self.socket.sendall(data)
		except: pass
		
	def update(self):
		b = self.buildinfo()
		if b != self.info:
			self.info = b
			self.send(b)
			
	def reportversion(self):
		self.buffer.insertString('.'.join(map(str, self.__attr__()['version'])))
		self.buffer.insertString(support.getbotversion())
		self.buffer.insertString("PyNet Client for PyBot")
		self.socket.sendall(self.buffer.build(0x05))
		
	def doping(self, cookie):
		self.buffer.insertDWord(cookie)
		self.socket.sendall(self.buffer.build(0x06))
		
	def sha1(self, string):
		sha1 = hashlib.sha1()
		sha1.update(string)
		return sha1.digest()
		
	def keepalive(self):
		try:
			self.send("\xdd\x00\x04\x00")
		except:
			self.p.addchat("red", str(sys.exc_info()))
			self.properdisconnect()
		
	def realmid(self, realm):
		if self.p.plugins.find("bncs").online == False:
			return 0
		block = realm.split(".")[0].lower() + "." + realm.split(".")[1].lower()
		if block == "useast.battle" or block == "63.240":
			return 1
		elif block == "uswest.battle" or block == "63.241":
			return 2
		elif block == "asia.battle" or block == "213.248":
			return 4
		elif block == "europe.battle" or block == "211.233":
			return 3
		else:
			return 5
		
	def buildinfo(self):
		bncs = self.p.plugins.find("bncs")
		self.buffer.insertString(bncs.mychannel)
		self.buffer.insertDWord(bncs.me.flags)
		self.buffer.insertDWord(self.realmid(bncs.server))
		self.buffer.insertString(bncs.server)
		self.buffer.insertString(support.flipntrim(bncs.gameID))
		return self.buffer.build(0x02)
		
	def sendevent(self, id, data):
		self.buffer.insertDWord(id)
		self.buffer.insertString(data)
		self.send(self.buffer.build(0x04))
		
	def disconnect(self):
		try:
			if self.connected:
				self.properdisconnect()
			self.socket.close()
			self.connected = False
		except: pass
		
	def properdisconnect(self):
		if self.passfail:
			self.addchat("red", "[PYNT] Password incorrect, fix it and type /connnect. Will not attempt to reconnect.")
		else:
			self.addchat(self.colors['error'], "[PYNT] Disconnected... connecting again in 5 minutes.")
			support.execafter(301, self.connect)
		
	def connect(self):
		if self.connected:
			self.addchat("red", "[PYNT] Could not connect... already connected.")
		if self.passfail:
			self.addchat("red", "[PYNT] Password incorrect, fix it and type /connnect. Will not attempt to reconnect.")
         
		self.socket = socket.socket ( socket.AF_INET, socket.SOCK_STREAM )
		self.socket.settimeout(15.0)
		self.addchat("yellow", "[PYNT] Connecting to " + self.p.config.get("pynet", "server", "pynet.no-ip.org") + "...")
		try:
			self.socket.connect( (self.p.config.get("pynet", "server", "pynet.no-ip.org"), 1337) )
		except socket.error, socket.herror:
			self.addchat(self.colors['error'],  "[PYNT] Socket error, it is possible the server is down or you are having DNS resolution issues.")
			self.disconnect()
			return False
		except socket.timeout:
			self.addchat(self.colors['error'],  "[PYNT] Socket did not respond in the specified time period")
			self.disconnect()
			return False
		except:
			self.addchat(self.colors['error'],  "[PYNT] Socket failed for an unhandled reason")
			self.disconnect()
			return False
		self.socket.settimeout(1000.0)
		self.connected = True
		self.addchat(self.colors['message'],  "[PYNT] Connected!")
		self.send(chr(0x01))
		threading.Thread.__init__(self)
		if not self.thread: self.start()
		self.buffer.insertString(self.username)
		self.buffer.insertRawData(self.sha1(self.p.config.get("pynet", "password")))
		try:
			self.buffer.insertString(self.p.plugins.find("bncs").unique)
		except:
			self.buffer.insertString(self.p.config.get("main", "username"))
		self.send(self.buffer.build(0x01))
		self.addchat("yellow",  "[PYNT] Sending login...")
		
	def recieve(self, id, length, data):
		#self.addchat(self.colors['message'],  "PY <<",hex(id),length)
		b = buffer.pin(0xDD)
		b.unbuild(data)
		
		if (id == 0x01):
			result = b.getByte()
			if (result == 0x00):
				self.addchat(self.colors['message'],  "[PYNT] Logged in as %s." % self.username)
				self.reportversion()
				self.info = ''
			elif (result == 0x02):
				self.addchat("yellow",  "[PYNET] Account does not exist.")
				self.buffer.insertString(self.username)
				self.buffer.insertRawData(self.sha1(self.p.config.get("pynet", "password")))
				self.send(self.buffer.build(0x03))
			elif (result == 0x01):
				self.addchat(self.colors['error'],  "[PYNT] Invalid password.")
				self.passfail = True
			elif (result == 0x03):
				self.addchat(self.colors['error'],  "[PYNT] You are banned.")
			else:
				self.addchat(self.colors['error'],  "[PYNT] Unknown response to 0x01.")
		elif (id == 0x03):
			result = b.getByte()
			if (result == 0x00):
				self.addchat(self.colors['message'],  "[PYNT] Account created.")
				self.reportversion()
				self.info = ''
			elif (result == 0x01):
				self.addchat("yellow",  "[PYNT] Account already exists")
				self.buffer.insertString(self.username)
				self.buffer.insertRawData(self.sha1(self.p.config.get("pynet", "password")))
				self.send(self.buffer.build(0x03))
			elif (result == 0x02):
				self.addchat(self.colors['error'],  "[PYNT] Invalid characters contained in username.")
			elif (result == 0x03):
				self.addchat(self.colors['error'],  "[PYNT] Invalid username.")
			else:
				self.addchat(self.colors['error'],  "[PYNT] Unknown response to 0x03.")
		elif (id == 0x04):
			ID = b.getDWord()
			username = b.getString()
			flags = b.getDWord()
			mod = b.getDWord()
			data = b.getString()
		
			""" 0x01: Joined a channel
				0x02: For every user in the channel, you get this
				0x03: User join
				0x04: User leave
				0x05: User change
				0x06: User talk (includes you, won't spit it back for slash commands)
				0x07: User whisper (to you)
				0x08: Information
				0x09: Error
				0x0A: Broadcast from the server
				0x0B: Battle.net Echo (the server wants you to send text to Battle.net) """
		
			if (ID in [0x02, 0x03, 0x05]):
				u = pn_user(username, flags, data)
				ss = u.info()
		
			if (ID == 0x01):
				self.addchat(self.colors['note'],  " -- Joined: ", self.colors['usernames'], username, self.colors['message'], " (" + hex(flags) + ")")
				self.addchat(self.colors['info'], data)
				self.channel = []
				self.channel_name = data
			elif (ID == 0x02):
				#if self.channel_name != 'lobby':
					#self.addchat(self.colors['message'],  " -- ", self.colors['usernames'], username, self.colors['message'], " (", self.colors['statstrings'], ss, self.colors['message'], ") is in the channel.")
				self.channel.append( u )
			elif (ID == 0x03):
				self.addchat(self.colors['note'],  " -- ", self.colors['usernames'], username, self.colors['message'], " (", self.colors['statstrings'], ss, self.colors['message'], ") has joined the channel.")
				self.channel.append( u )
			elif (ID == 0x04):
				self.addchat(self.colors['note'],  " -- ", self.colors['usernames'], username, self.colors['message'], " has left the channel.")
				for user in self.channel:
					if user.username == username: self.channel.remove(user)
			elif (ID == 0x05):
				self.addchat(self.colors['note'],  " -- ", self.colors['usernames'], username, self.colors['message'], " updated (", self.colors['statstrings'], ss, self.colors['message'], ").")
				for user in self.channel:
					if user.username == username: user = u
			elif (ID == 0x06):
				self.addchat(self.colors['info'],  "<", self.colors['usernames'], username, self.colors['info'], "> ", self.colors['usernames'], data)
			elif (ID == 0x07):
				if mod == 0x00:
					self.addchat(self.colors['info'],  "<from ", self.colors['usernames'], username, self.colors['info'], "> ", self.colors['usernames'], data)
				elif mod == 0x01:
					self.addchat(self.colors['info'],  "<to ", self.colors['usernames'], username, self.colors['info'], "> ", self.colors['usernames'], data)
			elif (ID == 0x08):
				self.addchat(self.colors['info'], data)
			elif (ID == 0x09):
				self.addchat(self.colors['error'], data)
			elif (ID == 0x0A):
				self.addchat(self.colors['usernames'], username + " says: ", "blue", data)
			elif (ID == 0x0B):
				self.addchat(self.colors['statstrings'], data)
				self.p.queue.addq(data)
			elif (ID == 0x0C):
				self.addchat(self.colors['error'], "[PYNT] Disconnected: %s" % data)
		elif (id == 0x05):
			pass
		elif (id == 0x06):
			self.doping(b.getDWord())
		else:
			pass
			
	def run(self):
		self.thread = True
		self.addchat(self.colors['info'],  "[PYNT] Thread started...")
		while self.execute:
			while self.connected:
				try:
					data = self.socket.recv(2048)
					if data == "" or not self.connected:
						print "Interupted"
						self.disconnect()
						break
					self.data += data
				except:
					print "pynet Stream stopped."
					print sys.exc_info()
					self.disconnect()
					break

				if not self.data:
					print "No data"
					self.disconnect()
					break
				elif len(self.data) > 0:
					b = buffer.pin(0xDD)
					id = int(b.unbuild(self.data))
					if len(self.data) == int(b.length):
						self.recieve(id, b.length, self.data)
						self.data = ''
					elif len(self.data) >= int(b.length): #under
						while len(self.data) >= int(b.length):
							self.recieve(id, b.length, self.data[:b.length])
							self.data = self.data[b.length:]
							id = int(b.unbuild(self.data))
			time.sleep(0.05)
		
	def __attr__(self):
		return {
			'name' : 'pynet',
			'author' : "vi[r]us",
			'version' : (1, 0),
			'description' : '',
			'notes' : '',
			'help' : '',
			'chatexplicit' : False,
			'onlymain' : False,
			'flags' : 's'
			}
			
	def __invoke__(self, ID, Length, Data, p):
		b = buffer.pin()
		b.unbuild(Data)
		
	def __cevent__(self, ID, Data, p):
		if (ID == 0x103):
			tab = Data[0]
			text = Data[1]
			if tab == self.tabname:
				if text == "/connect":
					self.passfail = False
					self.connect()
				else:
					self.sendevent(6, text)
		elif (ID == 0x105):
			self.execute = False
			self.disconnect()
		"""
		if (ID == 0x00):
			''' CE_UNKNOWN '''
		elif (ID == 0x01):
			''' CE_USERINCHANNEL '''
		elif (ID == 0x02):
			''' CE_USERJOIN '''
		elif (ID == 0x03):
			''' CE_USERLEAVES '''
		elif (ID == 0x04):
			''' CE_WHISPERFROM '''
		elif (ID == 0x05):
			''' CE_USERTALK '''
		elif (ID == 0x06):
			''' CE_BROADCAST '''
		elif (ID == 0x07):
			''' CE_CHANNELJOIN '''
		elif (ID == 0x09):
			''' CE_USERUPDATE / CE_FLAGSUPDATE '''
		elif (ID == 0x0A):
			''' CE_WHISPERTO '''
		elif (ID == 0x0D or ID == 0x0F or ID == 0x0E or ID == 0x13):
			''' CE_ERROR '''
		elif (ID == 0x12):
			''' CE_INFO '''
		elif (ID == 0x17):
			''' CE_USEREMOTE '''
		# Custom
		elif (ID == 0x100):
			## AddChat Echo from BNCS.
		elif (ID == 0x101):
			## Someone has issued a command instructing your bot. It is parsed but access was not checked.
			## index:
			## 0: Username
			## 1: User's flags in channel
			## 2: Parsed commandObject (view reference in support.py)
		elif (ID == 0x102):
			## The socket has failed or has been disconnected.
		elif (ID == 0x103):
			## Text was sent from the bot's user interface.
		elif (ID == 0x104):
			## The bot is starting to connect, it has already sent the protocol ID.
		"""
