
""" op.py

	Operator commands.
		
	"""

import support, default, sys, random, time
	
class exposed():
	def __init__(self, parent):
		self.p = parent
		self.udb = support.userlist()
		
		self.config = support.config(parent.cfgfile)
		self.config.set("op", "detect", "yes", False)
		self.autodetect = self.config.get("op", "detect")
		
		self.config.set("op", "mod_ipban", "no", False)
		self.config.set("op", "mod_clientbans", "", False)
		self.config.set("op", "mod_kickonyell", "no", False)
		
		default.create("safeadd", 70, [], "appends flags 's' to a userlist entry", "<trigger>%s <username>")
		default.create("shitadd", 70, [], "appends flags 'b' to a userlist entry", "<trigger>%s <username>")
		
		''' Load detection '''
		## persecond
		self.jps = 0
		self.jpst = support.now()
		## non-unique
		self.nuname = ''
		self.nutime = support.now()
		
		''' Record keeping '''
		self.bansc = 0
		self.reg = support.lit()
		self.match = ''
		self.bantime = support.now()
		self.ci = []
		self.bans = {}
			# banned, by operator
		
								# (total, amt)
		self.load_average_ping = (0, 0)
		
		''' Loadban '''
		self.loadban = False
		self.loadban_aggro = 0
		self.loadban_tol = 5
		self.loadban_calm = 18
		self.loadban_adr = 5
		self.loadban_bro = {}
		
		''' Channelban '''
		self.cbstream = False
		self.cbs = False
		self.cbtarg = ''
		self.cblist = []
		self.cbshuffle = True
		self.cbpy = False
		self.cbsquelch = False
		
		''' Matchban '''
		self.matchban = False
		
		''' PyNet MB '''
		self.pymatchban = True
		
		''' Timers '''
		self.timebans = {}
		self.tbtimer = support.timer(self.checktimebans, 10)
		
	def __attr__(self):
		return {
			'name' : 'op',
			'author' : "vi[r]us",
			'version' : (1, 0),
			'description' : 'Does simple op commands.',
			'notes' : '',
			'help' : '',
			'chatexplicit' : True,
			'flags' : "sc"
			}
		
	def checktimebans(self):
		if len(self.timebans) == 0: return
		n = support.now()
		tbub = []
		for item in self.timebans:
			started, dur = self.timebans[item]
			timesince = (n - started).seconds
			if timesince >= dur:
				self.p.queue.instant( "/unban %s" % item)
				tbub.append(item)
		for item in tbub:
			del self.timebans[item]
		
	def createCI(self):
		self.ci = []
		for user in self.p.plugins.find("channel").IChannel:
			self.ci.append(user.name)
		
	def findce(self, usernames):
		''' Tries to find common expressions in load names. '''
		pass
		
	def execloadban(self, u, msg="Loadban", q='instant'):
		''' msg = Message to ban with
			q = queue type, you can use:
				instant (instantly send)
				q (send with queue)
				overloaded (send using brother client)
				pn (PyNet)
			
			By sending the user object, we can do some neat
			'intelligent' tricks like modify the ban to match
			pings.
			'''
			
		if q == 'instant':
			self.p.queue.instant("/ban " + u.name + " " + msg + ") (" + str(self.bansc))
		elif q == 'overloaded':
			self.p.em_SendText("/ban " + u.name + " " + msg + ") (" + str(self.bansc))
		elif q == 'q' or q == 'hp':
			## Bans using the queue.
			self.p.queue.addq("/ban " + u.name + " " + msg + ") (" + str(self.bansc), 0)
		elif q == 'pn':
			self.p.plugins.find("pynet").sendevent(0x06, "/ban " + u.name + " " + msg + ") (" + str(self.bansc))
			
		self.bansc += 1
		self.bantime = support.now()
		self.loadban_aggro += 1
		# Load avg ping
		#total, amt = self.load_average_ping; self.load_average_ping = ( (total + u.ping), (amt + 1) )
		#print (total / amt)
		
	def clearvar(self):
		self.bantime = support.now()
		self.loadban = False
		self.mtb = False
		self.matchban = False
		self.pymatchban = False
		self.match = ""
		self.loadban_bro = {}
		
	def userobjectIs(self, e, user):
		if (user.name in self.ci): return False
		return self.udb.accessWildcard(user, e)
		'''expression = e.lower()
		if (expression == "num"):
			if ("#" in user.name):
				return True
			else:
				return False
		elif (expression == "all"):
			return True
		elif (expression == "gen"):
			vowels = ["a", "e", "i", "o", "u"]
			## Detect randomly generated names.
			jumps = 0
			for c in user.name.lower():
				if not (self.reg.match(c, "[_-@#]")):
					if not (c in vowels):
						# Consonant
						jumps += 1
					else:
						jumps = 0
				else:
					jumps -= 1
					if jumps <= 0: jumps = 0
					
				if jumps >= 4: ## No base word in the english language has 4 consonants in a row
					print "ISGENERATED",user.name
					return True
			print "j",jumps
		elif ("lag|" in expression):
			if (user.ping >= int(expression[4:])):
				return True
			else:
				return False
		elif (expression == "lag"):
			total, amt = self.load_average_ping
			if amt > 0:
				average = (round(total / amt, 0) - 25)
				if average > 500: average = 500
			else:
				average = 200
			if amt < 10:
				if user.ping >= 200:
					return True
			else:
				if user.ping >= average:
					return True
		elif ("game|" in expression):
			games = expression[5:].split(",")
			for game in games:
				if (user.game.lower() == game.strip().lower()):
					return True
			return False
		elif ("peon" in expression):
			if (user.icon == "1R3W"): return True
		elif ("icon|" in expression):
			if (user.icon == expression[5:]): return True
		elif ("clan|" in expression):
			if (user.clan.lower() == expression[5:].lower()): return True
		else:
			if self.reg.match(user.name, expression):
				return True
			else:
				return False
		return False'''
			
		
	def __ban__(self, uObj):
		if self.match == "": return None
		u = uObj.name
		last = int((support.now() - self.bantime).seconds)
		
		if self.loadban:
			print "AGGRO: " + str(self.loadban_aggro)
			if self.userobjectIs(self.match, uObj):
				if not self.udb.safelisted(u):
					''' Calculate cooldown '''
					if (last >= self.loadban_adr) and (self.loadban_aggro <= 5):
						if (last >= (self.loadban_adr * 3)):
							self.loadban_aggro =- 3
							print "SUPPRESS HEAVY %i" % self.loadban_aggro
						elif (last >= (self.loadban_adr * 2)):
							self.loadban_aggro =- 2
							print "SUPPRESS MEDIUM %i" % self.loadban_aggro
						elif (last >= self.loadban_adr):
							self.loadban_aggro =- 1
							print "SUPPRESS LIGHT %i" % self.loadban_aggro
						if self.loadban_aggro <= 0: self.loadban_aggro = 0

					if (self.loadban_aggro <= self.loadban_tol):
						self.execloadban(uObj)
					else:
						if (last >= self.loadban_calm):
							self.loadban_aggro = 0
							self.execloadban(uObj)
							for user in self.p.plugins.find("channel").IChannel:
								self.__ban__(user)
							print "CALM"
						else:
							pass
							'''
							if len(self.loadban_bro) > 0:
								try:
									bestitem = ''
									for key in self.loadban_bro:
										bans, lastban, obj = self.loadban_bro[key]
										if bans < 5: bestitem = key
									bans, lastban, obj = self.loadban_bro[bestitem]
									bans += 1
									print obj.cfgfile,"has",bans,"bans.."
									self.loadban_bro[bestitem] = (bans, support.now(), obj)
									obj.em_SendText("/ban " + uObj.name + " Loadban) (~")
								except AttributeError:
									print "All full." '''
							
		elif self.matchban:
			if self.userobjectIs(self.match, uObj):
				if not self.udb.safelisted(u): self.execloadban(uObj, msg="Matchban", q='q')
		elif self.pymatchban:
			if self.userobjectIs(self.match, uObj):
				if not self.udb.safelisted(u): self.execloadban(uObj, msg="Matchban", q='pn')
		else:
			''' No ban mode '''
			return False
		return True
		# }
				
		
	def __command__(self, COMMAND, o, source='~local', origin=4):
		p = self.p
		user, access, flags, space, CMD = support.commandValidate(COMMAND, o, source, p.plugins.find("channel").IChannel, self.udb)
		par = o.parameters
		
		p.veto = True
		if (CMD == "loadban"):
			return "Loadban is depreciated, use matchban instead."
			p.queue.padq(3)
			try:
				if par[0] == "?":
					return "Loadban [%s] \"%s\" {%i temporarily safelisted}" % (str(self.loadban), self.match, len(self.ci))
				else:
					self.clearvar()
				self.match = par[0]
				self.loadban = True
				self.loadban_aggro = 2
				self.createCI()
				for bro in self.p.family.brotherenum(self.p):
					self.loadban_bro[bro.cfgfile] = (0, support.now(), bro)
				if len(self.loadban_bro) == 0:
					return "Loadban enabled [%s]." % self.match
				else:
					return "Loadban enabled, %i bots following. [%s]." % (len(self.loadban_bro), self.match)
			except:
				print sys.exc_info()
				self.ci = []
				self.loadban = False
				return "Loadban disabled."
		elif (CMD == "timeban"):
			try:
				user = par[0]
				delay = int(par[1])
				delaytype = par[2].lower()
			except IndexError:
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 3)
			if (delaytype == "m"):
				ndelay = delay * 60
			elif (delaytype == "h"):
				ndelay = delay * 3600
			else:
				ndelay = delay
			if user.lower() in self.timebans:
				s, d = self.timebans[user.lower()]
				return "That user was timebanned at %s for %s seconds (%s remain)." % (str(s), str(d), str((support.now()-s).seconds))
			
			for usere in p.plugins.find("channel").IChannel:
				if usere.name.lower() == user.lower():
					if self.udb.safelisted(usere):
						return "Error: that user is safelisted"
			if self.udb.safelisted(user):
				return "Error: that user is directly safelisted"
			
			self.timebans[user.lower()] = (support.now(), ndelay)
			p.queue.addq("/ban %s %s" % (user, "Timebanned : " + str(delay) + str(delaytype)))
			return "User %s timebanned for %i seconds (%s %s)." % (user, ndelay, str(delay), str(delaytype))
		if (CMD == "matchban"):
			p.queue.padq(3)
			try:
				if par[0] == "?":
					return "Match ban [%s] \"%s\" {%i temporarily safelisted}" % (str(self.matchban), self.match, len(self.ci))
				else:
					self.clearvar()
				self.match = par[0]
				self.matchban = True
				self.createCI()
				for o in p.plugins.find("channel").IChannel:
					self.__ban__(o)

				return "Match ban enabled [%s]." % self.match
			except:
				self.ci = []
				self.matchban = False
				return "Match ban disabled."
		elif (CMD == "pymatchban"):
			p.queue.padq(3)
			try:
				if par[0] == "?":
					return "PyNet-aided Match ban [%s] \"%s\" {%i temporarily safelisted}" % (str(self.matchban), self.match, len(self.ci))
				else:
					self.clearvar()
				self.match = par[0]
				self.pymatchban = True
				self.createCI()
				return "PyNet-aided Match ban enabled [%s]." % self.match
			except:
				self.ci = []
				self.pymatchban = False
				return "PyNet Match ban disabled."
		if (CMD == "yield"):
			if not self.match == "-":
				self.clearvar()
				self.match = "-"
				p.queue.queue = []
				return "Disabled automatic load detection and any currently active tagbans."
			else:
				self.clearvar()
				self.match = ""
				return "Enabled automatic load detection."
		if (CMD == "queuetype"):
			try:
				p.queue.type = par[0]
				return "Queue type set to %s." % p.queue.type
			except:
				return "Queue is currently set to %s." % p.queue.type
		if (CMD == "cb"):
			try:
				self.cbtarg = ' '.join(par[0:])
				self.cbs = True
				self.cblist = []
				self.cbpy = False
				self.cbsquelch = False
				p.queue.addq( "/who " + self.cbtarg )
				return ''
			except:
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 1)
		if (CMD == "cs"):
			try:
				self.cbtarg = ' '.join(par[0:])
				self.cbs = True
				self.cblist = []
				self.cbsquelch = True
				p.queue.addq( "/who " + self.cbtarg )
				return ''
			except:
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 1)
		if (CMD == "pycb"):
			try:
				self.cbtarg = ' '.join(par[0:])
				self.cbs = True
				self.cblist = []
				self.cbpy = True
				self.cbsquelch = False
				p.queue.addq( "/who " + self.cbtarg )
				return ''
			except:
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 1)
		if (CMD == "kick") or (CMD == "ban"):
			try:
				safe = 0
				expression = par[0]
				try:
					msg = ' '.join(par[1:])
				except:
					msg = expression
				bans = 0
				for usere in p.plugins.find("channel").IChannel:
					if self.userobjectIs(expression, usere):
						if not self.udb.safelisted(usere):
							p.queue.addq( "/%s %s %s" % (CMD.lower(), usere.name, msg) )
							bans += 1
						else:
							safe += 1
				if (safe > 0):
					return "Failed to use on %i user(s) because they are safelisted." % safe
				if not (bans > 0):
					p.queue.addq( "/%s %s %s" % (CMD.lower(), expression, msg) )
				else:
					self.p.addchat("green", "Counted %i users matching \"%s\"." % (bans, expression))
				return ''
			except:
				print sys.exc_info()
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 1)
		if (CMD == "shitadd"):
			try:
				tname = par[0]
			except IndexError:
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 2)
			tacc = self.udb.getAccess(par[0])
			tfla = self.udb.getFlags(par[0])
			if (tacc >= access):
				return "You do not have enough access to shitlist this user."
			if ("a" in tfla) and (not source == "~console"):
				return "That user can't be shitlisted."
			self.udb.setFlags(par[0], "-s")
			self.udb.setFlags(par[0], "+b")
			return "User %s has been given flags \"b\"." % par[0]
		if (CMD == "safeadd"):
			try:
				tname = par[0]
			except IndexError:
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 2)
			tacc = self.udb.getAccess(par[0])
			tfla = self.udb.getFlags(par[0])
			if (tacc >= access):
				return "You do not have enough access to safelist this user."
			if ("a" in tfla) or ("s" in tfla):
				return "That user is already safelisted."
			self.udb.setFlags(par[0], "-b")
			self.udb.setFlags(par[0], "+s")
			return "User %s has been given flags \"s\"." % par[0]
		if (CMD == "unban"):
			try:
				expression = par[0]
				unbans = 0
				for banned, op in self.bans.items():
					if self.reg.match(banned, expression):
						p.queue.addq( "/unban %s" % banned )
						unbans += 1
				if unbans == 0:
					p.queue.addq( "/unban %s" % expression )
				else:
					self.p.addchat("green", "Counted %i users matching \"%s\"." % (unbans, expression))
				return ''
			except IndexError:
				print sys.exc_info()
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 1)
		if (CMD == "bancount"):
			try:
				oper = par[0]
				bc = 0
				for banned, op in self.bans.items():
					if oper.lower() == op.lower():
						oper = op
						bc += 1
				return "Since I joined this channel, %s has banned %i users." % (oper, bc)
			except: pass
			return "Since I joined this channel, %i users have been banned." % len(self.bans)
		if (CMD == "sleep"):
			self.clearvar()
			return "All bans disabled."
		if (CMD == "family"):
			if p.family.brothers() > 0:
				info = "Bots in this family: "
				for bro in p.family.children:
					u = bro.plugins.find("bncs").me
					info += u.name + " (in " + str(bro.plugins.find("bncs").mychannel) + " (Queue: " + str(bro.queue.bytes) + "b) (Trigger \"" + bro.config.get("main", "trigger") + "\"); "
				return info[:len(info)-2]
			else:
				return "I am an only child."
		else:
			p.veto = False
			return ''
		
	def cb_timer(self):
		self.cbs = False
		self.cbstream = False
		c = 0
		if self.cbshuffle: random.shuffle(self.cblist)
		ign = "Banning"
		if self.cbsquelch: ign = "Ignoring"
		self.p.addchat("#0099CC", "%s %i users from %s." % (ign, len(self.cblist), self.cbtarg))
		if self.cbsquelch:
			for user in self.cblist:
				self.p.queue.addq("/ignore " + user)
		else:
			for user in self.cblist:
				c += 1
				if not self.cbpy:
					if (c == len(self.cblist)):
						self.p.queue.addq("/ban " + user + " *")
					else:
						self.p.queue.addq("/ban " + user)
				else:
					self.p.plugins.find("pynet").sendevent(0x06, "/ban " + user)
		self.cbtarg = ''
		
	def getclientbans(self):
		clientbans = self.config.get("op", "mod_clientbans").split("|")
		ret = []
		for ban in clientbans:
			if not len(ban) == 4:
				return []
			if support.orient(ban) == False:
				return []
			ret.append(ban.upper())
		return ret
		
	def automatchban(self, match):
		self.clearvar()
		self.match = match
		self.matchban = True
		self.createCI()
		for o in self.p.plugins.find("channel").IChannel:
			self.__ban__(o)
		self.p.queue.addq("Match ban automatically enabled by the bot [%s]." % self.match)
		
	def __cevent__(self, ID, Data, p):
		if (ID == 0x101):
			support.commandProcess(Data, p, self.__command__)
		elif (ID == 0x02):
			''' CE_USERJOIN '''
			## Check ban settings
			o = support.channelObject( Data['username'], Data['flags'], Data['ping'], Data['text'] )
			if (len(self.match) > 1) and (self.pymatchban or self.matchban or self.loadban):
				if self.__ban__(o):
					return None
				
			## Detect loads
			if (self.autodetect == "yes") and (self.match == '') and (p.plugins.find("bncs").me.hasFlag(0x02)) and ((support.now() - p.plugins.find("bncs").logintime).seconds > 20):
				## By amount of joins per second
				last = int((support.now() - self.jpst).seconds)
				self.jps += 1
				if (last > 1):
					self.jps = 0
				else:
					if (self.jps >= 15):
						p.addchat("red", "Warning: there is a high number (15/s) of users entering the channel; matchban enabled [lag|250]")
						self.automatchban("lag|250")
				self.jpst = support.now()
				
				## By high non-unique names
				if (o.number > 2):
					if (self.nuname == o.unique):
						last = int((support.now() - self.nutime).seconds)
						if (last < 30):
							## Same high-numbered player, its a bot.
							if (self.nuname.find("@") != -1):
								nm = self.nuname.replace("@", "*@")
							else:
								nm = self.nuname + "*"
							p.addchat("red", "Warning: the same user is joining the channel with high-numbered non-unique names; matchban enabled [%s]" % nm)
							self.automatchban(nm)
					self.nutime = support.now()
					self.nuname = o.unique
						
			
			## Shitlist
			if self.udb.shitlisted(o):
				self.p.queue.instant( "/ban %s %s" % (Data['username'], "Shitlisted") )
				return
				
			## Timeban
			if Data['username'] in self.timebans:
				started, dur = self.timebans[Data['username']]
				timesince = (support.now() - started).seconds
				if timesince < dur:
					self.p.queue.instant( "/ban %s %s" % (Data['username'], "Timebanned : " + dur + "s") )
				else:
					del self.timebans[Data['username']]
				return
				
			## IPBans
			if self.config.get("op", "mod_ipban", "no") == "yes":
				if (o.hasFlag(0x20)):
					self.p.queue.instant( "/ban %s %s" % (Data['username'], "Squelchban") )
					return
					
			## Clientbans
			if self.config.get("op", "mod_clientbans", "") != '':
				clientbans = self.getclientbans()
				if support.orient(o.game) in clientbans:
					self.p.queue.instant( "/ban %s %s" % (Data['username'], "Clientban : " + o.ogame ))
					return
		elif (ID == 0x0D or ID == 0x0F or ID == 0x0E or ID == 0x13):
			''' CE_ERROR '''
			if self.cbs:
				if (Data['text'] == "That channel does not exist.") or (Data['text'] == "You do not have permission to view that channel."):
					self.p.queue.addq( "I can not see %s." % self.cbtarg )
					self.cbs = False
		elif (ID == 0x03):
			p.queue.priorityban(Data['username'])
			for banned, op in self.bans.items():
				if op == Data['username']:
					del self.bans[banned]
		elif (ID == 0x07):
			self.bans = {}
		elif (ID == 0x12):
			if (support.match(Data['text'], "* was banned by *")):
				parts = Data['text'].split(" ")
				self.bans[parts[0]] = parts[4].rstrip(".")
			elif (support.match(Data['text'], "* was unbanned by *")):
				parts = Data['text'].split(" ")
				try:
					del self.bans[parts[0]]
				except KeyError: pass
			if self.cbs:
				if (Data['text'].find("Users in channel") != -1):
					channel = Data['text'].split("Users in channel ")[1]
					channel = channel[:len(channel)-1]
					if channel.lower() == self.cbtarg.lower():
						self.cbstream = True
						self.cbtarg = channel
						lag = float(self.p.plugins.find("channel").countops())
						if lag < 2: lag = 2
						if lag > 4: lag = 4
						support.execafter( lag, self.cb_timer)
				elif self.cbstream:
					tup = Data['text'].split(" ")
					if len(tup) == 2:
						if "," in tup[0]:
							self.cblist.append( support.trimopbrackets(tup[0][:len(tup[0])-1]) )
							self.cblist.append( support.trimopbrackets(tup[1]))
					elif len(tup) == 1:
						self.cblist.append( support.trimopbrackets(tup[0]))
			# }
