""" pynet.py
	
"""

import support, threading, sys, os, default, socket, time
	
class irc_command():
	def __init__(self, command):
		self.command = command
		self.origin = "local"
		self.cmd = self.parse()
		
	def nomnom(self, message):
		if (message[0].upper() == message[0]) and (message[0].isalnum()):
			return ('', self.code(message[0]), message[1:])
		else:
			return (message[0].lstrip(":"), self.code(message[1]), message[2:])
		
	def code(self, code):
		try:
			return int(code)
		except ValueError:
			return code
			
	def username(self, origin):
		try:
			return origin.split("!")[0]
		except:
			return origin
			
	def parse(self):
		o, cmd, args = self.nomnom(self.command.split(" "))
		pos = 0
		fixed = []
		for arg in args:
			if len(arg) > 0:
				if arg[0] == ":":
					all = ' '.join(args[pos:])
					all = all[1:len(all)]
					fixed.append(all)
					return (self.username(o), cmd, fixed)
				else:
					fixed.append(arg)
			else:
				fixed.append(arg)
			pos += 1
		return (self.username(o), cmd, fixed)
	
class exposed(threading.Thread):
	def __init__(self, parent):
		self.p = parent
		if not self.p.family.oldest(self.p):
			return None
			
		self.udb = support.userlist()
			
		self.data = ''
		self.complete = True
		
		self.colors = {
			"statstrings" : "gray",
			"usernames" : "white",
			"message" : "green",
			"info" : "#0099CC",
			"note" : "yellow",
			"error" : "red"
			}
		
		self.p.config.set("irc", "server", "irc.freenode.net", False)
		self.p.config.set("irc", "server_password", "", False)
		self.p.config.set("irc", "nickname", "", False)
		self.p.config.set("irc", "default_channels", "#stealthbot", False)
		self.p.config.set("irc", "connectonstartup", "no", False)
		self.p.config.set("irc", "ident", "", False)
		
		self.server = self.p.config.get("irc", "server")
		self.nickname = self.p.config.get("irc", "nickname")
		self.userident = self.p.config.get("irc", "ident")
		# ...
		
		self.channel = []
		
		# ...
		
		self.execute = True
		self.connected = False
		self.thread = False
		
		threading.Thread.__init__(self)
		self.setDaemon(True)
		if (self.p.config.get("irc", "connectonstartup", "no") == "yes"):
			self.connect()
		
	def addchat(self, *args):
		self.p.addchat(*args, which="IRC Console")
		
	def send(self, data):
		try:
			self.socket.sendall(data + "\r\n")
		except: pass
		
	def disconnect(self):
		try:
			if self.connected:
				self.properdisconnect()
			self.socket.close()
			self.connected = False
		except: pass
		
	def properdisconnect(self):
		self.addchat("red", "Disconnected...")
		
	def connect(self):
		if self.connected:
			self.addchat("red", "Could not connect... already connected.")
		self.socket = socket.socket ( socket.AF_INET, socket.SOCK_STREAM )
		self.socket.settimeout(15.0)
		self.addchat("yellow", "Connecting...")
		try:
			self.socket.connect( (self.server, 6667) )
		except socket.error, socket.herror:
			self.addchat(self.colors['error'],  "Socket borked.")
			self.disconnect()
			return False
		except socket.timeout:
			self.addchat(self.colors['error'],  "Socket timed out")
			self.disconnect()
			return False
		except:
			self.addchat(self.colors['error'],  "Socket failed")
			self.disconnect()
			return False
		self.socket.settimeout(500.0)
		self.connected = True
		self.addchat(self.colors['message'],  "Connected!")

		threading.Thread.__init__(self)
		if not self.thread: self.start()
		time.sleep(0.25)
		self.sendlogin()

	def sendlogin(self):
		password = self.p.config.get("irc", "server_password")
		if self.nickname == "":
			self.nickname = self.p.config.get("main", "username")
			self.addchat("yellow",  "No username set, using bot's name instead. You may fix this by typing /irc username <nick>")
		if not password == "":
			self.send("PASS %s" % password)
		self.send("NICK %s" % self.nickname)
		self.send("USER %s PyBot PyBot :%s" % (self.nickname, self.nickname))
		if self.userident != "":
			self.send("NICKSERV IDENTIFY %s" % self.userident)
		if self.p.config.get("irc", "default_channels") != "":
			self.send("JOIN %s" % self.p.config.get("irc", "default_channels"))
		
		
		
	def recieve(self, CMD):
		if len(CMD) == 0: return None
		
		irc_packet = irc_command(CMD)
		origin, ID, args = irc_packet.cmd
		if (ID == "NOTICE"):
			self.addchat(self.colors['info'], args[1])
		elif (ID == "JOIN"):
			self.p.addchat(self.colors['note'], " -- ", self.colors['usernames'], origin, self.colors['message'], " has joined the channel.", which="IRC %s" % args[0])
		elif (ID == "PART"):
			self.p.addchat(self.colors['note'], " -- ", self.colors['usernames'], origin, self.colors['message'], " has left the channel.", which="IRC %s" % args[0])
		elif (ID == "PRIVMSG"):
			self.p.addchat(self.colors['info'], "<", self.colors['usernames'], origin, self.colors['info'], "> ", "white", args[1], which="IRC %s" % args[0])
		elif (ID == "MODE"):
			self.p.addchat(self.colors['note'], " -- ", self.colors['usernames'], origin, self.colors['message'], " set mode [%s]." % ' '.join(args[1:]), which="IRC %s" % args[0])
		elif (ID == "PING"):
			self.send("PONG :" + args[0])
		elif (ID == "QUIT"):
			self.p.addchat(self.colors['note'], " -- ", self.colors['usernames'], origin, self.colors['message'], " has quit the server: ", self.colors['usernames'], ' '.join(args[1:]), which="IRC %s" % args[0])
		elif (ID == 332):
			self.p.addchat(self.colors['info'], "# ", "white", args[2], which="IRC %s" % args[1])
			
		elif (type(ID) == type(0)):
			self.addchat(self.colors['info'], "[%i] %s" % (ID, ' '.join(args[1:])))
		else:
			self.addchat("red", CMD)

	def run(self):
		self.thread = True
		self.addchat(self.colors['info'],  "Thread started...")
		while self.execute:
			while self.connected:
				try:
					data = self.socket.recv(2048)
					if data == "" or not self.connected:
						print "Interupted"
						self.disconnect()
						break
					self.data += data
				except:
					print "Stream stopped."
					print sys.exc_info()
					self.disconnect()
					break

				if not self.data:
					print "No data"
					self.disconnect()
					break
				elif len(self.data) > 0:
					data = self.data.replace("\r", "")
					lines = data.split("\n")
					am = len(lines)
					if not data[-1] == "\n": # Theres more...
						self.data = lines[-1]
						usable = lines[:-1]
						for cmd in usable:
							self.recieve(cmd)
					else: # Nothing seperated
						for line in lines:
							self.recieve(line)
						self.data = ''
					
			time.sleep(0.05)
		
	def __attr__(self):
		return {
			'name' : 'irc',
			'author' : "vi[r]us",
			'version' : (1, 0),
			'description' : '',
			'notes' : '',
			'help' : '',
			'chatexplicit' : True,
			'onlymain' : True,
			'flags' : 'sc'
			}
			
	def __invoke__(self, ID, Length, Data, p):
		b = buffer.pin()
		b.unbuild(Data)
		
	def __command__(self, COMMAND, o, source='~local', origin=4):
		p = self.p
		user, access, flags, space, CMD = support.commandValidate(COMMAND, o, source, p.plugins.find("channel").IChannel, self.udb)
		par = o.parameters
			
		p.veto = True
		if (CMD == "irc"):
			if len(par) == 0: return "Wrong number of parameters."
			args = par[1:]
			iCMD = par[0].lower()
			if (iCMD == "connect"):
				support.execafter(2.5, self.connect)
				return 'Connecting... from now on, any IRC activity will be reported in IRC Console and similarly named tabs.'
			elif (iCMD == "username"):
				newnick = args[0]
				self.p.config.set("irc", "nickname", newnick, True)
				self.nickname = self.p.config.get("irc", "nickname")
				return "IRC Username set to \"" + self.nickname + "\"."
			elif (iCMD == "ident"):
				newid = ' '.join(args[:])
				self.p.config.set("irc", "ident", newid, True)
				self.userident = self.p.config.get("irc", "ident")
				return "IRC NickServ identification set to \"" + self.userident + "\"."
			elif (iCMD == "server"):
				newserv = args[0]
				self.p.config.set("irc", "server", newserv, True)
				self.server = self.p.config.get("irc", "server")
				return "IRC Server set to \"" + self.server + "\"."
			elif (iCMD == "channels"):
				newc = args[0]
				self.p.config.set("irc", "default_channels", newc, True)
				return "IRC default channels set to " + self.p.config.get("irc", "default_channels") + "."
			elif (iCMD == "join"):
				self.send("JOIN %s" % args[0])
				return ''
			elif (iCMD == "msg"):
				self.send(" ".join(args[:]))
				self.addchat(self.colors['info'], " ".join(args[:]))
			elif (iCMD == "cos"):
				newc = args[0].lower()
				if (not support.isyesno(newc)):
					return "Please use 'yes' or 'no' values."
				self.p.config.set("irc", "connectonstartup", newc, True)
				return "Connect to IRC on startup: " + self.p.config.get("irc", "connectonstartup")
			return 'Unknown IRC command'
		else:
			p.veto = False
			return ''
		p.veto = True
		return ''
		
	def __cevent__(self, ID, Data, p):
		if (ID == 0x101):
			support.commandProcess(Data, p, self.__command__)
		elif (ID == 0x103):
			tab = Data[0]
			text = Data[1]
			if type(tab) == str and tab[0:4] == "IRC ":
				channel = tab[4:]
				if not channel == "Console":
					self.send("PRIVMSG %s :%s" % (channel, text))
					self.p.addchat(self.colors['info'], "<", self.colors['usernames'], self.nickname, self.colors['info'], "> ", "white", text, which="IRC %s" % channel)
		"""
		if (ID == 0x00):
			''' CE_UNKNOWN '''
		elif (ID == 0x01):
			''' CE_USERINCHANNEL '''
		elif (ID == 0x02):
			''' CE_USERJOIN '''
		elif (ID == 0x03):
			''' CE_USERLEAVES '''
		elif (ID == 0x04):
			''' CE_WHISPERFROM '''
		elif (ID == 0x05):
			''' CE_USERTALK '''
		elif (ID == 0x06):
			''' CE_BROADCAST '''
		elif (ID == 0x07):
			''' CE_CHANNELJOIN '''
		elif (ID == 0x09):
			''' CE_USERUPDATE / CE_FLAGSUPDATE '''
		elif (ID == 0x0A):
			''' CE_WHISPERTO '''
		elif (ID == 0x0D or ID == 0x0F or ID == 0x0E or ID == 0x13):
			''' CE_ERROR '''
		elif (ID == 0x12):
			''' CE_INFO '''
		elif (ID == 0x17):
			''' CE_USEREMOTE '''
		# Custom
		elif (ID == 0x100):
			## AddChat Echo from BNCS.
		elif (ID == 0x101):
			## Someone has issued a command instructing your bot. It is parsed but access was not checked.
			## index:
			## 0: Username
			## 1: User's flags in channel
			## 2: Parsed commandObject (view reference in support.py)
		elif (ID == 0x102):
			## The socket has failed or has been disconnected.
		elif (ID == 0x103):
			## Text was sent from the bot's user interface.
		elif (ID == 0x104):
			## The bot is starting to connect, it has already sent the protocol ID.
		"""
