
""" general.py

	General bot functions and commands.
		
	"""
	
import support, default, sys, winamp, random, platform, time, md5
import __builtin__

disabled_names = list(set(dir(__builtin__)) ^\
                 set(['True', 'False', 'None', 'abs', 'all', 'any', 'apply',
                      'basestring', 'bin', 'bool', 'bytearray', 'bytes',
                      'callable', 'chr', 'cmp', 'complex', 'copyright',
                      'credits', 'dict', 'dir', 'divmod', 'enumerate', 'filter',
                      'float', 'format', 'frozenset', 'hash', 'help', 'hex',
                      'id', 'int', 'isinstance', 'issubclass', 'iter', 'len',
                      'license', 'list', 'long', 'map', 'max', 'min', 'oct',
                      'ord', 'pow', 'range', 'reduce', 'repr', 'reversed',
                      'round', 'slice', 'sorted', 'str', 'sum', 'tuple', 'type',
                      'unichr', 'unicode', 'xrange', 'zip', 'set']))
disabled_builtins = dict(zip(disabled_names, (None,) * len(disabled_names)))
	
class exposed():
	def __init__(self, parent):
		self.p = parent
		self.udb = support.userlist()
		self.cfg = support.config("pybot.ini")
		
		default.create("debugmode", 201, ["debug"], "enables debug mode and raises errors instead of passing them to the handler")
		
		self.id = ''
		self.idlist = []
		self.idrc = False
		
	def __attr__(self):
		return {
			'name' : 'cmd',
			'author' : "vi[r]us",
			'version' : (1, 0),
			'description' : 'Does simple chat commands.',
			'notes' : '',
			'help' : '',
			'chatexplicit' : True,
			'flags' : "sc"
			}
		
	def __command__(self, COMMAND, o, source='~local', origin=4):
		p = self.p
		user, access, flags, space, CMD = support.commandValidate(COMMAND, o, source, p.plugins.find("channel").IChannel, self.udb)
		par = o.parameters
		
		p.veto = True
		if (CMD == "say"):
			if (len(par) == 0) and (len(p.queue.lastaddq) > 0):
				if p.queue.lastaddq[:1] != "/":
					return p.queue.lastaddq
				else:
					return "The last sent message was a command."
			else:
				p.queue.addq(space + ' '.join(par))
				if origin in [2, 3]:
					return "Echoing text to %s." % p.plugins.find("bncs").mychannel
				else:
					return ''
		if (CMD == "megaphone"):
			cmd = space + ' '.join(par)
			if (p.queue.bytes < 25) and (p.queue.qsize() == 0):
				if len(cmd) > 150:
					return "That statement is too large to megaphone."
				p.em_SendText(cmd)
				p.em_SendText(cmd)
				p.em_SendText(cmd)
				p.em_SendText(cmd)
				p.queue.bytes = 500
				p.queue.padq(4)
			else:
				return "Please wait until the queue is not stressed."
			return ''
		elif (CMD == "yell"):
			if (len(par) == 0) and (len(p.queue.lastaddq) > 0):
				if p.queue.lastaddq[:1] != "/":
					return p.queue.lastaddq.upper()
				else:
					return "The last sent message was a command."
			else:
				p.queue.addq(space + ' '.join(par).upper())
				if origin in [2, 3]:
					return "Echoing text to %s." % p.plugins.find("bncs").mychannel
				else:
					return ''
		elif (CMD == "debugmode"):
			if p.debug:
				p.debug = False
				return "Debug mode has been disabled."
			else:
				p.debug = True
				return "Debug mode has been enabled. The bot will not handle plugin errors, and it is extremely likely the errors you are debugging will break the bot temporarily."
		elif (CMD == "pingme"):
			if source == "~console":
				return "You are the console, your ping cannot be measured."
			try:
				return "Your ping at login was %ims." % user.ping
			except:
				return "Your ping can't be determined from your current location."
		elif (CMD == "ping"):
			try:
				user = p.plugins.find("channel").find(par[0])
				if not user == None:
					return user.name + "'s ping at login was %ims." % user.ping
				else:
					return "I cannot see %s in the channel." % par[0]
			except IndexError:
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 1)
		elif (CMD == "md5"):
			return ""
		elif (CMD == "scope"):
			try:
				user = par[0].lower()
				valid = False
			except IndexError:
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 1)
				
			if self.id != '':
				return ""
			
			self.idlist = []
			if (source == "~console"):
				self.idrc = True
			else:
				self.idrc = False
				
			if (user == p.plugins.find("bncs").me.name.lower()):
				return "You cannot scope the bot, it would open a black hole."
				
			for u in p.plugins.find("channel").IChannel:
				if u.name.lower() == user.lower():
					valid = True
				else:
					if (not u.hasFlag(0x20)):
						self.idlist.append(u.name)
					
			if not valid:
				return "I cannot see %s in the channel." % par[0]
				
			self.id = user
				
			self.p.queue.addq("/ignore %s" % user)
			return ""
		elif (CMD == "help"):
			strs = "wtf"
			try:
				item = ' '.join(par[:]).lower()
				isalias = False
			except IndexError:
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 1)
			try:
				if (not item in default.commands()):
					if (item in default.aliases()):
						alias = item
						item = default.aliases()[item]
						isalias = True
					else:
						return "There is no related documentation for \"%s\"." % item
				a = default.commands()[item]
			except KeyError:
				return "There is no related documentation for \"%s\"." % item
			access = "access %i" % a
			if a == 202:
				access = "disabled"
			if a == 201:
				access = "console only"
			if a == 200:
				access = "admin only"
			if a == -1:
				access = "ignored users only"
			if a == -2:
				access = "defunct"
			try:
				doc = default.help()[item]
			except IndexError:
				return "There is no related documentation for \"%s\"." % item
				
			try:
				syn = default.syntax()[item]
			except IndexError:
				syn = "unknown syntax"
				
			if isalias:
				strs = "%s (redirected from \"%s\") (%s): %s (Syntax: %s)" % (item, alias, access, doc, syn)
			else:
				strs = "%s (%s): %s (Syntax: %s)" % (item, access, doc, syn)
			return strs
			
			
		elif (CMD == "safelist"):
			safelist = self.udb.find(flag="s")
			return "Entities with flags \"s\": " + '; '.join(safelist)
		elif (CMD == "shitlist"):
			shitlist = self.udb.find(flag="b")
			return "Entities with flags \"b\": " + '; '.join(shitlist)
		elif (CMD == "groups"):
			i = self.udb.find("group|")
			return "Entities that are groups: " + '; '.join(i)
		elif (CMD == "clans"):
			i = self.udb.find("clan|")
			return "Entities that are clan wildcards: " + '; '.join(i)
		elif (CMD == "flags"):
			flags = default.flagList()
			a = []
			for key in flags:
				a.append(key)
			return "Valid flags: %s" % support.listand(a)
			
		elif (CMD == "version"):
			version = support.version()
			return version.history()
		elif (CMD == "about"):
			version = support.getbotversion()
			return "I am a %s running on %s." % (version, str(platform.system() + " " + platform.release()))
		elif (CMD == "cq"):
			mc = len(p.queue.queue)
			p.queue.queue = []
			return "Queue cleared (%i.) {%ib}" % (mc, p.queue.bytes)
		elif (CMD == "scq"):
			p.queue.queue = []
			return ''
		elif (CMD == "where"):
			me = p.plugins.find("bncs").me
			if me.hasFlag(0x02):
				duty = "an operator of"
			else:
				duty = "talking in"
			return "I am " + duty + " " + p.plugins.find("bncs").mychannel + " (" + str(len(p.plugins.find("channel").IChannel)) + " users) with flags " + hex(me.flags) + "."
		elif (CMD == "quit"):
			print "Quit by command"
			p.destroy()
			sys.exit()
		elif (CMD == "plugins"):
			# god damn swent
			retr = []
			for plugin in self.p.plugins.all():
				retr.append(plugin.info['name'])
			return str(retr).replace("'", "")
		elif (CMD == "reloadplugins"):
			p.plugins.reloadall()
			return "All plugins reloaded."
		elif (CMD == "roll"):
			if len(par) == 0:
				return "Random number between 1 and 100: %i" % random.randint(1, 100)
			elif len(par) == 1:
				try:
					val = int(par[0])
					return "Random number between 1 and %i: %i" % (val, random.randint(1, val))
				except:
					return "Invalid number."
			elif len(par) >= 2:
				try:
					val = int(par[0])
					val2 = int(par[1])
					return "Random number between %i and %i: %i" % (val, val2, random.randint(val, val2))
				except:
					return "Invalid numbers."
		elif (CMD == "shuffle"):
			items = []
			for p in par:
				if len(p) > 0:
					items.append(p)
			random.shuffle(items)
			try:
				return "Randomly shuffled list: " + ", ".join(items)
			except:
				pass
		elif (CMD == "choice"):
			items = []
			for p in par:
				if len(p) > 0:
					items.append(p)
			try:
				return "Random item from list: " + random.choice(items)
			except:
				pass
		elif (CMD == "flip"):
			if random.randint(1, 100) > 50:
				return "Heads."
			else:
				return "Tails."
		elif (CMD == "exec"):
			evalutation = ' '.join(par[:])
			try:
				val = str(eval(evalutation, disabled_builtins))
				if (len(val) > 210) and (access < 100):
					return "Your math evaluation was too long to display."
				else:
					return space + val
			except:
				return "An error has occured, please make sure it is a valid math command."
				print "More error info:"
				print sys.exc_info()
		elif (CMD == "soundex"):
			lit = support.lit()
			try:
				a = lit.soundex(par[0])
				b = lit.soundex(par[1])
				if a == b:
					return "Values sound alike. (%s, %s)" % (a, b)
				else:
					return "Values sound different. (%s, %s)" % (a, b)
			except:
				print sys.exc_info()
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 2)
		elif (CMD == "join"):
			try:
				if not p.plugins.find("bncs").mychannel.lower() == ' '.join(par[0:]).lower():
					p.queue.addq( "/join %s" % ' '.join(par[0:]) )
					return ''
			except:
				return "Invalid number of parameters (%i); expected at least %i." % (len(par), 1)
		elif (CMD == "home"):
			p.queue.addq( "/join %s" % self.p.config.get("main", "home", "The Void"))
			return ''
		elif (CMD == "rejoin"):
			if p.plugins.find("bncs").me.hasFlag(0x02):
				p.queue.addq( "/rejoin" )
			else:
				location = p.plugins.find("bncs").mychannel
				p.queue.instant( "/join Rejoin %s" % location )
				p.queue.instant( "/join %s" % location )
			return ""
		elif (CMD == "time"):
			p.veto = False
			return "The current time on this computer is %s." % str(support.now())
		elif (CMD == "uptime"):
			botuptime = support.hutime((support.now() - p.plugins.find("bncs").logintime).seconds)
			uptime = support.hutime(support.getsysuptime())
			return "Operating system uptime: %s; connection uptime: %s" % (uptime, botuptime)
		elif (CMD == "trigger"):
			trigger = p.config.get("main", "trigger", ".")
			return "The bot's current trigger is \" %s \" (u%s) (Length: %i)." % (trigger, str(ord(trigger)).zfill(4), len(trigger))
		elif (CMD == "accept") or (CMD == "decline"):
			try:
				tag = par[0]
			except: return "Invalid number of parameters (%i); expected at least %i." % (len(par), 1)
			for invite in p.plugins.find("clan").i_pending:
				if invite.tag.lower() == tag.lower():
					p.plugins.find("clan").i_pending.remove(invite)
					if CMD == "accept":
						p.send(invite.accept())
						return "Invitation to " + invite.name + " has been accepted."
					else:
						p.send(invite.decline())
						return "Invitation to " + invite.name + " has been declined."
			return "No clans have invited me with that tag."
		else:
			try:
				if (CMD == "next"):
					p.winamp.doCommand(40048)
					return "Skipped to %s." % self.formatMP3string()
				elif (CMD == "back"):
					p.winamp.doCommand(40044)
					return "Skipped to %s." % self.formatMP3string()
				elif (CMD == "mp3"):
					return "Now Playing: %s" % self.formatMP3string()
			except winamp.WinampError:
				return "Winamp is not loaded."
			except TypeError:
				return "Error has occured in Winamp."
			
			p.veto = False
			return ''
		p.veto = True
		return ''
		
	def formatMP3string(self):
		length = int(self.p.winamp.getCurrentTrackLength())
		elap = int(self.p.winamp.getCurrentTrackPos())
		runtime = str(round((elap / length) * 100, 1)) + "%"
		volume = str(round((self.p.winamp.getVolume() / 255.0) * 100, 0)).replace(".0", "") + "%"
		return "%s (%s/%s runtime @ %s volume)" % (self.p.winamp.getCurrentTrackName(), support.swfTime(elap),
                                                           support.swfTime(length), volume)
		
	def checkign(self):
		r = []
		for u in self.p.plugins.find("channel").IChannel:
			if (u.name in self.idlist):
				if u.hasFlag(0x20):
					r.append(u.name)
		s = "%s is also: %s" % (self.id, ', '.join(r))
		if len(r) == 0:
			s = "%s has no other accounts in this channel." % self.id
		if not self.idrc:
			self.p.queue.addq( s )
		else:
			self.p.addchat( "#0099CC", "<from Console> ", "gray", s)
		self.p.queue.addq("/unignore %s" % self.id)
		
	def __cevent__(self, ID, Data, p):
		if (ID == 0x101):
			support.commandProcess(Data, p, self.__command__)
		elif (ID == 0x12):
			if (support.match(Data['text'], ".* has been squelched.")):
				user = Data['text'].split(" ")[0]
				if (user.lower() == self.id.lower()):
					self.id = user
					support.execafter( 2.5, self.checkign)
			elif (support.match(Data['text'], ".* has been unsquelched.")):
				user = Data['text'].split(" ")[0].lower()
				if (user.lower() == self.id.lower()):
					self.id = ''
					self.idlist = ''
		elif (ID == 0x04):
			autotext = ['Your friend * has (entered|exited) Battle.net.',
				"Your friend * entered a * game called *\."]
			for text in autotext:
				if support.match(Data['text'], text):
					return
			p.addchat(
				"green", "<",
				"yellow", Data['username'], 
				"green", "> ", 
				"gray", Data['text'],
				which='Whisper: ' + Data['username'])
		elif (ID == 0x05):
			if (Data['text'][:3] == "a8K"):
				m = Data['text'][3:]
		elif (ID == 0x103):
			if not Data[2]:
				tab = Data[0]
				text = Data[1]
				# ...
				if type(tab) != str or ((not tab[:7] == "PyNet: ") and (not tab[:9] == "Whisper: ") and not (tab.find("IRC ") != -1)):
					p.queue.addq(text)
				elif (tab.find("Whisper: ") != -1):
					p.queue.addq("/w %s %s" % (tab[9:], text))
