
""" dos.py

	Simple plugin to print chat events.
		
	"""
	
import support
	
class exposed():
	def __init__(self, parent):
		pass
		
	def __attr__(self):
		return {
			'name' : 'dos',
			'author' : "vi[r]us",
			'version' : (1, 0),
			'description' : 'Echo plugin.',
			'notes' : '',
			'help' : '',
			'chatexplicit' : True,
			'onlymain' : True,
			'flags' : "s"
			}
		
	def __cevent__(self, ID, Data, p):
		if (ID == 0x00):
			''' CE_UNKNOWN '''
			support.doprint( "<-- Unknown chat event -->" )
		elif (ID == 0x01):
			''' CE_USERINCHANNEL '''
			#o = support.channelObject( Data['username'], Data['flags'], Data['ping'], Data['text'] )
			#support.doprint( "<-- %s [%s]: %s" % (o.name, str(o.ping), o.infostring) )
		elif (ID == 0x02):
			''' CE_USERJOIN '''
			o = support.channelObject( Data['username'], Data['flags'], Data['ping'], Data['text'] )
			support.doprint( "<-- %s [%s]: %s has joined the channel. -->" % (o.name, str(o.ping), o.infostring) )
		elif (ID == 0x03):
			''' CE_USERLEAVES '''
			support.doprint( "<-- %s has left the channel. -->" % Data["username"] )
		elif (ID == 0x04):
			''' CE_WHISPERFROM '''
			support.doprint( "<from %s> %s" % (Data["username"], Data["text"]) )
		elif (ID == 0x05):
			''' CE_USERTALK '''
			support.doprint( "<%s> %s" % (Data["username"], Data["text"]) )
		elif (ID == 0x06):
			''' CE_BROADCAST '''
			support.doprint( "<Battle.net> %s -->" % Data["text"] )
		elif (ID == 0x07):
			''' CE_CHANNELJOIN '''
			support.doprint( "<-- Joined: %s -->" % Data["text"] )
		elif (ID == 0x09):
			''' CE_USERUPDATE / CE_FLAGSUPDATE '''
			support.doprint( "<-- %s now has flags %s. -->" % (Data["username"], hex(Data["flags"])) )
		elif (ID == 0x0A):
			''' CE_WHISPERTO '''
			support.doprint( "<to %s> %s" % (Data["username"], Data["text"]) )
		elif (ID == 0x0D or ID == 0x0F or ID == 0x0E or ID == 0x13):
			''' CE_ERROR '''
			support.doprint( Data["text"] )
		elif (ID == 0x12):
			''' CE_INFO '''
			support.doprint( Data["text"] )
		elif (ID == 0x17):
			''' CE_USEREMOTE '''
			support.doprint( "<%s %s>" % (Data["username"], Data["text"]) )
		elif (ID == 0x101):
			support.doprint( "Command from " + Data[0] + " (" + hex(Data[1]) + "): " + Data[2].name + " | " + str(Data[2].parameters) )
