
""" general.py

	General bot functions and commands.
		
	"""
	
import support, default, sys, winamp, random, time, httplib

class exposed():
	def __init__(self, parent):
		self.p = parent
		self.udb = support.userlist()
		self.cfg = support.config("pybot.ini")
		
	def __attr__(self):
		return {
			'name' : 'ci',
			'author' : "vi[r]us",
			'version' : (1, 0),
			'description' : 'Commands for keeping your clan maintained.',
			'notes' : '',
			'help' : '',
			'chatexplicit' : True,
			'flags' : "sc"
			}
		
	def __command__(self, COMMAND, o, source='~local', origin=4):
		p = self.p
		user, access, flags, space, CMD = support.commandValidate(COMMAND, o, source, p.plugins.find("channel").IChannel, self.udb)
		par = o.parameters
		
		p.veto = True
		if (CMD == "findclaninactive"):
			try:
				clan = par[0]
			except IndexError:
				clan = p.plugins.find("clan").myClan
			if (clan == ''):
				return "You must specify a clan to get information about."
			elif (len(clan) < 2 or len(clan) > 4):
				return "You must supply a valid clan tag."
				
			try:
				realm = par[1]
				if not realm.lower() in ['azeroth', 'lordaeron', 'northrend', 'kalimdor']:
					return "Invalid Battle.net realm."
			except IndexError:
				#realm = p.plugins.find("bncs").myServerName
				realm = "Azeroth"
			
			## ...
			
			inet = support.inet_mask()
			try:
				page1 = inet.open("http://www.battle.net/war3/ladder/w3xp-clan-profile.aspx?Gateway=%s&ClanTag=%s" % (realm, clan)).read()
			except IOError as e:
				eID = e[1]
				if (eID == 302):
					return "The requested clan does not exist."
				else:
					return "Message %s" % (str(e[1]) + ": " + str(e[2]))
			
			clan_title = page1.split('<span style = "FONT-SIZE: 15pt; font-variant: small-caps; letter-spacing: 3px; font-style: italic; COLOR: #ffffff; FONT-FAMILY: arial,helvetica,sans-serif; font-weight: bold;">')
			clan_title = clan_title[1].split("</span>")[0]
			
			print "Name: " + clan_title
			
			pages = 1
			for i in range(0,8):
				if (page1.find("PageNo=" + str(i)) != -1):
					pages = i
					
			pagecontent = {
				1 : page1.split(">Last Online</a></td>")[1].replace(chr(9), '')
				}
				
			if (pages > 1):
				for x in range(2,pages+1):
					print "Getting page #%i" % x
					pagecontent[x] = inet.open("http://www.battle.net/war3/ladder/w3xp-clan-profile.aspx?ClanTag=%s&Gateway=%s&PageNo=%i" % (clan, realm, x)).read().split(">Last Online</a></td>")[1].replace(chr(9), '')
			
			bymonth = []
			for page in pagecontent:
				users = self.parsepage(pagecontent[page])
				for user in users:
					name, j, o = user
					if (self.parsetime(o) > 30):
						bymonth.append(user)
						
			if len(bymonth) == 0:
				return "The clan has no members offline for more than 30 days."
			r = []
			f = True
			rs = ''
			d = '; '
			for user in bymonth:
				n, j, o = user
				r.append( n + " (" + str(self.parsetime(o)) + "d)" )
				if len(r) == 8:
					if f == True:
						rs += "Users offline > 30 days: " + d.join(r) + "\n"
						f = False
					else:
						rs += d.join(r) + "\n"
					r = []
			if not len(r) == 0:
				return rs + d.join(r)
			else:
				return rs.rstrip("\n")
		else:
			p.veto = False
			return ''
		p.veto = True
		return ''
		
	def parsepage(self, data):
		stuff = data.split('w3xp-player-profile.aspx')
		results = []
		for itemcont in stuff:
			try:
				item = itemcont.replace("\r", '').replace("\n", '')
				name = item.split('">')[1].split("</a>")[0]
				joined = item.split('</td><td class="rankingRow">')[1].split('</td>')[0].strip()
				lastonline = item.split('</td><td class="rankingRow">')[2].split('</td>')[0].strip()
				results.append( (name, joined, lastonline) )
			except IndexError:
				pass
		return results
		
	def parsetime(self, time):
		x = time.split(",")
		for value in x:
			v = value.strip()
			if v.find(" Days") != -1:
				return int(v.split(" ")[0])
		return 0
		
	def __cevent__(self, ID, Data, p):
		if (ID == 0x101): support.commandProcess(Data, p, self.__command__)
