
""" bncs.py

	Battle.net Connection Sequence
	
	Supports:
		* WarCraft 3
		
	"""
	
import buffer, support, language
import bnls, wx, time, random

import datetime
from string import join

_FILETIME_null_date = datetime.datetime(1601, 1, 1, 0, 0, 0)
def FiletimeToDateTime(timestring):
        high, low = map(int, (timestring.split(' ', 2) + ['0', '0'])[:2])
        timestamp = high
        timestamp <<= 32
        timestamp |= low
        return (_FILETIME_null_date + datetime.timedelta(microseconds=timestamp/10)).isoformat(' ')

def SecondsToReadable(s):
        s = int(s)
        y = s / 31556926
        y = y and ('%d year' % y) + (y > 1 and 's' or '') or ''
        s %= 31556926
        d = s / 86400
        d = d and ('%d day' % d) + (d > 1 and 's' or '') or ''
        s %= 86400
        h = s / 3600
        h = h and ('%d hour' % h) + (h > 1 and 's' or '') or ''
        s %= 3600
        m = s / 60
        m = m and ('%d minute' % m) + (m > 1 and 's' or '') or ''
        s %= 60
        s = s and ('%d second' % s) + (s > 1 and 's' or '') or ''
        return join(filter(bool, (y, d, h, m, s)), ', ')
	
class exposed():
	def __init__(self, parent):
		self.out = buffer.pout()
		self.config = support.config(parent.cfgfile)
		self.p = parent
		self.mychannel = "The Void"
		self.me = support.channelObject( '~' + self.config.get("main", "username", "PyBot"), 0x00, 0, self.config.get("main", "game", "3RAW") )
		self.online = False
		self.logintime = support.now()
		
		''' PRELOADS '''
		self.server = self.config.get("main", "bncs", "europe.battle.net")
		self.username= self.config.get("main", "username")
		self.password = self.config.get("main", "password")
		self.cdkey = self.config.get("main", "cdkey")
		self.expcdkey = self.config.get("main", "expcdkey")
		self.platform = "68XI"
		self.gameID = self.config.get("main", "game", "3RAW")
		self.gameVB = self.config.gettype("main", "verbyte", "int")
		self.location = self.config.get("main", "originfull", "United States")
		self.locationID = self.config.get("main", "origin", "USA")
		self.home = self.config.get("main", "home", "")
		self.bnls = bnls.BNLS(self.config.get("main", "bnls", "pyro.no-ip.biz"), self.p.cfgfile)
		
		''' HOLDS CONNECTION INFORMATION '''
		self.servertoken = ''
		self.mpqfiletime = ''
		self.clienttoken = ''
		self.SEPCookie = -1
		
		self.spoof = 0
		
	def __attr__(self):
		return {
			'name' : 'bncs',
			'author' : "vi[r]us",
			'version' : (1, 0),
			'description' : 'Logs into Battle.net and handles it\'s data.',
			'notes' : 'This class should generally not be edited.',
			'help' : '',
			'chatexplicit' : False,
			'flags' : "sk"
			}
			
	def log_out(self, text):
		support.doprint( "[BNCS] %s" % text )
			
	def __invoke__(self, ID, Length, Data, p):
		tr = language.english()
		b = buffer.pin()
		b.unbuild(Data)
		self.p = p
		
		Unhandled = [0x75, 0x0B, 0x00]
		if (ID == 0x104):
			p.addchat("yellow", "[BNLS] Connecting...")
			if not self.bnls.connect():
				p.addchat("red", "[BNLS] Could not connect. BNLS must be used to process the game checksum to login. Please modify it in your config.")
				return None
			else:
				p.addchat("green", "[BNLS] Connected!")
			''' CUSTOM_CONNECTIONESTABLISHED 
				* Note: The core sends the protocol ID.
			'''
			self.out.insertDWord(0)
			self.out.insertRawData(self.platform)
			self.out.insertRawData(self.gameID)
			self.out.insertDWord(self.gameVB) #version byte
			self.out.insertDWord(0)
			self.out.insertDWord(0)
			self.out.insertDWord(0)
			self.out.insertDWord(0)
			self.out.insertDWord(0)
			self.out.insertString(self.locationID)
			self.out.insertString(self.location)
			p.send(self.out.build(0x50))
			p.addchat("green", "[BNET] Connected!" )
		elif (ID == 0x101):
			''' CUSTOM_CONNECTIONTERMINATED '''
			pass
		elif (ID == 0x102):
			''' CUSTOM_CORE_ERROR '''
			pass
		elif (ID == 0x103):
			''' CUSTOM_BNLSANGRY '''
			pass
		elif (ID == 0x104):
			''' CUSTOM_BNFTPACTION '''
			pass
		elif (ID == 0x25):
			''' SID_PING '''
			if self.spoof == False:
				self.out.insertDWord(b.getDWord())
				p.send(self.out.build(0x25))
		elif (ID == 0x50):
			''' SID_AUTH_INFO '''
			self.bnls.nls = b.getDWord()
			self.servertoken = b.getDWord()
			b.getDWord()
			self.mpqfiletime = b.getRawData(8)
			mpqinfo = (b.getString(), b.getString())

			hash = self.bnls.hashcdkey(self.servertoken, self.cdkey)
			if hash == '':
				self.p.addchat("red",  "[BNET] CDKey hashing failed, please make sure it is a valid CDKey for the game you are connecting with.")
				self.p.addchat("red",  "[BNET] You may want to use BNLS to hash your CDKey, try setting 'keylocal' under 'hashing' to 'no' in your configuration file.")
				self.log_out("CDKey hashing failed, please check the key")
				return ''
			else:
				self.clienttoken = hash[0]
			checksum = self.bnls.gamechecksum(self.gameID, self.mpqfiletime, *mpqinfo)
			if checksum == '':
                                self.p.addchat("red",  "[BNET] Checksum failure")
				self.log_out("Checksum failure")
				return ''
			
			self.out.insertDWord(self.clienttoken) #clienttoken
			self.out.insertDWord(checksum[0]) #exe version
			self.out.insertDWord(checksum[1]) #hash
			self.out.insertDWord(1) #cdkey count
			self.out.insertDWord(0) #spawn?
			self.out.insertRawData(hash[1]) #9x long
			self.out.insertString(checksum[2]) #cdkey info
			self.out.insertString('PyBot: %s' % self.username) #owner
			p.send(self.out.build(0x51))
			p.addchat("yellow", "[BNET] Sending authorization.")
		elif (ID == 0x51):
			''' SID_AUTHCHECK '''
			result = b.getDWord()
			info = tr.SID_AUTHCHECK()
			if result in info:
				if result == 0:
					p.addchat("green", "[BNET] Authorized.")
					support.doprint( "[BNET] Authorized!" )
					if (self.gameID in ('3RAW', 'PX3W')):
                                                logondata = self.bnls.logonchallenge(self.username, self.password)
                                                self.out.insertRawData(logondata)
                                                self.out.insertString(self.username)
                                                p.send(self.out.build(0x53))
                                        else:
                                                pwhash = self.bnls.double_xsha1(self.password,
                                                                                self.clienttoken,
                                                                                self.servertoken)
                                                self.out.insertDWord(self.clienttoken)
                                                self.out.insertDWord(self.servertoken)
                                                self.out.insertRawData(pwhash)
                                                self.out.insertString(self.username)
                                                p.send(self.out.build(0x3A))
				else:
					msg = info[result] % {'info': b.getString()}
					support.doprint( "[BNET] " + msg)
					p.addchat("red", "[BNET] " + msg)
			else:
                                self.p.addchat("red",  "[BNET] Unknown version check response in 0x51. Check game verbytes.")
				self.log_out("Unknown version check response in 0x51. Check game verbytes.")
		elif (ID == 0x53):
			''' SID_AUTH_ACCOUNTLOGON (WarCraft) '''
			result = b.getDWord()
			info = tr.SID_AUTHCHECK()
			if result in info:
				if result == 0:
					salt = b.data[4:]
					proof = self.bnls.logonproof(salt)
					self.out.insertRawData(proof)
					p.send(self.out.build(0x54))
					self.p.addchat("yellow",  "[BNET] Sending logon proof...")
					self.log_out("Sending logon proof...")
					#p.plugins.find("ui").frame.tbicon.icon = wx.Icon("img\\pybot32_orange.png", wx.BITMAP_TYPE_PNG)
					#p.plugins.find("ui").frame.tbicon.SetIconImage()
				elif result == 1:
					salt = self.bnls.create(self.username, self.password)
					self.log_out("Recieved salt code from BNLS...")
					self.out.insertRawData(salt)
					self.out.insertString(self.username)
					p.addchat("red", "[BNET] Account does not exist.")
					p.addchat("yellow", "[BNET] Creating account...")
					p.send(self.out.build(0x52))
			else:
				self.log_out("Unknown login response in 0x53.")
			self.bnls.disconnect()

			if (not self.spoof == False) and (self.spoof > 1000):
				self.p.addchat("green", "Spoofing " + str( (self.spoof / 1000) ) + " second ping.")
				time.sleep( (self.spoof / 1000) )
				self.out.insertDWord(b.getDWord())
				p.send(self.out.build(0x25))
		elif (ID == 0x52):
			''' SID_AUTH_ACCOUNTCREATE (WarCraft) '''
			result = b.getDWord()
			info = tr.SID_ACCOUNTCREATE()
			if result in info:
				if result == 0x00:
					self.log_out("Account created.")
					p.addchat("green", "[BNET] Account created!")
					self.die()
				else:
					self.log_out(info[result])
					p.addchat("red", "[BNET] " + info[result])
			else:
				self.log_out("Account does not exist.")
		elif (ID == 0x54):
			''' SID_AUTH_ACCOUNTLOGONPROOF '''
			result = b.getDWord()
			info = tr.SID_LOGONRESULT()
			if result in info:
				if not (result == 2):
					self.out.insertWord(6112)
					p.send(self.out.build(0x45))
					self.out.insertString(self.username)
					self.out.insertString("")
					p.send(self.out.build(0x0a))
					self.log_out("Account information accepted!")
					p.addchat("green", "[BNET] Login accepted!")
				else:
                                        self.p.addchat("red",  "[BNET] %s" % info[result] )
					support.doprint( "[BNET] %s" % info[result] )
			else:
				self.log_out("Unknown version check response in 0x54.")
                elif (ID == 0x3A):
			result = b.getDWord()
			info = tr.SID_LOGONRESPONSE()
			if result in info:
				if result == 0x00:
					self.out.insertString(self.username)
					self.out.insertString("")
					p.send(self.out.build(0x0a))
					self.log_out("Account information accepted!")
					p.addchat("green", "[BNET] Login accepted!")
				else:
                                        self.p.addchat("red",  "[BNET] %s" % info[result] )
					support.doprint( "[BNET] %s" % info[result] )
			else:
				self.log_out("Unknown version check response in 0x3A.")
				
		elif (ID == 0x0A):
			''' SID_ENTERCHAT '''
			self.log_out("Login sequence completed.")
			self.unique = b.getString()
			self.log_out("Logged in as "+self.unique+".")
			self.logintime = support.now()
			p.addchat("green", "[BNET] Logged in as ", "yellow", self.unique, "green", ".")
			self.online = True
                        self.p.plugins.find("ui").set_status('Connected (%(server)s) as %(name)s', name=self.unique)
			
			''' >> EP INFO '''
			self.act_RequestSystemEP()
			
			self.me.name = self.unique
			''' >> SID_REQUESTCHANNELLIST '''
			self.out.insertDWord(0)
			p.send(self.out.build(0x0b))
			''' >> SID_CHANNELJOIN '''
			self.act_EnterChat("PyBot", 0x01)
		elif (ID == 0x26):
			''' SID_READUSERDATA '''
			accounts = b.getDWord()
			keys = b.getDWord()
			id = b.getDWord()
			if id == self.SEPCookie:
                                created = b.getString()
                                logon = b.getString()
                                logoff = b.getString()
                                logged = b.getString()
                                
				p.addchat("#0099CC", "Account Created: %s" % FiletimeToDateTime(created))
				p.addchat("#0099CC", "Last Logon: %s" % FiletimeToDateTime(logon))
				p.addchat("#0099CC", "Last Logoff: %s" % FiletimeToDateTime(logoff))
				p.addchat("#0099CC", "Time Logged: %s" % SecondsToReadable(logged))
		elif (ID == 0x09):
			''' SID_GETADVLISTEX '''
			count = b.getDWord()
			for i in range(0,count):
				gametype = b.getWord()
				param = b.getWord()
				b.getDWord()
				af = b.getWord()
				port = b.getWord()
				ip = b.getDWord()
				b.getDWord()
				b.getDWord()
				status = b.getDWord()
				gametime = b.getDWord()
				gamename = b.getString()
				gamepass = b.getString()
				gamestat = b.getString()
				p.addchat("#0099CC", "%s hosted by %s." % (gamename, str(ip)))
			p.addchat("#0099CC", "End of games list.")
		elif (ID in Unhandled):
			pass
		else:
			support.doprint( "Warning: Packet with ID %s is unhandled by BNCS." % hex(ID) )
		
	def act_EnterChat(self, ID, Mode=0x02):
		''' SID_CHANNELJOIN or SID_ENTERCHAT (/forcejoin) '''
		self.out.insertDWord(Mode)
		self.out.insertString(ID)
		self.p.send(self.out.build(0x0c))
		if (self.home != ""): self.em_SendText("/join %s" % self.home)
		support.execafter( 1, self.act_RequestLists)
		
	def act_RequestLists(self):
		self.p.plugins.find("clan").getClanList()
		
	def act_RequestSystemEP(self):
		## Extended profile of system info
		## /accountinfo
		self.SEPCookie = int(random.randint(1, 500))
		self.out.insertDWord(1)
		self.out.insertDWord(4)
		self.out.insertDWord(self.SEPCookie)
		self.out.insertString(self.username)
		self.out.insertString("System\Account Created")
		self.out.insertString("System\Last Logon")
		self.out.insertString("System\Last Logoff")
		self.out.insertString("System\Time Logged")
		self.p.send(self.out.build(0x26))
			
	def em_SendText(self, text):
		''' SID_SENDTEXT (?)
			* Note: Remove characters under ASCII: 20
		'''
		self.p.em_SendText(text)
		
	def checkConnect(self):
		if not self.online:
			self.p.plugins.find("ui").addchat("yellow", "Reconnecting...")
			self.p.disconnect()
			time.sleep(1)
			self.p.connect()
		
	def __cevent__(self, ID, Data, p):
		if (ID == 0x09) or (ID == 0x02) or (ID == 0x01):
			if Data['username'] == self.unique:
				self.me = support.channelObject( Data['username'], Data['flags'], Data['ping'], Data['text'] )
		elif (ID == 0x07):
			self.mychannel = Data['text']
                        self.p.plugins.find("ui").set_status('Connected (%(server)s) as %(name)s in channel %(chan)s',
                                                           chan= self.mychannel)
		elif (ID == 0x102):
			''' Socket failure? '''
			self.online = False
			self.p.plugins.find("ui").addchat("yellow", "The bot will attempt to reconnect in 5 minutes.")
			support.execafter(301, self.checkConnect)
