""" plugin.py

	Plugin base class. """
	
import sys, os, threading, time, support, datetime
	
class pluginList():
	def __init__(self):
		self.list = []
		self.rl = datetime.datetime.now()
		
	def all(self):
		return self.list
		
	def find(self, entry):
		for p in self.list:
			if p.info["name"].lower() == entry.lower():
				return p.p
		return None
		
	def reloadall(self):
		return None
		
	def count(self, type='all'):
		count = 0
		if type == 'all':
                        return len(self.list)
		for p in self.list:
                        if not hasattr(p, 'flags'):
                                continue
			if type == 'system' and ("s" in p.flags):
				count += 1
			elif type == 'standard' and not ("s" in p.flags):
				count += 1
		return count
		
	def add(self, entry):
		self.list.append( entry )
	
class plugin(threading.Thread):
	def __init__(self, source, p, sppt=False):
		''' Ideally, all plugins should have at least:
			* p.exposed (class)
			  * p.__attr_ (dictionary return)
			  * p.__invoke__ (to decide what to do)
			  * p.__cevent__ (chat event)
			* more classes
			
			The class will send anything raw to the plugins, except for chat events. They have their own function.
		'''
		threading.Thread.__init__(self)
		self.setDaemon(True)
		
		self.issupport = sppt
		self.parent = p
		self.skip = False
		self.running = True
		self.info = {}
		self.source = source
		self.p = None
		self.onlyCE = False
		self.onlyM = False ## Only loads for the oldest bot.
		
		time.sleep(0.01)
		
		try:
			source = __import__(self.source)
			if hasattr(source, 'exposed') == False:
                                #A friendlier message for non-exposed script files
                                self.skip = True
                                support.doprint('Warning: source for %s.py was not loaded because it has no exposed class.' % self.source)
                                del source
                                return None
                        elif source.exposed == None:
                                self.skip = True
                                #exposed variable specifically set to None, so we know it was not a mistake
                                #on the part of script writer. This should not be loaded as a plugin.
                                del source
                                return None
			self.p = source.exposed(p)
			self.info = self.p.__attr__()
		except:
			self.skip = True
			p.addchat( "red", "Warning: source for %s.py could not be loaded:" % self.source )
			support.doprint( "Warning: source for %s.py could not be loaded:" % self.source )
			for line in sys.exc_info():
				p.addchat( "red", " * " + str(line) )
				support.doprint( "   * " + str(line) )
			try:
				del source
			except: pass
			return None
			
		try:
			self.onlyM = self.info["onlymain"]
		except KeyError:
			self.onlyM = False
			
		try:
			self.flags = self.info["flags"]
		except KeyError:
			self.flags = ""

		if (self.onlyM and not p.family.oldest(p)):
			self.skip = True
			support.doprint( "Skipped %s (slave bots do not load this)" % self.source )
			return None

		try:
			self.onlyCE = self.info["chatexplicit"]
			support.doprint( "Loaded%s %s %s by %s." % ({True:" support file", False:""}[self.issupport], self.info["name"],
                                                                 '.'.join(map(str, self.info["version"])),
                                                                  self.info["author"]) )
		except:
			self.skip = True
			p.addchat( "red", "Warning: %s error in file [%s.py]:" % (str(sys.exc_info()[0]), self.source) )
			support.doprint( "Warning: %s error in file [%s.py]:" % (str(sys.exc_info()[0]), self.source) )
			for error in sys.exc_info():
				p.addchat( "red", " * " + str(error) )
				support.doprint( "   * " + str(error) )
			return None
		
		#self.start()
		
	def run(self):
		''' This is to keep the plugin on it's own thread. '''
		while self.running:
			time.sleep(0.04)
