""" main.py

	Loads classes for the bot and plugins.
	
	The only thing that is not a plugin is the connection between the Battle.net server and the bot.

	"""

''' Fix people who aren't running this by a batch file, and
	don't have a Python25/Lib reference. '''
import sys, os, support

support.doprint( " ============== System Startup ==============" )

support.doprint( " * Loading wxPython..." )
try:
	import wx
except:
	support.doprint( " * wxPython could not be loaded, please make sure you installed the correct wx." )

support.doprint( " * Loading winamp..." )
try:
	import winamp
except:
	support.doprint( " * Failed to load winamp controller." )
	
support.doprint( " * Importing plugin folders..." )
try:
	pfolders = ['sppt', 'ui', 'plugins']
	for folder in pfolders:
		sys.path.insert(0, os.path.abspath("./" + folder + "/"))
except:
	support.doprint( "Python will not allow the plugin folder to be added as an import location." )
	sys.exit()
	
import threading, socket
from select import select
import plugin, buffer, time, queue
import proxy

support.doprint( " ============== System Loaded ==============" )

class fakeui():
	# This is way easier than adding a try..catch to everything
	def __init__(self):
		self.info = {
				'name' : 'ui',
				'author' : "",
				'version' : (1, 0),
				'description' : 'LOLFAKE',
				'chatexplicit' : True
				}
		self.p = self
		self.source = 'FAKEUI'
		self.onlyCE = True
		self.flags = "sf"
		
	def __cevent__(self, ID, Data, p):
		pass
	
	def set_status(self, *args, **kwargs):
		pass
		
	def addchat(self, *args, **kwargs):
		pass

class family():
	def __init__(self, nc=False):
		self.children = []
		
	def add(self, cfg):
		bot = pybot(self, cfg)
		print "[INT] Created a new bot handle with %s." % cfg
		
	def rem(self, cfg):
		for c in self.children:
			if c.cfgfile == cfg:
				c.destroy()
				self.children.remove(c)
				print "[INT] Terminated a bot handle with %s." % cfg
				return True
		return False
		
	def brothers(self):
		return len(self.children)-1
		
	def oldest(self, src):
		try:
			if src.cfgfile == self.children[0].cfgfile:
				return True
			else:
				return False
		except IndexError:
			return True
		
	def brotherenum(self, src, onlyops=False):
		ret = []
		for b in self.children:
			if b.solo == "no":
				if (not b.cfgfile == src.cfgfile) and ((onlyops and b.plugins.find("bncs").me.hasFlag(0x02)) or (not onlyops)):
					ret.append(b)
		return ret
		
	def brother(self, src, onlyops=False):
		try:
		## Returns the brother with the lowest queue stress.
			if not src.cfgfile == self.children[0].cfgfile:
				# Only the leader
				return None
			else:
				bro = src
				for b in self.children:
					if (b.solo == "no"):
						if ((onlyops and b.plugins.find("bncs").me.hasFlag(0x02)) or (not onlyops)):
							if (b.queue.qsize() < bro.queue.qsize()):
								bro = b
				return bro
		except IndexError:
			## No brothers, return nothing
			return None
	
class pybot(threading.Thread):
	def __init__(self, family, cfg="pybot.ini"):
		self.cfgfile = cfg
		self.plugins = plugin.pluginList()
		self.vbsplugins = []
		self.queue = queue.queue(self)
		self.command = support.command(cfg)
		self.family = family
		family.children.append(self)
		
		self.debug = False
		
		self.winamp = winamp.Winamp()
	
		''' CONFIG '''
		self.config = support.config(cfg)
		
		''' srs '''
		self.config.set("main", "username", "", False)
		self.config.set("main", "password", "", False)
		self.config.set("main", "cdkey", "", False)
		self.config.set("main", "expcdkey", "", False)
		self.config.set("main", "verbyte", "23", False)
		self.config.set("main", "game", "3RAW", False)
		self.config.set("main", "origin", "USA", False)
		self.config.set("main", "originfull", "United States", False)
		self.config.set("main", "bnls", "alendar.no-ip.org", False)
		self.config.set("main", "bncs", "europe.battle.net", False)
		self.config.set("main", "ui", "yes", False)
		self.config.set("main", "solo", "no", False)
		self.config.set("main", "autoconnect", "yes", False)
		
		''' Proxy '''
		self.config.set("proxy", "server", "", False)
		self.config.set("proxy", "port", "80", False)
		self.config.set("proxy", "type", "socks5", False)
		
		''' other '''
		self.config.set("main", "trigger", ".", False)
		self.solo = self.config.get("main", "solo", "no") # Family-related
		
		''' SETUP '''
		self.socket = socket.socket ( socket.AF_INET, socket.SOCK_STREAM )
		self.socket.settimeout(300.0)
		self.connected = False #socket connected?
		self.execute = True #true as long as something does not want the listening operation to stop
		self.saydisc = False #true if something wants us to tell plugins we disconnected
		self.alive = False #true if the thread was started
		
		self.data = ""
		self.cycle = None
	
		''' PLUGINS '''
		''' Python '''
		self.slave_ui = False
		if (self.config.get("main", "ui") == "no"):
                        self.plugins.list.append(fakeui())
                        try:
                                pfolders.remove("ui")
                        except:
                                pass
                                
                elif not self.family.oldest(self):
                        self.slave_ui = True

		unloaded = 0
		iss = False
		for folder in pfolders:
                        if self.slave_ui and folder == 'ui':
                            try:
                                    for p in self.family.children[0].plugins.list:
                                            if p.info["name"].lower() == 'ui':
                                                    self.plugins.add(p)
                                                    p.p.new_bot(self)
                                                    break
                            except:
                                    pass
                            continue
			if folder in ["sppt", "ui"]:
				iss = True
			else: iss = False
			for file in os.listdir(folder + "/"):
				if file.lower().endswith(".py"):
					name = file[:len(file)-3]
					plug = plugin.plugin(name, self, iss) 
					if (not plug.skip) and not "d" in plug.flags:
						self.plugins.add( plug )
					else:
						unloaded += 1
					del plug
		support.doprint( "Loaded %i (%i system, %i ignored) modules. Type /plugins to view the list." % (len(self.plugins.list), self.plugins.count("system"), unloaded) )

		''' </plugins> '''
		
		threading.Thread.__init__(self)
		
		self.newsctrl = support.news()
		self.pybotmotd = self.newsctrl.retr()
		
		time.sleep(0.5) ## Wait for ui to be initialized
		
		self.addchat("#0099CC", "Welcome to PyBot.")
		self.addchat("#0099CC", "You can download the latest version of PyBot at: http://python.bot.nu/")
		self.addchat("green", "Loaded %i plugins (%i disabled). There are %i system modules loaded as plugins." % (self.plugins.count("standard"), unloaded, self.plugins.count("system")))
		news = self.pybotmotd.split("\n")
		for item in news:
			self.addchat("#00BBFF", item.rstrip("\r"))
		
		if self.config.get("main", "autoconnect", "yes") == "yes":
			self.addchat("yellow", "[PYBOT] Connect on startup...")
			self.connect()
		
	def addchat(self, *args, **kwargs):
                bncs = self.plugins.find('bncs')
                ui = self.plugins.find('ui')
                idx = self.family.children.index(self)
                if idx != 0 and ('which' in kwargs) == False:
                        kwargs['which'] = self
                        if hasattr(bncs, 'unique'):
                                kwargs['caption'] = '%s@%s' % (bncs.unique,
                                                               bncs.server)
                        else:
                                kwargs['caption'] = '%s@%s' % (bncs.username,
                                                               bncs.server)
                kwargs['owner'] = self
                if ui == None:
                        for idx in range(1, len(args), 2):
                                print args[idx]
                else:
                        ui.addchat(*args, **kwargs)
	def connect(self):
		if ("" in [self.config.get("main", "password"), self.config.get("main", "cdkey"), self.config.get("main", "username")]):
			self.addchat("red", "You have not given me enough information to connect.")
			return False
			
		self.disconnect()
		time.sleep(0.25)
		if self.config.get("proxy", "server", "") != "":
			proxytype = self.config.get("proxy", "type", "socks5").lower()
			port = int(self.config.get("proxy", "port", "80"))
			print proxytype
			self.useproxy = True
			pserver = self.config.get("proxy", "server")
			if proxytype == "socks4":
				self.socket = proxy.Socks4Proxy(pserver, port)
			elif proxytype == "socks5":
				self.socket = proxy.Socks5Proxy(pserver, port)
			elif proxytype == "http":
				self.socket = proxy.HTTPProxy(pserver, port)
			else:
				self.addchat("red", "[PROXY] Type not supported.")
				return False
		else:
			self.useproxy = False
			self.socket = socket.socket ( socket.AF_INET, socket.SOCK_STREAM )
			self.socket.settimeout(5.0)
		try:
			if self.useproxy:
				self.addchat("yellow", "[PROXY] Connecting... (routing connection to %s using %s.)" % (self.config.get("main", "bncs"), pserver))
				result = self.socket.proxy_connect( (self.config.get("main", "bncs"), 6112) )
				if result == True:
					self.addchat("green", "[PROXY] Connected and authorized.")
					self.addchat("yellow", "[BNET] Connecting...")
				else:
					self.addchat("red", "[PROXY] Could not connect: %s" % result)
			else:
				self.addchat("yellow", "[BNET] Connecting...")
				self.socket.connect( (self.config.get("main", "bncs"), 6112) )
		except socket.error, socket.herror:
			self.addchat("red", "[BNET] Connection could not be established due to a socket error.")
			self.disconnect()
			return False
		except socket.timeout:
			self.addchat("red", "[BNET] Connection timed out, the server appears to be unavailable.")
			self.disconnect()
			return False
		except:
			self.addchat("red", "[BNET] Socket failure, please check your Battle.net server, router/firewalls, and other potential things that block sockets.")
			self.disconnect()
			return False

		self.socket.settimeout(300.0)
		self.plugins.find("ui").set_status('Connected (%(server)s)', server=self.config.get("main", "bncs"))
		self.connected = True
		self.saydisc = True
		
		''' Make the queue a slow and empty it
			300b is about 5 medium-length messages '''
		self.queue.queue = []
		self.queue.bytes = 300
		
		''' CONNECTION TYPE '''
		self.socket.sendall( chr(0x01) )
		
		''' BEGIN SOCKET '''
		self.globalInvoke(0x104, 0, {})
		if not self.alive:
			self.start()
		else:
			print "No need to start the thread again."
		
	def destroy(self):
		for bot in self.family.children:
			bot.execute = False
			bot.disconnect()
		try:
			wx.CallAfter(sys.exit)
		except: pass
		
	def disconnect(self):
		try:
			self.data = ""
			self.socket.close()
			self.socket = None
			if self.connected:
				self.connected = False
				self.saydisc = True
				self.addchat("red", "All Battle.net connections closed.")
		except:
			pass
			
	def send(self, data):
		i = buffer.pin()
		id = i.unbuild(data)
		## support.doprint( " >> %s [BNCS] %s" % (hex(id), str(i.length)) )
		self.socket.sendall( data )
		
	def bot_AddQ(self, text, priority):
		self.queue.addq(text, priority)
		
	def bot_WhisperUser(self, username, text, d2=''):
		self.queue.addq("/w %s%s %s" % (d2, username, text))
		
	def em_SendText(self, text):
		''' SID_SENDTEXT (?)
			* Note: Remove characters under ASCII: 20
		'''
		output = ''
		for char in text:
				if ord(char) > 20:
						output += char
		out = buffer.pout()
		if (len(output) > 223):
				self.addchat("red", "Output too large: %s" % output)
				return None
		if not self.plugins.find("bncs").online:
			if len(output) > 0: self.addchat("red", "Offline: %s" % output)
			return None
		print "OUT",output
		if (len(output) > 0):
				out.insertString(str(output))
				self.send(out.build(0x0e))
		self.pluginSay(0x05, {"username" : self.plugins.find("bncs").unique, "flags" : 0, "ping" : 0, "text" : output})
        
	def recieve(self, ID, Length, Data):
		# support.doprint( " << %s [BNCS] %s" % (hex(ID), str(Length))
		self.globalInvoke(ID, Length, Data)
		
	def globalInvoke(self, ID, Length, Data):
		eventID = 0x0
		eventCMD = False
		for plugin in self.plugins.all():
			try:
				if (ID == 0x0F):
					''' Chat event '''
					b = buffer.pin()
					b.unbuild(Data)
					eventID = b.getDWord()
					eventData = {"flags":b.getDWord(), "ping":b.getDWord()}
					eventLegacy = [b.getDWord(), b.getDWord(), b.getDWord()]
					eventData["username"] = b.getString()
					eventData["text"] = b.getString()
					if (eventID == 0x12):
						self.queue.tryremban(eventData["text"])
						
						## Append ban count to messages
						if support.match(eventData["text"], ".*was banned by*"):
							bc = 1
							try:
								oper = eventData['text'].split(" ")[4].rstrip(".")
								for banned, op in self.plugins.find("op").bans.items():
									if oper.lower() == op.lower(): bc += 1
							except: bc = 0
							if bc > 1: eventData['text'] += " [%i]" % bc
						## Append original ban author to messages
						elif support.match(eventData["text"], ".*was unbanned by*"):
							banby = "?"
							try:
								for banned, op in self.plugins.find("op").bans.items():
									if banned.lower() == eventData['text'].split(" ")[0].lower():
										banby = op
							except: pass
							if (banby != "?"): eventData['text'] += " [%s]" % banby
						elif eventData['text'] == "Welcome to Battle.net!":
							self.addchat("#0099CC", "You are connected to an official Battle.net server.")
							return None
						##
					if (eventID in [0x04, 0x05]): #and (eventCMD == False):
						cmds = self.command.iscommand(eventData['text'], self, self.plugins.find("bncs").me.flags)
						if (not cmds == False):
							for plug in self.plugins.all():
								plug.p.__cevent__(eventID, eventData, self)
							if eventID == 0x05: id = 1
							if eventID == 0x04: id = 3
							for cmd in cmds:
								self.pluginSay( 0x101, (eventData['username'], eventData['flags'], cmd, id) )
							#eventCMD = True
							break
					plugin.p.__cevent__(eventID, eventData, self)
				else:
					''' Packet event '''
					if not plugin.onlyCE: plugin.p.__invoke__(ID, Length, Data, self)
			except IOError as e:
				support.doprint( "* File error [Event " + hex(ID) + "] in " + plugin.source )
				self.addchat("red", "[PLUG] Generic IOError in %s: " % plugin.source)
				for line in sys.exc_info():
					self.addchat("red", "[PLUG]  * " + str(line))
					support.doprint( "    * " + str(line) )
				for item in e.__dict__:
					self.addchat("red", "[PLUG]  ** " + item + ": " + str(e.__dict__[item]))
					support.doprint( "    > " + item + ": " + str(e.__dict__[item]) )
				if self.debug:
					self.addchat("red", "[PLUG] Raising IOError to console...")
					raise e
				break
			except:
				support.doprint( "* Plugin error [Event " + hex(ID) + "; Chat Event " + hex(eventID) + "] in " + plugin.source )
				self.addchat("red", "[PLUG] Event " + hex(ID) + "; Chat Event " + hex(eventID) + " in " + plugin.source)
				for line in sys.exc_info():
					support.doprint( "    * " + str(line) )
					self.addchat("red", "    * " + str(line))
				if self.debug:
					self.addchat("red", "[PLUG] Raising error to console...")
					raise
				break
				
	def pluginConsoleText(self, text):
		veto = False
		tab = self.plugins.find('ui').nb_main.page_current()[1]
		if len(text) > 2 and (type(tab) != str or (tab != "PyNet" and tab.find("Whisper: ") == -1)):
			if text[:1] == "/" and (not text[:2] == "//"):
				me = self.plugins.find("bncs").me
				cmds = self.command.iscommand(text, self, me.flags, flist=["/"])
				if (not cmds == False):
					for cmd in cmds:
						if self.pluginSay( 0x101, ("~console", me.flags, cmd, 4) ):
							veto = True
			if text[:2] == "//":
				me = self.plugins.find("bncs").me
				cmds = self.command.iscommand(text, self, me.flags, flist=["//"])
				if (not cmds == False):
					for cmd in cmds:
						if self.pluginSay( 0x101, ("~console", me.flags, cmd, 5) ):
							veto = True

		try:
			self.pluginSay(0x103, (tab, text, veto))
		except AttributeError:
			pass
		except:
			print sys.exc_info()
				
	def pluginSay(self, ID, *Data):
		if len(Data) == 1:
			Data = Data[0]
		v = False
		for plugin in self.plugins.all():
			if (ID != 0x101) or ((ID == 0x101) and "c" in plugin.flags):
				self.veto = False
				if plugin.p.__cevent__(ID, Data, self):
					v = True
					self.veto = False
				if self.veto:
					v = True
					self.veto = False
		return v
		
	def run(self):
		self.alive = True
		while self.execute:
			while self.connected:
				r = select([self.socket], [], [self.socket], 420)
				if r[0] == []: #Nothing to read in 420 seconds
					#Send SID_NULL to test connection
					self.socket.sendall('\xff\x00\x04\x00')
				if self.socket in r[2]: #Error
					support.doprint("Socket error")
					self.addchat("red", "[BNET] The remote connection has timed out.")
					self.disconnect()
					break
				try:
					data = self.socket.recv(2048)
					if data == "":
						self.addchat("red", "[BNET] The remote connection sent blank data, this is a sign of the socket closing.")
						self.disconnect()
						break
					if not self.connected:
						break
					self.data += data
				except:
					self.addchat("red", "[BNET] Connection stream has been interrupted.")
					support.doprint( "Stream stopped?!" )
					self.disconnect()
					break
					
				if not self.data:
					self.disconnect()
				elif len(self.data) > 0:
					b = buffer.pin()
					id = int(b.unbuild(self.data))
					if len(self.data) == int(b.length): #perfect size
						self.recieve(id, b.length, self.data)
						self.data = ''
					elif len(self.data) >= int(b.length): #over sent, cut off the stuff we want and leave the rest for next iteration
						while len(self.data) >= int(b.length):
							self.recieve(id, b.length, self.data[:b.length])
							self.data = self.data[b.length:]
							id = int(b.unbuild(self.data))
			if self.saydisc:
				support.doprint( "Disconnected by socket failure." )
				self.pluginSay(0x102, [])
				self.saydisc = False
			else:
				time.sleep(0.04)
		support.doprint( " ============== System Terminated Safely ==============" )
''' <--- '''
