""" language.py

	Support for other languages and also holds longer dictionary listings that bulk up other files.
	"""
	
class spanish:
	def __init__(self):
		''' The sad results of a few years of forgotten spanish + google translate '''
		pass
		
	def GEN_RESPONSES(self):
		return {'access_modify_noflag' : "%s now has access %i.",
				'access_modify' : "%s now has access %i and flags \"%s\".",
				'access_toolow' : "You do not have enough access to do that.",
				'access_safe' : "That user is safelisted.",
				'error_param' : "Invalid number of parameters (%i); expected at least %i.",
				'error_nf' : "There was nothing found matching \"%s\".",
				'generic_enabled' : "%s is now enabled. %s"}
		
	def CLAN_RANKCODES(self, type='names'):
		if type == 'names':
			return {0x00 : "pe(243)n (iniciado)",
					0x01 : "pe(243)n",
					0x02 : "miembro",
					0x03 : "oficial",
					0x04 : "jefe"}
		elif type == 'articles':
			return {0x00 : "un %s en",
					0x01 : "un %s en",
					0x02 : "un %s en",
					0x03 : "un %s de",
					0x04 : "el %s de"}
	
	def SID_AUTHCHECK(self):
		return {0x000:"(161)Pasiste la parada de la versi(243)n!",
				0x001:"La versi(243)n de la juego es viejo.",
				0x101:"La versi(243)n de la juego es inv(225)lido.",
				0x102:"La versi(243)n de la juego es inv(225)lido porque es nueva.",
				0x200:"El llave de el juego es inv(255)lido.",
				0x201:"El llave de el juego es inv(255)lido porque %(info)s lo usa",
				0x202:"El llave de el juego est(255) excluido.",
				0x203:"El llave de el juego es para un juego otro."}
				
	def SID_ACCOUNTERROR(self):
		return {0x00:"Account check successful, sending proof.",
				0x01:"Your account does not exist.",
				0x05:"Your account requires an upgrade."}
				
	def SID_ACCOUNTCREATE(self):
		return {0x00:"Account created!",
				0x04:"Username already exists.",
				0x07:"Username is too short.",
				0x08:"Username has illegal characters.", 
				0x09:"Username has illegal word.",
				0x0a:"Username does not have enough alpha-numerical characters.",
				0x0b:"Username has adjacent punctuation.",
				0x0c:"Username has too much punctuation."}
				
	def SID_LOGONRESULT(self):
		return {0x00:"Logon successful!",
				0x02:"Incorrect password.",
				0x0e:"This account needs a registered email."}
        def SID_LOGONRESPONSE(self):
                return {0x00: 'Logon successful!',
                        0x01: 'Account does not exist',
                        0x02: 'Invalid password',
                        0x06: 'Account closed'}
class english:
	def __init__(self):
		pass
		
	def GEN_RESPONSES(self):
		return {'access_modify_noflag' : "%s now has access %i.",
				'access_modify' : "%s now has access %i and flags \"%s\".",
				'access_toolow' : "You do not have enough access to do that.",
				'access_safe' : "That user is safelisted.",
				'error_param' : "Invalid number of parameters (%i); expected at least %i.",
				'error_nf' : "There was nothing found matching \"%s\".",
				'generic_enabled' : "%s is now enabled. %s"}
		
	def CLAN_RESPONSECODES(self):
		return {0x00 : "The operation succeeded.",
				0x01 : "The requested name is in use.",
				0x02 : "You attempted the operation too soon.",
				0x03 : "There are not enough members to continue.",
				0x04 : "The invitation was declined.",
				0x05 : "One or more members declined.",
				0x06 : "One or more members accepted.",
				0x07 : "You are not authorized to do that.",
				0x08 : "User not found.",
				0x09 : "The clan is full.",
				0x0A : "Invalid clan tag.",
				0x0B : "Invalid clan name.",
				0x0C : "User is not a member of that clan."
				}
		
	def CLAN_RANKCODES(self, type='names'):
		if type == 'names':
			return {0x00 : "Peon",
					0x01 : "Peon (demoted)",
					0x02 : "Grunt",
					0x03 : "Shaman",
					0x04 : "Chieftain"}
		elif type == 'articles':
			return {0x00 : "a %s in",
					0x01 : "a %s in",
					0x02 : "a %s in",
					0x03 : "a %s of",
					0x04 : "the %s of"}
		
	def SID_AUTHCHECK(self):
		return {0x000:"Version check passed!",
				0x001:"Game version out of date.",
				0x101:"Invalid game version.",
				0x102:"Game version newer than server's.",
				0x200:"Invalid CDKey.",
				0x201:"Your CDKey is in use by %(info)s.",
				0x202:"Your CDKey is banned.",
				0x203:"Your CDKey is for another game."}
				
	def SID_ACCOUNTERROR(self):
		return {0x00:"Account check successful, sending proof.",
				0x01:"Your account does not exist.",
				0x05:"Your account requires an upgrade."}
				
	def SID_ACCOUNTCREATE(self):
		return {0x00:"Account created!",
				0x04:"Username already exists.",
				0x07:"Username is too short.",
				0x08:"Username has illegal characters.", 
				0x09:"Username has illegal word.",
				0x0a:"Username does not have enough alpha-numerical characters.",
				0x0b:"Username has adjacent punctuation.",
				0x0c:"Username has too much punctuation."}
				
	def SID_LOGONRESULT(self):
		return {0x00:"Logon successful!",
				0x02:"Incorrect password.",
				0x0e:"This account needs a registered email."}
        def SID_LOGONRESPONSE(self):
                return {0x00: 'Logon successful!',
                        0x01: 'Account does not exist',
                        0x02: 'Invalid password',
                        0x06: 'Account closed'}			
class french:
	def __init__(self):
		pass
		
	def GEN_RESPONSES(self):
		return {'access_modify_noflag' : "%s now has access %i.",
				'access_modify' : "%s now has access %i and flags \"%s\".",
				'access_toolow' : "You do not have enough access to do that.",
				'access_safe' : "That user is safelisted.",
				'error_param' : "Invalid number of parameters (%i); expected at least %i.",
				'error_nf' : "There was nothing found matching \"%s\".",
				'generic_enabled' : "%s is now enabled. %s"}
		
	def CLAN_RESPONSECODES(self):
		return {0x00 : "The operation succeeded.",
				0x01 : "The requested name is in use.",
				0x02 : "You attempted the operation too soon.",
				0x03 : "There are not enough members to continue.",
				0x04 : "The invitation was declined.",
				0x05 : "One or more members declined.",
				0x06 : "One or more members accepted.",
				0x07 : "You are not authorized to do that.",
				0x08 : "User not found.",
				0x09 : "The clan is full.",
				0x0A : "Invalid clan tag.",
				0x0B : "Invalid clan name.",
				0x0C : "User is not a member of that clan."
				}
		
	def CLAN_RANKCODES(self, type='names'):
		if type == 'names':
			return {0x00 : "Peon",
					0x01 : "Peon (demoted)",
					0x02 : "Grunt",
					0x03 : "Shaman",
					0x04 : "Chieftain"}
		elif type == 'articles':
			return {0x00 : "a %s in",
					0x01 : "a %s in",
					0x02 : "a %s in",
					0x03 : "a %s of",
					0x04 : "the %s of"}
		
	def SID_AUTHCHECK(self):
		return {0x000:"Version check passed!",
				0x001:"Game version out of date.",
				0x101:"Invalid game version.",
				0x102:"Game version newer than server's.",
				0x200:"Invalid CDKey.",
				0x201:"Your CDKey is in use by %(info)s.",
				0x202:"Your CDKey is banned.",
				0x203:"Your CDKey is for another game."}
				
	def SID_ACCOUNTERROR(self):
		return {0x00:"Account check successful, sending proof.",
				0x01:"Your account does not exist.",
				0x05:"Your account requires an upgrade."}
				
	def SID_ACCOUNTCREATE(self):
		return {0x00:"Account created!",
				0x04:"Username already exists.",
				0x07:"Username is too short.",
				0x08:"Username has illegal characters.", 
				0x09:"Username has illegal word.",
				0x0a:"Username does not have enough alpha-numerical characters.",
				0x0b:"Username has adjacent punctuation.",
				0x0c:"Username has too much punctuation."}
				
	def SID_LOGONRESULT(self):
		return {0x00:"Logon successful!",
				0x02:"Incorrect password.",
				0x0e:"This account needs a registered email."}

        def SID_LOGONRESPONSE(self):
                return {0x00: 'Logon successful!',
                        0x01: 'Account does not exist',
                        0x02: 'Invalid password',
                        0x06: 'Account closed'}
class german:
	def __init__(self):
		pass
		
	def GEN_RESPONSES(self):
		return {'access_modify_noflag' : "%s now has access %i.",
				'access_modify' : "%s now has access %i and flags \"%s\".",
				'access_toolow' : "You do not have enough access to do that.",
				'access_safe' : "That user is safelisted.",
				'error_param' : "Invalid number of parameters (%i); expected at least %i.",
				'error_nf' : "There was nothing found matching \"%s\".",
				'generic_enabled' : "%s is now enabled. %s"}
		
	def CLAN_RESPONSECODES(self):
		return {0x00 : "The operation succeeded.",
				0x01 : "The requested name is in use.",
				0x02 : "You attempted the operation too soon.",
				0x03 : "There are not enough members to continue.",
				0x04 : "The invitation was declined.",
				0x05 : "One or more members declined.",
				0x06 : "One or more members accepted.",
				0x07 : "You are not authorized to do that.",
				0x08 : "User not found.",
				0x09 : "The clan is full.",
				0x0A : "Invalid clan tag.",
				0x0B : "Invalid clan name.",
				0x0C : "User is not a member of that clan."
				}
		
	def CLAN_RANKCODES(self, type='names'):
		if type == 'names':
			return {0x00 : "Peon",
					0x01 : "Peon (demoted)",
					0x02 : "Grunt",
					0x03 : "Shaman",
					0x04 : "Chieftain"}
		elif type == 'articles':
			return {0x00 : "a %s in",
					0x01 : "a %s in",
					0x02 : "a %s in",
					0x03 : "a %s of",
					0x04 : "the %s of"}
		
	def SID_AUTHCHECK(self):
		return {0x000:"Version check passed!",
				0x001:"Game version out of date.",
				0x101:"Invalid game version.",
				0x102:"Game version newer than server's.",
				0x200:"Invalid CDKey.",
				0x201:"Your CDKey is in use by %(info)s.",
				0x202:"Your CDKey is banned.",
				0x203:"Your CDKey is for another game."}
				
	def SID_ACCOUNTERROR(self):
		return {0x00:"Account check successful, sending proof.",
				0x01:"Your account does not exist.",
				0x05:"Your account requires an upgrade."}
				
	def SID_ACCOUNTCREATE(self):
		return {0x00:"Account created!",
				0x04:"Username already exists.",
				0x07:"Username is too short.",
				0x08:"Username has illegal characters.", 
				0x09:"Username has illegal word.",
				0x0a:"Username does not have enough alpha-numerical characters.",
				0x0b:"Username has adjacent punctuation.",
				0x0c:"Username has too much punctuation."}
				
	def SID_LOGONRESULT(self):
		return {0x00:"Logon successful!",
				0x02:"Incorrect password.",
				0x0e:"This account needs a registered email."}
        def SID_LOGONRESPONSE(self):
                return {0x00: 'Logon successful!',
                        0x01: 'Account does not exist',
                        0x02: 'Invalid password',
                        0x06: 'Account closed'}			
class mandarin():
	pass
	
class arabic():
	pass
	
class leet():
	pass
