""" default.py

	Contains values the bot uses as a reference, and may change depending on preference. """

'''

single pound comment = note
		Should be greenish.
double pound comment = needs to be implemented
		My editor makes it light blue? Check it.

'''

import support

def flagList():
	return {
		"a" : ("bot admin", "An administrative entity to the bot."),
		"b" : ("shitlisted", "Flagged as unwanted, and to be banned immediately."), 
		"s" : ("safelisted", "Flagged as respected, and to be ignored when collecting bans."),
		"o" : ("operator", "An operator entity to the bot."),
		"i" : ("access ignored", "Ignoring access to bypass groups."),
		"r" : ("rotating shaman", "A shaman entity to the bot, promote when possible."),
		"f" : ("fixed", "This user's access is locked in place.")
		}

def flagInfo(flag):
	flags = flagList()
	if flag in flags:
		return flags[flag]
	else:
		return ("flag " + flag, "No information for flag '" + flag + "'.")

def create(name, access=40, aliases=[], help="No documentation for %s", syntax="<trigger>%s"):
	h = help.replace("%s", name)
	s = syntax.replace("%s", name)
	config = support.config('commands.ini')
	config.set("access", name, str(access), False)
	config.set("help", name, h, False)
	config.set("syntax", name, s, False)
	if len(aliases) > 0:
		for alias in aliases:
			config.set("aliases", alias, name, False)
		
def readall(section='access'):
	config = support.config('commands.ini')
	r = {}
	keys = config.config.items(section)
	for key, value in keys:
		try:
			r[key] = int(value)
		except:
			r[key] = value
	return r
		
def commands():
	a = readall()
	b = {
		## For Console's Eyes Only...
		"next" : 201, #winamp
		"back" : 201, #winamp
		## Owner
		"google" : 200, #duh
		"quit" : 100, #duh
		"disconnect" : 100, #LOL I KNOW?
		"reconnect" : 100, #duh
		"exec" : 100, # This is not like StealthBot's, it will only let you do math.
		"family" : 100, #Returns other bots
		"irc" : 100, #Irc subcommand
		"reloadplugins" : 100,
		"findclaninactive" : 100,
		## In between
		## Operative
		"loadban" : 80, #Bye loads
		"matchban" : 80, #Like a color by numbers, but with bans!
		"pymatchban" : 80,
		"sleep" : 80, #Clear bans
		"cb" : 80, #SweepBan
		"pycb" : 80, #PyNet SweepBan
		"cs" : 80, #SweepSquelch
		"queuetype" : 80, #duh
		"calculate" : 80, #google math
		"kick" : 70, #<|>
		"ban" : 70, #<|>
		"timeban" : 70,
		"mp3" : 70, #winamp
		"unban" : 70, #<|>
		"accept" : 70, #for clans
		"decline" : 70, # " "
		"scope" : 70,
		"bancount" : 60, #returns # of users banned by a certain person
		"yield" : 60,
		## General-tools
		"say" : 60, #duh
		"yell" : 60, #caps lock is cruise control for cool
		"megaphone" : 80,
		"plugins" : 60, #duh
		"join" : 60, #duh
		"rejoin" : 60, #duh
		"home" : 60, #joins home channel
		## General-info
		"set" : 60, #userlist
		"rem" : 60, #userlist
		"note" : 60, #userlist
		"shitlist" : 60, #list of shit
		"safelist" : 60, #list of safe
		"groups" : 60,
		"clans" : 60,
		"flags" : 60,
		"cq" : 60, #clears the queue
		"scq" : 60, #clears the queue like a mutha fuckin ninja yo
		"soundex" : 60, #testing command
		## Random & Fun
		"choice" : 50, #lady luck
		"shuffle" : 50, #lady luck
		"roll" : 50, #lady luck
		"flip" : 50, #lady luck
		"ping" : 50, #ping you!
		"pingme" : 50, #no, ping you!
		"uptime" : 50,
		"md5" : 50,
		## Db
		"trigger" : 40, #duh
		"version" : 40, #PyBot baby!
		"about" : 40,
		"whoami" : 40, #tells you who YOU are
		"whois" : 40, #tells you about someone else
		"where" : 40, #tells you where the bot is
		"time" : 40,
		"help" : 40
		}
	return support.combinedict(a, b)
		
def help():
	a = readall("help")
	b = {
		## For Console's Eyes Only...
		"next" : "skips forward in winamp",
		"back" : "skips backward in winamp",
		"google" : "conducts a google search",
		"quit" : "closes the bot and all connections open",
		"disconnect" : "disconnects the bot",
		"reconnect" : "reconnects the bot",
		"exec" : "allows you to execute small python codes",
		"family" : "responds with all bots on the process",
		"irc" : "used to process commands targeting irc",
		"reloadplugins" : "reloads all plugins; defunct",
		"loadban" : "enables loadban, which will try to ban as many bots as possible that are in your channel",
		"matchban" : "enables ban-by-match",
		"pymatchban" : "enables ban-by-match using PyNet to process them",
		"sleep" : "disables any lockdown, anti-flood or netting commands",
		"cb" : "bans everyone in the specified channel",
		"pycb" : "bans everyone in the specified channel using PyNet to process them",
		"cs" : "squelches everyone in the specified channel",
		"queuetype" : "sets the type of the queue",
		"calculate" : "requests a google calculator search",
		"kick" : "kicks a user from the channel; if they are in the internal list, it will assume names",
		"ban" : "bans a user from the channel; if they are in the internal list, it will assume names",
		"mp3" : "responds with the current Winamp track playing",
		"unban" : "unbans a user from the channel; if they are in the internal list, it will assume names",
		"accept" : "accepts a clan invitation",
		"decline" : "declines a clan invitation",
		"bancount" : "returns the number of bans the specified operator has made, or if no one is specified, the whole channel's bancount",
		"say" : "echos the arguments back to you",
		"yell" : "echos the arguments back to you in all capital letters",
		"plugins" : "responds with a list of currently loaded plugin modules",
		"join" : "orders the bot to join a channel",
		"rejoin" : "orders the bot to rejoin the channel; this command will mirror battle.net's if the bot has operator flags",
		"home" : "orders the bot to return to it's home channel if set",
		"set" : "adds or modifies a user entry within the userlist",
		"rem" : "removes a user from the userlist",
		"shitlist" : "responds with a list of users that have flags 'b'",
		"safelist" : "responds with a list of users that have flags 's'",
		"cq" : "clears the bot's queue and responds with how many messages and bytes were flushed",
		"scq" : "silently clears the bot's queue",
		"soundex" : "compares two phrases to see if they are alike",
		"choice" : "chooses an item from a list",
		"shuffle" : "shuffles a list of items into a random sequence",
		"roll" : "virtually rolls a pair of dice",
		"flip" : "virtually flips a coin",
		"ping" : "responds with the specified user's ping at login",
		"pingme" : "responds with your ping at login",
		"trigger" : "responds with the current trigger of the bot; you may use '?' as a trigger for this command only",
		"version" : "responds with the current version of the bot",
		"whoami" : "tells you your access and flags",
		"whois" : "tells you the access and flags of the specified user",
		"where" : "responds with the location of the bot and it's current status in that channel",
		"help" : "you're retarded",
		"time" : "returns the time and date on the host computer",
		"uptime" : "returns the bot's connection uptime",
		"timeban" : "bans someone for a specified period of time; (eg. <trigger>timeban Bob 30 m) bans for 30 minutes",
		"note" : "sets or gets a user's notes",
		"about" : "returns the bot version and the system environment",
		"scope" : "scopes a user to see if they have other accounts in the channel",
		"md5" : "uses the md5 hashing algorithm on the arguments you provide",
		"groups" : "returns the the groups in the internal userlist",
		"clans" : "returns the clans in the internal userlist",
		"findclaninactive" : "locates a clan's Battle.net status page and returns users who have been offline for 30 or more days",
		"flags" : "returns a list of recognized PyBot flags",
		"megaphone" : "repeats a message 4 times if the queue permits",
		"yield" : "yields to automatic 6th senses that turn load protections on"
		}
	return support.combinedict(a, b)
			
def syntax():
	a = readall("syntax")
	b = {
		"next" : "<trigger>next",
		"back" : "<trigger>back",
		"google" : "<trigger>google <query-->",
		"quit" : "<trigger>quit",
		"disconnect" : "<trigger>disconnect",
		"reconnect" : "<trigger>reconnect",
		"exec" : "<trigger>exec <statement-->",
		"family" : "<trigger>family",
		"irc" : "<trigger>irc <operator> <arguments-->",
		"reloadplugins" : "<trigger>reloadplugins",
		"loadban" : "<trigger>loadban [expression]",
		"matchban" : "<trigger>matchban [expression]",
		"pymatchban" : "<trigger>pymatchban [expression]",
		"sleep" : "<trigger>sleep",
		"cb" : "<trigger>cb <channel>",
		"pycb" : "<trigger>pycb <channel>",
		"cs" : "<trigger>cs <channel>",
		"queuetype" : "<trigger>queuetype <type>",
		"calculate" : "<trigger>calculate <statement-->",
		"kick" : "<trigger>kick <username> [reason--]",
		"ban" : "<trigger>ban <username> [reason--]",
		"mp3" : "<trigger>mp3",
		"unban" : "<trigger>unban <username>",
		"accept" : "<trigger>accept <clan tag>",
		"decline" : "<trigger>decline <clan tag>",
		"bancount" : "<trigger>bancount [username]",
		"say" : "<trigger>say [statement--]",
		"yell" : "<trigger>yell <statement-->",
		"plugins" : "<trigger>plugins",
		"join" : "<trigger>join <channel-->",
		"rejoin" : "<trigger>rejoin",
		"home" : "<trigger>home",
		"set" : "<trigger>set <username> [access, flags or group--]",
		"rem" : "<trigger>rem <username>",
		"shitlist" : "<trigger>shitlist",
		"safelist" : "<trigger>safelist",
		"cq" : "<trigger>cq",
		"scq" : "<trigger>scq",
		"soundex" : "<trigger>soundex <expression A> <expression B>",
		"choice" : "<trigger>choice <items-->",
		"shuffle" : "<trigger>shuffle <items-->",
		"roll" : "<trigger>roll [[min] <max>]",
		"flip" : "<trigger>flip",
		"ping" : "<trigger>ping <username>",
		"pingme" : "<trigger>pingme",
		"trigger" : "?trigger",
		"version" : "<trigger>version",
		"whoami" : "<trigger>whoami",
		"whois" : "<trigger>whois <username>",
		"where" : "<trigger>where",
		"help" : "<trigger>help <command>",
		"time" : "<trigger>time",
		"uptime" : "<trigger>uptime",
		"timeban" : "<trigger>timeban <username> <modifier> <duration>",
		"note" : "<trigger>note <username> [notes]",
		"about" : "<trigger>about",
		"scope" : "<trigger>scope <username>",
		"md5" : "<trigger>md5 <query-->",
		"groups" : "<trigger>groups",
		"clans" : "<trigger>clans",
		"findclaninactive" : "<trigger> [[clan tag] [azeroth|lordaeron|kalimdor|northrend]]",
		"megaphone" : "<trigger>megaphone [statement--]",
		"yield" : "<trigger>yield"
		}
	return support.combinedict(a, b)
			
def aliases():
	a = readall("aliases")
	b = {
		"add" : "set",
		"del" : "rem",
		"find" : "whois",
		"ver" : "version",
		"info" : "version",
		"eval" : "exec",
		"math" : "exec",
		"calc" : "calculate",
		"convert" : "calculate",
		"cv" : "calculate",
		"p" : "ping",
		"k" : "kick",
		"b" : "ban",
		"q" : "quit",
		"v" : "version",
		"lb" : "loadban",
		"mb" : "matchban",
		"sweepban" : "cb",
		"sweepsquelch" : "cs",
		"zzz" : "sleep",
		"mp4" : "mp3",
		"ogg" : "mp3",
		">>" : "next",
		"<<" : "back",
		"bu" : "banunban",
		"kb" : "kickban",
		"rp" : "reloadplugins",
		"mod" : "set",
		"modify" : "set",
		"setaccess" : "set",
		"setflags" : "set",
		"setflag" : "set"
		}
	return support.combinedict(a, b)