""" bnls.py

	This is not a plugin because it is classified as a support class. It is 
	invoked like the support.py classes. This is not only easier, but it will
	force the parent to hang while it gets the data. Also, other plugins may
	want to use this class to do other stuff for their own plugin. """

import buffer, socket, time
import support
from hashing import *
from struct import pack

BNLS_codes = {'RATS': 0x01,
              'PXES': 0x02,
              'NB2W': 0x03,
              'VD2D': 0x04,
              'PX2D': 0x05,
              'RTSJ': 0x06,
              '3RAW': 0x07,
              'PX3W': 0x08}

class BNLS():
	def __init__(self, server, cfg="pybot.ini"):
		self.config = support.config(cfg)
		self.socket = socket.socket ( socket.AF_INET, socket.SOCK_STREAM )
		self.server = server
		self.connected = False
		self.data = ""
		self.out = buffer.pout()
		self.out.clear()

		self.config.set("hashing", "keylocal", "yes", False)
		self.config.set("hashing", "passlocal", "yes", False)
		
		self.nls = ''
		
	def disconnect(self):
		try:
			self.socket.close()
		except:
			pass
		self.connected = False
		print "[BNLS] Connection terminated"
		
	def connect(self):
		print "[BNLS] Connecting to %s..." % self.server
		try:
			self.socket = socket.socket ( socket.AF_INET, socket.SOCK_STREAM )
			self.socket.connect( (self.server, 9367) )
			self.connected = True
			print "[BNLS] Connected!"
		except:
			self.connected = False
			print "[BNLS] Could not connect to BNLS"
		return self.connected

	def recv(self):
                self.data = ""
                b = buffer.pin()
		while self.connected:
			try:
				self.data += self.socket.recv(1024)
			except:
				self.die()
			if len(self.data) > 0:
				b.unbuild(self.data, True)
				return b
			else:
				time.sleep(0.05)
		
	def hashcdkey(self, servertoken, key):
                if self.config.get("hashing", "keylocal", "yes") == "yes":
                        try:
                                client_token = int(time.time())
                                key_len = len(key)
                                if key_len == 13:
                                        x = cdkey.num(self, key)
                                elif key_len == 16:
                                        x = cdkey.alphanum(self, key)
                                        #if self.bot.connfig['login']['product'] in ['D2XP', 'W3XP']:
                                        #    x2 = cdkey.alphanum(self, self.bot.connfig['login']['expcdkey'])
                                        #    self.exp_update(x2)
                                elif key_len == 26:
                                        x = cdkey.alphanumex(self, key)
                                        #if self.bot.connfig['login']['product'] in ['D2XP', 'W3XP']:
                                        #    x2 = cdkey.alphanumex(self, self.bot.connfig['login']['expcdkey'])
                                        #    self.exp_update(x2)
                                else:
                                        return ""
                            
                                r = x.get_key_hash(client_token,
                                                   servertoken)
                                key_hash = pack('9l',
                                                key_len,
                                                x.get_product(),
                                                x.get_val1(),
                                                0,
                                                *r)
                        except ValueError, key: #invalid
                                return ""
                        else:
                                return (client_token, key_hash)
                else:
                        ''' Hashes your CDKey. '''
                        self.out.insertDWord(servertoken)
                        self.out.insertString(key)
                        self.socket.sendall(self.out.build(0x01, True))

                        b = self.recv()
                        if b.getDWord() == 1:
                                return (b.getDWord(), ''.join(self.data[11:]))
                        else:
                                return ''
        def double_xsha1(self, pw, ckey, skey):
                a = xsha1.calc_hash_buffer(pw.lower())
                bu = pack('<2L5l', ckey,
                          skey,
                          *a)
                b = xsha1.calc_hash_buffer(bu)
                return pack('<5l', *b)

        def single_xsha1(self, pw):
                a = xsha1.calc_hash_buffer(pw)
                return pack('<5l', *a)
				
	def gamechecksum(self, game, mpqfiletime, mpqname, formula):
		''' Sends your game code, the mpq, and the mpq data
			and gets back data needed for 0x51 '''
		self.out.insertDWord(BNLS_codes[game])
		self.out.insertDWord(0)
		self.out.insertDWord(0)
		self.out.insertRawData(mpqfiletime)
		self.out.insertString(mpqname)
		self.out.insertString(formula)
		self.socket.sendall(self.out.build(0x1a, True))

		b = self.recv()
		if b.getDWord() == 1:
                        ver = b.getDWord()
			checksum = b.getDWord()
			versionstring = b.getString()
			return (ver, checksum, versionstring)
		else:
			return ''
				
	def logonchallenge(self, username, password):
                if self.config.get("hashing", "passlocal", "yes") == "yes":
                        self.srp = srp.SRP(username,
                                           password)
                        
                        return srp.big_num_to_str(self.srp.get_A())
                else:
                        if self.nls != 1: #Set NLS version if not the default
                                self.socket.sendall( pack('<H', 7) + chr(0x0d) + pack('<L', self.nls))
                                if not self.recv().getDWord(): #Failed to find NLS version
                                        return ""
                                
                        ''' Sends your username and password and gets
                                the data needed for 0x53 '''
                        self.out.insertString(username)
                        self.out.insertString(password)
                        self.socket.sendall(self.out.build(0x02, True))

                        return self.recv().data
				
	def logonproof(self, data):
                if self.config.get("hashing", "passlocal", "yes") == "yes":
                        salt = data[:32]
                        ckB = data[32:]
                        
                        self.srp.B = srp.str_to_big_num(ckB)

                        self.srp.get_v(salt)
                        self.srp.get_u(ckB)
                        self.srp.get_S(salt,
                                       self.srp.B)
                        self.srp.get_K(srp.big_num_to_str(self.srp.S))
                        self.srp.get_M1(salt,
                                        ckB)
                        
                        M1 = self.srp.M1
                        del self.srp
                        #print M1.encode('hex')
                        return M1
                        
                else:
                        ''' Sends the data from 0x53 to bnls and
                                gets the data for 0x54 '''
                        self.out.insertRawData(data)
                        self.socket.sendall(self.out.build(0x03, True))
                        
                        return self.recv().data
				
	def create(self, name, password):
		''' Sends the data from 0x53 to bnls and
			gets the data for 0x54 '''
		self.out.insertString(name)
		self.out.insertString(password)
		self.socket.sendall(self.out.build(0x04, True))

		return self.recv().data
