using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;

namespace IFABot
{
    /// <summary>
    /// Plugin template for IFABot program.
    /// More information: http://www.ifa-france.com/ifabot
    /// </summary>
    /// <remarks>Namespace "IFABot" and class name "IFABotPlugin" have not to be changed.</remarks>
    public class IFABotPlugin
    {
        #region PLUGIN INFORMATION
        private static String _plugin_name = "My plugin";
        private static String _plugin_description = "My plugin does this, this and this.";
        private static String _plugin_bnet_infos = "Commands list:  !cmd1  !cmd2";
        private static String _plugin_irc_infos = "Commands list:  !cmd1  !cmd2";
        #endregion

        #region REQUIRED METHODS
        /// <summary>
        /// Gets plugin name.
        /// </summary>
        /// <returns>Returns the name of this plugin.</returns>
        /// <remarks>This method cannot be deleted or replaced.</remarks>
        public static String GetPluginName()
        {
            return _plugin_name;
        }

        /// <summary>
        /// Gets plugin description.
        /// </summary>
        /// <returns>Returns the description of this plugin.</returns>
        /// <remarks>This method cannot be deleted or replaced.</remarks>
        public static String GetPluginDescription()
        {
            return _plugin_description;
        }

        /// <summary>
        /// Gets plugin Battle.net infos.
        /// </summary>
        /// <returns>Returns information for Battle.net about this plugin (ex: implemented commands list).</returns>
        /// <remarks>This method cannot be deleted or replaced.</remarks>
        public static String GetPluginBNETInfos()
        {
            return _plugin_bnet_infos;
        }

        /// <summary>
        /// Gets plugin IRC infos.
        /// </summary>
        /// <returns>Returns information for IRC about this plugin (ex: implemented commands list).</returns>
        /// <remarks>This method cannot be deleted or replaced.</remarks>
        public static String GetPluginIRCInfos()
        {
            return _plugin_irc_infos;
        }

        /// <summary>
        /// Formats return structure containing messages to send.
        /// <param name="bnet_messages">List of Battle.net messages to send.</param>
        /// <param name="irc_messages">List of IRC messages to send.</param>
        /// </summary>
        /// <returns>Returns the correct messages structure.</returns>
        private static String[][] SendMessages(ArrayList bnet_messages, ArrayList irc_messages)
        {
            return new String[][] { (String[])bnet_messages.ToArray(typeof(String)), (String[])irc_messages.ToArray(typeof(String)) };
        }

        /// <summary>
        /// Formats return structure containing messages to send after command processing.
        /// <param name="bnet_messages">List of Battle.net messages to send.</param>
        /// <param name="irc_messages">List of IRC messages to send.</param>
        /// <param name="is_valid_command">Whether or not the command was valid.</param>
        /// </summary>
        /// <returns>Returns the correct messages structure after command processing.</returns>
        private static String[][] SendMessagesFromCommand(ArrayList bnet_messages, ArrayList irc_messages, Boolean is_valid_command)
        {
            return new String[][] { (String[])bnet_messages.ToArray(typeof(String)), (String[])irc_messages.ToArray(typeof(String)), new String[] { (is_valid_command) ? "1" : "0" } };
        }

        /// <summary>
        /// Formats return empty structure.
        /// </summary>
        /// <returns>Returns a correct empty structure.</returns>
        private static String[][] SendMessages()
        {
            return new String[][] { };
        }
        #endregion

        #region BNET EVENTS
        /// <summary>
        /// Processes a command from Battle.net.
        /// Command format: !xxxxxx [params]
        /// </summary>
        /// <param name="username">Player sending the command.</param>
        /// <param name="ping">Ping player.</param>
        /// <param name="command">Uppercased command without "!" prefix.</param>
        /// <param name="text">Text that follows the command.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC, the third array of strings contains a single string whether or not the command is valid.</returns>
        /// <remarks>SendMessagesFromCommand method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] BNET_ProcessCommands(String username, int ping, String command, String text)
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();
            Boolean is_valid_command = false;

            if (command == "SAMPLE")
                bnet_messages.Add("/w " + username + " This is a sample plugin for IFABot.");

            return SendMessagesFromCommand(bnet_messages, irc_messages, is_valid_command);
        }

        /// <summary>
        /// Triggers when IFABot just connected to Battle.net.
        /// </summary>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] BNET_EventOnConnect()
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when IFABot just disconnected from Battle.net.
        /// </summary>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] BNET_EventOnDisconnect()
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when IFABot just failed to connect to Battle.net.
        /// </summary>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] BNET_EventOnFailConnecting()
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when IFABot has retreived current players of a Battle.net channel.
        /// </summary>
        /// <param name="username">Player in the Battle.net channel.</param>
        /// <param name="game">Client type used by player.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] BNET_EventOnInChannel(String username, String game)
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when a player has joined the Battle.net channel.
        /// </summary>
        /// <param name="username">Player joining the Battle.net channel.</param>
        /// <param name="game">Client type used by player.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] BNET_EventOnJoin(String username, String game)
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when a player has left the Battle.net channel.
        /// </summary>
        /// <param name="username">Player leaving the Battle.net channel.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] BNET_EventOnLeave(String username)
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when a player has talked in the Battle.net channel.
        /// </summary>
        /// <param name="username">Player talking in the Battle.net channel.</param>
        /// <param name="text">Player message.</param>
        /// <param name="ping">Player ping.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] BNET_EventOnTalk(String username, String text, int ping)
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when a player has talked in emote mode (/me) in the Battle.net channel.
        /// </summary>
        /// <param name="username">Player talking in the Battle.net channel.</param>
        /// <param name="text">Player message.</param>
        /// <param name="ping">Player ping.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] BNET_EventOnEmote(String username, String text, int ping)
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when IFABot has entered a Battle.net channel.
        /// </summary>
        /// <param name="channel">Battle.net joined channel.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] BNET_EventOnEnterChannel(String channel)
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when IFABot has been whispered.
        /// </summary>
        /// <param name="username">Player whispering IFABot.</param>
        /// <param name="text">Player message.</param>
        /// <param name="ping">Player ping.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] BNET_EventOnWhisper(String username, String text, int ping)
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when IFABot just whispered a player.
        /// </summary>
        /// <param name="username">Whisperer player.</param>
        /// <param name="text">IFABot message.</param>
        /// <param name="ping">IFABot ping.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] BNET_EventOnWhisperSend(String username, String text, int ping)
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when Battle.net has sent information messages.
        /// </summary>
        /// <param name="text">Information message.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] BNET_EventOnInfo(String text)
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when Battle.net has sent error messages.
        /// </summary>
        /// <param name="text">Error message.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] BNET_EventOnError(String text)
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }
        #endregion

        #region IRC EVENTS
        /// <summary>
        /// Processes a command from IRC.
        /// Command format: !xxxxxx [params]
        /// </summary>
        /// <param name="username">User sending the command.</param>
        /// <param name="command">Uppercased command without "!" prefix.</param>
        /// <param name="text">Text that follows the command.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC, the third array of strings contains a single string whether or not the command is valid.</returns>
        /// <remarks>SendMessagesFromCommand method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] IRC_ProcessCommands(String username, String command, String text)
        {
            ArrayList irc_messages = new ArrayList();
            ArrayList bnet_messages = new ArrayList();
            Boolean is_valid_command = false;

            return SendMessagesFromCommand(bnet_messages, irc_messages, is_valid_command);
        }

        /// <summary>
        /// Triggers when IFABot just connected to IRC.
        /// </summary>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] IRC_EventOnConnect()
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when IFABot just disconnected from IRC.
        /// </summary>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] IRC_EventOnDisconnect()
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when IFABot just failed to connect to IRC.
        /// </summary>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] IRC_EventOnFailConnecting()
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when a whois information is received.
        /// </summary>
        /// <param name="username">User "whoised".</param>
        /// <param name="auth_name">User authentification name.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] IRC_EventOnWhois(String username, String auth_name)
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when a list of users is received.
        /// </summary>
        /// <param name="channel">Channel where are listed users.</param>
        /// <param name="users_list">Users list.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] IRC_EventOnNames(String channel, String users_list)
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when a user has quit IRC.
        /// </summary>
        /// <param name="username">User quitting IRC.</param>
        /// <param name="reason">Optional text set by user when quitting IRC.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] IRC_EventOnQuit(String username, String reason)
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when a user has changed his nickname on IRC.
        /// </summary>
        /// <param name="username">Current user nickname.</param>
        /// <param name="new_nick">New user nickname.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] IRC_EventOnNick(String username, String new_nick)
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when a user has left the IRC channel.
        /// </summary>
        /// <param name="username">User leaving the IRC channel.</param>
        /// <param name="channel">IRC channel user has left.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] IRC_EventOnPart(String username, String channel)
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when a user has joined the IRC channel.
        /// </summary>
        /// <param name="username">User joining the IRC channel.</param>
        /// <param name="channel">IRC channel user has joined.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] IRC_EventOnJoin(String username, String channel)
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when a user has been kicked by another user from the IRC channel.
        /// </summary>
        /// <param name="kicker">User who kicked from the IRC channel.</param>
        /// <param name="channel">IRC channel in which kick occurred.</param>
        /// <param name="kicked">User kicked from the IRC channel.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] IRC_EventOnKick(String kicker, String channel, String kicked)
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when a user has talked in the IRC channel.
        /// </summary>
        /// <param name="username">User talking in the IRC channel.</param>
        /// <param name="channel">IRC channel in which user has talked.</param>
        /// <param name="message">User message.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] IRC_EventOnTalkChannel(String username, String channel, String message)
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }

        /// <summary>
        /// Triggers when a user has talked in emote mode (/me) in the IRC channel.
        /// </summary>
        /// <param name="username">User talking in the IRC channel.</param>
        /// <param name="channel">IRC channel in which user has talked.</param>
        /// <param name="message">User message.</param>
        /// <returns>An array of arrays of strings: the first array of strings contains the messages that will be sent to Battle.net, the second array of strings contains the messages that will be sent to IRC.</returns>
        /// <remarks>SendMessages method can be used to easily return messages structure to IFABot.</remarks>
        public static String[][] IRC_EventOnEmote(String username, String channel, String message)
        {
            ArrayList bnet_messages = new ArrayList();
            ArrayList irc_messages = new ArrayList();

            return SendMessages(bnet_messages, irc_messages);
        }
        #endregion
    }
}
