Attribute VB_Name = "War3_SCLogin"

Option Explicit

Public aProfile() As xyzBot
'sets our type as an array for multiple profiles
Public Type xyzBot
  BNETServer As String 'bnet server connecting to
  CDKey As String 'cdkey for profile
  CDKeyExpansion As String 'for d2 expan or w3 expan
  ClientToken As Long 'logon item
  Connected As Boolean 'is connected to bnet
  Email1 As String 'if not null send recovery email to this..UNLESS
  Email2 As String 'this contains data as well as 1, then change email recovery address
  GameClient As String 'client
  Name As String 'username
  NewPass As String 'if not vbnullstring change pass
  NLS As Long 'logon item
  OldNLS As Long 'logon item
  Pass As String 'password to username
  Proxy As String 'if not vbnullstring connect to this proxy
  RealName As String 'unique name
  ServerToken As Long 'logon item
  Socksified As Boolean 'socks use granted (proxy), auto true if not using a proxy
  StrBuffer As String 'for data parsing
End Type
'login data


Public Sub ParseBNCS(Data As String, Index As Integer, PacketID As Byte)

  If Not aProfile(Index).Connected Then
    Select Case PacketID
      Case &H4C, &H25, &HF, &H7D, &H7F, &H75, &H7A, &HA, &H3D, &H59
      'ones to ignore
      Case Else
        AddC vbGreen, "[" & chngDisplayIndex(Index) & "] <- Recieved 0x" & Hex(PacketID)
    End Select
  End If
  'shows packet recieved
  'coded by Fleet-

  Select Case PacketID
    Case &H59:           RegisterAccountEmail PacketID, Index 'send registration email
    Case &H7C:           'parses w3 clan motd
    Case &H72:           'parses clan creation invites (recieved invite from bla)
    Case &H70:           'parses clan tag availability checking
    Case &H77:           'invite acceptance reply
    Case &H78:           'clan member removal status
    Case &H7F:           'clan member status update
    Case &H7D:           'clan member list
    Case &H75, &H7A:     'clan rank update
    Case &HF:            handleChatEvent Data, Index 'standard joins leaves talk ect
    Case &H0:            PBuffer.sendPacket &H0, Index 'stay alive
    Case &H25:           If aProfile(Index).Connected Then frmMain.wS(Index).SendData Data 'stayalive again
    Case &HA:            Parse0x0A Data, Index 'final login part for sc/w3
    Case &H79:           'join clan invitation recieved
    Case &H50:           Parse0x50 Data, Index 'send key hash sc/w3
    Case &H51:           Parse0x51 Data, Index 'key hash reply
    Case &H3A:           Parse0x3A Data, Index 'login reply (sc)
    Case &H31:           Parse0x31 Data, Index 'account password change reply (sc)
    Case &H3D:           Parse0x3D Data, Index 'account creation reply (sc)
    Case &H52:           Parse0x52 Data, Index 'account creation reply (w3)
    Case &H53:           Parse0x53 Data, Index 'login auth (w3)
    Case &H54:           Parse0x54 Data, Index 'login auth proof (w3)
    Case &H55:           Parse0x55 Data, Index 'pass change auth (w3)
    Case &H56:           Parse0x56 Data, Index 'pass change auth proof (w3)
    Case Else:           'do nothing!
  End Select

End Sub
'handles packets to said functions/subs


Private Sub Parse0x0A(Data As String, Index As Integer)
  
  GetRealName Data, Index
  'gets unique name
  aProfile(Index).Connected = True
  'sets as connected
  aProfile(Index).ServerToken = 0
  aProfile(Index).ClientToken = 0
  'wipes these, no longer needed
  AddC vbGreen, "[" & chngDisplayIndex(Index) & "] --- Bnet: Logon complete, joining home channel."
  'chat

End Sub
'parse unique name response and finishes SC/W3 logon


Private Sub Parse0x3D(Data As String, Index As Integer)

  If Mid$(Data, 5, 1) = vbNullChar Then
    AddC vbGreen, "[" & chngDisplayIndex(Index) & "] --- Bnet: Account creation successful."
    'Send0x3A Index
    'logs in SC
  Else
    'AddC vbYellow, "[" & chngDisplayIndex(Index) & "] --- Bnet: Account creation failed."
    'frmMain.wS(Index).Close
  End If

End Sub
'account creation reply SC

Private Sub Parse0x3A(Data As String, Index As Integer)

  Select Case Asc(Mid$(Data, 5, 1))
    Case &H1
      AddC vbGreen, "[" & chngDisplayIndex(Index) & "] --- Bnet: Account doesn't exist, reconnect"
      Exit Sub
    Case &H2
      AddC vbYellow, "[" & chngDisplayIndex(Index) & "] --- Bnet: Logon failed"
    Case &H0
      With PBuffer
        .InsertNTString aProfile(Index).Name
        .InsertBYTE 0
        .sendPacket &HA, Index
        'to gather real name
        .InsertDWORD 2
        .InsertNTString "Clan Cell" '// this would be your home channel
        .sendPacket &HC, Index
      End With
      'send enter chat packet
      Exit Sub
  End Select
  
  DisconnectProfile Index
  
End Sub
'parse sc login

Private Sub Send0x3D(Index As Integer)

  With PBuffer
    .InsertNonNTString hashPassword(aProfile(Index).Pass)
    .InsertNTString aProfile(Index).Name
    .sendPacket &H3D, Index
  End With
  
End Sub
'creates an account for SC


Private Sub GetRealName(Data As String, Index As Integer)
Dim Spltn() As String
  
  Spltn() = Split(Data, vbNullChar, 5)
  aProfile(Index).RealName = Spltn(1)
  Erase Spltn()
  'sets real name

End Sub
'gets unique name (all clients)

Private Sub Parse0x52(Data As String, Index As Integer)
  
  Select Case PBuffer.GetDWORD(Mid$(Data, 5, 4))
    Case &H0
      AddC vbGreen, "[" & chngDisplayIndex(Index) & "] --- Bnet: Account creation successful."
      Send0x53 Index
    Case Else
      AddC vbYellow, "[" & chngDisplayIndex(Index) & "] --- Bnet: Account creation failed."
      DisconnectProfile Index
  End Select

End Sub
'account creation reply (w3)

Private Sub Parse0x50(Data As String, Index As Integer)
Dim mpqNumber As Long, ChecksumFormula As String
Dim EXEVersion As Long, Checksum As Long, EXEInfo As String
Dim PublicValue As Long, ProductValue As Long
Dim KeyHash As String * 20, mpqName As String
Dim lDecoder As Long
  
  aProfile(Index).ServerToken = PBuffer.GetDWORD(Mid$(Data, 9, 4))
  
  mpqName = Mid$(Data, InStr(1, Data, "ver-IX86-"), Len(Data))
  mpqName = Left$(mpqName, InStr(1, mpqName, ".mpq") + 3)
      
  mpqNumber = Mid$(mpqName, 10, 1) '\new code
   
  If mpqNumber < 0 Then
    AddC vbYellow, "[" & chngDisplayIndex(Index) & "] --- Bnet: Couldn't extract MPQ number"
    DisconnectProfile Index
    Exit Sub
  End If
  'mpqnumber failed
  
  ChecksumFormula = Mid$(Data, InStr(1, Data, "ver-IX86-") + 15, Len(Data)) '\new code
  
  Dim sFile(2) As String
  
  If aProfile(Index).GameClient = "NB2W" Then
    sFile(0) = "\Hashes\w2bn\Warcraft II BNE.exe"
    sFile(1) = "\Hashes\w2bn\Storm.dll"
    sFile(2) = "\Hashes\w2bn\Battle.snp"
    'sets files w2
  ElseIf Len(aProfile(Index).CDKey) = 13 Then
    sFile(0) = "\Hashes\star\Starcraft.exe"
    sFile(1) = "\Hashes\star\Storm.dll"
    sFile(2) = "\Hashes\star\Battle.snp"
    'sets files sc/bw
  ElseIf Len(aProfile(Index).CDKey) = 26 Then
    sFile(0) = "\Hashes\war3\War3.exe"
    sFile(1) = "\Hashes\war3\Storm.dll"
    sFile(2) = "\Hashes\war3\Game.dll"
    'sets files w3
  ElseIf aProfile(Index).GameClient = "VD2D" Or aProfile(Index).GameClient = "PX2D" Then
    sFile(0) = "\hashes\d2dv\Game.exe"
    sFile(1) = "\hashes\d2dv\bnclient.dll"
    sFile(2) = "\hashes\d2dv\d2client.dll"
    'd2 client
  End If
    
  If Not checkRevision(ChecksumFormula, App.Path & sFile(0), App.Path & sFile(1), App.Path & sFile(2), mpqNumber, Checksum) Then
    If Len(aProfile(Index).CDKey) = 13 Then
      AddC vbYellow, "[" & chngDisplayIndex(Index) & "] --- Bnet: Missing Starcraft / Broodwar hashes."
      'need hashes sc
    ElseIf aProfile(Index).GameClient = "NB2W" Then
      AddC vbYellow, "[" & chngDisplayIndex(Index) & "] --- Bnet: Missing Warcraft 2 hashes."
      'war2
    ElseIf aProfile(Index).GameClient = "VD2D" Or aProfile(Index).GameClient = "PX2D" Then
      AddC vbYellow, "[" & chngDisplayIndex(Index) & "] --- Bnet: Missing Diablo 2 hashes."
      'war2
    Else
      AddC vbYellow, "[" & chngDisplayIndex(Index) & "] --- Bnet: Missing Warcraft 3 hashes."
      'war3
    End If
    'check hash type for mesasge
    DisconnectProfile Index
    Exit Sub
  End If
  'bad hashes

  EXEVersion = getExeInfo(App.Path & sFile(0), EXEInfo)
  If (EXEVersion = 0) Then
    AddC vbYellow, "[" & chngDisplayIndex(Index) & "] --- Bnet: Couldn't obtain EXE version."
    DisconnectProfile Index
    Exit Sub
  End If
  'couldnt get exe version
  
  If kd_quick(aProfile(Index).CDKey, aProfile(Index).ClientToken, aProfile(Index).ServerToken, PublicValue, ProductValue, KeyHash, 20) = 0 Then
    AddC vbYellow, "[" & chngDisplayIndex(Index) & "] --- Bnet: Couldn't decode cdkey."
    DisconnectProfile Index
    Exit Sub
  End If
  'decode cdkey (  1  )
  
  Dim sKeyHolder As String
  sKeyHolder = "b001"
  '// change later to read from config (key in use by)
  
  With PBuffer
    .InsertDWORD aProfile(Index).ClientToken
    .InsertDWORD EXEVersion
    .InsertDWORD Checksum
    '----------
    If aProfile(Index).GameClient = "PX3W" Or aProfile(Index).GameClient = "PX2D" Then
      .InsertDWORD &H2 'keys sending (  2  )
    Else
      .InsertDWORD &H1 'keys sending (  1  )
    End If
    'how many keys being sent
    .InsertDWORD &H0 'Not using spawn.
    .InsertDWORD Len(aProfile(Index).CDKey)
    .InsertDWORD ProductValue
    .InsertDWORD PublicValue
    .InsertDWORD 0
    .InsertNonNTString KeyHash
    'key hash (  1  )
    If aProfile(Index).GameClient = "PX3W" Or aProfile(Index).GameClient = "PX2D" Then
      'if then
      PublicValue = 0
      ProductValue = 0
      KeyHash = vbNullString
      'just incase
      If kd_quick(aProfile(Index).CDKeyExpansion, aProfile(Index).ClientToken, aProfile(Index).ServerToken, PublicValue, ProductValue, KeyHash, 20) = 0 Then
        AddC vbYellow, "[" & chngDisplayIndex(Index) & "] --- Bnet: Couldn't decode cdkey[2]."
        DisconnectProfile Index
        Exit Sub
      End If
      'decode cdkey (  2  )
      .InsertDWORD Len(aProfile(Index).CDKeyExpansion)
      .InsertDWORD ProductValue
      .InsertDWORD PublicValue
      .InsertDWORD 0
      .InsertNonNTString KeyHash
      'key hash (  2  )
    End If
    'if expansion hash the second key
    .InsertNTString EXEInfo
    .InsertNTString "<SomeChat> " & sKeyHolder
    .sendPacket &H51, Index
  End With
  'sends!

  'c// 0x51 sent | client
    
End Sub
'sends hashes, and cdkey hash


Private Sub Send0x53(Index As Integer)
Dim Var_A As String * 32

  If aProfile(Index).NLS = 0 Then
    aProfile(Index).NLS = nls_init(aProfile(Index).Name, aProfile(Index).Pass)
    If aProfile(Index).NLS = 0 Then
      'c// couldnt load NLS protocols
      DisconnectProfile Index
      Exit Sub
    End If
  End If
  'couldnt initialize NLS
  
  Call nls_get_A(aProfile(Index).NLS, Var_A)
  'retrieve "public ephermeral value" 'A'
  
  With PBuffer
    .InsertNonNTString Var_A
    .InsertNTString aProfile(Index).Name
    .sendPacket &H53, Index
  End With
  
End Sub
'send w3 login


Private Sub Parse0x51(Data As String, Index As Integer)
  
  Select Case PBuffer.GetDWORD(Mid$(Data, 5, 4))
    Case &H0
      PBuffer.InsertNonNTString "tenb" '// reverse tenb for plug (doesnt work for w3)
      PBuffer.sendPacket &H14, Index
      'udp
      
      If LenB(aProfile(Index).Email1) <> 0 Then
        If LenB(aProfile(Index).Email2) <> 0 Then
          Send0x5B Index
        'change address
        Else
          Send0x5A Index
          'send packet and exit sub and null entry
        'recover
        End If
        'send packets
        aProfile(Index).Email1 = vbNullString
        aProfile(Index).Email2 = vbNullString
        'reset variables
      End If
      'if reg back / email change
      
      If LenB(aProfile(Index).NewPass) = 0 Then
        If aProfile(Index).GameClient = "3RAW" Or aProfile(Index).GameClient = "PX3W" Then
          Send0x53 Index
          'send w3 login
        Else
          Send0x3D Index 'creates sc account
          'send create before this, since we cant send 0x3A after creation
          'doesnt matter if account pre-exist no harm will come
          Send0x3A Index 'send sc logon
          'send sc login
        End If
        'not a pass change
      Else
        If aProfile(Index).GameClient = "3RAW" Then
          Send0x55 Index
          'changes w3 pass
        Else
          Send0x31 Index 'change passwword sc
        End If
        'change pass
        Exit Sub
      End If
      'if pass change exit sub, dont process email change and pass change at once
      
      Exit Sub
    'cdkey is good send logon
    Case &H100
      AddC vbRed, "1"
      'c// old product version
    Case &H101
      AddC vbRed, "2"
      'c// invalid product version
    Case &H200
      AddC vbRed, "3"
      'c// invalid cdkey
    Case &H201
      Dim SS1() As String, sKeyInUseBy As String
      SS1() = Split(Data, vbNullChar)
      If UBound(SS1) > 2 Then sKeyInUseBy = SS1(3)
      'sets key in use by
      'c// key in use by & sKeyInUseBy
    Case &H202
      AddC vbRed, "4"
      'c// cdkey is banned
    Case &H203
      AddC vbRed, "5"
      'c// cdkey meant for another product
  End Select

  DisconnectProfile Index
  'if we're here something went wrong
  
End Sub
'cdkey check reply

Private Sub Send0x5A(Index As Integer)
    
  AddC vbGreen, "[" & chngDisplayIndex(Index) & "] --- Bnet: Account registration recovery sent."
  'chat
  PBuffer.InsertNTString aProfile(Index).Name
  PBuffer.InsertNTString aProfile(Index).Email1
  PBuffer.sendPacket &H5A, Index

End Sub
'recovers an account

Private Sub Send0x5B(Index As Integer)
    
  AddC vbGreen, "[" & chngDisplayIndex(Index) & "] --- Bnet: Account registration email change sent."
  'chat
  PBuffer.InsertNTString aProfile(Index).Name
  PBuffer.InsertNTString aProfile(Index).Email1
  PBuffer.InsertNTString aProfile(Index).Email2
  PBuffer.sendPacket &H5B, Indax

End Sub
'changes email registration address


Private Sub Send0x3A(Index As Integer)
  
  With PBuffer
    .InsertDWORD aProfile(Index).ClientToken
    .InsertDWORD aProfile(Index).ServerToken
    .InsertNonNTString doubleHashPassword(aProfile(Index).Pass, aProfile(Index).ClientToken, aProfile(Index).ServerToken)
    .InsertNTString aProfile(Index).Name
    .sendPacket &H3A, Index
  End With
  
End Sub
'send logon SC

Private Sub Send0x55(Index As Integer)
Dim A As String * 32
    
  aProfile(Index).NLS = nls_init(aProfile(Index).Name, aProfile(Index).Pass)
  If aProfile(Index).NLS = 0 Then
    'c// couldnt initialize nls
    DisconnectProfile Index
    Exit Sub
  End If
  'start nls
    
  With PBuffer
    Call nls_get_A(aProfile(Index).NLS, A)
    .InsertNonNTString A
    .InsertNTString aProfile(Index).Name
    .sendPacket &H55, Index
  End With
  
End Sub
'request to change a pass to a W3 account, auth

Private Sub Parse0x55(Data As String, Index As Integer)
Dim ServerKey As String, Salt As String, NewPW As String
Dim NewNLS As Long, OutputBuffer As String * 84
    
  Select Case Asc(Mid$(Data, 5, 1))
    Case &H0
      'okay for change, trying
    Case &H1
      'c// account doesnt exist
      DisconnectProfile Index
      Exit Sub
    Case &H5
      'c// account requiers upgrade
      DisconnectProfile Index
      Exit Sub
    Case Else
      'c// unhandled response
      DisconnectProfile Index
      Exit Sub
  End Select
    
  Salt = Mid$(Data, 9, 32)
  ServerKey = Mid$(Data, 41, 32)
  
  NewPW = aProfile(Index).NewPass
  NewNLS = nls_account_change_proof(aProfile(Index).NLS, OutputBuffer, NewPW, ServerKey, Salt)
    
  If NewNLS = 0 Then
    AddC vbYellow, "[" & chngDisplayIndex(Index) & "] --- Bnet: Couldn't create account password change packet."
    DisconnectProfile Index
    Exit Sub
  End If
    
  aProfile(Index).OldNLS = aProfile(Index).NLS
  aProfile(Index).NLS = NewNLS
        
  PBuffer.InsertNonNTString OutputBuffer
  PBuffer.sendPacket &H56, Index
  
End Sub

Private Sub Parse0x31(Data As String, Index As Integer)
  
  If Mid$(Data, 5, 1) = vbNullChar Then
    AddC vbYellow, "[" & chngDisplayIndex(Index) & "] --- Bnet: Account password change failed."
    'failed
    DisconnectProfile Index
  Else
    AddC vbGreen, "[" & chngDisplayIndex(Index) & "] --- Bnet: Account password change successful."
    'change good
    aProfile(Index).Pass = aProfile(Index).NewPass
    aProfile(Index).NewPass = vbNullString
    'reset
    Send0x3A Index
    'finish logon
  End If
  
End Sub
'account password change reply SC

Private Sub Send0x31(Index As Integer)

  AddC vbGreen, "[" & chngDisplayIndex(Index) & "] --- Bnet: Attempting to change account password."
  
  With PBuffer
    .InsertDWORD aProfile(Index).ClientToken
    .InsertDWORD aProfile(Index).ServerToken
    .InsertNonNTString doubleHashPassword(aProfile(Index).Pass, aProfile(Index).ClientToken, aProfile(Index).ServerToken)
    .InsertNonNTString hashPassword(aProfile(Index).NewPass)
    .InsertNTString aProfile(Index).Name
    .sendPacket &H31, Index
  End With
  
End Sub
'sends password change request SC

Private Sub Parse0x56(Data As String, Index As Integer)
Dim M2 As String
  
  
  Select Case Asc(Mid$(Data, 5, 1))
    Case &H0
      M2 = Mid$(Data, 9, 20)
      If (nls_check_M2(aProfile(Index).OldNLS, M2, vbNullString, vbNullString) = 0) Then
        AddC vbYellow, "[" & chngDisplayIndex(Index) & "] --- Bnet: Server account password change proof failed."
        'always pops some reason...
        DisconnectProfile Index
      End If
      'free old nls
      'free nls since we're going to pop it again
      If aProfile(Index).OldNLS <> 0 Then
        Call nls_free(aProfile(Index).OldNLS)
        aProfile(Index).OldNLS = 0
      End If
      AddC vbGreen, "[" & chngDisplayIndex(Index) & "] --- Bnet: Account password change successful."
      'chat
      aProfile(Index).Pass = aProfile(Index).NewPass
      aProfile(Index).NewPass = vbNullString
      'resets
      Send0x53 Index
      'send logon
    Case &H2
      'c// incorrect old pass
      DisconnectProfile Index
    Case Else
      'c// unhandled error
      DisconnectProfile Index
  End Select

End Sub
'pass change authproof reply w3


Private Sub Parse0x53(Data As String, Index As Integer)

  Select Case PBuffer.GetDWORD(Mid$(Data, 5, 4))
    Case &H0: 'Logon accepted
    Case &H1
      AddC vbGreen, "[" & chngDisplayIndex(Index) & "] --- Bnet: Account doesn't exist, creating."
      Send0x52 Index
      Exit Sub
    'account doesnt exist, create
    Case &H5
      AddC vbRed, "1"
      'c// accoutn requires upgrade
      Exit Sub
    Case Else
      AddC vbRed, "2"
      'c// not handled
      Exit Sub
  End Select
  
  Dim M1 As String * 20, Salt As String, Var_B As String

  Salt = Mid$(Data, 9, 32)
  Var_B = Mid$(Data, 41, 32)
     
  Call nls_get_M1(aProfile(Index).NLS, M1, Var_B, Salt)
  'get password proof
  
  With PBuffer
    .InsertNonNTString M1
    .sendPacket &H54, Index
  End With

End Sub
'logon auth reply W3

Private Sub Send0x52(Index As Integer)
Dim sBuffer As String, lBuffer As Long
  
  lBuffer = 65 + Len(aProfile(Index).Name)
  sBuffer = String$(lBuffer, vbNullChar) ' Initialize buffer
  'prep
  If nls_account_create(aProfile(Index).NLS, sBuffer, lBuffer) = 0 Then
    'c// old product version
    Exit Sub
  End If
  'old product version?
  
  With PBuffer
    .InsertNonNTString sBuffer
    .sendPacket &H52, Index
  End With
  
End Sub
'creates a w3 account

Private Sub RegisterAccountEmail(lPacketID As Byte, Index As Integer)
  
  'PBuffer.InsertNTString "someemail@okay.com" '// replace with correct data
  'PBuffer.sendPacket lPacketID, Index

End Sub
'registers an account to an email

Private Sub Parse0x54(Data As String, Index As Integer)
Dim pReply As Long

  pReply = PBuffer.GetDWORD(Mid$(Data, 5, 4))
  'stores case
  Select Case pReply
    Case &H0, &HE
      FreeNLS Index
      'release nls
      If pReply = &HE Then RegisterAccountEmail &HE, Index
      'send email registration
      Send0xABC Index
      Exit Sub
    'allset
    Case &H2
      AddC vbYellow, "[" & chngDisplayIndex(Index) & "] --- Bnet: Account closed, or invalid password."
      'prolly invalid pass
    Case Else
      AddC vbYellow, "[" & chngDisplayIndex(Index) & "] --- Bnet: Unhandled logon failure."
      'yep
  End Select
  
  DisconnectProfile Index
  'logon failed
  
End Sub
'logon proof reply W3

Private Sub Send0xABC(Index As Integer)
  
  With PBuffer
    .InsertNTString aProfile(Index).Name
    .InsertBYTE &H0
    .sendPacket &HA, Index
    .InsertNonNTString "3RAW"
    .sendPacket &HB, Index
    .InsertDWORD &H2 '&h1
    .InsertNTString "Clan Cell" 'L  for client channel
    .sendPacket &HC, Index
  End With

End Sub
'w3 conection successful,enter chat

Public Sub Send0x50(Index As Integer)

  frmMain.wS(Index).SendData ChrW$(1)
  'client protocol
    
  With PBuffer
    .InsertDWORD &H0
    .InsertNonNTString "68XI" & aProfile(Index).GameClient
        
    Select Case aProfile(Index).GameClient
      Case "3RAW", "PX3W":     .InsertDWORD "&H14" 'w3
      Case "VD2D", "PX2D":     .InsertDWORD "&H0B" 'd2/d2xp
      Case "PXES", "RATS":     .InsertDWORD "&HCF" 'sc/bw
      Case "NB2W":             .InsertDWORD "&H4F" 'w2 '// change to read from config later (for all verbytes)
    End Select
    'verbyte

    .InsertDWORD &H0
    .InsertDWORD &H0
    .InsertDWORD &H0
    .InsertDWORD &H0
    .InsertDWORD &H0
    .InsertNTString "USA"
    .InsertNTString "United States"
    .sendPacket &H50, Index
  End With
  'sending & h 50
  
  DoEvents
  'for low ping
  PBuffer.InsertDWORD 0
  PBuffer.sendPacket &H25, Index
  
  'c// 0x50 sent
  
End Sub
'sends 0x50


Public Sub FreeNLS(Index As Integer)
  
  If aProfile(Index).NLS <> 0 Then
    Call nls_free(aProfile(Index).NLS)
    aProfile(Index).NLS = 0
  End If
  
  If aProfile(Index).OldNLS <> 0 Then
    Call nls_free(aProfile(Index).OldNLS)
    aProfile(Index).OldNLS = 0
  End If
  
End Sub
'releases NLS
