Attribute VB_Name = "handleChatEvents"
Option Explicit

Public Sub handleChatEvent(Data As String, Index As Integer)
Dim lEID As Long, sFlags As String, sMessage As String, sUsername As String, lPing As Long

On Error GoTo Err

  sUsername = KillNull(Mid$(Data, 29))
  sMessage = KillNull(Mid$(Data, Len(sUsername) + 30))
  lEID = MakeLong(Mid$(Data, 5, 4))
  lPing = MakeLong(Mid$(Data, 13, 4))
  sFlags = MakeLong(Mid$(Data, 9, 4))

  sMessage = Replace$(sMessage, "\rtf", "/rtf")
  'protect against malicous input

  Select Case lEID
    
    Case &H1
    'USERS: recieved after joining a channel, after CHAN:
    Case &H13
    'ERROR: can be invalid channel, muted reply, not logged on, ect
    Case &H2
    'JOIN: a user joins channel you are in
    Case &H3
    'LEAVE: a user leaves the channel you are in
    Case &H12
    'INFO: recieved when a user is kicked/banned, can be an MOTD, /who, ect
    Case &H7
    'CHAN: recieved when you join a new channel, before anything else
    Case &H9
    'FLAGS: recieved during a user flag update, such as operator, ignore, ect
    Case &H4
    'WHISPFROM: you recieved a whisper
    Case &HA
    'WHISPTO: you sent out a whisper
    Case &H17
    'EMOTE: you recieved a /me
    Case &H5
    'TALK: you recieved chatter
    Case &HF
    'RESTRICTED: recieved when doing /who on a /clan private channel, or when attempting to non-create join a restricted channel using &HC
  End Select

Err:
  'c// if err.Number > 0 then addChat err.description
End Sub
