Attribute VB_Name = "Winamp"
Option Explicit
Private Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As Long
Private Declare Function SendMessageWA Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
'Private Declare Function SendMessageCDS Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As COPYDATASTRUCT) As Long
'Private Declare Function PostMessage Lib "user32" Alias "PostMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Const WM_USER = &H400
Const WM_WA_IPC = WM_USER
'Const WM_COPYDATA = &H4A
Const WM_COMMAND = &H111

Private Declare Function GetWindowText Lib "user32" Alias "GetWindowTextA" (ByVal hwnd As Long, ByVal lpString As String, ByVal cch As Long) As Long
Private Declare Function GetWindowTextLength Lib "user32" Alias "GetWindowTextLengthA" (ByVal hwnd As Long) As Long

Dim Hwnd_Winamp As Long

Private Enum WM_USER_MSGS
    wmWritePlaylist = 120 'Writes out the current playlist to Winampdir\winamp.m3u, and returns the current position in the playlist.
End Enum


'Const IPC_ISPLAYING = 104
Const IPC_GETOUTPUTTIME = 105
Const IPC_JUMPTOTIME = 106
Const IPC_SETPLAYLISTPOS = 121
Const IPC_SETVOLUME = 122
Const WINAMP_VOLUMEUP = 40058
Const WINAMP_VOLUMEDOWN = 40059
Const WINAMP_BUTTON1 = 40044
Const WINAMP_BUTTON2 = 40045
Const WINAMP_BUTTON3 = 40046
Const WINAMP_BUTTON4 = 40047
Const WINAMP_BUTTON5 = 40048
'Const WINAMP_BUTTON1_SHIFT = 40144
'Const WINAMP_BUTTON4_SHIFT = 40147
'Const WINAMP_BUTTON5_SHIFT = 40148
'Const WINAMP_BUTTON1_CTRL = 40154
'Const WINAMP_BUTTON2_CTRL = 40155
'Const WINAMP_BUTTON5_CTRL = 40158

Type COPYDATASTRUCT
        dwData As Long
        cbData As Long
        lpData As String
End Type


Public Function CurrentMP3(bBot As Boolean, Optional bReset As Byte, Optional bIdle As Boolean, Optional bWIdle As Boolean, Optional bProfileAmp As Boolean) As String
Dim sTitle As String, lLength As Long, iLength As Integer, s As String 'overall title, seconds, minutes, dump
Static sLastPlaying As String
  
  If bReset Then sLastPlaying = vbNullString
  'resets last playing so we can display mp3
  
  If Not FindWinamp Then
    If bWIdle Then Exit Function
    'winamp idle, dont display if not on!
    If bIdle Then
      If iIdleType = 0 Or bProfileAmp Then CurrentMP3 = gS(59)
    Else
      ChopText gS(50), True 'cannot find as running
    End If
    Exit Function
  End If
  'winamp isnt loaded
  
  sTitle = WATitle
  'title
  
  If IsNumeric(Left$(sTitle, 1)) Then
    lLength = GetSongLength
    iLength = 0
    Do Until lLength < 60
      iLength = iLength + 1
      lLength = lLength - 60
    Loop
    'grabs minutes and seconds in song length
    s = lLength
    'sets seconds
    If Len(s) = 1 Then s = "0" & s
    'adds a 0 onto the second(s) if only 1 digit
        
    sTitle = Replace(sTitle, " - Winamp", vbNullString)
    sTitle = Replace(sTitle, vbNullChar, vbNullString)
    'parses out bad things

    If sTitle = sLastPlaying Then Exit Function
    sLastPlaying = sTitle
    'stores last playing
    
    If Not bIdle Then sTitle = sTitle & " (" & iLength & ":" & s & ")"
    'adds time to the title ilength= minutes
    
    If InStrB(sTitle, "[Paused]") = 0 And InStrB(sTitle, "[Stopped]") = 0 Then s = "PLAYING"
    'song is playing
    If InStrB(sTitle, "[Stopped]") Then
      s = "STOPPED"
      sTitle = Replace(sTitle, " [Stopped]", vbNullString)
    End If
    'stopped
    If InStrB(sTitle, "[Paused]") Then
      s = "PAUSED"
      sTitle = Replace(sTitle, " [Paused]", vbNullString)
    End If
    'pause
    If bIdle Then
      If InStrB(sTitle, ".") Then sTitle = Mid$(sTitle, InStr(sTitle, ".") + 2)
      'removes song #
      CurrentMP3 = "Winamp: " & sTitle
    Else
      ChopText "/me WinAmp -" & s & "- " & sTitle & " - Element Chat 2.0", False
    End If
    'adds to queue and runs
  End If

End Function
'idles / displays winamp song playing
'// confusing as shit re-write

Public Function FindWinamp() As Boolean
    
    Hwnd_Winamp = FindWindow("Winamp v1.x", vbNullString)
    If Hwnd_Winamp Then FindWinamp = True

End Function

Public Function WATitle() As String
On Error GoTo Err
    
    If FindWinamp Then
      
      WATitle = String(GetWindowTextLength(Hwnd_Winamp) + 1, vbNullChar)
      GetWindowText Hwnd_Winamp, WATitle, Len(WATitle)
      'get txt
      If Left$(WATitle, 6) = "Winamp" Then
        WATitle = gS(54)
        'no song currently playing
        Exit Function
      End If
    
    Else
      
      'couldnt locate winamp, eek?
      WATitle = gS(53)
    
    End If

Err:
End Function

Public Function GetSongLength() As Long
    GetSongLength = SendMessageWA(Hwnd_Winamp, WM_WA_IPC, 1, IPC_GETOUTPUTTIME)
End Function

Public Function SetCurrentSongPosition(Optional Seconds As Long, Optional Ms As Long)
    SetCurrentSongPosition = SendMessageWA(Hwnd_Winamp, WM_WA_IPC, (Seconds * 1000 + Ms), IPC_JUMPTOTIME)
End Function

Public Function SetPlayListPosition(Position As Integer) As Long
    SetPlayListPosition = SendMessageWA(Hwnd_Winamp, WM_WA_IPC, Position, IPC_SETPLAYLISTPOS)
End Function

Public Function SetVolume(Volume As Integer) As Long
    SetVolume = SendMessageWA(Hwnd_Winamp, WM_WA_IPC, Volume, IPC_SETVOLUME)
End Function

Public Function VolumeUp() As Long
    VolumeUp = SendMessageWA(Hwnd_Winamp, WM_COMMAND, WINAMP_VOLUMEUP, 0)
    VolumeUp = SendMessageWA(Hwnd_Winamp, WM_COMMAND, WINAMP_VOLUMEUP, 0)
End Function
Public Function VolumeDown() As Long
    VolumeDown = SendMessageWA(Hwnd_Winamp, WM_COMMAND, WINAMP_VOLUMEDOWN, 0)
    VolumeDown = SendMessageWA(Hwnd_Winamp, WM_COMMAND, WINAMP_VOLUMEDOWN, 0)
End Function

Public Function PreviousTrack() As Long
    PreviousTrack = SendMessageWA(Hwnd_Winamp, WM_COMMAND, WINAMP_BUTTON1, 0)
End Function

Public Function PlaySong() As Long
    PlaySong = SendMessageWA(Hwnd_Winamp, WM_COMMAND, WINAMP_BUTTON2, 0)
End Function

Public Function PauseSong() As Long
    PauseSong = SendMessageWA(Hwnd_Winamp, WM_COMMAND, WINAMP_BUTTON3, 0)
End Function
Public Function StopSong() As Long
    StopSong = SendMessageWA(Hwnd_Winamp, WM_COMMAND, WINAMP_BUTTON4, 0)
End Function

Public Function NextTrack() As Long
    NextTrack = SendMessageWA(Hwnd_Winamp, WM_COMMAND, WINAMP_BUTTON5, 0)
End Function

Public Sub FindSong(ByVal String1 As String, bBot As Boolean)
Dim strData As String, strSimon As String, i As Long
On Error GoTo Err
 
  FindWinamp
  Write_Playlist

  strSimon = LCase$(GetINI("Visual", "Winamp"))
  strSimon = Left$(strSimon, InStr(strSimon, "winamp.exe") - 2)
  'parses out winamp location
  
  If LenB(Dir$(strSimon & "\WINAMP.m3u")) > 0 Then
  
    Open strSimon & "\WINAMP.m3u" For Input As #3
    Do While Not EOF(3)
    Line Input #3, strData

      If Left$(strData, 4) <> "#EXT" Then

        Do Until InStr(strData, "\") = 0
          strData = Mid$(strData, InStr(strData, "\") + 1)
        Loop
        'finds name of mp3 only
      
        strData = Left$(strData, Len(strData) - 4)
        'chops of .mp3 extension
      
        i = i + 1
         If InStrB(LCase$(strData), LCase$(String1)) Then
           FindWinamp
           SetPlayListPosition (i - 1)
           PlaySong
           Close #3
           Exit Sub
        End If
        'if song match
         
      End If
      
    Loop
    Close #3

    ChopText gS(52), bBot 'could not find song

  Else
  
    ChopText gS(51), bBot 'wrong winamp path
  
  End If


Err:

End Sub
'plays a specific winamp song

Private Function SendUser(id As WM_USER_MSGS, Optional Data As Long) As Long
  SendUser = SendMessageWA(Hwnd_Winamp, WM_USER, Data, id)
End Function

Private Sub Write_Playlist()
  SendUser wmWritePlaylist
End Sub






