#ifndef CONNECTION_H
#define CONNECTION_H

#include "PacketBuffer.h"
#include "dmstring.h"
#include "ConsoleOutput.h"
#include <process.h>
#include <io.h>
#include "Storm.h"

#define CONNECTED    1
#define DISCONNECTED 0

char storm[128] = "", battle[128] = "", diablo[128] = "";

typedef unsigned long (__stdcall CheckRevisionProc)(char *diablo, char *battle, char *storm, char *hashcmd, unsigned long *pa, unsigned long *pb, char *pbuf);
CheckRevisionProc *CheckRevision;

DWORD __stdcall MyGetModuleFileName(HMODULE hModule, LPTSTR lpFilename, DWORD nSize);
DWORD __stdcall MyGetModuleFileName(HMODULE hModule, LPTSTR lpFilename, DWORD nSize)
{
	if(hModule == GetModuleHandle(0)) 
	{
		if(nSize > strlen(diablo)) 
		{
			printf("Fooled verification DLL\n");
			strcpy(lpFilename, diablo);
			return strlen(diablo);
		} 
		else
			return 0;
	} 
	else
		return GetModuleFileName(hModule, lpFilename, nSize);
}

class BinaryBot
{
public:
	BinaryBot();
	~BinaryBot();

	WSADATA wsadata;
	SOCKET s;
	HANDLE recvevent;
	CRITICAL_SECTION critsec;
	ConsoleOutput *Output;
	char tmppacketid;
	DWORD encryptvalue;
	int pingvalue;
	int state;
	
	char pbuf[128], errorbuf[128], mpqfile[128];
	DWORD a, b, passbuf, makebuf;

	char homechannel[128], password[256], username[20], statstring[256], unname[20];

	char hashcmd[64];

	struct BnetPacket
	{
		char packetid;
		unsigned short packetlen;
		char *packetdata;
	};

	PacketBuffer packetbuf, sendbuf;

	unsigned long loadandrunverdll(DWORD *pa, DWORD *pb, char *pbuf, char *hashcmd, char *lib);
	void datahash(unsigned long*param);
	void calchashbuf(unsigned long *hash, void *inbuf, int len);
	void getvalues(const char *databuf, DWORD *ping, WORD *flags, char *name, char *txt);
	
	bool Connect(char *szServer);
	void Disconnect();
	bool Startup();
	bool GetData(BnetPacket &Data);
	void MsgLoop();
};

BinaryBot::BinaryBot()
{
	InitializeCriticalSection(&critsec);
	Output = new ConsoleOutput(&critsec, false, 0);
}

BinaryBot::~BinaryBot() { DeleteCriticalSection(&critsec); }

bool BinaryBot::Connect(char *szServer)
{
	Output->WriteEx(ConsoleOutput::WHITE, "Attempting to connect to %s\n", szServer);
  s = INVALID_SOCKET;
  state = DISCONNECTED;
  if (WSAStartup(0x101,&wsadata)) 
    return false;
  if (wsadata.wVersion != 0x101) 
  {
    WSACleanup();
    return false;
  }
  struct sockaddr_in name;
  struct hostent *hp;
  memset(&name, '\0', sizeof(name));
  name.sin_family = AF_INET;
  name.sin_port = htons(6112);
  char *p = szServer;
  while (*p && (isdigit(*p) || (*p == '.')))
    p++;
  if (*p) 
  {
    hp = gethostbyname(szServer);
    if (hp == 0)
      return false;
    memcpy(&name.sin_addr, hp->h_addr, hp->h_length);
  }
  else
    name.sin_addr.s_addr = inet_addr(szServer);
  s = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
  if (s == INVALID_SOCKET)
    return false;
  if (connect(s, (struct sockaddr *)&name, sizeof(name)))
    return false;
  recvevent = CreateEvent(0, 0, 0, 0);
  WSAResetEvent(recvevent);
  WSAEventSelect(s, recvevent, 0);
  WSAEventSelect(s, recvevent, FD_READ | FD_CLOSE);
  state = CONNECTED;
  return true;
}

void BinaryBot::Disconnect()
{
	if (s == INVALID_SOCKET)
		return;
	closesocket(s);
	s = INVALID_SOCKET;
	state = DISCONNECTED;
}

bool BinaryBot::Startup()
{
	send(s, "\x1", 1, 0);
	packetbuf.insert((int)0); 
	packetbuf.insert((int)0);
	packetbuf.insert((int)0); 
	packetbuf.insert((int)0);
	packetbuf.insert("vLBBot");
	packetbuf.insert("vLBBot");
	packetbuf.sendpacket(s, 0x05);

	packetbuf.insert("68XIRHSS", 8);
	packetbuf.insert((int)0xa5);
	packetbuf.insert((int)0);
	packetbuf.sendpacket(s, 0x06);
	BnetPacket Data;
	for(int i = 0; i < 4; i++)
	{
		GetData(Data);
		Sleep(300);
		switch(Data.packetid)
		{
		case 0x05:
			//nothing, account number shit doesn't matter
			break;
		case 0x28:
			//random pw encrypt value
			encryptvalue = *(unsigned long*)Data.packetdata + 4;
			Output->WriteEx(ConsoleOutput::BLUE, "Recieved random hash encrypt value: 0x%x\n", encryptvalue);
			break;
		case 0x25:
			//ping packet
			pingvalue = *(int*)Data.packetdata;
			packetbuf.insert((int)pingvalue);
			packetbuf.sendpacket(s, 0x25);
			break;
		case 0x06:
			//mpq name and hash command
			memset(mpqfile, 0, sizeof(mpqfile));
			memset(hashcmd, 0, sizeof(hashcmd));
			memcpy(mpqfile, Data.packetdata + 7, 12);
			memcpy(hashcmd, Data.packetdata + 19, Data.packetlen - 20);
			Output->WriteEx(ConsoleOutput::BLUE, "MPQ: %s\n", mpqfile);
			Output->WriteEx(ConsoleOutput::BLUE, "Hash command: %s\n", hashcmd);
			break;
		}
	}
	strcpy(storm, "sshr/storm.dll");
	strcpy(battle, "sshr/battle.snp");
	strcpy(diablo, "sshr/starcraft.exe");
	Output->WriteEx(ConsoleOutput::YELLOW, "Using: %s, %s, and %s\n", diablo, battle, storm);
	loadandrunverdll(&a, &b, pbuf, hashcmd, mpqfile);
	Output->WriteEx(ConsoleOutput::WHITE, "a: %08x\n", a);
	Output->WriteEx(ConsoleOutput::WHITE, "b: %08x\n", b);
	Output->WriteEx(ConsoleOutput::WHITE, "pbuf: %s\n", pbuf);
	packetbuf.insert("68XIRHSS", 8);
	packetbuf.insert((int)0xa5);
	packetbuf.insert((int)a);
	packetbuf.insert((int)b);
	packetbuf.insert(pbuf);
	packetbuf.sendpacket(s, 0x07);
	GetData(Data);
	if(Data.packetdata[0] != 0x02)
	{
		Output->WriteEx(ConsoleOutput::RED, "Battle net rejected your hash!\n");
		return false;
	}
	else
		Output->WriteEx(ConsoleOutput::GREEN, "Battle net accepted your Diablo version.\n");
	Output->WriteEx(ConsoleOutput::WHITE, "Logging on...\n");
	packetbuf.sendpacket(s, 0x2d);
	packetbuf.insert("tenb");
	packetbuf.sendpacket(s, 0x14);
	DWORD passwordhash[7];
	passwordhash[0] = GetTickCount();
	passwordhash[1] = encryptvalue;
	calchashbuf(passwordhash+2, password, strlen(password));
	calchashbuf(passwordhash+2, passwordhash, 7*4);
	packetbuf.insert(passwordhash, 7*4);
	packetbuf.insert(username);
	packetbuf.sendpacket(s, 0x29);
	GetData(Data);
	if(Data.packetdata[0] != 0x01)
	{
		Output->WriteEx(ConsoleOutput::RED, "Login failed!\n");
		return false;
	}
	packetbuf.insert(username);
	packetbuf.insert(statstring);
	packetbuf.sendpacket(s, 0x0a);
	packetbuf.insert("LTRD");
	packetbuf.sendpacket(s, 0x0b);
	packetbuf.insert((int)2);
	packetbuf.insert(homechannel);
	packetbuf.sendpacket(s, 0x0c);
	GetData(Data); //channel list
	GetData(Data); //server list
	GetData(Data);
	packetbuf.insert(Data.packetdata);
	packetbuf.extract(unname);
	packetbuf.clear();
	Output->WriteEx(ConsoleOutput::YELLOW, "Logged on as %s\n", unname);
	return true;
}

void BinaryBot::MsgLoop()
{
	BnetPacket Data;
	DWORD ping;
	WORD flags;
	char name[128], txt[512];
	while(GetData(Data))
	{
		if(Data.packetid == 0x0F)
		{
			switch(Data.packetdata[0])
			{
			case 0x01:
				getvalues(Data.packetdata, &ping, &flags, name, txt);
				Output->WriteEx(ConsoleOutput::WHITE, "In channel: %s:%d:%d: %s\n", name, ping, flags, txt);
				break;
			}
		}
	}
}

void BinaryBot::getvalues(const char *databuf, DWORD *ping, WORD *flags, char *name, char *txt)
{
	PacketBuffer Data;
	*ping = *(unsigned long *)databuf + 8;
	*flags = *(unsigned short *)databuf + 4;
	Data.insert(databuf);
	Data += 24;
	Data.extract(name);
	Data += strlen(name);
	Data.extract(txt);
}

bool BinaryBot::GetData(BnetPacket &Data)
{
	char databuf[6000] = "";
	char header[4] = "";
	int recvlen = 0, buflen = 0;
	DWORD wait = WaitForSingleObject(recvevent, 10000);
	if(wait == WAIT_TIMEOUT)
		return false;
	recv(s, (char *)header, 4, 0);
	Data.packetid = header[1];
	Data.packetlen = *(unsigned short *)&header[2];
	Data.packetdata = new char[Data.packetlen];
	ZeroMemory(Data.packetdata, Data.packetlen);
	wait = WaitForSingleObject(recvevent, 10000);
	if(wait == WAIT_TIMEOUT)
		return false;
	while(buflen < (int)(Data.packetlen - 4))
	{
		recvlen = recv(s, (char *)databuf + buflen, 1, 0);
		sprintf(Data.packetdata, "%s%c", Data.packetdata, databuf[buflen]);
		buflen += recvlen;
	}
	return true;
}

unsigned long BinaryBot::loadandrunverdll(DWORD *pa, DWORD *pb, char *pbuf, char *hashcmd, char *lib)
{
	*pa = *pb = *pbuf = 0;
	unsigned long result;
	char *p;
	int size;
	char dllname[260];
	strcpy(dllname, lib);
	if(strchr(dllname, '.'))
		strcpy(strchr(dllname, '.')+1, "DLL");
	HANDLE hMPQ, hfMPQ;
	if(!SFileOpenArchive(lib, NULL, NULL, &hMPQ)) {
		Output->WriteEx(ConsoleOutput::RED, "Error opening MPQ\n");
		return 0;
	}
	if(!SFileOpenFileEx(hMPQ, dllname, NULL, &hfMPQ)) {
		Output->WriteEx(ConsoleOutput::RED, "Error opening DLL\n");
		return 0;
	}
	size = SFileGetFileSize(hfMPQ, NULL);
	if(size>0 && size<1000000) {
		p = new char[size];
		DWORD bytesread;
		if(!SFileReadFile(hfMPQ, p, size, &bytesread, NULL)) {
			Output->WriteEx(ConsoleOutput::RED, "Error reading DLL\n");
			return 0;
		}
		FILE *f = fopen(dllname, "wb");
		fwrite(p, size, 1, f);
		fclose(f);
		delete [] p;
	}
	if(!SFileCloseFile(hfMPQ)) {
		Output->WriteEx(ConsoleOutput::RED, "Error closing DLL\n");
		return 0;
	}
	if(!SFileCloseArchive(hMPQ)) {
		Output->WriteEx(ConsoleOutput::RED, "Error reading MPQ\n");
		return 0;
	}

	HINSTANCE hCheck;
	hCheck = LoadLibrary(dllname);
	CheckRevision = (CheckRevisionProc*)GetProcAddress(hCheck, "CheckRevision");

	DWORD gmfn = (DWORD)GetModuleFileName;
	DWORD *pdw;
	int i = 100000;
	pdw = (DWORD*)((DWORD)CheckRevision & 0xfffffffc);
	while(i--) 
	{ 
		DWORD oldprot; 
		VirtualProtect(pdw, 4, PAGE_EXECUTE_READWRITE, &oldprot); 
		if(*pdw == gmfn) 
		{ 
			*pdw = (DWORD)MyGetModuleFileName; 
			break;
		} 
		else 
			pdw++; 
		VirtualProtect(pdw, 4, oldprot, &oldprot);
	}

	result = CheckRevision(diablo, battle, storm, hashcmd, pa, pb, pbuf);
	FreeLibrary(hCheck);
	return result;
}

void BinaryBot::datahash(unsigned long*param)
{
	unsigned long buf[0x50];
	unsigned long dw, a, b, c, d, e, *p;
	int i;
	memcpy(buf, param+5, 0x40);
	for(i=0x10; i<0x50; i++) 
	{
		dw = buf[i-0x10]^buf[i-0x8]^buf[i-0xe]^buf[i-0x3];
		buf[i] = (1>>(0x20-(unsigned char)dw)) | (1<<(unsigned char)dw);		
	}
	a = param[0];	// edi
	b = param[1];	// eax
	c = param[2];	// esi
	d = param[3];	// edx
	e = param[4];	// [+18], ebx
	p = buf;		// [+14]
	i = 0x14;		// [+10]
	do 
	{
		dw = ((a<<5) | (a>>0x1b)) + ((~b & d) | (c & b)) + e + *p++ + 0x5A827999; // ecx
		e = d;
		d = c;
		c = (b>>2)  | (b<<0x1e);
		b = a;
		a = dw;
	} while(--i);
	i = 0x14;		// [+14]
	do 
	{
		dw = (d ^ c ^ b) + e + ((a<<5) | (a>>0x1b)) + *p++ + 0x6ED9EBA1; // ecx
		e = d;
		d = c;
		c = (b>>2) | (b<<0x1e);
		b = a;
		a = dw;
	} while(--i);
	i = 0x14;
	do 
	{
		dw = ((c & b) | (d & c) | (d & b)) + e + ((a<<5) | (a>>0x1b)) + *p++ - 0x70E44324; // ecx
		e = d;
		d = c;
		c = (b>>2) | (b<<0x1e);
		b = a;
		a = dw;
	} while(--i);

	i = 0x14;
	do 
	{
		dw = ((a<<5) | (a>>0x1b)) + e + (d ^ c ^ b) + *p++ - 0x359D3E2A; // ecx
		e = d;
		d = c;
		c = (b>>2) | (b<<0x1e);
		b = a;
		a = dw;
	} while(--i);
	param[0] += a;
	param[1] += b;
	param[2] += c;
	param[3] += d;
	param[4] += e;

}

void BinaryBot::calchashbuf(unsigned long *hash, void *inbuf, int len)
{
	char *buf = (char*)inbuf;
	int pos;
	int sublen;
	unsigned long hashbuf[0x10 + 5];
	hashbuf[0] = 0x67452301;
	hashbuf[1] = 0xEFCDAB89;
	hashbuf[2] = 0x98BADCFE;
	hashbuf[3] = 0x10325476;
	hashbuf[4] = 0xC3D2E1F0;
	for(pos=0; pos<len; pos+=0x40) {
		sublen = len - pos;
		if(sublen > 0x40)
			sublen = 0x40;
		memcpy(hashbuf+5, buf+pos, sublen);
		if(sublen<0x40)
			ZeroMemory((char*)(hashbuf+5)+sublen, 0x40-sublen);
		datahash(hashbuf);
	}
	memcpy(hash, hashbuf, 5*4);
}

#endif