Attribute VB_Name = "BinaryUtil"
Declare Function CheckRevision Lib "binarybot.dll" Alias "_CheckRevision@32" (ByVal FileExe As String, ByVal FileStormDll As String, ByVal FileBnetDll As String, ByVal HashText As String, ByRef Version As Long, ByRef Checksum As Long, ByVal ExeInfo As String, ByVal MpqName As String) As Long
Declare Function CreatePasswordHash Lib "binarybot.dll" Alias "_CreatePasswordHash@16" (ByVal Outbuf As String, ByVal EncryptValue As Long, ByVal Password As String, ByVal Username As String)
Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (ByRef Destination As Any, ByRef Source As Any, ByVal numBytes As Long)
Public Declare Sub ZeroMemory Lib "kernel32" Alias "RtlMoveMemory" (dest As Any, ByVal numBytes As Long)
Public Declare Function GetTickCount Lib "kernel32" () As Long
Const StarcraftPath = "c:\vlbbot\vb\"

Function CreateVersionPacket(HashCmd As String, MpqName As String) As String
    Dim Version As Long
    Dim Checksum As Long
    Dim ExeInfo As String
    Dim Result As Long
    ExeInfo = Space(256)
    r = CheckRevision(StarcraftPath & "Starcraft.exe", StarcraftPath & "storm.dll", StarcraftPath & "battle.snp", HashCmd, Version, Checksum, ExeInfo, MpqName)
    NullTruncString ExeInfo
    CreateVersionPacket = "68XIRHSS" & MKL(&HA5) & MKL(Version) & MKL(Checksum) & ExeInfo & Chr(0)
End Function

Function MKL(Value As Long) As String
    Dim Result As String * 4
    CopyMemory ByVal Result, Value, 4
    MKL = Result
End Function

Function MKI(Value As Integer) As String
    Dim Result As String * 2
    CopyMemory ByVal Result, Value, 2
    MKI = Result
End Function

Function CVL(x As String) As Long
    If Len(x) < 4 Then
        MsgBox "CVL(): String too short"
        Stop
    End If
    CopyMemory CVL, ByVal x, 4
End Function

Function CVI(x As String) As Integer
    If Len(x) < 2 Then
        MsgBox "CVI(): String too short"
        Stop
    End If
    CopyMemory CVI, ByVal x, 2
End Function

Sub NullTruncString(ByRef Text As String)
    Dim i As Integer
    i = InStr(Text, Chr(0))
    If i = 0 Then Exit Sub
    Text = Left(Text, i - 1)
End Sub

Public Function LShift(ByRef pnValue As Long, ByRef pnShift As Long)
    LShift = pnValue * (2 ^ pnShift)
End Function

Public Function RShift(ByRef pnValue As Long, ByRef pnShift As Long)
    RShift = CLng(pnValue \ (2 ^ pnShift))
End Function

Public Function DecodeCDKey(ByVal lpszCDKey As String, ByRef lpdwProductId As Double, ByRef lpdwValue1 As Double, ByRef lpdwValue2 As Double) As Boolean
Dim bValid As Boolean
lpszCDKey = Replace(lpszCDKey, "-", "")
bValid = DecodeStarcraftKey(lpszCDKey)
lpdwProductId = Val("&H" & Left(lpszCDKey, 2))
lpdwValue1 = Mid(lpszCDKey, 3, 7)
lpdwValue2 = Mid(lpszCDKey, 10, 3)
DecodeCDKey = bValid
End Function

Public Function DecodeStarcraftKey(ByRef key As String) As Boolean
Dim r As Double, n As Double, n2 As Double, v As Double, v2 As Double, keyvalue As Double, c1 As Byte, c2 As Byte, c As Byte, bValid As Boolean, i As Integer, aryKey(0 To 12) As String
For i = 1 To 13
    aryKey(i - 1) = Mid(key, i, 1)
Next i
v = 3
For i = 0 To 11
    c = aryKey(i)
    n = Val(c)
    n2 = v * 2
    n = n Xor n2
    v = v + n
Next i
v = v Mod 10
If Hex(v) = aryKey(12) Then
    bValid = True
End If
v = 194
For i = 11 To 0 Step -1
    If v < 7 Then GoTo continue
    c = aryKey(i)
    n = CInt(v / 12)
    n2 = v Mod 12
    v = v - 17
    c2 = aryKey(n2)
    aryKey(i) = c2
    aryKey(n2) = c
Next i
continue:
v2 = &H13AC9741
For i = 11 To 0 Step -1
    c = UCase(aryKey(i))
    aryKey(i) = c
    If Asc(c) <= Asc("7") Then
        v = v2
        c2 = v And &HFF
        c2 = c2 And 7
        c2 = c2 Xor c
        v = RShift(CLng(v), 3)
        aryKey(i) = c2
        v2 = v
    ElseIf Asc(c) < 65 Then
        c2 = CByte(i)
        c2 = c2 And 1
        c2 = c2 Xor c
        aryKey(i) = c2
    End If
Next i
key = Join(aryKey, "")
DecodeStarcraftKey = bValid
End Function

