#ifndef _DMSTRING_H_
#define _DMSTRING_H_

#include <ctype.h>
#include <string.h>

char *substring(char *source, int start, int len);
int sfind(char *source, char tofind);
int sfind(char *source, char *tofind);
char *ucase(char *source);
char ucase(char source);
char *lcase(char *source);
char lcase(char source);
int length(char *source);

char *substring(char *source, int start, int len)
{
	if((len + start) > length(source))
		len = length(source) - start;
	char *buffer;
	buffer = new char[512];
	int pos = 0;
	for(int i = start; i <= (len + start); i++)
		buffer[pos++] = source[i];
	buffer[pos] = 0;
	return buffer;
}

int sfind(char *source, char tofind)
{
	for(int i = 0; i < (int)strlen(source); i++)
		if(source[i]==tofind)
			return i;
	return -1;
}

int sfind(char *source, char *tofind)
{
	char *pdest;
	pdest = strstr(source, tofind);
	if((int)(pdest - source) < 0)
		return -1;
	else
		return (int)(pdest - source);
}

char *ucase(char *source)
{
	char *p = new char[2056];
	for(int i = 0; i < (int)strlen(source); i++)
		p[i] = toupper(source[i]);
	p[i] = 0;
	return p;
}

char ucase(char source)
{
	return toupper(source);
}

char *lcase(char *source)
{
	char *p = new char[2056];
	for(int i = 0; i < (int)strlen(source); i++)
		p[i] = tolower(source[i]);
	p[i] = 0;
	return p;
}

char lcase(char source)
{
	return tolower(source);
}

int length(char *source)
{
	return (int)strlen(source);
}

#endif